/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightVisitorBasedInspection;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.SuppressableProblemGroup;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightInfo
implements Segment {
    private static final Logger LOG = Logger.getInstance(HighlightInfo.class);
    private static final String DESCRIPTION_PLACEHOLDER = "\u0000";
    private static final byte BIJECTIVE_MASK = 1;
    private static final byte HAS_HINT_MASK = 2;
    private static final byte FROM_INJECTION_MASK = 4;
    private static final byte AFTER_END_OF_LINE_MASK = 8;
    private static final byte FILE_LEVEL_ANNOTATION_MASK = 16;
    private static final byte NEEDS_UPDATE_ON_TYPING_MASK = 32;
    public final TextAttributes forcedTextAttributes;
    public final TextAttributesKey forcedTextAttributesKey;
    @NotNull
    public final HighlightInfoType type;
    public final int startOffset;
    public final int endOffset;
    public List<Pair<IntentionActionDescriptor, TextRange>> quickFixActionRanges;
    public List<Pair<IntentionActionDescriptor, RangeMarker>> quickFixActionMarkers;
    private final String description;
    private final String toolTip;
    @NotNull
    private final HighlightSeverity severity;
    private final GutterMark gutterIconRenderer;
    private final ProblemGroup myProblemGroup;
    private final String inspectionToolId;
    private int group;
    private int fixStartOffset;
    private int fixEndOffset;
    private volatile byte myFlags;
    final int navigationShift;
    JComponent fileLevelComponent;
    @Nullable(value="null means it the same as highlighter")
    @Nullable(value="null means it the same as highlighter") RangeMarker fixMarker;
    volatile RangeHighlighterEx highlighter;
    PsiElement psiElement;
    private static final String ANNOTATOR_INSPECTION_SHORT_NAME = "Annotator";

    protected HighlightInfo(@Nullable TextAttributes forcedTextAttributes, @Nullable TextAttributesKey forcedTextAttributesKey, @NotNull HighlightInfoType type, int startOffset, int endOffset, @Nullable String escapedDescription, @Nullable String escapedToolTip, @NotNull HighlightSeverity severity, boolean afterEndOfLine, @Nullable Boolean needsUpdateOnTyping, boolean isFileLevelAnnotation, int navigationShift, ProblemGroup problemGroup, @Nullable String inspectionToolId, GutterMark gutterIconRenderer, int group) {
        if (type == null) {
            HighlightInfo.$$$reportNull$$$0(0);
        }
        if (severity == null) {
            HighlightInfo.$$$reportNull$$$0(1);
        }
        if (startOffset < 0 || startOffset > endOffset) {
            LOG.error("Incorrect highlightInfo bounds. description=" + escapedDescription + "; startOffset=" + startOffset + "; endOffset=" + endOffset + ";type=" + type);
        }
        this.forcedTextAttributes = forcedTextAttributes;
        this.forcedTextAttributesKey = forcedTextAttributesKey;
        this.type = type;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.fixStartOffset = startOffset;
        this.fixEndOffset = endOffset;
        this.description = escapedDescription;
        this.toolTip = HighlightInfo.encodeTooltip(escapedToolTip, escapedDescription);
        this.severity = severity;
        this.setFlag((byte)8, afterEndOfLine);
        this.setFlag((byte)32, HighlightInfo.calcNeedUpdateOnTyping(needsUpdateOnTyping, type));
        this.setFlag((byte)16, isFileLevelAnnotation);
        this.navigationShift = navigationShift;
        this.myProblemGroup = problemGroup;
        this.gutterIconRenderer = gutterIconRenderer;
        this.inspectionToolId = inspectionToolId;
        this.group = group;
    }

    @Nullable
    public static HighlightInfo fromRangeHighlighter(@NotNull RangeHighlighter highlighter) {
        Object errorStripeTooltip;
        if (highlighter == null) {
            HighlightInfo.$$$reportNull$$$0(2);
        }
        return (errorStripeTooltip = highlighter.getErrorStripeTooltip()) instanceof HighlightInfo ? (HighlightInfo)errorStripeTooltip : null;
    }

    @NotNull
    ProperTextRange getFixTextRange() {
        return new ProperTextRange(this.fixStartOffset, this.fixEndOffset);
    }

    void setFromInjection(boolean fromInjection) {
        this.setFlag((byte)4, fromInjection);
    }

    @Nullable
    public String getToolTip() {
        String toolTip = this.toolTip;
        String description = this.description;
        if (toolTip == null || description == null || !toolTip.contains(DESCRIPTION_PLACEHOLDER)) {
            return toolTip;
        }
        String decoded = StringUtil.replace((String)toolTip, (String)DESCRIPTION_PLACEHOLDER, (String)XmlStringUtil.escapeString((String)description));
        return XmlStringUtil.wrapInHtml((CharSequence)decoded);
    }

    private static String encodeTooltip(String tooltip, String description) {
        if (tooltip == null || description == null || description.isEmpty()) {
            return tooltip;
        }
        String encoded = StringUtil.replace((String)tooltip, (String)XmlStringUtil.escapeString((String)description), (String)DESCRIPTION_PLACEHOLDER);
        if (encoded == tooltip) {
            return tooltip;
        }
        if (encoded.equals(DESCRIPTION_PLACEHOLDER)) {
            encoded = DESCRIPTION_PLACEHOLDER;
        }
        return XmlStringUtil.stripHtml((String)encoded);
    }

    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getInspectionToolId() {
        return this.inspectionToolId;
    }

    private boolean isFlagSet(@FlagConstant byte mask) {
        return BitUtil.isSet((byte)this.myFlags, (byte)mask);
    }

    private void setFlag(@FlagConstant byte mask, boolean value2) {
        this.myFlags = BitUtil.set((byte)this.myFlags, (byte)mask, (boolean)value2);
    }

    boolean isFileLevelAnnotation() {
        return this.isFlagSet((byte)16);
    }

    boolean isBijective() {
        return this.isFlagSet((byte)1);
    }

    void setBijective(boolean bijective) {
        this.setFlag((byte)1, bijective);
    }

    @NotNull
    public HighlightSeverity getSeverity() {
        HighlightSeverity highlightSeverity = this.severity;
        if (highlightSeverity == null) {
            HighlightInfo.$$$reportNull$$$0(3);
        }
        return highlightSeverity;
    }

    public RangeHighlighterEx getHighlighter() {
        return this.highlighter;
    }

    public void setHighlighter(@Nullable RangeHighlighterEx highlighter) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.highlighter = highlighter;
    }

    public boolean isAfterEndOfLine() {
        return this.isFlagSet((byte)8);
    }

    @Nullable
    public TextAttributes getTextAttributes(@Nullable PsiElement element2, @Nullable EditorColorsScheme editorColorsScheme) {
        if (this.forcedTextAttributes != null) {
            return this.forcedTextAttributes;
        }
        EditorColorsScheme colorsScheme = HighlightInfo.getColorsScheme(editorColorsScheme);
        if (this.forcedTextAttributesKey != null) {
            return colorsScheme.getAttributes(this.forcedTextAttributesKey);
        }
        return HighlightInfo.getAttributesByType(element2, this.type, (TextAttributesScheme)colorsScheme);
    }

    public static TextAttributes getAttributesByType(@Nullable PsiElement element2, @NotNull HighlightInfoType type, @NotNull TextAttributesScheme colorsScheme) {
        SeverityRegistrar severityRegistrar;
        TextAttributes textAttributes;
        if (type == null) {
            HighlightInfo.$$$reportNull$$$0(4);
        }
        if (colorsScheme == null) {
            HighlightInfo.$$$reportNull$$$0(5);
        }
        if ((textAttributes = (severityRegistrar = SeverityRegistrar.getSeverityRegistrar(element2 != null ? element2.getProject() : null)).getTextAttributesBySeverity(type.getSeverity(element2))) != null) {
            return textAttributes;
        }
        TextAttributesKey key = type.getAttributesKey();
        return colorsScheme.getAttributes(key);
    }

    @Nullable
    Color getErrorStripeMarkColor(@NotNull PsiElement element2, @Nullable(value="when null, a global scheme will be used") @Nullable(value="when null, a global scheme will be used") EditorColorsScheme colorsScheme) {
        Color errorStripeColor;
        TextAttributes forcedTextAttributes;
        if (element2 == null) {
            HighlightInfo.$$$reportNull$$$0(6);
        }
        if (this.forcedTextAttributes != null) {
            return this.forcedTextAttributes.getErrorStripeColor();
        }
        EditorColorsScheme scheme = HighlightInfo.getColorsScheme(colorsScheme);
        if (this.forcedTextAttributesKey != null && (forcedTextAttributes = scheme.getAttributes(this.forcedTextAttributesKey)) != null && (errorStripeColor = forcedTextAttributes.getErrorStripeColor()) != null) {
            return errorStripeColor;
        }
        if (this.getSeverity() == HighlightSeverity.ERROR) {
            return scheme.getAttributes(CodeInsightColors.ERRORS_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.WARNING) {
            return scheme.getAttributes(CodeInsightColors.WARNINGS_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.INFO) {
            return scheme.getAttributes(CodeInsightColors.INFO_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.WEAK_WARNING) {
            return scheme.getAttributes(CodeInsightColors.WEAK_WARNING_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING) {
            return scheme.getAttributes(CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING).getErrorStripeColor();
        }
        TextAttributes attributes = HighlightInfo.getAttributesByType(element2, this.type, (TextAttributesScheme)scheme);
        return attributes == null ? null : attributes.getErrorStripeColor();
    }

    @NotNull
    private static EditorColorsScheme getColorsScheme(@Nullable EditorColorsScheme customScheme) {
        EditorColorsScheme editorColorsScheme = customScheme != null ? customScheme : EditorColorsManager.getInstance().getGlobalScheme();
        if (editorColorsScheme == null) {
            HighlightInfo.$$$reportNull$$$0(7);
        }
        return editorColorsScheme;
    }

    @Nullable
    private static String htmlEscapeToolTip(@Nullable String unescapedTooltip) {
        return unescapedTooltip == null ? null : XmlStringUtil.wrapInHtml((CharSequence)XmlStringUtil.escapeString((String)unescapedTooltip));
    }

    boolean needUpdateOnTyping() {
        return this.isFlagSet((byte)32);
    }

    private static boolean calcNeedUpdateOnTyping(@Nullable Boolean needsUpdateOnTyping, HighlightInfoType type) {
        if (needsUpdateOnTyping != null) {
            return needsUpdateOnTyping;
        }
        if (type instanceof HighlightInfoType.UpdateOnTypingSuppressible) {
            return ((HighlightInfoType.UpdateOnTypingSuppressible)((Object)type)).needsUpdateOnTyping();
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HighlightInfo)) {
            return false;
        }
        HighlightInfo info = (HighlightInfo)obj;
        return info.getSeverity() == this.getSeverity() && info.startOffset == this.startOffset && info.endOffset == this.endOffset && Comparing.equal((Object)info.type, (Object)this.type) && Comparing.equal((Object)info.gutterIconRenderer, (Object)this.gutterIconRenderer) && Comparing.equal((Object)info.forcedTextAttributes, (Object)this.forcedTextAttributes) && Comparing.equal((Object)info.forcedTextAttributesKey, (Object)this.forcedTextAttributesKey) && Comparing.strEqual((String)info.getDescription(), (String)this.getDescription());
    }

    protected boolean equalsByActualOffset(@NotNull HighlightInfo info) {
        if (info == null) {
            HighlightInfo.$$$reportNull$$$0(8);
        }
        if (info == this) {
            return true;
        }
        return info.getSeverity() == this.getSeverity() && info.getActualStartOffset() == this.getActualStartOffset() && info.getActualEndOffset() == this.getActualEndOffset() && Comparing.equal((Object)info.type, (Object)this.type) && Comparing.equal((Object)info.gutterIconRenderer, (Object)this.gutterIconRenderer) && Comparing.equal((Object)info.forcedTextAttributes, (Object)this.forcedTextAttributes) && Comparing.equal((Object)info.forcedTextAttributesKey, (Object)this.forcedTextAttributesKey) && Comparing.strEqual((String)info.getDescription(), (String)this.getDescription());
    }

    public int hashCode() {
        return this.startOffset;
    }

    public String toString() {
        String s = "HighlightInfo(" + this.startOffset + "," + this.endOffset + ")";
        if (this.getActualStartOffset() != this.startOffset || this.getActualEndOffset() != this.endOffset) {
            s = s + "; actual: (" + this.getActualStartOffset() + "," + this.getActualEndOffset() + ")";
        }
        if (this.highlighter != null) {
            s = s + " text='" + this.getText() + "'";
        }
        if (this.getDescription() != null) {
            s = s + ", description='" + this.getDescription() + "'";
        }
        s = s + " severity=" + this.getSeverity();
        s = s + " group=" + this.getGroup();
        if (this.quickFixActionRanges != null) {
            s = s + "; quickFixes: " + this.quickFixActionRanges;
        }
        if (this.gutterIconRenderer != null) {
            s = s + "; gutter: " + this.gutterIconRenderer;
        }
        return s;
    }

    @NotNull
    public static Builder newHighlightInfo(@NotNull HighlightInfoType type) {
        if (type == null) {
            HighlightInfo.$$$reportNull$$$0(9);
        }
        return new B(type);
    }

    void setGroup(int group) {
        this.group = group;
    }

    private static boolean isAcceptedByFilters(@NotNull HighlightInfo info, @Nullable PsiElement psiElement) {
        if (info == null) {
            HighlightInfo.$$$reportNull$$$0(10);
        }
        PsiFile file2 = psiElement == null ? null : psiElement.getContainingFile();
        for (HighlightInfoFilter filter2 : (HighlightInfoFilter[])HighlightInfoFilter.EXTENSION_POINT_NAME.getExtensions()) {
            if (filter2.accept(info, file2)) continue;
            return false;
        }
        info.psiElement = psiElement;
        return true;
    }

    public GutterMark getGutterIconRenderer() {
        return this.gutterIconRenderer;
    }

    @Nullable
    public ProblemGroup getProblemGroup() {
        return this.myProblemGroup;
    }

    @NotNull
    public static HighlightInfo fromAnnotation(@NotNull Annotation annotation) {
        if (annotation == null) {
            HighlightInfo.$$$reportNull$$$0(11);
        }
        return HighlightInfo.fromAnnotation(annotation, false);
    }

    @NotNull
    static HighlightInfo fromAnnotation(@NotNull Annotation annotation, boolean batchMode) {
        List fixes;
        if (annotation == null) {
            HighlightInfo.$$$reportNull$$$0(12);
        }
        TextAttributes forcedAttributes = annotation.getEnforcedTextAttributes();
        TextAttributesKey key = annotation.getTextAttributes();
        TextAttributesKey forcedAttributesKey = forcedAttributes == null && key != HighlighterColors.NO_HIGHLIGHTING ? key : null;
        HighlightInfo info = new HighlightInfo(forcedAttributes, forcedAttributesKey, HighlightInfo.convertType(annotation), annotation.getStartOffset(), annotation.getEndOffset(), annotation.getMessage(), annotation.getTooltip(), annotation.getSeverity(), annotation.isAfterEndOfLine(), annotation.needsUpdateOnTyping(), annotation.isFileLevelAnnotation(), 0, annotation.getProblemGroup(), null, (GutterMark)annotation.getGutterIconRenderer(), 4);
        List list2 = fixes = batchMode ? annotation.getBatchFixes() : annotation.getQuickFixes();
        if (fixes != null) {
            for (Annotation.QuickFixInfo quickFixInfo : fixes) {
                TextRange range2 = quickFixInfo.textRange;
                HighlightDisplayKey k = quickFixInfo.key != null ? quickFixInfo.key : HighlightDisplayKey.find((String)ANNOTATOR_INSPECTION_SHORT_NAME);
                info.registerFix(quickFixInfo.quickFix, null, HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)k), range2, k);
            }
        }
        HighlightInfo highlightInfo = info;
        if (highlightInfo == null) {
            HighlightInfo.$$$reportNull$$$0(13);
        }
        return highlightInfo;
    }

    @NotNull
    private static HighlightInfoType convertType(@NotNull Annotation annotation) {
        if (annotation == null) {
            HighlightInfo.$$$reportNull$$$0(14);
        }
        ProblemHighlightType type = annotation.getHighlightType();
        HighlightSeverity severity = annotation.getSeverity();
        return HighlightInfo.toHighlightInfoType(type, severity);
    }

    @NotNull
    private static HighlightInfoType toHighlightInfoType(ProblemHighlightType problemHighlightType, @NotNull HighlightSeverity severity) {
        if (severity == null) {
            HighlightInfo.$$$reportNull$$$0(15);
        }
        if (problemHighlightType == ProblemHighlightType.LIKE_UNUSED_SYMBOL) {
            HighlightInfoType highlightInfoType = HighlightInfoType.UNUSED_SYMBOL;
            if (highlightInfoType == null) {
                HighlightInfo.$$$reportNull$$$0(16);
            }
            return highlightInfoType;
        }
        if (problemHighlightType == ProblemHighlightType.LIKE_UNKNOWN_SYMBOL) {
            HighlightInfoType highlightInfoType = HighlightInfoType.WRONG_REF;
            if (highlightInfoType == null) {
                HighlightInfo.$$$reportNull$$$0(17);
            }
            return highlightInfoType;
        }
        if (problemHighlightType == ProblemHighlightType.LIKE_DEPRECATED) {
            HighlightInfoType highlightInfoType = HighlightInfoType.DEPRECATED;
            if (highlightInfoType == null) {
                HighlightInfo.$$$reportNull$$$0(18);
            }
            return highlightInfoType;
        }
        if (problemHighlightType == ProblemHighlightType.LIKE_MARKED_FOR_REMOVAL) {
            HighlightInfoType highlightInfoType = HighlightInfoType.MARKED_FOR_REMOVAL;
            if (highlightInfoType == null) {
                HighlightInfo.$$$reportNull$$$0(19);
            }
            return highlightInfoType;
        }
        return HighlightInfo.convertSeverity(severity);
    }

    @NotNull
    public static HighlightInfoType convertSeverity(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            HighlightInfo.$$$reportNull$$$0(20);
        }
        HighlightInfoType highlightInfoType = severity == HighlightSeverity.ERROR ? HighlightInfoType.ERROR : (severity == HighlightSeverity.WARNING ? HighlightInfoType.WARNING : (severity == HighlightSeverity.INFO ? HighlightInfoType.INFO : (severity == HighlightSeverity.WEAK_WARNING ? HighlightInfoType.WEAK_WARNING : (severity == HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING ? HighlightInfoType.GENERIC_WARNINGS_OR_ERRORS_FROM_SERVER : HighlightInfoType.INFORMATION))));
        if (highlightInfoType == null) {
            HighlightInfo.$$$reportNull$$$0(21);
        }
        return highlightInfoType;
    }

    @NotNull
    public static ProblemHighlightType convertType(@NotNull HighlightInfoType infoType) {
        if (infoType == null) {
            HighlightInfo.$$$reportNull$$$0(22);
        }
        if (infoType == HighlightInfoType.ERROR || infoType == HighlightInfoType.WRONG_REF) {
            ProblemHighlightType problemHighlightType = ProblemHighlightType.ERROR;
            if (problemHighlightType == null) {
                HighlightInfo.$$$reportNull$$$0(23);
            }
            return problemHighlightType;
        }
        if (infoType == HighlightInfoType.WARNING) {
            ProblemHighlightType problemHighlightType = ProblemHighlightType.WARNING;
            if (problemHighlightType == null) {
                HighlightInfo.$$$reportNull$$$0(24);
            }
            return problemHighlightType;
        }
        if (infoType == HighlightInfoType.INFORMATION) {
            ProblemHighlightType problemHighlightType = ProblemHighlightType.INFORMATION;
            if (problemHighlightType == null) {
                HighlightInfo.$$$reportNull$$$0(25);
            }
            return problemHighlightType;
        }
        ProblemHighlightType problemHighlightType = ProblemHighlightType.WEAK_WARNING;
        if (problemHighlightType == null) {
            HighlightInfo.$$$reportNull$$$0(26);
        }
        return problemHighlightType;
    }

    @NotNull
    public static ProblemHighlightType convertSeverityToProblemHighlight(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            HighlightInfo.$$$reportNull$$$0(27);
        }
        ProblemHighlightType problemHighlightType = severity == HighlightSeverity.ERROR ? ProblemHighlightType.ERROR : (severity == HighlightSeverity.WARNING ? ProblemHighlightType.WARNING : (severity == HighlightSeverity.INFO ? ProblemHighlightType.INFO : (severity == HighlightSeverity.WEAK_WARNING ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.INFORMATION)));
        if (problemHighlightType == null) {
            HighlightInfo.$$$reportNull$$$0(28);
        }
        return problemHighlightType;
    }

    public boolean hasHint() {
        return this.isFlagSet((byte)2);
    }

    void setHint(boolean hasHint) {
        this.setFlag((byte)2, hasHint);
    }

    public int getActualStartOffset() {
        RangeHighlighterEx h = this.highlighter;
        return h == null || !h.isValid() ? this.startOffset : h.getStartOffset();
    }

    public int getActualEndOffset() {
        RangeHighlighterEx h = this.highlighter;
        return h == null || !h.isValid() ? this.endOffset : h.getEndOffset();
    }

    public int getStartOffset() {
        return this.getActualStartOffset();
    }

    public int getEndOffset() {
        return this.getActualEndOffset();
    }

    int getGroup() {
        return this.group;
    }

    boolean isFromInjection() {
        return this.isFlagSet((byte)4);
    }

    @NotNull
    public String getText() {
        if (this.isFileLevelAnnotation()) {
            return "";
        }
        RangeHighlighterEx highlighter = this.highlighter;
        if (highlighter == null) {
            throw new RuntimeException("info not applied yet");
        }
        if (!highlighter.isValid()) {
            return "";
        }
        String string = highlighter.getDocument().getText(TextRange.create((Segment)highlighter));
        if (string == null) {
            HighlightInfo.$$$reportNull$$$0(29);
        }
        return string;
    }

    public void registerFix(@Nullable IntentionAction action2, @Nullable List<IntentionAction> options, @Nullable String displayName, @Nullable TextRange fixRange, @Nullable HighlightDisplayKey key) {
        if (action2 == null) {
            return;
        }
        if (fixRange == null) {
            fixRange = new TextRange(this.startOffset, this.endOffset);
        }
        if (this.quickFixActionRanges == null) {
            this.quickFixActionRanges = ContainerUtil.createLockFreeCopyOnWriteList();
        }
        IntentionActionDescriptor desc = new IntentionActionDescriptor(action2, options, displayName, null, key, this.getProblemGroup(), this.getSeverity());
        this.quickFixActionRanges.add((Pair<IntentionActionDescriptor, TextRange>)Pair.create((Object)desc, (Object)fixRange));
        this.fixStartOffset = Math.min(this.fixStartOffset, fixRange.getStartOffset());
        this.fixEndOffset = Math.max(this.fixEndOffset, fixRange.getEndOffset());
        if (action2 instanceof HintAction) {
            this.setHint(true);
        }
    }

    public void unregisterQuickFix(@NotNull Condition<? super IntentionAction> condition) {
        if (condition == null) {
            HighlightInfo.$$$reportNull$$$0(30);
        }
        if (this.quickFixActionRanges != null) {
            this.quickFixActionRanges.removeIf(pair -> condition.value((Object)((IntentionActionDescriptor)pair.first).getAction()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 15: 
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 3: 
            case 7: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsScheme";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoType";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverity";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorsScheme";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "fromAnnotation";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "toHighlightInfoType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "convertSeverity";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "convertType";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "convertSeverityToProblemHighlight";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromRangeHighlighter";
                break;
            }
            case 3: 
            case 7: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAttributesByType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getErrorStripeMarkColor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "equalsByActualOffset";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newHighlightInfo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptedByFilters";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fromAnnotation";
                break;
            }
            case 14: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "convertType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "toHighlightInfoType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "convertSeverity";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "convertSeverityToProblemHighlight";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "unregisterQuickFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IntentionActionDescriptor {
        private final IntentionAction myAction;
        private volatile List<IntentionAction> myOptions;
        private volatile HighlightDisplayKey myKey;
        private final ProblemGroup myProblemGroup;
        private final HighlightSeverity mySeverity;
        private final String myDisplayName;
        private final Icon myIcon;
        private Boolean myCanCleanup;

        IntentionActionDescriptor(@NotNull IntentionAction action2, List<IntentionAction> options, String displayName) {
            if (action2 == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(0);
            }
            this(action2, options, displayName, null);
        }

        public IntentionActionDescriptor(@NotNull IntentionAction action2, Icon icon2) {
            if (action2 == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(1);
            }
            this(action2, null, null, icon2);
        }

        IntentionActionDescriptor(@NotNull IntentionAction action2, @Nullable List<IntentionAction> options, @Nullable String displayName, @Nullable Icon icon2) {
            if (action2 == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(2);
            }
            this(action2, options, displayName, icon2, null, null, null);
        }

        public IntentionActionDescriptor(@NotNull IntentionAction action2, @Nullable List<IntentionAction> options, @Nullable String displayName, @Nullable Icon icon2, @Nullable HighlightDisplayKey key, @Nullable ProblemGroup problemGroup, @Nullable HighlightSeverity severity) {
            if (action2 == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(3);
            }
            this.myAction = action2;
            this.myOptions = options;
            this.myDisplayName = displayName;
            this.myIcon = icon2;
            this.myKey = key;
            this.myProblemGroup = problemGroup;
            this.mySeverity = severity;
        }

        @NotNull
        public IntentionAction getAction() {
            IntentionAction intentionAction = this.myAction;
            if (intentionAction == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(4);
            }
            return intentionAction;
        }

        boolean isError() {
            return this.mySeverity == null || this.mySeverity.compareTo(HighlightSeverity.ERROR) >= 0;
        }

        boolean isInformation() {
            return HighlightSeverity.INFORMATION.equals((Object)this.mySeverity);
        }

        boolean canCleanup(@NotNull PsiElement element2) {
            if (element2 == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(5);
            }
            if (this.myCanCleanup == null) {
                InspectionToolWrapper toolWrapper;
                InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance(element2.getProject()).getCurrentProfile();
                HighlightDisplayKey key = this.myKey;
                this.myCanCleanup = key == null ? Boolean.valueOf(false) : Boolean.valueOf((toolWrapper = profile.getInspectionTool(key.toString(), element2)) != null && toolWrapper.isCleanupTool());
            }
            return this.myCanCleanup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public List<IntentionAction> getOptions(@NotNull PsiElement element2, @Nullable Editor editor) {
            HighlightDisplayKey idKey;
            if (element2 == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(6);
            }
            if (editor != null && Boolean.FALSE.equals(editor.getUserData(IntentionManager.SHOW_INTENTION_OPTIONS_KEY))) {
                return null;
            }
            List options = this.myOptions;
            HighlightDisplayKey key = this.myKey;
            if (this.myProblemGroup != null) {
                HighlightDisplayKey problemGroupKey;
                String problemName = this.myProblemGroup.getProblemName();
                HighlightDisplayKey highlightDisplayKey = problemGroupKey = problemName != null ? HighlightDisplayKey.findById((String)problemName) : null;
                if (problemGroupKey != null) {
                    key = problemGroupKey;
                }
            }
            if (options != null || key == null) {
                return options;
            }
            IntentionManager intentionManager = IntentionManager.getInstance();
            List newOptions = intentionManager.getStandardIntentionOptions(key, element2);
            InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance(element2.getProject()).getCurrentProfile();
            InspectionToolWrapper toolWrapper = profile.getInspectionTool(key.toString(), element2);
            if (!(toolWrapper instanceof LocalInspectionToolWrapper) && (idKey = HighlightDisplayKey.findById((String)key.toString())) != null) {
                toolWrapper = profile.getInspectionTool(idKey.toString(), element2);
            }
            if (toolWrapper != null) {
                InspectionProfileEntry wrappedTool;
                this.myCanCleanup = toolWrapper.isCleanupTool();
                IntentionAction fixAllIntention = intentionManager.createFixAllIntention(toolWrapper, this.myAction);
                InspectionProfileEntry inspectionProfileEntry = wrappedTool = toolWrapper instanceof LocalInspectionToolWrapper ? ((LocalInspectionToolWrapper)toolWrapper).getTool() : ((GlobalInspectionToolWrapper)toolWrapper).getTool();
                if (wrappedTool instanceof DefaultHighlightVisitorBasedInspection.AnnotatorBasedInspection) {
                    List<IntentionAction> actions = Collections.emptyList();
                    if (this.myProblemGroup instanceof SuppressableProblemGroup) {
                        actions = Arrays.asList(((SuppressableProblemGroup)this.myProblemGroup).getSuppressActions(element2));
                    }
                    if (fixAllIntention != null) {
                        if (actions.isEmpty()) {
                            return Collections.singletonList(fixAllIntention);
                        }
                        actions = new ArrayList<IntentionAction>(actions);
                        actions.add(fixAllIntention);
                    }
                    return actions;
                }
                ContainerUtil.addIfNotNull((Collection)newOptions, (Object)fixAllIntention);
                if (wrappedTool instanceof CustomSuppressableInspectionTool) {
                    Object[] suppressActions = ((CustomSuppressableInspectionTool)wrappedTool).getSuppressActions(element2);
                    if (suppressActions != null) {
                        ContainerUtil.addAll((Collection)newOptions, (Object[])suppressActions);
                    }
                } else {
                    Object[] suppressFixes = wrappedTool.getBatchSuppressActions(element2);
                    if (suppressFixes.length > 0) {
                        newOptions.addAll(ContainerUtil.map((Object[])suppressFixes, SuppressIntentionActionFromFix::convertBatchToSuppressIntentionAction));
                    }
                }
            }
            if (this.myProblemGroup instanceof SuppressableProblemGroup) {
                Object[] suppressActions = ((SuppressableProblemGroup)this.myProblemGroup).getSuppressActions(element2);
                ContainerUtil.addAll((Collection)newOptions, (Object[])suppressActions);
            }
            IntentionActionDescriptor intentionActionDescriptor = this;
            synchronized (intentionActionDescriptor) {
                options = this.myOptions;
                if (options == null) {
                    this.myOptions = options = newOptions;
                }
                this.myKey = null;
            }
            return options;
        }

        @Nullable
        public String getDisplayName() {
            return this.myDisplayName;
        }

        public String toString() {
            String text2 = this.getAction().getText();
            return "descriptor: " + (text2.isEmpty() ? this.getAction().getClass() : text2);
        }

        @Nullable
        public Icon getIcon() {
            return this.myIcon;
        }

        public boolean equals(Object obj) {
            return obj instanceof IntentionActionDescriptor && this.myAction.equals(((IntentionActionDescriptor)obj).myAction);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "canCleanup";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getOptions";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class B
    implements Builder {
        private Boolean myNeedsUpdateOnTyping;
        private TextAttributes forcedTextAttributes;
        private TextAttributesKey forcedTextAttributesKey;
        private final HighlightInfoType type;
        private int startOffset;
        private int endOffset;
        private String escapedDescription;
        private String escapedToolTip;
        private HighlightSeverity severity;
        private boolean isAfterEndOfLine;
        private boolean isFileLevelAnnotation;
        private int navigationShift;
        private GutterIconRenderer gutterIconRenderer;
        private ProblemGroup problemGroup;
        private String inspectionToolId;
        private PsiElement psiElement;
        private int group;

        private B(@NotNull HighlightInfoType type) {
            if (type == null) {
                B.$$$reportNull$$$0(0);
            }
            this.startOffset = -1;
            this.endOffset = -1;
            this.type = type;
        }

        @Override
        @NotNull
        public Builder gutterIconRenderer(@NotNull GutterIconRenderer gutterIconRenderer) {
            if (gutterIconRenderer == null) {
                B.$$$reportNull$$$0(1);
            }
            assert (this.gutterIconRenderer == null) : "gutterIconRenderer already set";
            this.gutterIconRenderer = gutterIconRenderer;
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(2);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder problemGroup(@NotNull ProblemGroup problemGroup) {
            if (problemGroup == null) {
                B.$$$reportNull$$$0(3);
            }
            assert (this.problemGroup == null) : "problemGroup already set";
            this.problemGroup = problemGroup;
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(4);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder inspectionToolId(@NotNull String inspectionToolId) {
            if (inspectionToolId == null) {
                B.$$$reportNull$$$0(5);
            }
            assert (this.inspectionToolId == null) : "inspectionToolId already set";
            this.inspectionToolId = inspectionToolId;
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(6);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder description(@NotNull String description) {
            if (description == null) {
                B.$$$reportNull$$$0(7);
            }
            assert (this.escapedDescription == null) : "description already set";
            this.escapedDescription = description;
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(8);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder descriptionAndTooltip(@NotNull String description) {
            if (description == null) {
                B.$$$reportNull$$$0(9);
            }
            Builder builder2 = this.description(description).unescapedToolTip(description);
            if (builder2 == null) {
                B.$$$reportNull$$$0(10);
            }
            return builder2;
        }

        @Override
        @NotNull
        public Builder textAttributes(@NotNull TextAttributes attributes) {
            if (attributes == null) {
                B.$$$reportNull$$$0(11);
            }
            assert (this.forcedTextAttributes == null) : "textAttributes already set";
            this.forcedTextAttributes = attributes;
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(12);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder textAttributes(@NotNull TextAttributesKey attributesKey) {
            if (attributesKey == null) {
                B.$$$reportNull$$$0(13);
            }
            assert (this.forcedTextAttributesKey == null) : "textAttributesKey already set";
            this.forcedTextAttributesKey = attributesKey;
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(14);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder unescapedToolTip(@NotNull String unescapedToolTip) {
            if (unescapedToolTip == null) {
                B.$$$reportNull$$$0(15);
            }
            assert (this.escapedToolTip == null) : "Tooltip was already set";
            this.escapedToolTip = HighlightInfo.htmlEscapeToolTip(unescapedToolTip);
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(16);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder escapedToolTip(@NotNull String escapedToolTip) {
            if (escapedToolTip == null) {
                B.$$$reportNull$$$0(17);
            }
            assert (this.escapedToolTip == null) : "Tooltip was already set";
            this.escapedToolTip = escapedToolTip;
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(18);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder range(int start2, int end) {
            assert (this.startOffset == -1 && this.endOffset == -1) : "Offsets already set";
            this.startOffset = start2;
            this.endOffset = end;
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(19);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder range(@NotNull TextRange textRange) {
            if (textRange == null) {
                B.$$$reportNull$$$0(20);
            }
            assert (this.startOffset == -1 && this.endOffset == -1) : "Offsets already set";
            this.startOffset = textRange.getStartOffset();
            this.endOffset = textRange.getEndOffset();
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(21);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder range(@NotNull ASTNode node) {
            if (node == null) {
                B.$$$reportNull$$$0(22);
            }
            Builder builder2 = this.range(node.getPsi());
            if (builder2 == null) {
                B.$$$reportNull$$$0(23);
            }
            return builder2;
        }

        @Override
        @NotNull
        public Builder range(@NotNull PsiElement element2) {
            if (element2 == null) {
                B.$$$reportNull$$$0(24);
            }
            assert (this.psiElement == null) : " psiElement already set";
            this.psiElement = element2;
            Builder builder2 = this.range(element2.getTextRange());
            if (builder2 == null) {
                B.$$$reportNull$$$0(25);
            }
            return builder2;
        }

        @Override
        @NotNull
        public Builder range(@NotNull PsiElement element2, @NotNull TextRange rangeInElement) {
            if (element2 == null) {
                B.$$$reportNull$$$0(26);
            }
            if (rangeInElement == null) {
                B.$$$reportNull$$$0(27);
            }
            TextRange absoluteRange = rangeInElement.shiftRight(element2.getTextRange().getStartOffset());
            Builder builder2 = this.range(element2, absoluteRange.getStartOffset(), absoluteRange.getEndOffset());
            if (builder2 == null) {
                B.$$$reportNull$$$0(28);
            }
            return builder2;
        }

        @Override
        @NotNull
        public Builder range(@NotNull PsiElement element2, int start2, int end) {
            if (element2 == null) {
                B.$$$reportNull$$$0(29);
            }
            assert (this.psiElement == null) : " psiElement already set";
            this.psiElement = element2;
            Builder builder2 = this.range(start2, end);
            if (builder2 == null) {
                B.$$$reportNull$$$0(30);
            }
            return builder2;
        }

        @Override
        @NotNull
        public Builder endOfLine() {
            this.isAfterEndOfLine = true;
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(31);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder needsUpdateOnTyping(boolean update2) {
            assert (this.myNeedsUpdateOnTyping == null) : " needsUpdateOnTyping already set";
            this.myNeedsUpdateOnTyping = update2;
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(32);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder severity(@NotNull HighlightSeverity severity) {
            if (severity == null) {
                B.$$$reportNull$$$0(33);
            }
            assert (this.severity == null) : " severity already set";
            this.severity = severity;
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(34);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder fileLevelAnnotation() {
            this.isFileLevelAnnotation = true;
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(35);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder navigationShift(int navigationShift) {
            this.navigationShift = navigationShift;
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(36);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder group(int group) {
            this.group = group;
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(37);
            }
            return b;
        }

        @Override
        @Nullable
        public HighlightInfo create() {
            HighlightInfo info = this.createUnconditionally();
            LOG.assertTrue(this.psiElement != null || this.severity == HighlightInfoType.SYMBOL_TYPE_SEVERITY || this.severity == HighlightInfoType.INJECTED_FRAGMENT_SEVERITY || ArrayUtil.find((Object[])HighlightSeverity.DEFAULT_SEVERITIES, (Object)this.severity) != -1, (Object)"Custom type requires not-null element to detect its text attributes");
            if (!HighlightInfo.isAcceptedByFilters(info, this.psiElement)) {
                return null;
            }
            return info;
        }

        @Override
        @NotNull
        public HighlightInfo createUnconditionally() {
            if (this.severity == null) {
                this.severity = this.type.getSeverity(this.psiElement);
            }
            return new HighlightInfo(this.forcedTextAttributes, this.forcedTextAttributesKey, this.type, this.startOffset, this.endOffset, this.escapedDescription, this.escapedToolTip, this.severity, this.isAfterEndOfLine, this.myNeedsUpdateOnTyping, this.isFileLevelAnnotation, this.navigationShift, this.problemGroup, this.inspectionToolId, (GutterMark)this.gutterIconRenderer, this.group);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 18: 
                case 19: 
                case 21: 
                case 23: 
                case 25: 
                case 28: 
                case 30: 
                case 31: 
                case 32: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 18: 
                case 19: 
                case 21: 
                case 23: 
                case 25: 
                case 28: 
                case 30: 
                case 31: 
                case 32: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gutterIconRenderer";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 18: 
                case 19: 
                case 21: 
                case 23: 
                case 25: 
                case 28: 
                case 30: 
                case 31: 
                case 32: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightInfo$B";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problemGroup";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inspectionToolId";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributesKey";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unescapedToolTip";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "escapedToolTip";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textRange";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 24: 
                case 26: 
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeInElement";
                    break;
                }
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "severity";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfo$B";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "gutterIconRenderer";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "problemGroup";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "inspectionToolId";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "description";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "descriptionAndTooltip";
                    break;
                }
                case 12: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "textAttributes";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "unescapedToolTip";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "escapedToolTip";
                    break;
                }
                case 19: 
                case 21: 
                case 23: 
                case 25: 
                case 28: 
                case 30: {
                    objectArray = objectArray2;
                    objectArray2[1] = "range";
                    break;
                }
                case 31: {
                    objectArray = objectArray2;
                    objectArray2[1] = "endOfLine";
                    break;
                }
                case 32: {
                    objectArray = objectArray2;
                    objectArray2[1] = "needsUpdateOnTyping";
                    break;
                }
                case 34: {
                    objectArray = objectArray2;
                    objectArray2[1] = "severity";
                    break;
                }
                case 35: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fileLevelAnnotation";
                    break;
                }
                case 36: {
                    objectArray = objectArray2;
                    objectArray2[1] = "navigationShift";
                    break;
                }
                case 37: {
                    objectArray = objectArray2;
                    objectArray2[1] = "group";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "gutterIconRenderer";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 18: 
                case 19: 
                case 21: 
                case 23: 
                case 25: 
                case 28: 
                case 30: 
                case 31: 
                case 32: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "problemGroup";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "inspectionToolId";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "description";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "descriptionAndTooltip";
                    break;
                }
                case 11: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "textAttributes";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "unescapedToolTip";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "escapedToolTip";
                    break;
                }
                case 20: 
                case 22: 
                case 24: 
                case 26: 
                case 27: 
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "range";
                    break;
                }
                case 33: {
                    objectArray = objectArray;
                    objectArray[2] = "severity";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 18: 
                case 19: 
                case 21: 
                case 23: 
                case 25: 
                case 28: 
                case 30: 
                case 31: 
                case 32: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Builder {
        @NotNull
        public Builder range(@NotNull TextRange var1);

        @NotNull
        public Builder range(@NotNull ASTNode var1);

        @NotNull
        public Builder range(@NotNull PsiElement var1);

        @NotNull
        public Builder range(@NotNull PsiElement var1, @NotNull TextRange var2);

        @NotNull
        public Builder range(@NotNull PsiElement var1, int var2, int var3);

        @NotNull
        public Builder range(int var1, int var2);

        @NotNull
        public Builder gutterIconRenderer(@NotNull GutterIconRenderer var1);

        @NotNull
        public Builder problemGroup(@NotNull ProblemGroup var1);

        @NotNull
        public Builder inspectionToolId(@NotNull String var1);

        @NotNull
        public Builder description(@NotNull String var1);

        @NotNull
        public Builder descriptionAndTooltip(@NotNull String var1);

        @NotNull
        public Builder textAttributes(@NotNull TextAttributes var1);

        @NotNull
        public Builder textAttributes(@NotNull TextAttributesKey var1);

        @NotNull
        public Builder unescapedToolTip(@NotNull String var1);

        @NotNull
        public Builder escapedToolTip(@NotNull String var1);

        @NotNull
        public Builder endOfLine();

        @NotNull
        public Builder needsUpdateOnTyping(boolean var1);

        @NotNull
        public Builder severity(@NotNull HighlightSeverity var1);

        @NotNull
        public Builder fileLevelAnnotation();

        @NotNull
        public Builder navigationShift(int var1);

        @NotNull
        public Builder group(int var1);

        @Nullable(value="null means filtered out")
        public @Nullable(value="null means filtered out") HighlightInfo create();

        @NotNull
        public HighlightInfo createUnconditionally();
    }

    private static @interface FlagConstant {
    }
}

