/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.documentation.DocFontSizePopup;
import com.intellij.codeInsight.documentation.render.DocRenderDummyLineMarkerProvider;
import com.intellij.codeInsight.documentation.render.DocRenderItemUpdater;
import com.intellij.codeInsight.documentation.render.DocRenderMouseEventBridge;
import com.intellij.codeInsight.documentation.render.DocRenderPassFactory;
import com.intellij.codeInsight.documentation.render.DocRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DocRenderItem {
    private static final Key<DocRenderItem> OUR_ITEM = Key.create((String)"doc.render.item");
    private static final Key<Collection<DocRenderItem>> OUR_ITEMS = Key.create((String)"doc.render.items");
    private static final Key<VisibleAreaListener> VISIBLE_AREA_LISTENER = Key.create((String)"doc.render.visible.area.listener");
    private static final Key<Disposable> LISTENERS_DISPOSABLE = Key.create((String)"doc.render.listeners.disposable");
    final Editor editor;
    final RangeHighlighter highlighter;
    String textToRender;
    private FoldRegion foldRegion;
    Inlay<DocRenderer> inlay;

    static boolean isValidRange(@NotNull Document document, @NotNull TextRange range2) {
        if (document == null) {
            DocRenderItem.$$$reportNull$$$0(0);
        }
        if (range2 == null) {
            DocRenderItem.$$$reportNull$$$0(1);
        }
        CharSequence text2 = document.getImmutableCharSequence();
        int startOffset = range2.getStartOffset();
        int endOffset = range2.getEndOffset();
        int startLine = document.getLineNumber(startOffset);
        int endLine = document.getLineNumber(endOffset);
        return startLine > 0 && endLine < document.getLineCount() - 1 && CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)text2.subSequence(document.getLineStartOffset(startLine), startOffset)) && CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)text2.subSequence(endOffset, document.getLineEndOffset(endLine)));
    }

    static void setItemsToEditor(@NotNull Editor editor, @NotNull DocRenderPassFactory.Items itemsToSet, boolean collapseNewItems) {
        ArrayList items;
        ArrayList existing;
        if (editor == null) {
            DocRenderItem.$$$reportNull$$$0(2);
        }
        if (itemsToSet == null) {
            DocRenderItem.$$$reportNull$$$0(3);
        }
        if ((existing = (ArrayList)editor.getUserData(OUR_ITEMS)) == null) {
            if (itemsToSet.isEmpty()) {
                return;
            }
            items = new ArrayList();
            editor.putUserData(OUR_ITEMS, items);
        } else {
            items = existing;
        }
        DocRenderItem.keepScrollingPositionWhile(editor, () -> {
            ArrayList<Runnable> foldingTasks = new ArrayList<Runnable>();
            ArrayList<DocRenderItem> itemsToUpdateInlays = new ArrayList<DocRenderItem>();
            boolean updated = false;
            Iterator it = items.iterator();
            while (it.hasNext()) {
                DocRenderPassFactory.Item matchingItem;
                DocRenderItem item = (DocRenderItem)it.next();
                DocRenderPassFactory.Item item2 = matchingItem = item.isValid() ? itemsToSet.removeItem((Segment)item.highlighter) : null;
                if (matchingItem == null) {
                    updated |= item.remove(foldingTasks);
                    it.remove();
                    continue;
                }
                if (matchingItem.textToRender != null && !matchingItem.textToRender.equals(item.textToRender)) {
                    item.textToRender = matchingItem.textToRender;
                    itemsToUpdateInlays.add(item);
                    continue;
                }
                item.updateIcon();
            }
            ArrayList<DocRenderItem> newRenderItems = new ArrayList<DocRenderItem>();
            for (DocRenderPassFactory.Item item : itemsToSet) {
                DocRenderItem newItem = new DocRenderItem(editor, item.textRange, collapseNewItems ? null : item.textToRender);
                newRenderItems.add(newItem);
                if (!collapseNewItems) continue;
                updated |= newItem.toggle(foldingTasks);
                newItem.textToRender = item.textToRender;
                itemsToUpdateInlays.add(newItem);
            }
            editor.getFoldingModel().runBatchFoldingOperation(() -> foldingTasks.forEach(Runnable::run), true, false);
            newRenderItems.forEach(DocRenderItem::cleanup);
            items.addAll(newRenderItems);
            return updated |= DocRenderItem.updateInlays(itemsToUpdateInlays);
        });
        DocRenderItem.setupListeners(editor, items.isEmpty());
    }

    private static void setupListeners(final @NotNull Editor editor, boolean disable) {
        if (editor == null) {
            DocRenderItem.$$$reportNull$$$0(4);
        }
        if (disable) {
            Disposable listenersDisposable;
            VisibleAreaListener visibleAreaListener = (VisibleAreaListener)editor.getUserData(VISIBLE_AREA_LISTENER);
            if (visibleAreaListener != null) {
                editor.getScrollingModel().removeVisibleAreaListener(visibleAreaListener);
                editor.putUserData(VISIBLE_AREA_LISTENER, null);
            }
            if ((listenersDisposable = (Disposable)editor.getUserData(LISTENERS_DISPOSABLE)) != null) {
                Disposer.dispose((Disposable)listenersDisposable);
                editor.putUserData(LISTENERS_DISPOSABLE, null);
            }
        } else {
            if (editor.getUserData(VISIBLE_AREA_LISTENER) == null) {
                MyVisibleAreaListener visibleAreaListener = new MyVisibleAreaListener(editor);
                editor.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)visibleAreaListener);
                editor.putUserData(VISIBLE_AREA_LISTENER, (Object)visibleAreaListener);
            }
            if (editor.getUserData(LISTENERS_DISPOSABLE) == null) {
                MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
                connection.setDefaultHandler((event, params) -> DocRenderItem.updateInlays(editor));
                connection.subscribe(EditorColorsManager.TOPIC);
                EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

                    public void editorReleased(@NotNull EditorFactoryEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (event.getEditor() == editor) {
                            DocRenderItem.setItemsToEditor(editor, new DocRenderPassFactory.Items(), false);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/documentation/render/DocRenderItem$1", "editorReleased"));
                    }
                }, (Disposable)connection);
                editor.getCaretModel().addCaretListener((CaretListener)new MyCaretListener(), (Disposable)connection);
                DocRenderMouseEventBridge mouseEventBridge = new DocRenderMouseEventBridge();
                editor.addEditorMouseListener((EditorMouseListener)mouseEventBridge, (Disposable)connection);
                editor.addEditorMouseMotionListener((EditorMouseMotionListener)mouseEventBridge, (Disposable)connection);
                editor.putUserData(LISTENERS_DISPOSABLE, (Object)connection);
            }
        }
    }

    private static void keepScrollingPositionWhile(@NotNull Editor editor, @NotNull BooleanSupplier task2) {
        if (editor == null) {
            DocRenderItem.$$$reportNull$$$0(5);
        }
        if (task2 == null) {
            DocRenderItem.$$$reportNull$$$0(6);
        }
        EditorScrollingPositionKeeper keeper = new EditorScrollingPositionKeeper(editor);
        keeper.savePosition();
        if (task2.getAsBoolean()) {
            keeper.restorePosition(false);
        }
    }

    static DocRenderItem getItemAroundOffset(@NotNull Editor editor, int offset) {
        Collection items;
        if (editor == null) {
            DocRenderItem.$$$reportNull$$$0(7);
        }
        if ((items = (Collection)editor.getUserData(OUR_ITEMS)) == null || items.isEmpty()) {
            return null;
        }
        Document document = editor.getDocument();
        if (offset < 0 || offset > document.getTextLength()) {
            return null;
        }
        int line = document.getLineNumber(offset);
        return items.stream().filter(i -> {
            if (!i.isValid()) {
                return false;
            }
            int startLine = document.getLineNumber(i.highlighter.getStartOffset());
            int endLine = document.getLineNumber(i.highlighter.getEndOffset());
            return line >= startLine - 1 && line <= endLine + 1;
        }).min(Comparator.comparingInt(i -> i.highlighter.getStartOffset())).orElse(null);
    }

    private DocRenderItem(@NotNull Editor editor, @NotNull TextRange textRange, @Nullable String textToRender) {
        if (editor == null) {
            DocRenderItem.$$$reportNull$$$0(8);
        }
        if (textRange == null) {
            DocRenderItem.$$$reportNull$$$0(9);
        }
        this.editor = editor;
        this.textToRender = textToRender;
        assert (editor.getProject() != null);
        this.highlighter = editor.getMarkupModel().addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), 0, null, HighlighterTargetArea.EXACT_RANGE);
        this.updateIcon();
    }

    private int calcFoldStartOffset() {
        Document document = this.highlighter.getDocument();
        int startLine = document.getLineNumber(this.highlighter.getStartOffset());
        return startLine == 0 ? 0 : document.getLineEndOffset(startLine - 1);
    }

    private int calcFoldEndOffset() {
        return this.highlighter.getEndOffset();
    }

    private int calcInlayOffset() {
        int endOffset;
        Document document = this.highlighter.getDocument();
        int endLine = document.getLineNumber(endOffset = this.highlighter.getEndOffset());
        return endLine < document.getLineCount() - 1 ? document.getLineStartOffset(endLine + 1) : endOffset;
    }

    private boolean isValid() {
        if (!this.highlighter.isValid() || this.highlighter.getStartOffset() >= this.highlighter.getEndOffset()) {
            return false;
        }
        return this.foldRegion == null && this.inlay == null || this.foldRegion != null && this.foldRegion.isValid() && this.foldRegion.getStartOffset() == this.calcFoldStartOffset() && this.foldRegion.getEndOffset() == this.calcFoldEndOffset() && this.inlay != null && this.inlay.isValid() && this.inlay.getOffset() == this.calcInlayOffset();
    }

    private void cleanup() {
        if (this.foldRegion == null && this.inlay != null && this.inlay.isValid()) {
            Disposer.dispose(this.inlay);
            this.inlay = null;
        }
    }

    private boolean remove(@NotNull Collection<Runnable> foldingTasks) {
        if (foldingTasks == null) {
            DocRenderItem.$$$reportNull$$$0(10);
        }
        boolean updated = false;
        this.highlighter.dispose();
        if (this.foldRegion != null && this.foldRegion.isValid()) {
            foldingTasks.add(() -> this.foldRegion.getEditor().getFoldingModel().removeFoldRegion(this.foldRegion));
            updated = true;
        }
        if (this.inlay != null && this.inlay.isValid()) {
            Disposer.dispose(this.inlay);
            updated = true;
        }
        return updated;
    }

    boolean toggle(@Nullable Collection<Runnable> foldingTasks) {
        if (!(this.editor instanceof EditorEx)) {
            return false;
        }
        FoldingModelEx foldingModel = ((EditorEx)this.editor).getFoldingModel();
        if (this.foldRegion == null) {
            if (this.textToRender == null && foldingTasks == null) {
                this.generateHtmlInBackgroundAndToggle();
                return false;
            }
            int inlayOffset = this.calcInlayOffset();
            this.inlay = this.editor.getInlayModel().addBlockElement(inlayOffset, true, true, -100, (EditorCustomElementRenderer)new DocRenderer(this));
            if (this.inlay != null) {
                int foldStartOffset = this.calcFoldStartOffset();
                int foldEndOffset = this.calcFoldEndOffset();
                Runnable foldingTask = () -> {
                    this.foldRegion = foldingModel.createFoldRegion(foldStartOffset, foldEndOffset, "", null, true);
                    if (this.foldRegion != null) {
                        this.foldRegion.putUserData(OUR_ITEM, (Object)this);
                    }
                };
                if (foldingTasks == null) {
                    foldingModel.runBatchFoldingOperation(foldingTask, true, false);
                    this.cleanup();
                } else {
                    foldingTasks.add(foldingTask);
                }
            }
        } else {
            Runnable foldingTask = () -> {
                for (FoldRegion region : foldingModel.getAllFoldRegions()) {
                    if (region.getStartOffset() < this.foldRegion.getStartOffset() || region.getEndOffset() > this.foldRegion.getEndOffset()) continue;
                    region.setExpanded(true);
                }
                foldingModel.removeFoldRegion(this.foldRegion);
                this.foldRegion = null;
            };
            if (foldingTasks == null) {
                foldingModel.runBatchFoldingOperation(foldingTask, true, false);
            } else {
                foldingTasks.add(foldingTask);
            }
            Disposer.dispose(this.inlay);
            this.inlay = null;
            if (!EditorSettingsExternalizable.getInstance().isDocCommentRenderingEnabled()) {
                this.textToRender = null;
            }
        }
        return true;
    }

    private void generateHtmlInBackgroundAndToggle() {
        ReadAction.nonBlocking(() -> DocRenderPassFactory.calcText(this.getComment())).withDocumentsCommitted(Objects.requireNonNull(this.editor.getProject())).coalesceBy(new Object[]{this}).finishOnUiThread(ModalityState.any(), html -> {
            this.textToRender = html;
            this.toggle(null);
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    PsiDocCommentBase getComment() {
        PsiDocumentManager psiDocumentManager;
        PsiFile file2;
        if (this.highlighter.isValid() && (file2 = (psiDocumentManager = PsiDocumentManager.getInstance((Project)Objects.requireNonNull(this.editor.getProject()))).getPsiFile(this.editor.getDocument())) != null) {
            return (PsiDocCommentBase)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(this.highlighter.getStartOffset()), PsiDocCommentBase.class, (boolean)false);
        }
        return null;
    }

    private static boolean updateInlays(@NotNull Collection<DocRenderItem> items) {
        if (items == null) {
            DocRenderItem.$$$reportNull$$$0(11);
        }
        return DocRenderItemUpdater.getInstance().updateInlays(ContainerUtil.mapNotNull(items, i -> i.inlay));
    }

    private static void updateInlays(@NotNull Editor editor) {
        if (editor == null) {
            DocRenderItem.$$$reportNull$$$0(12);
        }
        DocRenderItem.keepScrollingPositionWhile(editor, () -> {
            Collection items = (Collection)editor.getUserData(OUR_ITEMS);
            return items != null && DocRenderItem.updateInlays(items);
        });
    }

    private void updateIcon() {
        boolean iconExists;
        boolean iconEnabled = DocRenderDummyLineMarkerProvider.isGutterIconEnabled();
        boolean bl = iconExists = this.highlighter.getGutterIconRenderer() != null;
        if (iconEnabled != iconExists) {
            if (iconEnabled) {
                this.highlighter.setGutterIconRenderer((GutterIconRenderer)new MyGutterIconRenderer(AllIcons.Gutter.JavadocRead));
            } else {
                this.highlighter.setGutterIconRenderer(null);
            }
            if (this.inlay != null) {
                this.inlay.update();
            }
        }
    }

    AnAction createToggleAction() {
        return new ToggleRenderingAction(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemsToSet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingTasks";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderItem";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidRange";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setItemsToEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setupListeners";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "keepScrollingPositionWhile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getItemAroundOffset";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "updateInlays";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class ChangeFontSize
    extends DumbAwareAction {
        ChangeFontSize() {
            super(CodeInsightBundle.messagePointer((String)"javadoc.adjust.font.size", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Editor editor;
            if (e == null) {
                ChangeFontSize.$$$reportNull$$$0(0);
            }
            if ((editor = (Editor)e.getData(CommonDataKeys.EDITOR)) != null) {
                DocFontSizePopup.show(() -> DocRenderItem.updateInlays(editor));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/render/DocRenderItem$ChangeFontSize", "actionPerformed"));
        }
    }

    private static class ToggleRenderingAction
    extends DumbAwareAction {
        private final DocRenderItem item;

        private ToggleRenderingAction(DocRenderItem item) {
            this.copyFrom(ActionManager.getInstance().getAction("ToggleRenderedDocPresentation"));
            this.item = item;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleRenderingAction.$$$reportNull$$$0(0);
            }
            if (this.item.isValid()) {
                this.item.toggle(null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/render/DocRenderItem$ToggleRenderingAction", "actionPerformed"));
        }
    }

    class MyGutterIconRenderer
    extends GutterIconRenderer
    implements DumbAware {
        private final Icon icon;

        MyGutterIconRenderer(Icon icon2) {
            this.icon = icon2;
        }

        public boolean equals(Object obj) {
            return obj instanceof MyGutterIconRenderer;
        }

        public int hashCode() {
            return 0;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon2 = this.icon;
            if (icon2 == null) {
                MyGutterIconRenderer.$$$reportNull$$$0(0);
            }
            return icon2;
        }

        @NotNull
        public GutterIconRenderer.Alignment getAlignment() {
            GutterIconRenderer.Alignment alignment = GutterIconRenderer.Alignment.RIGHT;
            if (alignment == null) {
                MyGutterIconRenderer.$$$reportNull$$$0(1);
            }
            return alignment;
        }

        public boolean isNavigateAction() {
            return true;
        }

        @Nullable
        public String getTooltipText() {
            AnAction action2 = ActionManager.getInstance().getAction("ToggleRenderedDocPresentation");
            if (action2 == null) {
                return null;
            }
            String actionText = action2.getTemplateText();
            if (actionText == null) {
                return null;
            }
            return XmlStringUtil.wrapInHtml((CharSequence)(actionText + HelpTooltip.getShortcutAsHtml((String)KeymapUtil.getFirstKeyboardShortcutText((AnAction)action2))));
        }

        @Nullable
        public AnAction getClickAction() {
            return DocRenderItem.this.createToggleAction();
        }

        public ActionGroup getPopupMenuActions() {
            return (ActionGroup)ObjectUtils.tryCast((Object)ActionManager.getInstance().getAction("DocCommentGutterIconContextMenu"), ActionGroup.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInsight/documentation/render/DocRenderItem$MyGutterIconRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAlignment";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class MyVisibleAreaListener
    implements VisibleAreaListener {
        private int lastWidth;
        private AffineTransform lastFrcTransform;

        private MyVisibleAreaListener(@NotNull Editor editor) {
            if (editor == null) {
                MyVisibleAreaListener.$$$reportNull$$$0(0);
            }
            this.lastWidth = DocRenderer.calcInlayWidth(editor);
            this.lastFrcTransform = MyVisibleAreaListener.getTransform(editor);
        }

        private static AffineTransform getTransform(Editor editor) {
            return FontInfo.getFontRenderContext(editor.getContentComponent()).getTransform();
        }

        public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
            if (e == null) {
                MyVisibleAreaListener.$$$reportNull$$$0(1);
            }
            if (e.getNewRectangle().isEmpty()) {
                return;
            }
            Editor editor = e.getEditor();
            int newWidth = DocRenderer.calcInlayWidth(editor);
            AffineTransform transform = MyVisibleAreaListener.getTransform(editor);
            if (newWidth != this.lastWidth || !Objects.equals(transform, this.lastFrcTransform)) {
                this.lastWidth = newWidth;
                this.lastFrcTransform = transform;
                DocRenderItem.updateInlays(editor);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderItem$MyVisibleAreaListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visibleAreaChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyCaretListener
    implements CaretListener {
        private MyCaretListener() {
        }

        public void caretPositionChanged(@NotNull CaretEvent event) {
            if (event == null) {
                MyCaretListener.$$$reportNull$$$0(0);
            }
            MyCaretListener.onCaretUpdate(event);
        }

        public void caretAdded(@NotNull CaretEvent event) {
            if (event == null) {
                MyCaretListener.$$$reportNull$$$0(1);
            }
            MyCaretListener.onCaretUpdate(event);
        }

        private static void onCaretUpdate(@NotNull CaretEvent event) {
            DocRenderItem item;
            Caret caret;
            if (event == null) {
                MyCaretListener.$$$reportNull$$$0(2);
            }
            if ((caret = event.getCaret()) == null) {
                return;
            }
            int caretOffset = caret.getOffset();
            FoldRegion foldRegion = caret.getEditor().getFoldingModel().getCollapsedRegionAtOffset(caretOffset);
            if (foldRegion != null && caretOffset > foldRegion.getStartOffset() && (item = (DocRenderItem)foldRegion.getUserData(OUR_ITEM)) != null) {
                item.toggle(null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderItem$MyCaretListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "caretPositionChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "caretAdded";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onCaretUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

