/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.tree.injected.FoldingRegionWindow;
import com.intellij.util.ObjectUtils;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorFoldingInfo {
    private static final Key<EditorFoldingInfo> KEY = Key.create((String)"EditorFoldingInfo.KEY");
    private static final Object ourLock = ObjectUtils.sentinel((String)"lock");
    private final Map<FoldRegion, SmartPsiElementPointer<?>> myFoldRegionToSmartPointerMap = Collections.synchronizedMap(new THashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static EditorFoldingInfo get(@NotNull Editor editor) {
        if (editor == null) {
            EditorFoldingInfo.$$$reportNull$$$0(0);
        }
        if (editor instanceof EditorWindow) {
            return new EditorFoldingInfoWindow(EditorFoldingInfo.get(((EditorWindow)editor).getDelegate()));
        }
        Object object = ourLock;
        // MONITORENTER : object
        EditorFoldingInfo info = (EditorFoldingInfo)editor.getUserData(KEY);
        if (info == null) {
            info = new EditorFoldingInfo();
            editor.putUserData(KEY, (Object)info);
        }
        EditorFoldingInfo editorFoldingInfo = info;
        // MONITOREXIT : object
        if (editorFoldingInfo != null) return editorFoldingInfo;
        EditorFoldingInfo.$$$reportNull$$$0(1);
        return editorFoldingInfo;
    }

    @Nullable
    public PsiElement getPsiElement(@NotNull FoldRegion region) {
        SmartPsiElementPointer<?> pointer;
        if (region == null) {
            EditorFoldingInfo.$$$reportNull$$$0(2);
        }
        if ((pointer = this.myFoldRegionToSmartPointerMap.get(region)) == null) {
            return null;
        }
        PsiElement element2 = pointer.getElement();
        return element2 != null && element2.isValid() ? element2 : null;
    }

    @Nullable
    TextRange getPsiElementRange(@NotNull FoldRegion region) {
        PsiElement element2;
        if (region == null) {
            EditorFoldingInfo.$$$reportNull$$$0(3);
        }
        if ((element2 = this.getPsiElement(region)) == null) {
            return null;
        }
        PsiFile containingFile = element2.getContainingFile();
        InjectedLanguageManager injectedManager = InjectedLanguageManager.getInstance((Project)containingFile.getProject());
        boolean isInjected = injectedManager.isInjectedFragment(containingFile);
        TextRange range2 = element2.getTextRange();
        if (isInjected) {
            range2 = injectedManager.injectedToHost(element2, range2);
        }
        return range2;
    }

    void addRegion(@NotNull FoldRegion region, @NotNull SmartPsiElementPointer<?> pointer) {
        if (region == null) {
            EditorFoldingInfo.$$$reportNull$$$0(4);
        }
        if (pointer == null) {
            EditorFoldingInfo.$$$reportNull$$$0(5);
        }
        this.myFoldRegionToSmartPointerMap.put(region, pointer);
    }

    public void removeRegion(@NotNull FoldRegion region) {
        if (region == null) {
            EditorFoldingInfo.$$$reportNull$$$0(6);
        }
        this.myFoldRegionToSmartPointerMap.remove(region);
    }

    public void dispose() {
        this.myFoldRegionToSmartPointerMap.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/folding/impl/EditorFoldingInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/EditorFoldingInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementRange";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addRegion";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeRegion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EditorFoldingInfoWindow
    extends EditorFoldingInfo {
        private final EditorFoldingInfo myDelegate;

        private EditorFoldingInfoWindow(EditorFoldingInfo delegate) {
            this.myDelegate = delegate;
        }

        @Override
        @Nullable
        public PsiElement getPsiElement(@NotNull FoldRegion region) {
            if (region == null) {
                EditorFoldingInfoWindow.$$$reportNull$$$0(0);
            }
            return this.myDelegate.getPsiElement(EditorFoldingInfoWindow.getHostRegion(region));
        }

        @Override
        void addRegion(@NotNull FoldRegion region, @NotNull SmartPsiElementPointer<?> pointer) {
            if (region == null) {
                EditorFoldingInfoWindow.$$$reportNull$$$0(1);
            }
            if (pointer == null) {
                EditorFoldingInfoWindow.$$$reportNull$$$0(2);
            }
            this.myDelegate.addRegion(EditorFoldingInfoWindow.getHostRegion(region), pointer);
        }

        @Override
        public void removeRegion(@NotNull FoldRegion region) {
            if (region == null) {
                EditorFoldingInfoWindow.$$$reportNull$$$0(3);
            }
            this.myDelegate.removeRegion(EditorFoldingInfoWindow.getHostRegion(region));
        }

        @Override
        public void dispose() {
            this.myDelegate.dispose();
        }

        private static FoldRegion getHostRegion(@NotNull FoldRegion injectedRegion) {
            if (injectedRegion == null) {
                EditorFoldingInfoWindow.$$$reportNull$$$0(4);
            }
            return injectedRegion instanceof FoldingRegionWindow ? ((FoldingRegionWindow)injectedRegion).getDelegate() : injectedRegion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "region";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pointer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "injectedRegion";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/folding/impl/EditorFoldingInfo$EditorFoldingInfoWindow";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPsiElement";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRegion";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeRegion";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getHostRegion";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

