/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hints.BlackListDialog$createBlacklistPanel$;
import com.intellij.codeInsight.hints.BlackListPanelKt;
import com.intellij.codeInsight.hints.HintUtilsKt;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.ParameterHintsPassFactory;
import com.intellij.codeInsight.hints.settings.Diff;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/codeInsight/hints/BlackListDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "language", "Lcom/intellij/lang/Language;", "patternToAdd", "", "(Lcom/intellij/lang/Language;Ljava/lang/String;)V", "getLanguage", "()Lcom/intellij/lang/Language;", "myEditor", "Lcom/intellij/ui/EditorTextField;", "getMyEditor", "()Lcom/intellij/ui/EditorTextField;", "setMyEditor", "(Lcom/intellij/ui/EditorTextField;)V", "myPatternsAreValid", "", "baseLanguageComment", "provider", "Lcom/intellij/codeInsight/hints/InlayParameterHintsProvider;", "createBlacklistPanel", "Ljavax/swing/JPanel;", "createCenterPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "setLanguageBlacklistToDefault", "storeBlackListDiff", "text", "updateOkEnabled", "editorTextField", "intellij.platform.lang.impl"})
public final class BlackListDialog
extends DialogWrapper {
    @NotNull
    public EditorTextField myEditor;
    private boolean myPatternsAreValid;
    @NotNull
    private final Language language;
    private final String patternToAdd;

    @NotNull
    public final EditorTextField getMyEditor() {
        EditorTextField editorTextField = this.myEditor;
        if (editorTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myEditor");
        }
        return editorTextField;
    }

    public final void setMyEditor(@NotNull EditorTextField editorTextField) {
        Intrinsics.checkParameterIsNotNull((Object)editorTextField, (String)"<set-?>");
        this.myEditor = editorTextField;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.createBlacklistPanel(this.language);
    }

    private final JPanel createBlacklistPanel(Language language) {
        LayoutBuilder builder$iv;
        InlayParameterHintsProvider provider;
        InlayParameterHintsProvider inlayParameterHintsProvider = provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        Intrinsics.checkExpressionValueIsNotNull((Object)inlayParameterHintsProvider, (String)"provider");
        if (!inlayParameterHintsProvider.isBlackListSupported()) {
            return null;
        }
        String blackList = BlackListPanelKt.access$getLanguageBlackList(language);
        String finalText = this.patternToAdd != null ? blackList + "\n" + this.patternToAdd : blackList;
        EditorTextField editorTextField = BlackListPanelKt.access$createBlacklistEditorField(finalText);
        editorTextField.setAlignmentX(0.0f);
        editorTextField.addDocumentListener(new DocumentListener(this, editorTextField){
            final /* synthetic */ BlackListDialog this$0;
            final /* synthetic */ EditorTextField $editorTextField;

            public void documentChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                BlackListDialog.access$updateOkEnabled(this.this$0, this.$editorTextField);
            }
            {
                this.this$0 = $outer;
                this.$editorTextField = $captured_local_variable$1;
            }
        });
        this.updateOkEnabled(editorTextField);
        this.myEditor = editorTextField;
        LCFlags[] constraints$iv = new LCFlags[]{};
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder $this$panel = builder$iv = LayoutImplKt.createLayoutBuilder();
        boolean bl = false;
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, null, false, (Function1)new Function1<Row, Unit>(this, language, editorTextField, provider){
            final /* synthetic */ BlackListDialog this$0;
            final /* synthetic */ Language $language$inlined;
            final /* synthetic */ EditorTextField $editorTextField$inlined;
            final /* synthetic */ InlayParameterHintsProvider $provider$inlined;
            {
                this.this$0 = blackListDialog;
                this.$language$inlined = language;
                this.$editorTextField$inlined = editorTextField;
                this.$provider$inlined = inlayParameterHintsProvider;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                RowBuilder.DefaultImpls.row$default((RowBuilder)$this$row, null, false, (Function1)new Function1<Row, Unit>(this){
                    final /* synthetic */ createBlacklistPanel$$inlined$panel$lambda$1 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                        Row this_$iv = $this$row;
                        boolean $i$f$right = false;
                        this_$iv.alignRight();
                        Row $this$right = this_$iv;
                        boolean bl = false;
                        Cell.link$default($this$right, "Reset", null, (Function0)new Function0<Unit>(this){
                            final /* synthetic */ createBlacklistPanel$$inlined$panel$lambda$1$1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }

                            public final void invoke() {
                                BlackListDialog.access$setLanguageBlacklistToDefault(this.this$0.this$0.this$0, this.this$0.this$0.$language$inlined);
                            }
                        }, 2, null);
                    }
                }, 3, null);
                RowBuilder.DefaultImpls.row$default((RowBuilder)$this$row, null, false, (Function1)new Function1<Row, Unit>(this){
                    final /* synthetic */ createBlacklistPanel$$inlined$panel$lambda$1 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                        Cell.invoke$default($this$row, (JComponent)((Object)this.this$0.$editorTextField$inlined), new CCFlags[]{$this$row.getGrow()}, null, null, 6, null);
                    }
                }, 3, null);
                RowBuilder.DefaultImpls.row$default((RowBuilder)$this$row, null, false, (Function1)new Function1<Row, Unit>(this){
                    final /* synthetic */ createBlacklistPanel$$inlined$panel$lambda$1 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                        BlackListDialog blackListDialog = this.this$0.this$0;
                        InlayParameterHintsProvider inlayParameterHintsProvider = this.this$0.$provider$inlined;
                        Intrinsics.checkExpressionValueIsNotNull((Object)inlayParameterHintsProvider, (String)"provider");
                        String string = BlackListDialog.access$baseLanguageComment(blackListDialog, inlayParameterHintsProvider);
                        if (string != null) {
                            String string2 = string;
                            boolean bl = false;
                            boolean bl2 = false;
                            String it = string2;
                            boolean bl3 = false;
                            $this$row.commentRow(it);
                        }
                        $this$row.commentRow(BlackListPanelKt.access$getBlacklistExplanationHTML(this.this$0.$language$inlined));
                    }
                }, 3, null);
            }
        }, 3, null);
        DialogPanel panel$iv = ComponentsKt.DialogPanel(title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
        LayoutKt.initPanel(builder$iv, panel$iv);
        return (JPanel)panel$iv;
    }

    private final String baseLanguageComment(InlayParameterHintsProvider provider) {
        String string;
        Language language = provider.getBlackListDependencyLanguage();
        if (language != null) {
            Language language2 = language;
            boolean bl = false;
            boolean bl2 = false;
            Language it = language2;
            boolean bl3 = false;
            Object[] objectArray = new Object[1];
            Language language3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)language3, (String)"it");
            objectArray[0] = language3.getDisplayName();
            string = CodeInsightBundle.message((String)"inlay.hints.base.blacklist.description", (Object[])objectArray);
        } else {
            string = null;
        }
        return string;
    }

    private final void setLanguageBlacklistToDefault(Language language) {
        InlayParameterHintsProvider provider;
        InlayParameterHintsProvider inlayParameterHintsProvider = provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (inlayParameterHintsProvider == null) {
            Intrinsics.throwNpe();
        }
        Set set = inlayParameterHintsProvider.getDefaultBlackList();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"provider!!.defaultBlackList");
        Set defaultBlacklist = set;
        EditorTextField editorTextField = this.myEditor;
        if (editorTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myEditor");
        }
        editorTextField.setText(StringUtil.join((Collection)defaultBlacklist, (String)"\n"));
    }

    private final void updateOkEnabled(EditorTextField editorTextField) {
        String string = editorTextField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"editorTextField.text");
        String text2 = string;
        List<Integer> invalidLines = HintUtilsKt.getBlackListInvalidLineNumbers(text2);
        this.myPatternsAreValid = invalidLines.isEmpty();
        Action action2 = this.getOKAction();
        Intrinsics.checkExpressionValueIsNotNull((Object)action2, (String)"okAction");
        action2.setEnabled(this.myPatternsAreValid);
        Editor editor = editorTextField.getEditor();
        if (editor != null) {
            BlackListPanelKt.access$highlightErrorLines(invalidLines, editor);
        }
    }

    protected void doOKAction() {
        super.doOKAction();
        EditorTextField editorTextField = this.myEditor;
        if (editorTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myEditor");
        }
        String string = editorTextField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"myEditor.text");
        String blacklist = string;
        this.storeBlackListDiff(this.language, blacklist);
    }

    /*
     * WARNING - void declaration
     */
    private final void storeBlackListDiff(Language language, String text2) {
        InlayParameterHintsProvider provider;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)text2, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String e = (String)element$iv$iv;
            boolean bl = false;
            String $this$trim$iv = e;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl2 = false;
                boolean bl3 = match$iv$iv = it <= ' ';
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            CharSequence charSequence = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            boolean bl4 = false;
            if (!(charSequence.length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set updatedBlackList = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        InlayParameterHintsProvider inlayParameterHintsProvider = provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        Intrinsics.checkExpressionValueIsNotNull((Object)inlayParameterHintsProvider, (String)"provider");
        Set set = inlayParameterHintsProvider.getDefaultBlackList();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"provider.defaultBlackList");
        Set defaultBlackList = set;
        Diff diff = Diff.Builder.build(defaultBlackList, updatedBlackList);
        ParameterNameHintsSettings.Companion.getInstance().setBlackListDiff(HintUtilsKt.getLanguageForSettingKey(language), diff);
        ParameterHintsPassFactory.forceHintsUpdateOnNextPass();
    }

    @NotNull
    public final Language getLanguage() {
        return this.language;
    }

    public BlackListDialog(@NotNull Language language, @Nullable String patternToAdd) {
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        super(null);
        this.language = language;
        this.patternToAdd = patternToAdd;
        this.myPatternsAreValid = true;
        this.setTitle(CodeInsightBundle.message((String)"settings.inlay.parameter.hints.blacklist", (Object[])new Object[0]));
        this.init();
    }

    public /* synthetic */ BlackListDialog(Language language, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(language, string);
    }

    public static final /* synthetic */ void access$updateOkEnabled(BlackListDialog $this, EditorTextField editorTextField) {
        $this.updateOkEnabled(editorTextField);
    }

    public static final /* synthetic */ void access$setLanguageBlacklistToDefault(BlackListDialog $this, Language language) {
        $this.setLanguageBlacklistToDefault(language);
    }

    public static final /* synthetic */ String access$baseLanguageComment(BlackListDialog $this, InlayParameterHintsProvider provider) {
        return $this.baseLanguageComment(provider);
    }
}

