/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionBean;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionActionWrapper;
import com.intellij.codeInsight.intention.impl.config.IntentionSettingsConfigurable;
import com.intellij.codeInsight.intention.impl.config.IntentionsOptionsTopHitProvider;
import com.intellij.ide.ui.TopHitCache;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.Interner;
import com.intellij.util.containers.WeakStringInterner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="IntentionManagerSettings", storages={@Storage(value="intentionSettings.xml")})
public final class IntentionManagerSettings
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance(IntentionManagerSettings.class);
    private static final ExecutorService ourExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"Intentions Loader");
    private final Set<String> myIgnoredActions = Collections.synchronizedSet(new LinkedHashSet());
    private final Map<MetaDataKey, IntentionActionMetaData> myMetaData = new LinkedHashMap<MetaDataKey, IntentionActionMetaData>();
    private final Map<IntentionActionBean, MetaDataKey> myExtensionMapping = new HashMap<IntentionActionBean, MetaDataKey>();
    @NonNls
    private static final String IGNORE_ACTION_TAG = "ignoreAction";
    @NonNls
    private static final String NAME_ATT = "name";
    private static final Pattern HTML_PATTERN = Pattern.compile("<[^<>]*>");

    public IntentionManagerSettings() {
        IntentionManager.EP_INTENTION_ACTIONS.getPoint(null).addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<IntentionActionBean>(){

            public void extensionAdded(@NotNull IntentionActionBean extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                IntentionManagerSettings.this.registerMetaDataForEP(extension);
                TopHitCache.getInstance().invalidateCachedOptions(IntentionsOptionsTopHitProvider.class);
            }

            public void extensionRemoved(@NotNull IntentionActionBean extension, @NotNull PluginDescriptor pluginDescriptor) {
                String[] categories;
                if (extension == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((categories = extension.getCategories()) == null) {
                    return;
                }
                IntentionManagerSettings.this.unregisterMetaDataForEP(extension);
                TopHitCache.getInstance().invalidateCachedOptions(IntentionsOptionsTopHitProvider.class);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, true, (Disposable)this);
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerMetaDataForEP(@NotNull IntentionActionBean extension) {
        String[] categories;
        if (extension == null) {
            IntentionManagerSettings.$$$reportNull$$$0(0);
        }
        if ((categories = extension.getCategories()) == null) {
            return;
        }
        IntentionActionWrapper instance = new IntentionActionWrapper(extension);
        String descriptionDirectoryName = extension.getDescriptionDirectoryName();
        if (descriptionDirectoryName == null) {
            descriptionDirectoryName = instance.getDescriptionDirectoryName();
        }
        try {
            IntentionManagerSettings intentionManagerSettings = this;
            synchronized (intentionManagerSettings) {
                MetaDataKey key = this.registerMetaData(new IntentionActionMetaData(instance, extension.getLoaderForClass(), categories, descriptionDirectoryName));
                this.myExtensionMapping.put(extension, key);
            }
        }
        catch (ExtensionNotApplicableException extensionNotApplicableException) {
            // empty catch block
        }
    }

    @NotNull
    public static IntentionManagerSettings getInstance() {
        IntentionManagerSettings intentionManagerSettings = (IntentionManagerSettings)ServiceManager.getService(IntentionManagerSettings.class);
        if (intentionManagerSettings == null) {
            IntentionManagerSettings.$$$reportNull$$$0(1);
        }
        return intentionManagerSettings;
    }

    void registerIntentionMetaData(@NotNull IntentionAction intentionAction, String @NotNull [] category, @NotNull String descriptionDirectoryName) {
        if (intentionAction == null) {
            IntentionManagerSettings.$$$reportNull$$$0(2);
        }
        if (descriptionDirectoryName == null) {
            IntentionManagerSettings.$$$reportNull$$$0(3);
        }
        if (category == null) {
            IntentionManagerSettings.$$$reportNull$$$0(4);
        }
        this.registerMetaData(new IntentionActionMetaData(intentionAction, IntentionManagerSettings.getClassLoader(intentionAction), category, descriptionDirectoryName));
    }

    private static ClassLoader getClassLoader(@NotNull IntentionAction intentionAction) {
        if (intentionAction == null) {
            IntentionManagerSettings.$$$reportNull$$$0(5);
        }
        return intentionAction instanceof IntentionActionWrapper ? ((IntentionActionWrapper)intentionAction).getImplementationClassLoader() : intentionAction.getClass().getClassLoader();
    }

    public boolean isShowLightBulb(@NotNull IntentionAction action2) {
        if (action2 == null) {
            IntentionManagerSettings.$$$reportNull$$$0(6);
        }
        return !this.myIgnoredActions.contains(action2.getFamilyName());
    }

    public void loadState(@NotNull Element element2) {
        if (element2 == null) {
            IntentionManagerSettings.$$$reportNull$$$0(7);
        }
        this.myIgnoredActions.clear();
        for (Element e : element2.getChildren(IGNORE_ACTION_TAG)) {
            this.myIgnoredActions.add(e.getAttributeValue(NAME_ATT));
        }
    }

    public Element getState() {
        Element element2 = new Element("state");
        for (String name : this.myIgnoredActions) {
            element2.addContent(new Element(IGNORE_ACTION_TAG).setAttribute(NAME_ATT, name));
        }
        return element2;
    }

    @NotNull
    public synchronized List<IntentionActionMetaData> getMetaData() {
        return new ArrayList<IntentionActionMetaData>(this.myMetaData.values());
    }

    public boolean isEnabled(@NotNull IntentionActionMetaData metaData) {
        if (metaData == null) {
            IntentionManagerSettings.$$$reportNull$$$0(8);
        }
        return !this.myIgnoredActions.contains(IntentionManagerSettings.getFamilyName(metaData));
    }

    private static String getFamilyName(@NotNull IntentionActionMetaData metaData) {
        if (metaData == null) {
            IntentionManagerSettings.$$$reportNull$$$0(9);
        }
        return StringUtil.join((String[])metaData.myCategory, (String)"/") + "/" + metaData.getAction().getFamilyName();
    }

    private static String getFamilyName(@NotNull IntentionAction action2) {
        if (action2 == null) {
            IntentionManagerSettings.$$$reportNull$$$0(10);
        }
        return action2 instanceof IntentionActionWrapper ? ((IntentionActionWrapper)action2).getFullFamilyName() : action2.getFamilyName();
    }

    public void setEnabled(@NotNull IntentionActionMetaData metaData, boolean enabled) {
        if (metaData == null) {
            IntentionManagerSettings.$$$reportNull$$$0(11);
        }
        if (enabled) {
            this.myIgnoredActions.remove(IntentionManagerSettings.getFamilyName(metaData));
        } else {
            this.myIgnoredActions.add(IntentionManagerSettings.getFamilyName(metaData));
        }
    }

    public boolean isEnabled(@NotNull IntentionAction action2) {
        if (action2 == null) {
            IntentionManagerSettings.$$$reportNull$$$0(12);
        }
        return !this.myIgnoredActions.contains(IntentionManagerSettings.getFamilyName(action2));
    }

    public void setEnabled(@NotNull IntentionAction action2, boolean enabled) {
        if (action2 == null) {
            IntentionManagerSettings.$$$reportNull$$$0(13);
        }
        if (enabled) {
            this.myIgnoredActions.remove(IntentionManagerSettings.getFamilyName(action2));
        } else {
            this.myIgnoredActions.add(IntentionManagerSettings.getFamilyName(action2));
        }
    }

    private synchronized MetaDataKey registerMetaData(@NotNull IntentionActionMetaData metaData) {
        MetaDataKey key;
        if (metaData == null) {
            IntentionManagerSettings.$$$reportNull$$$0(14);
        }
        if (!this.myMetaData.containsKey((Object)(key = new MetaDataKey(metaData.myCategory, metaData.getFamily())))) {
            IntentionManagerSettings.processMetaData(metaData);
        }
        this.myMetaData.put(key, metaData);
        return key;
    }

    private static void processMetaData(@NotNull IntentionActionMetaData metaData) {
        Application app;
        if (metaData == null) {
            IntentionManagerSettings.$$$reportNull$$$0(15);
        }
        if ((app = ApplicationManager.getApplication()).isUnitTestMode() || app.isHeadlessEnvironment()) {
            return;
        }
        ourExecutor.execute(() -> {
            if (app.isDisposed()) {
                return;
            }
            try {
                SearchableOptionsRegistrar registrar = SearchableOptionsRegistrar.getInstance();
                if (registrar == null) {
                    return;
                }
                String descriptionText = StringUtil.toLowerCase((String)metaData.getDescription().getText());
                descriptionText = HTML_PATTERN.matcher(descriptionText).replaceAll(" ");
                Set words = registrar.getProcessedWordsWithoutStemming(descriptionText);
                words.addAll(registrar.getProcessedWords(metaData.getFamily()));
                registrar.addOptions((Collection)words, metaData.getFamily(), metaData.getFamily(), "preferences.intentionPowerPack", IntentionSettingsConfigurable.getDisplayNameText());
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    synchronized void unregisterMetaData(@NotNull IntentionAction intentionAction) {
        if (intentionAction == null) {
            IntentionManagerSettings.$$$reportNull$$$0(16);
        }
        for (Map.Entry<MetaDataKey, IntentionActionMetaData> entry : this.myMetaData.entrySet()) {
            if (entry.getValue().getAction() != intentionAction) continue;
            this.myMetaData.remove((Object)entry.getKey());
            break;
        }
    }

    private synchronized void unregisterMetaDataForEP(IntentionActionBean extension) {
        MetaDataKey key = this.myExtensionMapping.remove(extension);
        assert (key != null) : extension;
        this.myMetaData.remove((Object)key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings";
                break;
            }
            case 2: 
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentionAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionDirectoryName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerMetaDataForEP";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerIntentionMetaData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getClassLoader";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isShowLightBulb";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 8: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFamilyName";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setEnabled";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerMetaData";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processMetaData";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "unregisterMetaData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MetaDataKey
    extends Pair<String, String> {
        private static final Interner<String> ourInterner = new WeakStringInterner();

        private MetaDataKey(String @NotNull [] categoryNames, @NotNull String familyName) {
            if (familyName == null) {
                MetaDataKey.$$$reportNull$$$0(0);
            }
            if (categoryNames == null) {
                MetaDataKey.$$$reportNull$$$0(1);
            }
            super((Object)StringUtil.join((String[])categoryNames, (String)":"), ourInterner.intern((Object)familyName));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "familyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "categoryNames";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings$MetaDataKey";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

