/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000bH\u0000\u001a\u000e\u0010\f\u001a\u0004\u0018\u00010\u0003*\u00020\u000bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"CONTAINER_PATTERN", "Ljava/util/regex/Pattern;", "orderEntryText", "", "fileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "sdkText", "getColoredAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "Lcom/intellij/navigation/ItemPresentation;", "getLocationText", "intellij.platform.lang.impl"})
public final class UtilKt {
    private static final Pattern CONTAINER_PATTERN;

    @Nullable
    public static final TextAttributes getColoredAttributes(@NotNull ItemPresentation $this$getColoredAttributes) {
        ColoredItemPresentation coloredPresentation;
        ColoredItemPresentation coloredItemPresentation;
        Intrinsics.checkParameterIsNotNull((Object)$this$getColoredAttributes, (String)"$this$getColoredAttributes");
        ItemPresentation itemPresentation = $this$getColoredAttributes;
        if (!(itemPresentation instanceof ColoredItemPresentation)) {
            itemPresentation = null;
        }
        if ((coloredItemPresentation = (coloredPresentation = (ColoredItemPresentation)itemPresentation)) == null || (coloredItemPresentation = coloredItemPresentation.getTextAttributesKey()) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)coloredItemPresentation, (String)"coloredPresentation?.tex\u2026ributesKey ?: return null");
        ColoredItemPresentation textAttributesKey = coloredItemPresentation;
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        return editorColorsManager.getSchemeForCurrentUITheme().getAttributes((TextAttributesKey)textAttributesKey);
    }

    @Nullable
    public static final String getLocationText(@NotNull ItemPresentation $this$getLocationText) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getLocationText, (String)"$this$getLocationText");
        String string = $this$getLocationText.getLocationString();
        if (string == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"locationString ?: return null");
        String locationString = string;
        Matcher matcher = CONTAINER_PATTERN.matcher(locationString);
        return matcher.matches() ? matcher.group(2) : locationString;
    }

    @Nullable
    public static final String orderEntryText(@NotNull ProjectFileIndex fileIndex, @NotNull VirtualFile file2) {
        OrderEntry entry;
        Object v1;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)fileIndex, (String)"fileIndex");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            List list2 = fileIndex.getOrderEntriesForFile(file2);
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"fileIndex.getOrderEntriesForFile(file)");
            Iterable iterable = list2;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                OrderEntry entry2 = (OrderEntry)t;
                boolean bl3 = false;
                if (!(entry2 instanceof LibraryOrderEntry || entry2 instanceof JdkOrderEntry)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        OrderEntry orderEntry = entry = (OrderEntry)v1;
        return orderEntry != null ? orderEntry.getPresentableName() : null;
    }

    @Nullable
    public static final String sdkText(@NotNull VirtualFile file2) {
        String string;
        Sdk sdk2;
        Sdk sdk3;
        boolean bl;
        Sdk[] sdkArray;
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            if (!Registry.is((String)"index.run.configuration.jre")) {
                return null;
            }
            ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectJdkTable, (String)"ProjectJdkTable.getInstance()");
            Sdk[] sdkArray2 = projectJdkTable.getAllJdks();
            Intrinsics.checkExpressionValueIsNotNull((Object)sdkArray2, (String)"ProjectJdkTable.getInstance().allJdks");
            sdkArray = sdkArray2;
            bl = false;
            Sdk[] sdkArray3 = sdkArray;
            boolean bl2 = false;
            Sdk[] sdkArray4 = sdkArray3;
            int n = sdkArray4.length;
            for (int i = 0; i < n; ++i) {
                RootProvider rootProvider;
                Sdk sdk4;
                Sdk sdk5 = sdk4 = sdkArray4[i];
                boolean bl3 = false;
                Sdk sdk6 = sdk5;
                Intrinsics.checkExpressionValueIsNotNull((Object)sdk6, (String)"sdk");
                Intrinsics.checkExpressionValueIsNotNull((Object)sdk6.getRootProvider(), (String)"sdk.rootProvider");
                SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                VirtualFile[] virtualFileArray = rootProvider.getFiles(OrderRootType.CLASSES);
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"rootProvider.getFiles(OrderRootType.CLASSES)");
                spreadBuilder.addSpread((Object)virtualFileArray);
                VirtualFile[] virtualFileArray2 = rootProvider.getFiles(OrderRootType.SOURCES);
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray2, (String)"rootProvider.getFiles(OrderRootType.SOURCES)");
                spreadBuilder.addSpread((Object)virtualFileArray2);
                Set roots = SetsKt.setOf((Object[])((VirtualFile[])spreadBuilder.toArray((Object[])new VirtualFile[spreadBuilder.size()])));
                if (!VfsUtilCore.isUnder((VirtualFile)file2, (Set)roots)) continue;
                sdk3 = sdk4;
                break block4;
            }
            sdk3 = null;
        }
        Sdk sdk7 = sdk2 = sdk3;
        if (sdk7 != null) {
            sdkArray = sdk7;
            bl = false;
            boolean bl4 = false;
            Sdk[] $this$run = sdkArray;
            boolean bl5 = false;
            string = "< " + $this$run.getName() + " >";
        } else {
            string = null;
        }
        return string;
    }

    static {
        Pattern pattern = Pattern.compile("(\\(in |\\()?([^)]*)(\\))?");
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\"(\\\\(in |\\\\()?([^)]*)(\\\\))?\")");
        CONTAINER_PATTERN = pattern;
    }
}

