/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import com.intellij.codeInspection.InspectionsReportConverter;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonInspectionsReportConverter
implements InspectionsReportConverter {
    @NonNls
    private static final String FORMAT_NAME = "json";
    @NonNls
    private static final String JSON_EXTENSION = ".json";
    @NonNls
    private static final String FILE = "file";
    @NonNls
    private static final String LINE = "line";
    @NonNls
    private static final String OFFSET = "offset";
    @NonNls
    private static final String LENGTH = "length";
    @NonNls
    private static final String MODULE = "module";
    @NonNls
    private static final String PACKAGE = "package";
    @NonNls
    protected static final String PROBLEM = "problem";
    @NonNls
    protected static final String PROBLEMS = "problems";
    @NonNls
    private static final String DESCRIPTION = "description";
    @NonNls
    private static final String SEVERITY_ATTR = "severity";
    @NonNls
    private static final String ATTRIBUTE_KEY_ATTR = "attribute_key";
    @NonNls
    private static final String HINT = "hint";
    @NonNls
    private static final String HINTS = "hints";
    @NonNls
    private static final String DISPLAY_NAME = "displayName";
    @NonNls
    private static final String SHORT_NAME = "shortName";
    @NonNls
    private static final String ENABLED = "enabled";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String ID = "id";
    @NonNls
    private static final String VALUE = "value";
    @NonNls
    private static final String GROUP = "group";
    @NonNls
    private static final String GROUPS = "groups";
    @NonNls
    private static final String INSPECTION = "inspection";
    @NonNls
    private static final String HIGHLIGHTED_ELEMENT = "highlighted_element";
    @NonNls
    private static final String PROJECT_FINGERPRINT = "ProjectFingerprint";
    @NonNls
    private static final String FILE_FINGERPRINT = "file_fingerprint";
    @NonNls
    private static final String FILE_NAME = "file_name";
    @NonNls
    private static final String FILE_PATH = "file_path";
    @NonNls
    private static final String LANGUAGE = "language";
    @NonNls
    private static final String LINES_COUNT = "lines_count";
    @NonNls
    private static final String MODIFICATION_TIMESTAMP = "modification_timestamp";

    @Override
    public String getFormatName() {
        return FORMAT_NAME;
    }

    @Override
    public boolean useTmpDirForRawData() {
        return true;
    }

    @Override
    public void convert(@NotNull String rawDataDirectoryPath, @Nullable String outputPath, @NotNull Map<String, Tools> tools, @NotNull List<? extends File> inspectionsResults) throws InspectionsReportConverter.ConversionException {
        if (rawDataDirectoryPath == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(0);
        }
        if (tools == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(1);
        }
        if (inspectionsResults == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(2);
        }
        if (outputPath == null) {
            throw new InspectionsReportConverter.ConversionException("Output path isn't specified");
        }
        try {
            Files.createDirectories(new File(outputPath).toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new InspectionsReportConverter.ConversionException("Cannot create dirs in output path: " + outputPath + " error: " + e.getMessage());
        }
        Gson gson2 = new GsonBuilder().setPrettyPrinting().create();
        SAXBuilder builder2 = new SAXBuilder();
        for (File file2 : inspectionsResults) {
            String fileNameWithoutExt = FileUtil.getNameWithoutExtension((File)file2);
            File jsonFile = new File(outputPath, fileNameWithoutExt + JSON_EXTENSION);
            try {
                BufferedWriter writer = Files.newBufferedWriter(jsonFile.toPath(), CharsetToolkit.UTF8_CHARSET, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    JsonWriter jsonWriter = gson2.newJsonWriter((Writer)writer);
                    Throwable throwable2 = null;
                    try {
                        Document doc = builder2.build(file2);
                        if (".descriptions".equals(fileNameWithoutExt)) {
                            JsonInspectionsReportConverter.convertDescriptions(jsonWriter, doc);
                            continue;
                        }
                        if (PROJECT_FINGERPRINT.equals(fileNameWithoutExt)) {
                            JsonInspectionsReportConverter.convertProjectFingerprint(jsonWriter, doc);
                            continue;
                        }
                        JsonInspectionsReportConverter.convertProblems(jsonWriter, doc);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (jsonWriter == null) continue;
                        if (throwable2 != null) {
                            try {
                                jsonWriter.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        jsonWriter.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    ((Writer)writer).close();
                }
            }
            catch (IOException | JDOMException e) {
                throw new InspectionsReportConverter.ConversionException("Cannot convert file: " + file2.getPath() + " error: " + e.getMessage());
            }
        }
    }

    private static void convertProjectFingerprint(@NotNull JsonWriter jsonWriter, @NotNull Document problems) throws IOException {
        if (jsonWriter == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(3);
        }
        if (problems == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(4);
        }
        jsonWriter.beginObject();
        jsonWriter.name(PROBLEMS);
        jsonWriter.beginArray();
        for (Element fileFingerprint : problems.getRootElement().getChildren(FILE_FINGERPRINT)) {
            JsonInspectionsReportConverter.convertFileFingerprint(jsonWriter, fileFingerprint);
        }
        jsonWriter.endArray();
        jsonWriter.endObject();
    }

    private static void convertFileFingerprint(@NotNull JsonWriter writer, @NotNull Element problem) throws IOException {
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(5);
        }
        if (problem == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(6);
        }
        writer.beginObject();
        writer.name(FILE_NAME).value(problem.getChildText(FILE_NAME));
        writer.name(FILE_PATH).value(problem.getChildText(FILE_PATH));
        writer.name(LANGUAGE).value(problem.getChildText(LANGUAGE));
        try {
            int linesCount = Integer.parseInt(problem.getChildText(LINES_COUNT));
            writer.name(LINES_COUNT).value((long)linesCount);
        }
        catch (NumberFormatException e) {
            writer.name(LINES_COUNT).nullValue();
        }
        try {
            long modificationStamp = Long.parseLong(problem.getChildText(MODIFICATION_TIMESTAMP));
            writer.name(MODIFICATION_TIMESTAMP).value(modificationStamp);
        }
        catch (NumberFormatException e) {
            writer.name(MODIFICATION_TIMESTAMP).nullValue();
        }
        writer.endObject();
    }

    private static void convertProblems(@NotNull JsonWriter jsonWriter, @NotNull Document problems) throws IOException {
        if (jsonWriter == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(7);
        }
        if (problems == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(8);
        }
        jsonWriter.beginObject();
        jsonWriter.name(PROBLEMS);
        jsonWriter.beginArray();
        for (Element problem : problems.getRootElement().getChildren(PROBLEM)) {
            JsonInspectionsReportConverter.convertProblem(jsonWriter, problem);
        }
        jsonWriter.endArray();
        jsonWriter.endObject();
    }

    protected static void convertProblem(@NotNull JsonWriter writer, @NotNull Element problem) throws IOException {
        Element hints;
        Element entryPoint;
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(9);
        }
        if (problem == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(10);
        }
        writer.beginObject();
        writer.name(FILE).value(problem.getChildText(FILE));
        JsonInspectionsReportConverter.writeInt(writer, problem, LINE);
        JsonInspectionsReportConverter.writeInt(writer, problem, OFFSET);
        JsonInspectionsReportConverter.writeInt(writer, problem, LENGTH);
        writer.name(MODULE).value(problem.getChildText(MODULE));
        writer.name(PACKAGE).value(problem.getChildText(PACKAGE));
        Element problemClassElement = problem.getChild("problem_class");
        if (problemClassElement != null) {
            JsonInspectionsReportConverter.convertProblemClass(writer, problemClassElement);
        }
        if ((entryPoint = problem.getChild("entry_point")) != null) {
            JsonInspectionsReportConverter.convertEntryPoint(writer, entryPoint);
        }
        if ((hints = problem.getChild(HINTS)) != null) {
            JsonInspectionsReportConverter.convertHints(writer, hints);
        }
        writer.name(HIGHLIGHTED_ELEMENT).value(problem.getChildText(HIGHLIGHTED_ELEMENT));
        writer.name(DESCRIPTION).value(problem.getChildText(DESCRIPTION));
        writer.endObject();
    }

    private static void writeInt(@NotNull JsonWriter writer, @NotNull Element problem, @NotNull String elementName) throws IOException {
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(11);
        }
        if (problem == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(12);
        }
        if (elementName == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(13);
        }
        try {
            int intValue = Integer.parseInt(problem.getChildText(elementName));
            writer.name(elementName).value((long)intValue);
        }
        catch (NumberFormatException e) {
            writer.name(elementName).nullValue();
        }
    }

    private static void convertProblemClass(@NotNull JsonWriter writer, @NotNull Element problemClass) throws IOException {
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(14);
        }
        if (problemClass == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(15);
        }
        writer.name("problem_class");
        writer.beginObject().name(NAME).value(problemClass.getText());
        String inspectionId = problemClass.getAttributeValue(ID);
        if (inspectionId != null) {
            writer.name(ID).value(inspectionId);
        }
        writer.name(SEVERITY_ATTR).value(problemClass.getAttributeValue(SEVERITY_ATTR)).name(ATTRIBUTE_KEY_ATTR).value(problemClass.getAttributeValue(ATTRIBUTE_KEY_ATTR)).endObject();
    }

    private static void convertEntryPoint(@NotNull JsonWriter writer, @NotNull Element entryPoint) throws IOException {
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(16);
        }
        if (entryPoint == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(17);
        }
        writer.name("entry_point");
        writer.beginObject().name("TYPE").value(entryPoint.getAttributeValue("TYPE")).name("FQNAME").value(entryPoint.getAttributeValue("FQNAME")).endObject();
    }

    private static void convertHints(@NotNull JsonWriter writer, @NotNull Element hints) throws IOException {
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(18);
        }
        if (hints == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(19);
        }
        writer.name(HINTS);
        writer.beginArray();
        for (Element hint : hints.getChildren(HINT)) {
            writer.value(hint.getAttributeValue(VALUE));
        }
        writer.endArray();
    }

    private static void convertDescriptions(@NotNull JsonWriter writer, @NotNull Document descriptions) throws IOException {
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(20);
        }
        if (descriptions == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(21);
        }
        writer.beginObject();
        JsonInspectionsReportConverter.convertDescriptionsContents(writer, descriptions, null);
        writer.endObject();
    }

    protected static void convertDescriptionsContents(@NotNull JsonWriter writer, @NotNull Document descriptions, @Nullable Predicate<String> inspectionFilter) throws IOException {
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(22);
        }
        if (descriptions == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(23);
        }
        Element inspectionsElement = descriptions.getRootElement();
        writer.name("profile").value(inspectionsElement.getAttributeValue("profile"));
        writer.name(GROUPS);
        writer.beginArray();
        for (Element group : inspectionsElement.getChildren(GROUP)) {
            JsonInspectionsReportConverter.convertGroup(writer, group, inspectionFilter);
        }
        writer.endArray();
    }

    private static void convertGroup(@NotNull JsonWriter writer, @NotNull Element group, @Nullable Predicate<String> inspectionFilter) throws IOException {
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(24);
        }
        if (group == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(25);
        }
        if (inspectionFilter != null) {
            boolean anyInspectionsInFilter = false;
            for (Element inspection : group.getChildren(INSPECTION)) {
                if (!inspectionFilter.test(inspection.getAttributeValue(SHORT_NAME))) continue;
                anyInspectionsInFilter = true;
                break;
            }
            if (!anyInspectionsInFilter) {
                return;
            }
        }
        writer.beginObject();
        writer.name(NAME).value(group.getAttributeValue(NAME));
        writer.name("inspections").beginArray();
        for (Element inspection : group.getChildren(INSPECTION)) {
            if (inspectionFilter != null && !inspectionFilter.test(inspection.getAttributeValue(SHORT_NAME))) continue;
            JsonInspectionsReportConverter.convertInspectionDescription(writer, inspection);
        }
        writer.endArray();
        writer.endObject();
    }

    private static void convertInspectionDescription(@NotNull JsonWriter writer, @NotNull Element inspection) throws IOException {
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(26);
        }
        if (inspection == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(27);
        }
        writer.beginObject().name(SHORT_NAME).value(inspection.getAttributeValue(SHORT_NAME)).name(DISPLAY_NAME).value(inspection.getAttributeValue(DISPLAY_NAME)).name(ENABLED).value(Boolean.parseBoolean(inspection.getAttributeValue(ENABLED))).name(DESCRIPTION).value(inspection.getValue()).endObject();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawDataDirectoryPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionsResults";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonWriter";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROBLEMS;
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 6: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROBLEM;
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemClass";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryPoint";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = HINTS;
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptions";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = GROUP;
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = INSPECTION;
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/ex/JsonInspectionsReportConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "convert";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "convertProjectFingerprint";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "convertFileFingerprint";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "convertProblems";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "convertProblem";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "writeInt";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "convertProblemClass";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "convertEntryPoint";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "convertHints";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "convertDescriptions";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "convertDescriptionsContents";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "convertGroup";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "convertInspectionDescription";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

