/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.applications;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.applications.DiffApplicationBase;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.ide.CliResult;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import java.awt.Window;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DiffApplication
extends DiffApplicationBase {
    DiffApplication() {
        super("diff", 2, 3);
    }

    @Override
    @NotNull
    public String getUsageMessage() {
        String scriptName = ApplicationNamesInfo.getInstance().getScriptName();
        String string = DiffBundle.message((String)"diff.application.usage.parameters.and.description", (Object[])new Object[]{scriptName});
        if (string == null) {
            DiffApplication.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public Future<CliResult> processCommand(@NotNull List<String> args, @Nullable String currentDirectory) throws Exception {
        ContentDiffRequest request2;
        if (args == null) {
            DiffApplication.$$$reportNull$$$0(1);
        }
        List<String> filePaths = args.subList(1, args.size());
        List<VirtualFile> files2 = DiffApplication.findFiles(filePaths, currentDirectory);
        Project project = DiffApplication.guessProject(files2);
        if (files2.size() == 3) {
            files2 = this.replaceNullsWithEmptyFile(files2);
            request2 = DiffRequestFactory.getInstance().createFromFiles(project, files2.get(0), files2.get(2), files2.get(1));
        } else {
            request2 = DiffRequestFactory.getInstance().createFromFiles(project, files2.get(0), files2.get(1));
        }
        SimpleDiffRequestChain chain = new SimpleDiffRequestChain((DiffRequest)request2);
        chain.putUserData(DiffUserDataKeys.PLACE, (Object)"External");
        if (project != null) {
            CompletableFuture<CliResult> future2 = new CompletableFuture<CliResult>();
            Runnable resultCallback = () -> future2.complete(CliResult.OK);
            DiffDialogHints dialogHints = new DiffDialogHints(WindowWrapper.Mode.FRAME, null, wrapper2 -> UIUtil.runWhenWindowClosed((Window)wrapper2.getWindow(), (Runnable)resultCallback));
            DiffManagerEx.getInstance().showDiffBuiltin(project, (DiffRequestChain)chain, dialogHints);
            CompletableFuture<CliResult> completableFuture = future2;
            if (completableFuture == null) {
                DiffApplication.$$$reportNull$$$0(2);
            }
            return completableFuture;
        }
        DiffManagerEx.getInstance().showDiffBuiltin(null, (DiffRequestChain)chain, DiffDialogHints.MODAL);
        Future future3 = CliResult.OK_FUTURE;
        if (future3 == null) {
            DiffApplication.$$$reportNull$$$0(3);
        }
        return future3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/applications/DiffApplication";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsageMessage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/applications/DiffApplication";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "processCommand";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

