/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.impl.OpenInEditorWithMouseAction;
import com.intellij.diff.actions.impl.SetEditorSettingsAction;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.diff.tools.holders.TextEditorHolder;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.base.InitialScrollPositionSupport;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.breadcrumbs.SimpleDiffBreadcrumbsPanel;
import com.intellij.diff.tools.util.side.OnesideDiffViewer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineCol;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.pom.Navigatable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OnesideTextDiffViewer
extends OnesideDiffViewer<TextEditorHolder> {
    @NotNull
    private final List<? extends EditorEx> myEditableEditors;
    @NotNull
    protected final SetEditorSettingsAction myEditorSettingsAction;

    public OnesideTextDiffViewer(@NotNull DiffContext context, @NotNull ContentDiffRequest request2) {
        if (context == null) {
            OnesideTextDiffViewer.$$$reportNull$$$0(0);
        }
        if (request2 == null) {
            OnesideTextDiffViewer.$$$reportNull$$$0(1);
        }
        super(context, request2, TextEditorHolder.TextEditorHolderFactory.INSTANCE);
        this.myEditableEditors = TextDiffViewerUtil.getEditableEditors(this.getEditors());
        this.myEditorSettingsAction = new SetEditorSettingsAction(this.getTextSettings(), this.getEditors());
        this.myEditorSettingsAction.applyDefaults();
        new MyOpenInEditorWithMouseAction().install(this.getEditors());
        DiffUtil.installLineConvertor(this.getEditor(), this.getContent());
        if (this.getProject() != null) {
            this.myContentPanel.setBreadcrumbs(new SimpleDiffBreadcrumbsPanel(this.getEditor(), (Disposable)this), this.getTextSettings());
        }
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.installEditorListeners();
    }

    @Override
    protected void onDispose() {
        this.destroyEditorListeners();
        super.onDispose();
    }

    @Override
    @NotNull
    protected TextEditorHolder createEditorHolder(@NotNull EditorHolderFactory<TextEditorHolder> factory) {
        if (factory == null) {
            OnesideTextDiffViewer.$$$reportNull$$$0(2);
        }
        TextEditorHolder holder = super.createEditorHolder(factory);
        boolean[] forceReadOnly = TextDiffViewerUtil.checkForceReadOnly(this.myContext, this.myRequest);
        if (forceReadOnly[0]) {
            holder.getEditor().setViewer(true);
        }
        TextEditorHolder textEditorHolder = holder;
        if (textEditorHolder == null) {
            OnesideTextDiffViewer.$$$reportNull$$$0(3);
        }
        return textEditorHolder;
    }

    @Override
    @Nullable
    protected JComponent createTitle() {
        List<JComponent> textTitles = DiffUtil.createTextTitles(this.myRequest, Arrays.asList(this.getEditor(), this.getEditor()));
        return (JComponent)this.getSide().select(textTitles);
    }

    @NotNull
    public TextDiffSettingsHolder.TextDiffSettings getTextSettings() {
        TextDiffSettingsHolder.TextDiffSettings textDiffSettings = TextDiffViewerUtil.getTextSettings(this.myContext);
        if (textDiffSettings == null) {
            OnesideTextDiffViewer.$$$reportNull$$$0(4);
        }
        return textDiffSettings;
    }

    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        List<AnAction> list2 = TextDiffViewerUtil.createEditorPopupActions();
        if (list2 == null) {
            OnesideTextDiffViewer.$$$reportNull$$$0(5);
        }
        return list2;
    }

    protected void installEditorListeners() {
        new TextDiffViewerUtil.EditorActionsPopup(this.createEditorPopupActions()).install(this.getEditors(), this.myPanel);
    }

    protected void destroyEditorListeners() {
    }

    @NotNull
    public List<? extends EditorEx> getEditors() {
        List<EditorEx> list2 = Collections.singletonList(this.getEditor());
        if (list2 == null) {
            OnesideTextDiffViewer.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    protected List<? extends EditorEx> getEditableEditors() {
        List<? extends EditorEx> list2 = this.myEditableEditors;
        if (list2 == null) {
            OnesideTextDiffViewer.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @NotNull
    public EditorEx getEditor() {
        EditorEx editorEx = ((TextEditorHolder)this.getEditorHolder()).getEditor();
        if (editorEx == null) {
            OnesideTextDiffViewer.$$$reportNull$$$0(8);
        }
        return editorEx;
    }

    @NotNull
    public DocumentContent getContent() {
        DocumentContent documentContent = (DocumentContent)super.getContent();
        if (documentContent == null) {
            OnesideTextDiffViewer.$$$reportNull$$$0(9);
        }
        return documentContent;
    }

    protected void scrollToLine(int line) {
        DiffUtil.scrollEditor(this.getEditor(), line, false);
    }

    @Override
    @Nullable
    protected Navigatable getNavigatable() {
        return this.getContent().getNavigatable(LineCol.fromCaret((Editor)this.getEditor()));
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request2) {
        if (context == null) {
            OnesideTextDiffViewer.$$$reportNull$$$0(10);
        }
        if (request2 == null) {
            OnesideTextDiffViewer.$$$reportNull$$$0(11);
        }
        return OnesideDiffViewer.canShowRequest(context, request2, TextEditorHolder.TextEditorHolderFactory.INSTANCE);
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            OnesideTextDiffViewer.$$$reportNull$$$0(12);
        }
        if (DiffDataKeys.CURRENT_EDITOR.is(dataId)) {
            return this.getEditor();
        }
        return super.getData(dataId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/side/OnesideTextDiffViewer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/side/OnesideTextDiffViewer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorHolder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorPopupActions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditableEditors";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createEditorHolder";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canShowRequest";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected abstract class MyInitialScrollPositionHelper
    extends InitialScrollPositionSupport.TwosideInitialScrollHelper {
        protected MyInitialScrollPositionHelper() {
        }

        @Override
        @NotNull
        protected List<? extends Editor> getEditors() {
            List<? extends EditorEx> list2 = OnesideTextDiffViewer.this.getEditors();
            if (list2 == null) {
                MyInitialScrollPositionHelper.$$$reportNull$$$0(0);
            }
            return list2;
        }

        @Override
        protected void disableSyncScroll(boolean value2) {
        }

        @Override
        protected boolean doScrollToLine() {
            if (this.myScrollToLine == null) {
                return false;
            }
            Side side = (Side)this.myScrollToLine.first;
            if (side != OnesideTextDiffViewer.this.getSide()) {
                return false;
            }
            OnesideTextDiffViewer.this.scrollToLine((Integer)this.myScrollToLine.second);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/OnesideTextDiffViewer$MyInitialScrollPositionHelper", "getEditors"));
        }
    }

    private class MyOpenInEditorWithMouseAction
    extends OpenInEditorWithMouseAction {
        private MyOpenInEditorWithMouseAction() {
        }

        @Override
        protected Navigatable getNavigatable(@NotNull Editor editor, int line) {
            if (editor == null) {
                MyOpenInEditorWithMouseAction.$$$reportNull$$$0(0);
            }
            if (editor != OnesideTextDiffViewer.this.getEditor()) {
                return null;
            }
            return OnesideTextDiffViewer.this.getContent().getNavigatable(new LineCol(line));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/side/OnesideTextDiffViewer$MyOpenInEditorWithMouseAction", "getNavigatable"));
        }
    }
}

