/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomWhiteListRule;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TipsOfTheDayUsagesCollector {
    private static final String GROUP_ID = "ui.tips";
    private static final String NO_FEATURE_ID = "no.feature.id";

    public static void trigger(String feature) {
        FUCounterUsageLogger.getInstance().logEvent(GROUP_ID, feature);
    }

    public static void triggerShow(@NotNull String type) {
        if (type == null) {
            TipsOfTheDayUsagesCollector.$$$reportNull$$$0(0);
        }
        FUCounterUsageLogger.getInstance().logEvent(GROUP_ID, "dialog.shown", new FeatureUsageData().addData("type", type));
    }

    public static void triggerTipShown(@NotNull TipAndTrickBean tip) {
        if (tip == null) {
            TipsOfTheDayUsagesCollector.$$$reportNull$$$0(1);
        }
        FeatureUsageData usageData = new FeatureUsageData();
        String featureId = tip.featureId;
        usageData.addData("feature_id", featureId != null ? featureId : NO_FEATURE_ID);
        usageData.addData("filename", tip.fileName);
        FUCounterUsageLogger.getInstance().logEvent(GROUP_ID, "tip.shown", usageData);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tip";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/TipsOfTheDayUsagesCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerShow";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerTipShown";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class TipInfoWhiteListRule
    extends CustomWhiteListRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "tip_info".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            TipAndTrickBean tip;
            if (data2 == null) {
                TipInfoWhiteListRule.$$$reportNull$$$0(0);
            }
            if (context == null) {
                TipInfoWhiteListRule.$$$reportNull$$$0(1);
            }
            if (TipsOfTheDayUsagesCollector.NO_FEATURE_ID.equals(data2) || TipInfoWhiteListRule.isThirdPartyValue((String)data2)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    TipInfoWhiteListRule.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            PluginInfo info = context.pluginInfo;
            if (info != null) {
                ValidationResultType validationResultType = info.isSafeToReport() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                if (validationResultType == null) {
                    TipInfoWhiteListRule.$$$reportNull$$$0(3);
                }
                return validationResultType;
            }
            Object filename = context.eventData.get("filename");
            if (filename instanceof String && (tip = TipAndTrickBean.findByFileName((String)filename)) != null) {
                PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)tip.getPluginDescriptor());
                context.setPluginInfo(pluginInfo);
                ValidationResultType validationResultType = pluginInfo.isSafeToReport() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                if (validationResultType == null) {
                    TipInfoWhiteListRule.$$$reportNull$$$0(4);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                TipInfoWhiteListRule.$$$reportNull$$$0(5);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/TipsOfTheDayUsagesCollector$TipInfoWhiteListRule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/TipsOfTheDayUsagesCollector$TipInfoWhiteListRule";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

