/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.CopyPathProvider;
import com.intellij.ide.actions.CopyPathsAction;
import com.intellij.ide.actions.CopyReferenceUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyReferencePopup
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(CopyReferencePopup.class);
    private static final String COPY_REFERENCE_POPUP_PLACE = "CopyReferencePopupPlace";
    private static final int DEFAULT_WIDTH = JBUIScale.scale((int)500);
    private static final PresentationFactory PRESENTATION_FACTORY = new PresentationFactory();

    public void update(@NotNull AnActionEvent e) {
        ActionGroup actionGroup;
        if (e == null) {
            CopyReferencePopup.$$$reportNull$$$0(0);
        }
        if ((actionGroup = this.getCopyReferenceActionGroup()) == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        List<AnAction> actions = Utils.expandActionGroup(false, actionGroup, PRESENTATION_FACTORY, e.getDataContext(), e.getPlace());
        e.getPresentation().setEnabledAndVisible(CopyPathsAction.isCopyReferencePopupAvailable() && !actions.isEmpty());
    }

    public void actionPerformed(final @NotNull AnActionEvent e) {
        ActionGroup actionGroup;
        if (e == null) {
            CopyReferencePopup.$$$reportNull$$$0(1);
        }
        if ((actionGroup = this.getCopyReferenceActionGroup()) == null) {
            return;
        }
        final DataContext dataContext = CopyReferencePopup.cloneDataContext(e);
        PopupFactoryImpl.ActionGroupPopup popup2 = new PopupFactoryImpl.ActionGroupPopup("Copy", actionGroup, e.getDataContext(), true, true, false, true, null, -1, null, COPY_REFERENCE_POPUP_PLACE){

            @Override
            protected ListCellRenderer<PopupFactoryImpl.ActionItem> getListElementRenderer() {
                return new PopupListElementRenderer<PopupFactoryImpl.ActionItem>((ListPopupImpl)this){
                    private JLabel myInfoLabel;
                    private JLabel myShortcutLabel;

                    @Override
                    protected JComponent createItemComponent() {
                        this.myTextLabel = new ErrorLabel();
                        this.myTextLabel.setBorder(JBUI.Borders.empty((int)1));
                        this.myInfoLabel = new JLabel();
                        this.myInfoLabel.setBorder((Border)JBUI.Borders.empty((int)1, (int)10, (int)1, (int)1));
                        this.myShortcutLabel = new JLabel();
                        this.myShortcutLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
                        this.myShortcutLabel.setForeground(UIUtil.getContextHelpForeground());
                        JPanel textPanel = new JPanel(new BorderLayout());
                        JPanel titlePanel = new JPanel(new BorderLayout());
                        titlePanel.add((Component)this.myTextLabel, "West");
                        titlePanel.add((Component)this.myShortcutLabel, "Center");
                        textPanel.add((Component)titlePanel, "West");
                        textPanel.add((Component)this.myInfoLabel, "Center");
                        return this.layoutComponent(textPanel);
                    }

                    @Override
                    protected void customizeComponent(@NotNull JList<? extends PopupFactoryImpl.ActionItem> list2, @NotNull PopupFactoryImpl.ActionItem actionItem, boolean isSelected) {
                        int pos;
                        if (list2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (actionItem == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        AnAction action2 = actionItem.getAction();
                        AnActionEvent event = new AnActionEvent(e.getInputEvent(), dataContext, CopyReferencePopup.COPY_REFERENCE_POPUP_PLACE, action2.getTemplatePresentation().clone(), e.getActionManager(), e.getModifiers());
                        ActionUtil.performDumbAwareUpdate((boolean)true, (AnAction)action2, (AnActionEvent)event, (boolean)false);
                        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                        List<PsiElement> elements2 = CopyReferenceUtil.getElementsToCopy(editor, dataContext);
                        String qualifiedName = null;
                        if (action2 instanceof CopyPathProvider) {
                            qualifiedName = ((CopyPathProvider)action2).getQualifiedName(this.getProject(), elements2, editor, dataContext);
                        }
                        if (qualifiedName != null) {
                            this.myInfoLabel.setText(qualifiedName);
                        }
                        Color foreground = isSelected ? UIUtil.getListSelectionForeground((boolean)true) : UIUtil.getInactiveTextColor();
                        this.myInfoLabel.setForeground(foreground);
                        this.myShortcutLabel.setForeground(foreground);
                        MnemonicNavigationFilter filter2 = myStep.getMnemonicNavigationFilter();
                        int n = pos = filter2 == null ? -1 : filter2.getMnemonicPos((Object)actionItem);
                        if (pos != -1) {
                            String text2 = this.myTextLabel.getText();
                            text2 = text2.substring(0, pos) + text2.substring(pos + 1);
                            this.myTextLabel.setText(text2);
                            this.myTextLabel.setDisplayedMnemonicIndex(pos);
                        }
                        if (action2 instanceof CopyPathProvider) {
                            Shortcut shortcut = (Shortcut)ArrayUtil.getFirstElement((Object[])action2.getShortcutSet().getShortcuts());
                            this.myShortcutLabel.setText(shortcut != null ? KeymapUtil.getShortcutText((Shortcut)shortcut) : null);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "list";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "actionItem";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/ide/actions/CopyReferencePopup$1$1";
                        objectArray[2] = "customizeComponent";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }

            @Override
            protected boolean isResizable() {
                return true;
            }
        };
        CopyReferencePopup.updatePopupSize(popup2);
        popup2.showInBestPositionFor(e.getDataContext());
    }

    @Nullable
    public ActionGroup getCopyReferenceActionGroup() {
        AnAction popupGroup = ActionManager.getInstance().getAction("CopyReferencePopupGroup");
        if (!(popupGroup instanceof DefaultActionGroup)) {
            LOG.warn("Cannot find 'CopyReferencePopup' action to show popup");
            return null;
        }
        return (ActionGroup)popupGroup;
    }

    private static void updatePopupSize(@NotNull ListPopup popup2) {
        if (popup2 == null) {
            CopyReferencePopup.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            popup2.getContent().setPreferredSize(new Dimension(DEFAULT_WIDTH, popup2.getContent().getPreferredSize().height));
            popup2.getContent().setSize(new Dimension(DEFAULT_WIDTH, popup2.getContent().getPreferredSize().height));
            popup2.setSize(popup2.getContent().getPreferredSize());
        });
    }

    @NotNull
    private static DataContext cloneDataContext(@NotNull AnActionEvent e) {
        if (e == null) {
            CopyReferencePopup.$$$reportNull$$$0(3);
        }
        DataContext dataContext = e.getDataContext();
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put(CommonDataKeys.PSI_ELEMENT.getName(), CommonDataKeys.PSI_ELEMENT.getData(dataContext));
        map2.put(CommonDataKeys.PROJECT.getName(), CommonDataKeys.PROJECT.getData(dataContext));
        map2.put(LangDataKeys.PSI_ELEMENT_ARRAY.getName(), LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext));
        map2.put(CommonDataKeys.VIRTUAL_FILE_ARRAY.getName(), CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext));
        map2.put(CommonDataKeys.EDITOR.getName(), CommonDataKeys.EDITOR.getData(dataContext));
        DataContext dataContext2 = SimpleDataContext.getSimpleContext(map2, DataContext.EMPTY_CONTEXT);
        if (dataContext2 == null) {
            CopyReferencePopup.$$$reportNull$$$0(4);
        }
        return dataContext2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CopyReferencePopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CopyReferencePopup";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneDataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updatePopupSize";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cloneDataContext";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

