/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.ide.actions.CreateGroupHandler;
import com.intellij.ide.util.DirectoryUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.util.IncorrectOperationException;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class CreatePackageHandler
extends CreateGroupHandler {
    private static final String DELIMITER = ".";
    private static final String REGEX_DELIMITER = Pattern.quote(".");
    @NotNull
    private final PsiDirectory myPackageRoot;
    @NotNull
    private final String myInitialText;

    CreatePackageHandler(@NotNull Project project, @NotNull PsiDirectory directory) {
        if (project == null) {
            CreatePackageHandler.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            CreatePackageHandler.$$$reportNull$$$0(1);
        }
        super(project, directory);
        this.myPackageRoot = this.getPackageRoot();
        this.myInitialText = this.buildInitialText();
    }

    public boolean checkInput(String inputString) {
        if (inputString.isEmpty() || inputString.equals(this.myInitialText)) {
            this.errorText = null;
            return true;
        }
        if (inputString.endsWith(DELIMITER)) {
            this.errorText = IdeBundle.message((String)"error.invalid.java.package.name.format", (Object[])new Object[0]);
            return false;
        }
        PsiDirectoryFactory nameValidator = PsiDirectoryFactory.getInstance(this.myProject);
        VirtualFile file2 = this.myPackageRoot.getVirtualFile();
        this.errorText = null;
        for (String token : inputString.split(REGEX_DELIMITER)) {
            if (token.isEmpty()) {
                this.errorText = IdeBundle.message((String)"error.invalid.java.package.name.format", (Object[])new Object[0]);
                return false;
            }
            if (file2 != null && (file2 = file2.findChild(token)) != null && !file2.isDirectory()) {
                this.errorText = IdeBundle.message((String)"error.file.with.name.already.exists", (Object[])new Object[]{token});
                return false;
            }
            if (!nameValidator.isValidPackageName(token)) {
                this.errorText = IdeBundle.message((String)"error.invalid.java.package.name", (Object[])new Object[0]);
            }
            if (!FileTypeManager.getInstance().isFileIgnored(token)) continue;
            this.errorText = IdeBundle.message((String)"warning.create.package.with.ignored.name", (Object[])new Object[]{token});
        }
        if (file2 != null) {
            this.errorText = IdeBundle.message((String)"error.package.with.name.already.exists", (Object[])new Object[]{file2.getName()});
            return false;
        }
        return true;
    }

    public boolean canClose(String packageName) {
        if (packageName.isEmpty() || packageName.equals(this.myInitialText)) {
            Messages.showMessageDialog((Project)this.myProject, (String)IdeBundle.message((String)"error.name.should.be.specified", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return false;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            String dirPath = this.myPackageRoot.getVirtualFile().getPresentableUrl();
            String actionName = IdeBundle.message((String)"progress.creating.package", (Object[])new Object[]{dirPath, packageName});
            LocalHistoryAction action2 = LocalHistory.getInstance().startAction(actionName);
            try {
                this.createdElement = DirectoryUtil.createSubdirectories(packageName, this.myPackageRoot, DELIMITER);
            }
            catch (IncorrectOperationException ex) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((Project)this.myProject, (String)CreateElementActionBase.filterMessage((String)ex.getMessage()), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon()));
            }
            finally {
                action2.finish();
            }
        }), IdeBundle.message((String)"command.create.package", (Object[])new Object[0]), null);
        return this.createdElement != null;
    }

    @Override
    @NotNull
    String getInitialText() {
        String string = this.myInitialText;
        if (string == null) {
            CreatePackageHandler.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private String buildInitialText() {
        if (this.myPackageRoot.isEquivalentTo((PsiElement)this.myDirectory)) {
            return "";
        }
        String root = this.myPackageRoot.getVirtualFile().getPath();
        String current2 = this.myDirectory.getVirtualFile().getPath();
        String string = current2.substring(root.length() + 1).replace("/", DELIMITER) + DELIMITER;
        if (string == null) {
            CreatePackageHandler.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private PsiDirectory getPackageRoot() {
        PsiDirectoryFactory manager = PsiDirectoryFactory.getInstance(this.myProject);
        PsiDirectory directory = this.myDirectory;
        for (PsiDirectory parent = directory.getParent(); parent != null && manager.isPackage(parent); parent = parent.getParent()) {
            directory = parent;
        }
        PsiDirectory psiDirectory = directory;
        if (psiDirectory == null) {
            CreatePackageHandler.$$$reportNull$$$0(4);
        }
        return psiDirectory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CreatePackageHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CreatePackageHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildInitialText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

