/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.DirectoryPathMatcher;
import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.DefaultChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.DefaultFileNavigationContributor;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.ide.util.gotoByName.MatchResult;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.codeStyle.FixingLayoutMatcher;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoFileItemProvider
extends DefaultChooseByNameItemProvider {
    private static final Logger LOG = Logger.getInstance(GotoFileItemProvider.class);
    private static final int EXACT_MATCH_DEGREE = 5000;
    private static final int DIRECTORY_MATCH_DEGREE = 0;
    private final Project myProject;
    private final GotoFileModel myModel;

    public GotoFileItemProvider(@NotNull Project project, @Nullable PsiElement context, @NotNull GotoFileModel model) {
        if (project == null) {
            GotoFileItemProvider.$$$reportNull$$$0(0);
        }
        if (model == null) {
            GotoFileItemProvider.$$$reportNull$$$0(1);
        }
        super(context);
        this.myProject = project;
        this.myModel = model;
    }

    @Override
    public boolean filterElementsWithWeights(@NotNull ChooseByNameBase base, @NotNull FindSymbolParameters parameters, @NotNull ProgressIndicator indicator, @NotNull Processor<? super FoundItemDescriptor<?>> consumer) {
        if (base == null) {
            GotoFileItemProvider.$$$reportNull$$$0(2);
        }
        if (parameters == null) {
            GotoFileItemProvider.$$$reportNull$$$0(3);
        }
        if (indicator == null) {
            GotoFileItemProvider.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            GotoFileItemProvider.$$$reportNull$$$0(5);
        }
        return (Boolean)ProgressManager.getInstance().computePrioritized(() -> this.doFilterElements(base, parameters, indicator, consumer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFilterElements(@NotNull ChooseByNameBase base, @NotNull FindSymbolParameters parameters, @NotNull ProgressIndicator indicator, @NotNull Processor<? super FoundItemDescriptor<?>> consumer) {
        if (base == null) {
            GotoFileItemProvider.$$$reportNull$$$0(6);
        }
        if (parameters == null) {
            GotoFileItemProvider.$$$reportNull$$$0(7);
        }
        if (indicator == null) {
            GotoFileItemProvider.$$$reportNull$$$0(8);
        }
        if (consumer == null) {
            GotoFileItemProvider.$$$reportNull$$$0(9);
        }
        long start2 = System.currentTimeMillis();
        try {
            String pattern = parameters.getCompletePattern();
            PsiFileSystemItem absolute = this.getFileByAbsolutePath(pattern);
            if (absolute != null && !consumer.process((Object)new FoundItemDescriptor((Object)absolute, 5000))) {
                boolean bl = true;
                return bl;
            }
            if (pattern.startsWith("./") || pattern.startsWith(".\\")) {
                parameters = parameters.withCompletePattern(pattern.substring(1));
            }
            if (!this.processItemsForPattern(base, parameters, consumer, indicator)) {
                boolean bl = false;
                return bl;
            }
            String fixedPattern = FixingLayoutMatcher.fixLayout((String)pattern);
            boolean bl = fixedPattern == null || this.processItemsForPattern(base, parameters.withCompletePattern(fixedPattern), consumer, indicator);
            return bl;
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Goto File \"" + parameters.getCompletePattern() + "\" took " + (System.currentTimeMillis() - start2) + " ms");
            }
        }
    }

    private boolean processItemsForPattern(@NotNull ChooseByNameBase base, @NotNull FindSymbolParameters parameters, @NotNull Processor<? super FoundItemDescriptor<?>> consumer, @NotNull ProgressIndicator indicator) {
        int index;
        if (base == null) {
            GotoFileItemProvider.$$$reportNull$$$0(10);
        }
        if (parameters == null) {
            GotoFileItemProvider.$$$reportNull$$$0(11);
        }
        if (consumer == null) {
            GotoFileItemProvider.$$$reportNull$$$0(12);
        }
        if (indicator == null) {
            GotoFileItemProvider.$$$reportNull$$$0(13);
        }
        String sanitized = GotoFileItemProvider.getSanitizedPattern(parameters.getCompletePattern(), this.myModel);
        int qualifierEnd = sanitized.lastIndexOf(47) + 1;
        NameGrouper grouper = new NameGrouper(sanitized.substring(qualifierEnd), indicator);
        this.processNames(FindSymbolParameters.simple(this.myProject, true), (Processor<? super String>)((Processor)grouper::processName));
        Ref hasSuggestions = Ref.create((Object)false);
        for (DirectoryPathMatcher dirMatcher = DirectoryPathMatcher.root(this.myModel, sanitized.substring(0, qualifierEnd)); dirMatcher != null; dirMatcher = dirMatcher.appendChar(grouper.namePattern.charAt(index))) {
            index = grouper.index;
            SuffixMatches group = grouper.nextGroup(base);
            if (group == null) break;
            if (group.processFiles(parameters.withLocalPattern(dirMatcher.dirPattern), consumer, (Ref<Boolean>)hasSuggestions, dirMatcher)) continue;
            return false;
        }
        return true;
    }

    private void processNames(@NotNull FindSymbolParameters parameters, @NotNull Processor<? super String> nameProcessor) {
        if (parameters == null) {
            GotoFileItemProvider.$$$reportNull$$$0(14);
        }
        if (nameProcessor == null) {
            GotoFileItemProvider.$$$reportNull$$$0(15);
        }
        List contributors = DumbService.getDumbAwareExtensions((Project)this.myProject, (ExtensionPointName)ChooseByNameContributor.FILE_EP_NAME);
        for (ChooseByNameContributor contributor : contributors) {
            if (contributor instanceof DefaultFileNavigationContributor) {
                FilenameIndex.processAllFileNames(nameProcessor, (GlobalSearchScope)parameters.getSearchScope(), (IdFilter)parameters.getIdFilter());
                continue;
            }
            this.myModel.processContributorNames(contributor, parameters, nameProcessor);
        }
    }

    @NotNull
    public static String getSanitizedPattern(@NotNull String pattern, @NotNull GotoFileModel model) {
        if (pattern == null) {
            GotoFileItemProvider.$$$reportNull$$$0(16);
        }
        if (model == null) {
            GotoFileItemProvider.$$$reportNull$$$0(17);
        }
        return GotoFileItemProvider.removeSlashes(StringUtil.replace((String)ChooseByNamePopup.getTransformedPattern(pattern, model), (String)"\\", (String)"/"));
    }

    @NotNull
    public static MinusculeMatcher getQualifiedNameMatcher(@NotNull String pattern) {
        if (pattern == null) {
            GotoFileItemProvider.$$$reportNull$$$0(18);
        }
        pattern = "*" + StringUtil.replace((String)StringUtil.replace((String)pattern, (String)"\\", (String)"*\\*"), (String)"/", (String)"*/*");
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher((String)pattern).withCaseSensitivity(NameUtil.MatchingCaseSensitivity.NONE).preferringStartMatches().build();
        if (minusculeMatcher == null) {
            GotoFileItemProvider.$$$reportNull$$$0(19);
        }
        return minusculeMatcher;
    }

    @NotNull
    private static String removeSlashes(@NotNull String s) {
        if (s == null) {
            GotoFileItemProvider.$$$reportNull$$$0(20);
        }
        String string = StringUtil.trimLeading((String)StringUtil.trimTrailing((String)s, (char)'/'), (char)'/');
        if (string == null) {
            GotoFileItemProvider.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Nullable
    private PsiFileSystemItem getFileByAbsolutePath(@NotNull String pattern) {
        if (pattern == null) {
            GotoFileItemProvider.$$$reportNull$$$0(22);
        }
        if (pattern.contains("/") || pattern.contains("\\")) {
            ProjectFileIndex index;
            String path = FileUtil.toSystemIndependentName((String)ChooseByNamePopup.getTransformedPattern(pattern, this.myModel));
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByPathIfCached(path);
            if (vFile != null && ((index = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject)).isInContent(vFile) || index.isInLibrary(vFile))) {
                return PsiUtilCore.findFileSystemItem((Project)this.myProject, (VirtualFile)vFile);
            }
        }
        return null;
    }

    @NotNull
    private Iterable<FoundItemDescriptor<PsiFileSystemItem>> matchQualifiers(@NotNull MinusculeMatcher qualifierMatcher, @NotNull Iterable<? extends PsiFileSystemItem> iterable) {
        if (qualifierMatcher == null) {
            GotoFileItemProvider.$$$reportNull$$$0(23);
        }
        if (iterable == null) {
            GotoFileItemProvider.$$$reportNull$$$0(24);
        }
        ArrayList<FoundItemDescriptor<PsiFileSystemItem>> matching2 = new ArrayList<FoundItemDescriptor<PsiFileSystemItem>>();
        for (PsiFileSystemItem psiFileSystemItem : iterable) {
            ProgressManager.checkCanceled();
            String qualifier = Objects.requireNonNull(this.getParentPath(psiFileSystemItem));
            FList fragments = qualifierMatcher.matchingFragments(qualifier);
            if (fragments == null) continue;
            int gapPenalty = fragments.isEmpty() ? 0 : qualifier.length() - ((TextRange)fragments.get(fragments.size() - 1)).getEndOffset();
            int degree = qualifierMatcher.matchingDegree(qualifier, false, fragments) - gapPenalty;
            matching2.add((FoundItemDescriptor<PsiFileSystemItem>)new FoundItemDescriptor((Object)psiFileSystemItem, degree));
        }
        if (matching2.size() > 1) {
            Comparator<FoundItemDescriptor> comparator2 = Comparator.comparing(res2 -> res2.getWeight()).reversed();
            matching2.sort(comparator2);
        }
        ArrayList<FoundItemDescriptor<PsiFileSystemItem>> arrayList = matching2;
        if (arrayList == null) {
            GotoFileItemProvider.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @Nullable
    private String getParentPath(@NotNull PsiFileSystemItem item) {
        String fullName;
        if (item == null) {
            GotoFileItemProvider.$$$reportNull$$$0(26);
        }
        return (fullName = this.myModel.getFullName(item)) == null ? null : StringUtil.getPackageName((String)FileUtilRt.toSystemIndependentName((String)fullName), (char)'/') + '/';
    }

    @NotNull
    private static JBIterable<FoundItemDescriptor<PsiFileSystemItem>> moveDirectoriesToEnd(@NotNull Iterable<FoundItemDescriptor<PsiFileSystemItem>> iterable) {
        if (iterable == null) {
            GotoFileItemProvider.$$$reportNull$$$0(27);
        }
        ArrayList dirs = new ArrayList();
        JBIterable jBIterable = JBIterable.from(iterable).filter(res2 -> {
            if (res2.getItem() instanceof PsiDirectory) {
                dirs.add(new FoundItemDescriptor(res2.getItem(), 0));
                return false;
            }
            return true;
        }).append(dirs);
        if (jBIterable == null) {
            GotoFileItemProvider.$$$reportNull$$$0(28);
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<FoundItemDescriptor<PsiFileSystemItem>> getFilesMatchingPath(@NotNull FindSymbolParameters parameters, @NotNull List<MatchResult> fileNames, @NotNull DirectoryPathMatcher dirMatcher, @NotNull ProgressIndicator indicator) {
        if (parameters == null) {
            GotoFileItemProvider.$$$reportNull$$$0(29);
        }
        if (fileNames == null) {
            GotoFileItemProvider.$$$reportNull$$$0(30);
        }
        if (dirMatcher == null) {
            GotoFileItemProvider.$$$reportNull$$$0(31);
        }
        if (indicator == null) {
            GotoFileItemProvider.$$$reportNull$$$0(32);
        }
        GlobalSearchScope scope = dirMatcher.narrowDown(parameters.getSearchScope());
        FindSymbolParameters adjusted = parameters.withScope(scope);
        List<List<MatchResult>> sortedNames = GotoFileItemProvider.sortAndGroup(fileNames, Comparator.comparing(mr -> StringUtil.toLowerCase((String)FileUtilRt.getNameWithoutExtension((String)mr.elementName))));
        JBIterable jBIterable = JBIterable.from(sortedNames).flatMap(nameGroup -> this.getItemsForNames(indicator, adjusted, (List<? extends MatchResult>)nameGroup));
        if (jBIterable == null) {
            GotoFileItemProvider.$$$reportNull$$$0(33);
        }
        return jBIterable;
    }

    @NotNull
    private Iterable<FoundItemDescriptor<PsiFileSystemItem>> getItemsForNames(@NotNull ProgressIndicator indicator, @NotNull FindSymbolParameters parameters, @NotNull List<? extends MatchResult> matchResults) {
        if (indicator == null) {
            GotoFileItemProvider.$$$reportNull$$$0(34);
        }
        if (parameters == null) {
            GotoFileItemProvider.$$$reportNull$$$0(35);
        }
        if (matchResults == null) {
            GotoFileItemProvider.$$$reportNull$$$0(36);
        }
        ArrayList<PsiFileSystemItem> group = new ArrayList<PsiFileSystemItem>();
        HashMap<PsiFileSystemItem, Integer> nesting = new HashMap<PsiFileSystemItem, Integer>();
        HashMap<PsiFileSystemItem, Integer> matchDegrees = new HashMap<PsiFileSystemItem, Integer>();
        for (MatchResult matchResult : matchResults) {
            ProgressManager.checkCanceled();
            for (Object o : this.myModel.getElementsByName(matchResult.elementName, parameters, indicator)) {
                PsiFileSystemItem psiItem;
                String qualifier;
                ProgressManager.checkCanceled();
                if (!(o instanceof PsiFileSystemItem) || (qualifier = this.getParentPath(psiItem = (PsiFileSystemItem)o)) == null) continue;
                group.add(psiItem);
                nesting.put(psiItem, StringUtil.countChars((CharSequence)qualifier, (char)'/'));
                matchDegrees.put(psiItem, matchResult.matchingDegree);
            }
        }
        if (group.size() > 1) {
            group.sort(Comparator.comparing(nesting::get).thenComparing(this.getPathProximityComparator()).thenComparing(this.myModel::getFullName));
        }
        List list2 = ContainerUtil.map(group, item -> new FoundItemDescriptor(item, ((Integer)matchDegrees.get(item)).intValue()));
        if (list2 == null) {
            GotoFileItemProvider.$$$reportNull$$$0(37);
        }
        return list2;
    }

    private static int findMatchStartingPosition(@NotNull String candidateName, @NotNull String namePattern) {
        if (candidateName == null) {
            GotoFileItemProvider.$$$reportNull$$$0(38);
        }
        if (namePattern == null) {
            GotoFileItemProvider.$$$reportNull$$$0(39);
        }
        int namePos = candidateName.length();
        for (int i = namePattern.length(); i > 0; --i) {
            char c = namePattern.charAt(i - 1);
            if (!Character.isLetterOrDigit(c) || (namePos = StringUtil.lastIndexOfIgnoreCase((String)candidateName, (char)c, (int)(namePos - 1))) >= 0) continue;
            return i;
        }
        return 0;
    }

    @NotNull
    private static <T> List<List<T>> sortAndGroup(@NotNull List<T> items, @NotNull Comparator<? super T> comparator2) {
        if (items == null) {
            GotoFileItemProvider.$$$reportNull$$$0(40);
        }
        if (comparator2 == null) {
            GotoFileItemProvider.$$$reportNull$$$0(41);
        }
        List list2 = ((StreamEx)StreamEx.of(items).sorted(comparator2)).groupRuns((n1, n2) -> comparator2.compare(n1, n2) == 0).toList();
        if (list2 == null) {
            GotoFileItemProvider.$$$reportNull$$$0(42);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 21: 
            case 25: 
            case 28: 
            case 33: 
            case 37: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 21: 
            case 25: 
            case 28: 
            case 33: 
            case 37: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 14: 
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 4: 
            case 8: 
            case 13: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameProcessor";
                break;
            }
            case 16: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 19: 
            case 21: 
            case 25: 
            case 28: 
            case 33: 
            case 37: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/GotoFileItemProvider";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierMatcher";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNames";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirMatcher";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchResults";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateName";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namePattern";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/GotoFileItemProvider";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNameMatcher";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "removeSlashes";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "matchQualifiers";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "moveDirectoriesToEnd";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesMatchingPath";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsForNames";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "sortAndGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filterElementsWithWeights";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doFilterElements";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processItemsForPattern";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processNames";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSanitizedPattern";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameMatcher";
                break;
            }
            case 19: 
            case 21: 
            case 25: 
            case 28: 
            case 33: 
            case 37: 
            case 42: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeSlashes";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getFileByAbsolutePath";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "matchQualifiers";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getParentPath";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "moveDirectoriesToEnd";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getFilesMatchingPath";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getItemsForNames";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findMatchStartingPosition";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "sortAndGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: 
            case 21: 
            case 25: 
            case 28: 
            case 33: 
            case 37: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SuffixMatches {
        final String patternSuffix;
        final MinusculeMatcher matcher;
        final List<MatchResult> matchingNames;
        final ProgressIndicator indicator;

        SuffixMatches(String pattern, @NotNull int from, ProgressIndicator indicator) {
            if (pattern == null) {
                SuffixMatches.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                SuffixMatches.$$$reportNull$$$0(1);
            }
            this.matchingNames = new ArrayList<MatchResult>();
            this.patternSuffix = pattern.substring(from);
            boolean preferStartMatches = from == 0 && !this.patternSuffix.startsWith("*");
            String matchPattern = (from > 0 ? " " : "*") + this.patternSuffix;
            NameUtil.MatcherBuilder builder2 = NameUtil.buildMatcher((String)matchPattern).withCaseSensitivity(NameUtil.MatchingCaseSensitivity.NONE);
            if (preferStartMatches) {
                builder2.preferringStartMatches();
            }
            this.matcher = builder2.build();
            this.indicator = indicator;
        }

        public String toString() {
            return "SuffixMatches{patternSuffix='" + this.patternSuffix + '\'' + ", matchingNames=" + this.matchingNames + '}';
        }

        boolean matchName(@NotNull ChooseByNameBase base, String name) {
            MatchResult result2;
            if (base == null) {
                SuffixMatches.$$$reportNull$$$0(2);
            }
            if ((result2 = GotoFileItemProvider.matches(base, this.patternSuffix, this.matcher, name)) != null) {
                this.matchingNames.add(result2);
                return true;
            }
            return false;
        }

        boolean processFiles(@NotNull FindSymbolParameters parameters, @NotNull Processor<? super FoundItemDescriptor<?>> processor2, @NotNull Ref<Boolean> hasSuggestions, @NotNull DirectoryPathMatcher dirMatcher) {
            Set<String> existingNames;
            if (parameters == null) {
                SuffixMatches.$$$reportNull$$$0(3);
            }
            if (processor2 == null) {
                SuffixMatches.$$$reportNull$$$0(4);
            }
            if (hasSuggestions == null) {
                SuffixMatches.$$$reportNull$$$0(5);
            }
            if (dirMatcher == null) {
                SuffixMatches.$$$reportNull$$$0(6);
            }
            MinusculeMatcher qualifierMatcher = GotoFileItemProvider.getQualifiedNameMatcher(parameters.getLocalPatternName());
            List matchingNames = this.matchingNames;
            if (this.patternSuffix.length() <= 3 && !dirMatcher.dirPattern.isEmpty() && (existingNames = dirMatcher.findFileNamesMatchingIfCheap(this.patternSuffix.charAt(0), this.matcher)) != null) {
                matchingNames = ContainerUtil.filter(matchingNames, mr -> existingNames.contains(mr.elementName));
            }
            List<List<MatchResult>> groups = this.groupByMatchingDegree(matchingNames);
            for (List<MatchResult> group : groups) {
                Processor trackingProcessor;
                JBIterable matchedFiles;
                JBIterable filesMatchingPath = GotoFileItemProvider.this.getFilesMatchingPath(parameters, group, dirMatcher, this.indicator);
                Object object = matchedFiles = parameters.getLocalPatternName().isEmpty() ? filesMatchingPath : GotoFileItemProvider.this.matchQualifiers(qualifierMatcher, (Iterable)filesMatchingPath.map(res2 -> (PsiFileSystemItem)res2.getItem()));
                if (ContainerUtil.process((Iterable)(matchedFiles = GotoFileItemProvider.moveDirectoriesToEnd((Iterable)matchedFiles)), (Processor)(trackingProcessor = res2 -> {
                    hasSuggestions.set((Object)true);
                    return processor2.process(res2);
                }))) continue;
                return false;
            }
            return (Boolean)hasSuggestions.get() != false || parameters.isSearchInLibraries() || !this.hasSuggestionsOutsideProject(parameters.getCompletePattern(), groups, dirMatcher);
        }

        private boolean hasSuggestionsOutsideProject(@NotNull String pattern, @NotNull List<? extends List<MatchResult>> groups, @NotNull DirectoryPathMatcher dirMatcher) {
            if (pattern == null) {
                SuffixMatches.$$$reportNull$$$0(7);
            }
            if (groups == null) {
                SuffixMatches.$$$reportNull$$$0(8);
            }
            if (dirMatcher == null) {
                SuffixMatches.$$$reportNull$$$0(9);
            }
            return ContainerUtil.exists(groups, group -> !GotoFileItemProvider.this.getFilesMatchingPath(FindSymbolParameters.wrap(pattern, GotoFileItemProvider.this.myProject, true), group, dirMatcher, this.indicator).isEmpty());
        }

        @NotNull
        private List<List<MatchResult>> groupByMatchingDegree(@NotNull List<MatchResult> matchingNames) {
            if (matchingNames == null) {
                SuffixMatches.$$$reportNull$$$0(10);
            }
            Comparator comparator2 = (mr1, mr2) -> {
                boolean exactPrefix1 = StringUtil.startsWith((CharSequence)mr1.elementName, (CharSequence)this.patternSuffix);
                boolean exactPrefix2 = StringUtil.startsWith((CharSequence)mr2.elementName, (CharSequence)this.patternSuffix);
                if (exactPrefix1 && exactPrefix2) {
                    return 0;
                }
                if (exactPrefix1 != exactPrefix2) {
                    return exactPrefix1 ? -1 : 1;
                }
                return mr1.compareDegrees((MatchResult)mr2);
            };
            List list2 = GotoFileItemProvider.sortAndGroup(matchingNames, comparator2);
            if (list2 == null) {
                SuffixMatches.$$$reportNull$$$0(11);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "base";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hasSuggestions";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dirMatcher";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groups";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchingNames";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/GotoFileItemProvider$SuffixMatches";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/GotoFileItemProvider$SuffixMatches";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "groupByMatchingDegree";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "matchName";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "processFiles";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "hasSuggestionsOutsideProject";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "groupByMatchingDegree";
                    break;
                }
                case 11: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class NameGrouper {
        private final String namePattern;
        @NotNull
        private final ProgressIndicator indicator;
        private final List<List<String>> candidateNames;
        private int index;

        NameGrouper(@NotNull String namePattern, ProgressIndicator indicator) {
            if (namePattern == null) {
                NameGrouper.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                NameGrouper.$$$reportNull$$$0(1);
            }
            this.namePattern = namePattern;
            this.candidateNames = IntStreamEx.range((int)0, (int)namePattern.length()).mapToObj(__ -> new ArrayList()).toList();
            this.indicator = indicator;
        }

        boolean processName(@NotNull String name) {
            if (name == null) {
                NameGrouper.$$$reportNull$$$0(2);
            }
            this.indicator.checkCanceled();
            int position = GotoFileItemProvider.findMatchStartingPosition(name, this.namePattern);
            if (position < this.namePattern.length()) {
                this.candidateNames.get(position).add(name);
            }
            return true;
        }

        @Nullable
        SuffixMatches nextGroup(@NotNull ChooseByNameBase base) {
            if (base == null) {
                NameGrouper.$$$reportNull$$$0(3);
            }
            if (this.index >= this.namePattern.length()) {
                return null;
            }
            SuffixMatches matches = new SuffixMatches(this.namePattern, this.index, this.indicator);
            for (String name : this.candidateNames.get(this.index)) {
                if (matches.matchName(base, name) || this.index + 1 >= this.namePattern.length()) continue;
                this.candidateNames.get(this.index + 1).add(name);
            }
            this.candidateNames.set(this.index, null);
            ++this.index;
            return matches;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namePattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "base";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/GotoFileItemProvider$NameGrouper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nextGroup";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

