/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.SaveFileAsTemplateDialog;
import com.intellij.ide.actions.SaveFileAsTemplateHandler;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.impl.FileTemplateConfigurable;
import com.intellij.ide.fileTemplates.impl.FileTemplateManagerImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

final class SaveFileAsTemplateAction
extends AnAction {
    SaveFileAsTemplateAction() {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SaveFileAsTemplateAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)Objects.requireNonNull(e.getData(CommonDataKeys.PROJECT));
        String fileText = (String)Objects.requireNonNull(e.getData(PlatformDataKeys.FILE_TEXT));
        VirtualFile file2 = (VirtualFile)Objects.requireNonNull(e.getData(CommonDataKeys.VIRTUAL_FILE));
        String extension = StringUtil.notNullize((String)file2.getExtension());
        String nameWithoutExtension = file2.getNameWithoutExtension();
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        for (SaveFileAsTemplateHandler handler2 : SaveFileAsTemplateHandler.EP_NAME.getExtensionList()) {
            String textFromHandler = handler2.getTemplateText(psiFile, fileText, nameWithoutExtension);
            if (textFromHandler == null) continue;
            fileText = textFromHandler;
            break;
        }
        FileTemplateManager templateManager = FileTemplateManager.getInstance(project);
        Object[] templates = templateManager.getAllTemplates();
        FileTemplate template = FileTemplateUtil.createTemplate(nameWithoutExtension, extension, fileText, (FileTemplate[])templates);
        FileTemplateConfigurable configurable2 = new FileTemplateConfigurable(project);
        configurable2.setProportion(0.6f);
        configurable2.setTemplate(template, FileTemplateManagerImpl.getInstanceImpl(project).getDefaultTemplateDescription());
        SaveFileAsTemplateDialog dialog2 = new SaveFileAsTemplateDialog(project, (Configurable)configurable2);
        if (dialog2.showAndGet()) {
            templateManager.setTemplates("Default", Arrays.asList(ArrayUtil.append((Object[])templates, (Object)template)));
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SaveFileAsTemplateAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(e.getData(CommonDataKeys.VIRTUAL_FILE) != null && e.getData(PlatformDataKeys.FILE_TEXT) != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/ide/actions/SaveFileAsTemplateAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

