/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkItem;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.bookmarks.BookmarksListener;
import com.intellij.ide.favoritesTreeView.AbstractFavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.IconManager;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BookmarksFavoriteListProvider
extends AbstractFavoritesListProvider<Bookmark>
implements BookmarksListener {
    public BookmarksFavoriteListProvider(Project project) {
        super(project, "Bookmarks");
        project.getMessageBus().connect().subscribe(BookmarksListener.TOPIC, (Object)this);
        this.updateChildren();
    }

    @Override
    public void bookmarkAdded(@NotNull Bookmark b) {
        if (b == null) {
            BookmarksFavoriteListProvider.$$$reportNull$$$0(0);
        }
        this.updateChildren();
    }

    @Override
    public void bookmarkRemoved(@NotNull Bookmark b) {
        if (b == null) {
            BookmarksFavoriteListProvider.$$$reportNull$$$0(1);
        }
        this.updateChildren();
    }

    @Override
    public void bookmarkChanged(@NotNull Bookmark b) {
        if (b == null) {
            BookmarksFavoriteListProvider.$$$reportNull$$$0(2);
        }
        this.updateChildren();
    }

    @Override
    public void bookmarksOrderChanged() {
        this.updateChildren();
    }

    private void updateChildren() {
        if (this.myProject.isDisposed()) {
            return;
        }
        this.myChildren.clear();
        List<Bookmark> bookmarks = BookmarkManager.getInstance(this.myProject).getValidBookmarks();
        for (final Bookmark bookmark : bookmarks) {
            AbstractTreeNode<Bookmark> child2 = new AbstractTreeNode<Bookmark>(this.myProject, bookmark){

                @NotNull
                public Collection<? extends AbstractTreeNode<Bookmark>> getChildren() {
                    List list2 = Collections.emptyList();
                    if (list2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return list2;
                }

                public boolean canNavigate() {
                    return bookmark.canNavigate();
                }

                public boolean canNavigateToSource() {
                    return bookmark.canNavigateToSource();
                }

                public void navigate(boolean requestFocus) {
                    bookmark.navigate(requestFocus);
                }

                protected void update(@NotNull PresentationData presentation) {
                    if (presentation == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    presentation.setPresentableText(bookmark.toString());
                    presentation.setIcon(bookmark.getIcon());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 1: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 1: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/bookmarks/BookmarksFavoriteListProvider$1";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "presentation";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getChildren";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/bookmarks/BookmarksFavoriteListProvider$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "update";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            child2.setParent((AbstractTreeNode)this.myNode);
            this.myChildren.add(child2);
        }
        FavoritesManager.getInstance(this.myProject).fireListeners(this.getListName(this.myProject));
    }

    @Override
    @Nullable
    public String getCustomName(@NotNull CommonActionsPanel.Buttons type) {
        if (type == null) {
            BookmarksFavoriteListProvider.$$$reportNull$$$0(3);
        }
        switch (type) {
            case EDIT: {
                return IdeBundle.message((String)"action.bookmark.edit.description", (Object[])new Object[0]);
            }
            case REMOVE: {
                return IdeBundle.message((String)"action.bookmark.delete", (Object[])new Object[0]);
            }
        }
        return null;
    }

    @Override
    public boolean willHandle(@NotNull CommonActionsPanel.Buttons type, Project project, @NotNull Set<Object> selectedObjects) {
        if (type == null) {
            BookmarksFavoriteListProvider.$$$reportNull$$$0(4);
        }
        if (selectedObjects == null) {
            BookmarksFavoriteListProvider.$$$reportNull$$$0(5);
        }
        switch (type) {
            case EDIT: {
                if (selectedObjects.size() != 1) {
                    return false;
                }
                Object toEdit = selectedObjects.iterator().next();
                return toEdit instanceof AbstractTreeNode && ((AbstractTreeNode)toEdit).getValue() instanceof Bookmark;
            }
            case REMOVE: {
                for (Object toRemove2 : selectedObjects) {
                    if (toRemove2 instanceof AbstractTreeNode && ((AbstractTreeNode)toRemove2).getValue() instanceof Bookmark) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void handle(@NotNull CommonActionsPanel.Buttons type, Project project, @NotNull Set<Object> selectedObjects, JComponent component2) {
        if (type == null) {
            BookmarksFavoriteListProvider.$$$reportNull$$$0(6);
        }
        if (selectedObjects == null) {
            BookmarksFavoriteListProvider.$$$reportNull$$$0(7);
        }
        switch (type) {
            case EDIT: {
                Bookmark bookmark;
                Object toEdit;
                if (selectedObjects.size() != 1 || !((toEdit = selectedObjects.iterator().next()) instanceof AbstractTreeNode) || !(((AbstractTreeNode)toEdit).getValue() instanceof Bookmark) || (bookmark = (Bookmark)((AbstractTreeNode)toEdit).getValue()) == null) break;
                BookmarkManager.getInstance(project).editDescription(bookmark, component2);
                break;
            }
            case REMOVE: {
                for (Object toRemove2 : selectedObjects) {
                    Bookmark bookmark = (Bookmark)((AbstractTreeNode)toRemove2).getValue();
                    BookmarkManager.getInstance(project).removeBookmark(bookmark);
                }
                break;
            }
        }
    }

    @Override
    public int getWeight() {
        return 100;
    }

    @Override
    public void customizeRenderer(ColoredTreeCellRenderer renderer, JTree tree, @NotNull Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value2 == null) {
            BookmarksFavoriteListProvider.$$$reportNull$$$0(8);
        }
        renderer.clear();
        renderer.setIcon(Bookmark.DEFAULT_ICON);
        if (value2 instanceof Bookmark) {
            Bookmark bookmark = (Bookmark)value2;
            BookmarkItem.setupRenderer((SimpleColoredComponent)renderer, this.myProject, bookmark, selected2);
            if (renderer.getIcon() != null) {
                RowIcon icon2 = IconManager.getInstance().createRowIcon(3, RowIcon.Alignment.CENTER);
                icon2.setIcon(bookmark.getIcon(), 0);
                icon2.setIcon((Icon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)1)), 1);
                icon2.setIcon(renderer.getIcon(), 2);
                renderer.setIcon((Icon)icon2);
            } else {
                renderer.setIcon(bookmark.getIcon());
            }
        } else {
            renderer.append(this.getListName(this.myProject));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedObjects";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/bookmarks/BookmarksFavoriteListProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "bookmarkAdded";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "bookmarkRemoved";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "bookmarkChanged";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCustomName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "willHandle";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "handle";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeRenderer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

