/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.bookmarks.actions.BookmarksAction;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class ToggleBookmarkAction
extends BookmarksAction
implements DumbAware,
Toggleable {
    public ToggleBookmarkAction() {
        this.getTemplatePresentation().setText(IdeBundle.messagePointer((String)"action.bookmark.toggle", (Object[])new Object[0]));
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        BookmarksAction.BookmarkInContextInfo info;
        boolean selected2;
        if (event == null) {
            ToggleBookmarkAction.$$$reportNull$$$0(0);
        }
        Project project = event.getProject();
        DataContext dataContext = event.getDataContext();
        event.getPresentation().setEnabled(project != null && (CommonDataKeys.EDITOR.getData(dataContext) != null || CommonDataKeys.VIRTUAL_FILE.getData(dataContext) != null));
        if ("TouchBarGeneral".equals(event.getPlace())) {
            event.getPresentation().setIcon(AllIcons.Actions.Checked);
        }
        boolean bl = selected2 = (info = ToggleBookmarkAction.getBookmarkInfo(event)) != null && info.getBookmarkAtPlace() != null;
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            event.getPresentation().setText(selected2 ? "Clear Bookmark" : "Set Bookmark");
        } else {
            event.getPresentation().setText(IdeBundle.messagePointer((String)"action.bookmark.toggle", (Object[])new Object[0]));
            Toggleable.setSelected((Presentation)event.getPresentation(), (boolean)selected2);
        }
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ToggleBookmarkAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        BookmarksAction.BookmarkInContextInfo info = ToggleBookmarkAction.getBookmarkInfo(e);
        if (info == null) {
            return;
        }
        boolean selected2 = info.getBookmarkAtPlace() != null;
        Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)selected2);
        if (selected2) {
            BookmarkManager.getInstance(project).removeBookmark(info.getBookmarkAtPlace());
        } else {
            BookmarkManager.getInstance(project).addTextBookmark(info.getFile(), info.getLine(), "");
        }
    }

    public static BookmarksAction.BookmarkInContextInfo getBookmarkInfo(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ToggleBookmarkAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return null;
        }
        BookmarksAction.BookmarkInContextInfo info = new BookmarksAction.BookmarkInContextInfo(e.getDataContext(), project).invoke();
        return info.getFile() == null ? null : info;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/bookmarks/actions/ToggleBookmarkAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getBookmarkInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

