/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.dnd;

import com.intellij.icons.AllIcons;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DropTargetHighlighter;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public class Highlighters
implements DnDEvent.DropTargetHighlightingType {
    private static final List<DropTargetHighlighter> ourHightlighters = new ArrayList<DropTargetHighlighter>();
    private static final ArrayList<DropTargetHighlighter> ourCurrentHighlighters = new ArrayList();

    static void show(int aType, JLayeredPane aPane, Rectangle aRectangle, DnDEvent aEvent) {
        ArrayList<DropTargetHighlighter> toShow = new ArrayList<DropTargetHighlighter>();
        for (DropTargetHighlighter ourHightlighter : ourHightlighters) {
            if ((ourHightlighter.getMask() & aType) == 0) continue;
            toShow.add(ourHightlighter);
        }
        for (int i = 0; i < toShow.size(); ++i) {
            DropTargetHighlighter each = (DropTargetHighlighter)toShow.get(i);
            each.show(aPane, aRectangle, aEvent);
        }
        ourCurrentHighlighters.addAll(toShow);
    }

    static void hideAllBut(int aType) {
        for (int i = 0; i < ourCurrentHighlighters.size(); ++i) {
            DropTargetHighlighter each = ourCurrentHighlighters.get(i);
            if ((each.getMask() & aType) != 0) continue;
            each.vanish();
            ourCurrentHighlighters.remove(each);
        }
    }

    static void hide() {
        for (int i = 0; i < ourCurrentHighlighters.size(); ++i) {
            ourCurrentHighlighters.get(i).vanish();
        }
        ourCurrentHighlighters.clear();
    }

    static void hide(int aType) {
        for (int i = 0; i < ourCurrentHighlighters.size(); ++i) {
            DropTargetHighlighter each = ourCurrentHighlighters.get(i);
            if ((each.getMask() & aType) == 0) continue;
            each.vanish();
            ourCurrentHighlighters.remove(each);
        }
    }

    static boolean isVisibleExcept(int type) {
        int resultType = type;
        for (DropTargetHighlighter each : ourCurrentHighlighters) {
            resultType |= each.getMask();
        }
        return type != resultType;
    }

    static boolean isVisible() {
        return ourCurrentHighlighters.size() > 0;
    }

    static {
        ourHightlighters.add(new RectangleHighlighter());
        ourHightlighters.add(new FilledRectangleHighlighter());
        ourHightlighters.add(new HorizontalLinesHighlighter());
        ourHightlighters.add(new TextHighlighter());
        ourHightlighters.add(new ErrorTextHighlighter());
        ourHightlighters.add(new VerticalLinesHighlighter());
    }

    private static class VerticalLinesHighlighter
    extends AbstractComponentHighlighter {
        private static final Icon TOP = AllIcons.General.ArrowDown;
        private static final Icon BOTTOM = AllIcons.General.ArrowUp;

        private VerticalLinesHighlighter() {
        }

        @Override
        protected void _show(JLayeredPane aPane, Rectangle aRectangle, DnDEvent aEvent) {
            Rectangle rectangle = new Rectangle(aRectangle.x, aRectangle.y - TOP.getIconHeight(), aRectangle.width, aRectangle.height + TOP.getIconHeight() + BOTTOM.getIconHeight());
            this.setBounds(rectangle);
        }

        @Override
        protected void paintComponent(Graphics g) {
            TOP.paintIcon(this, g, (this.getWidth() - TOP.getIconWidth()) / 2, 0);
            BOTTOM.paintIcon(this, g, (this.getWidth() - BOTTOM.getIconWidth()) / 2, this.getHeight() - BOTTOM.getIconHeight());
        }

        @Override
        public int getMask() {
            return 8;
        }
    }

    private static class HorizontalLinesHighlighter
    extends AbstractComponentHighlighter {
        private HorizontalLinesHighlighter() {
        }

        @Override
        protected void _show(JLayeredPane aPane, Rectangle aRectangle, DnDEvent aEvent) {
            Rectangle rectangle = new Rectangle(aRectangle.x - AllIcons.General.ArrowRight.getIconWidth(), aRectangle.y - AllIcons.General.ArrowRight.getIconHeight(), aRectangle.width + AllIcons.General.ArrowRight.getIconWidth() + AllIcons.General.ArrowLeft.getIconWidth(), aRectangle.height + AllIcons.General.ArrowRight.getIconHeight());
            this.setBounds(rectangle);
        }

        @Override
        protected void paintComponent(Graphics g) {
            AllIcons.General.ArrowRight.paintIcon(this, g, 0, this.getHeight() / 2);
            AllIcons.General.ArrowLeft.paintIcon(this, g, this.getWidth() - AllIcons.General.ArrowLeft.getIconWidth(), this.getHeight() / 2);
        }

        @Override
        public int getMask() {
            return 4;
        }
    }

    private static class RectangleHighlighter
    extends AbstractComponentHighlighter {
        RectangleHighlighter() {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createLineBorder((Color)JBColor.RED));
        }

        @Override
        protected void _show(JLayeredPane aPane, Rectangle aRectangle, DnDEvent aEvent) {
            this.setBounds(aRectangle);
        }

        @Override
        public int getMask() {
            return 1;
        }
    }

    private static class FilledRectangleHighlighter
    extends AbstractComponentHighlighter {
        FilledRectangleHighlighter() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createLineBorder((Color)JBColor.RED));
            this.setBackground((Color)JBColor.RED);
        }

        @Override
        protected void _show(JLayeredPane aPane, Rectangle aRectangle, DnDEvent aEvent) {
            this.setBounds(aRectangle);
        }

        @Override
        public int getMask() {
            return 2;
        }
    }

    private static class ErrorTextHighlighter
    extends BaseTextHighlighter {
        ErrorTextHighlighter() {
            super(MessageType.ERROR);
        }

        @Override
        public int getMask() {
            return 32;
        }
    }

    public static class TextHighlighter
    extends BaseTextHighlighter {
        public TextHighlighter() {
            super(MessageType.INFO);
        }

        @Override
        public int getMask() {
            return 16;
        }
    }

    public static abstract class BaseTextHighlighter
    implements DropTargetHighlighter {
        private Balloon myCurrentBalloon;
        private final MessageType myMessageType;

        public BaseTextHighlighter(MessageType type) {
            this.myMessageType = type;
        }

        @Override
        public void show(JLayeredPane aPane, Rectangle aRectangle, DnDEvent aEvent) {
            if (!Registry.is((String)"ide.dnd.textHints")) {
                return;
            }
            String result2 = aEvent.getExpectedDropResult();
            if (result2 != null && result2.length() > 0) {
                RelativePoint point = null;
                for (DropTargetHighlighter each : ourHightlighters) {
                    if (!(each instanceof AbstractComponentHighlighter)) continue;
                    Rectangle rec = ((AbstractComponentHighlighter)each).getBounds();
                    point = new RelativePoint((Component)aPane, new Point(rec.x + rec.width, rec.y + rec.height / 2));
                    break;
                }
                if (point == null) {
                    point = new RelativePoint((Component)aPane, new Point(aRectangle.x + aRectangle.width, aRectangle.y + aRectangle.height / 2));
                }
                this.myCurrentBalloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(result2, this.myMessageType, null).createBalloon();
                this.myCurrentBalloon.show(point, Balloon.Position.atRight);
            }
        }

        @Override
        public void vanish() {
            if (this.myCurrentBalloon != null) {
                this.myCurrentBalloon.hide();
                this.myCurrentBalloon = null;
            }
        }

        protected Integer getLayer() {
            return JLayeredPane.POPUP_LAYER;
        }
    }

    private static abstract class AbstractComponentHighlighter
    extends JPanel
    implements DropTargetHighlighter {
        protected AbstractComponentHighlighter() {
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
        }

        @Override
        public final void show(JLayeredPane aPane, Rectangle aRectangle, DnDEvent aEvent) {
            if (this.getParent() != aPane) {
                this.vanish();
                aPane.add((Component)this, this.getLayer());
            }
            this._show(aPane, aRectangle, aEvent);
        }

        protected Integer getLayer() {
            return JLayeredPane.MODAL_LAYER;
        }

        @Override
        public void vanish() {
            Container parent = this.getParent();
            Rectangle bounds2 = this.getBounds();
            if (parent != null) {
                parent.remove(this);
                parent.repaint(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
            }
        }

        protected abstract void _show(JLayeredPane var1, Rectangle var2, DnDEvent var3);
    }
}

