/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.extensionResources;

import com.intellij.ide.extensionResources.ResourceVersions;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DigestUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExtensionsRootType
extends RootType {
    static final Logger LOG = Logger.getInstance(ExtensionsRootType.class);
    private static final String EXTENSIONS_PATH = "extensions";
    private static final String BACKUP_FILE_EXTENSION = "old";

    ExtensionsRootType() {
        super(EXTENSIONS_PATH, "Extensions");
    }

    @NotNull
    public static ExtensionsRootType getInstance() {
        ExtensionsRootType extensionsRootType = (ExtensionsRootType)ExtensionsRootType.findByClass(ExtensionsRootType.class);
        if (extensionsRootType == null) {
            ExtensionsRootType.$$$reportNull$$$0(0);
        }
        return extensionsRootType;
    }

    @NotNull
    public static Condition<File> regularFileFilter() {
        return new Condition<File>(){
            private final ExtensionsRootType myRootType = ExtensionsRootType.getInstance();

            public boolean value(File file2) {
                if (file2.isDirectory() || file2.isHidden()) {
                    return false;
                }
                String name = file2.getName();
                String extension = FileUtilRt.getExtension((String)name);
                return !extension.isEmpty() && !FileUtilRt.extensionEquals((String)name, (String)"txt") && !FileUtilRt.extensionEquals((String)name, (String)"properties") && !extension.startsWith(ExtensionsRootType.BACKUP_FILE_EXTENSION) && !this.myRootType.isResourceFile(file2);
            }
        };
    }

    @Nullable
    public PluginId getOwner(@Nullable VirtualFile resource) {
        VirtualFile file2 = this.getPluginResourcesDirectoryFor(resource);
        return file2 != null ? PluginId.findId((String[])new String[]{file2.getName()}) : null;
    }

    @Nullable
    public File findResource(@NotNull PluginId pluginId, @NotNull String path) throws IOException {
        if (pluginId == null) {
            ExtensionsRootType.$$$reportNull$$$0(1);
        }
        if (path == null) {
            ExtensionsRootType.$$$reportNull$$$0(2);
        }
        this.extractBundledExtensionsIfNeeded(pluginId);
        return this.findExtensionImpl(pluginId, path);
    }

    @Nullable
    public File findResourceDirectory(@NotNull PluginId pluginId, @NotNull String path, boolean createIfMissing) throws IOException {
        if (pluginId == null) {
            ExtensionsRootType.$$$reportNull$$$0(3);
        }
        if (path == null) {
            ExtensionsRootType.$$$reportNull$$$0(4);
        }
        this.extractBundledExtensionsIfNeeded(pluginId);
        return this.findExtensionsDirectoryImpl(pluginId, path, createIfMissing);
    }

    public void extractBundledResources(@NotNull PluginId pluginId, @NotNull String path) throws IOException {
        List<URL> bundledResources;
        if (pluginId == null) {
            ExtensionsRootType.$$$reportNull$$$0(5);
        }
        if (path == null) {
            ExtensionsRootType.$$$reportNull$$$0(6);
        }
        if ((bundledResources = ExtensionsRootType.getBundledResourceUrls(pluginId, path)).isEmpty()) {
            return;
        }
        File resourcesDirectory = this.findExtensionsDirectoryImpl(pluginId, path, true);
        if (resourcesDirectory == null) {
            return;
        }
        for (URL bundledResourceDirUrl : bundledResources) {
            VirtualFile bundledResourcesDir = VfsUtil.findFileByURL((URL)bundledResourceDirUrl);
            if (bundledResourcesDir == null || !bundledResourcesDir.isDirectory()) continue;
            ExtensionsRootType.extractResources(bundledResourcesDir, resourcesDirectory);
        }
    }

    @Nullable
    public String substituteName(@NotNull Project project, @NotNull VirtualFile file2) {
        String name;
        VirtualFile resourcesDir;
        if (project == null) {
            ExtensionsRootType.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            ExtensionsRootType.$$$reportNull$$$0(8);
        }
        if (file2.equals(resourcesDir = this.getPluginResourcesDirectoryFor(file2)) && (name = this.getPluginResourcesRootName(resourcesDir)) != null) {
            return name;
        }
        return super.substituteName(project, file2);
    }

    public boolean isResourceFile(@NotNull File file2) {
        if (file2 == null) {
            ExtensionsRootType.$$$reportNull$$$0(9);
        }
        return false;
    }

    @Nullable
    String getPath(@Nullable VirtualFile resource) {
        VirtualFile pluginResourcesDir = this.getPluginResourcesDirectoryFor(resource);
        PluginId pluginId = this.getOwner(pluginResourcesDir);
        return pluginResourcesDir != null && pluginId != null ? VfsUtilCore.getRelativePath((VirtualFile)resource, (VirtualFile)pluginResourcesDir) : null;
    }

    @Nullable
    private File findExtensionImpl(@NotNull PluginId pluginId, @NotNull String path) throws IOException {
        File dir;
        if (pluginId == null) {
            ExtensionsRootType.$$$reportNull$$$0(10);
        }
        if (path == null) {
            ExtensionsRootType.$$$reportNull$$$0(11);
        }
        File file2 = (dir = this.findExtensionsDirectoryImpl(pluginId, "", false)) == null ? null : new File(dir, path);
        return file2 != null && file2.exists() && file2.isFile() ? file2 : null;
    }

    @Nullable
    private File findExtensionsDirectoryImpl(@NotNull PluginId pluginId, @NotNull String path, boolean createIfMissing) throws IOException {
        if (pluginId == null) {
            ExtensionsRootType.$$$reportNull$$$0(12);
        }
        if (path == null) {
            ExtensionsRootType.$$$reportNull$$$0(13);
        }
        String fullPath = this.getPath(pluginId, path);
        File dir = new File(FileUtil.toSystemDependentName((String)fullPath));
        if (createIfMissing && !dir.exists() && !dir.mkdirs()) {
            throw new IOException("Failed to create directory: " + dir.getPath());
        }
        if (!dir.exists()) {
            return null;
        }
        if (!dir.isDirectory()) {
            throw new IOException("Not a directory: " + dir.getPath());
        }
        return dir;
    }

    @Nullable
    private String getPluginResourcesRootName(VirtualFile resourcesDir) {
        PluginId ownerPluginId = this.getOwner(resourcesDir);
        if (ownerPluginId == null) {
            return null;
        }
        if (PluginManagerCore.CORE_ID == ownerPluginId) {
            return PlatformUtils.getPlatformPrefix();
        }
        IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin(ownerPluginId);
        if (plugin != null) {
            return plugin.getName();
        }
        return null;
    }

    @Contract(value="null->null")
    private VirtualFile getPluginResourcesDirectoryFor(@Nullable VirtualFile resource) {
        if (resource == null) {
            return null;
        }
        String rootPath = ScratchFileService.getInstance().getRootPath((RootType)this);
        VirtualFile root = LocalFileSystem.getInstance().findFileByPath(rootPath);
        if (root == null) {
            return null;
        }
        VirtualFile parent = resource;
        VirtualFile file2 = resource;
        while (parent != null && !root.equals(parent)) {
            file2 = parent;
            parent = file2.getParent();
        }
        return parent != null && file2.isDirectory() ? file2 : null;
    }

    @NotNull
    private String getPath(@NotNull PluginId pluginId, @NotNull String path) {
        if (pluginId == null) {
            ExtensionsRootType.$$$reportNull$$$0(14);
        }
        if (path == null) {
            ExtensionsRootType.$$$reportNull$$$0(15);
        }
        String string = ScratchFileService.getInstance().getRootPath((RootType)this) + "/" + pluginId.getIdString() + (StringUtil.isEmpty((String)path) ? "" : "/" + path);
        if (string == null) {
            ExtensionsRootType.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static List<URL> getBundledResourceUrls(@NotNull PluginId pluginId, @NotNull String path) throws IOException {
        if (pluginId == null) {
            ExtensionsRootType.$$$reportNull$$$0(17);
        }
        if (path == null) {
            ExtensionsRootType.$$$reportNull$$$0(18);
        }
        String resourcesPath = "extensions/" + path;
        IdeaPluginDescriptorImpl plugin = null;
        for (IdeaPluginDescriptorImpl descriptor2 : PluginManagerCore.getLoadedPlugins(null)) {
            if (descriptor2.getPluginId() != pluginId) continue;
            plugin = descriptor2;
            break;
        }
        if (plugin == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                ExtensionsRootType.$$$reportNull$$$0(19);
            }
            return list2;
        }
        ClassLoader pluginClassLoader = plugin.getPluginClassLoader();
        Enumeration<URL> resources = pluginClassLoader.getResources(resourcesPath);
        if (resources == null) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                ExtensionsRootType.$$$reportNull$$$0(20);
            }
            return list3;
        }
        if (plugin.getUseIdeaClassLoader()) {
            List list4 = ContainerUtil.toList(resources);
            if (list4 == null) {
                ExtensionsRootType.$$$reportNull$$$0(21);
            }
            return list4;
        }
        LinkedHashSet urls = new LinkedHashSet(ContainerUtil.toList(resources));
        List dependentPluginClassLoaders = (List)StreamEx.of((Object[])plugin.getDependentPluginIds()).map(id2 -> PluginManagerCore.getPlugin(id2)).nonNull().map(PluginDescriptor::getPluginClassLoader).without((Object)pluginClassLoader).collect(Collectors.toList());
        for (ClassLoader classLoader : dependentPluginClassLoaders) {
            urls.removeAll(ContainerUtil.toList(classLoader.getResources(resourcesPath)));
        }
        return new ArrayList<URL>(urls);
    }

    private static void extractResources(final @NotNull VirtualFile from, final @NotNull File to) throws IOException {
        if (from == null) {
            ExtensionsRootType.$$$reportNull$$$0(22);
        }
        if (to == null) {
            ExtensionsRootType.$$$reportNull$$$0(23);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)from, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS}){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file2) {
                VirtualFileVisitor.Result result2;
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                try {
                    result2 = this.visitImpl(file2);
                }
                catch (IOException e) {
                    throw new VirtualFileVisitor.VisitorException((Throwable)e);
                }
                if (result2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return result2;
            }

            VirtualFileVisitor.Result visitImpl(@NotNull VirtualFile file2) throws IOException {
                File dir;
                File child2;
                if (file2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                if ((child2 = new File(to, FileUtil.toSystemDependentName((String)Objects.requireNonNull(VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)from))))).exists() && child2.isDirectory() != file2.isDirectory()) {
                    ExtensionsRootType.renameToBackupCopy(child2);
                }
                File file3 = dir = file2.isDirectory() ? child2 : child2.getParentFile();
                if (!dir.exists() && !dir.mkdirs()) {
                    LOG.warn("Failed to create dir: " + dir.getPath());
                    return SKIP_CHILDREN;
                }
                if (file2.isDirectory()) {
                    return CONTINUE;
                }
                if (file2.getFileType().isBinary()) {
                    return CONTINUE;
                }
                if (file2.getLength() > (long)FileUtilRt.LARGE_FOR_CONTENT_LOADING) {
                    return CONTINUE;
                }
                String newText = FileUtil.loadTextAndClose((InputStream)file2.getInputStream());
                String oldText = child2.exists() ? FileUtil.loadFile((File)child2) : "";
                String newHash = ExtensionsRootType.hash(newText);
                String oldHash = ExtensionsRootType.hash(oldText);
                boolean upToDate = StringUtil.equals((CharSequence)oldHash, (CharSequence)newHash);
                if (upToDate) {
                    return CONTINUE;
                }
                if (child2.exists()) {
                    ExtensionsRootType.renameToBackupCopy(child2);
                }
                FileUtil.writeToFile((File)child2, (String)newText);
                return CONTINUE;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/extensionResources/ExtensionsRootType$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/extensionResources/ExtensionsRootType$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "visitImpl";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, IOException.class);
    }

    @NotNull
    private static String hash(@NotNull String s) {
        byte[] digest;
        if (s == null) {
            ExtensionsRootType.$$$reportNull$$$0(24);
        }
        MessageDigest md5 = DigestUtil.md5();
        StringBuilder sb = new StringBuilder();
        for (byte b : digest = md5.digest(s.getBytes(StandardCharsets.UTF_8))) {
            sb.append(Integer.toHexString(b));
        }
        String string = sb.toString();
        if (string == null) {
            ExtensionsRootType.$$$reportNull$$$0(25);
        }
        return string;
    }

    private static void renameToBackupCopy(@NotNull File file2) throws IOException {
        if (file2 == null) {
            ExtensionsRootType.$$$reportNull$$$0(26);
        }
        File parent = file2.getParentFile();
        int i = 0;
        String newName = file2.getName() + "." + BACKUP_FILE_EXTENSION;
        while (new File(parent, newName).exists()) {
            newName = file2.getName() + "." + BACKUP_FILE_EXTENSION + "_" + i;
            ++i;
        }
        FileUtil.rename((File)file2, (String)newName);
    }

    private void extractBundledExtensionsIfNeeded(@NotNull PluginId pluginId) throws IOException {
        if (pluginId == null) {
            ExtensionsRootType.$$$reportNull$$$0(27);
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return;
        }
        IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin(pluginId);
        if (plugin == null || !ResourceVersions.getInstance().shouldUpdateResourcesOf(plugin)) {
            return;
        }
        this.extractBundledResources(pluginId, "");
        ResourceVersions.getInstance().resourcesUpdated(plugin);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/extensionResources/ExtensionsRootType";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 9: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/extensionResources/ExtensionsRootType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledResourceUrls";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "hash";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findResource";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findResourceDirectory";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extractBundledResources";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "substituteName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isResourceFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findExtensionImpl";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findExtensionsDirectoryImpl";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getBundledResourceUrls";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "extractResources";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "hash";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "renameToBackupCopy";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "extractBundledExtensionsIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

