/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.project;

import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.lightEdit.project.LightEditDirectoryIndex;
import com.intellij.ide.lightEdit.project.LightEditDumbService;
import com.intellij.ide.lightEdit.project.LightEditFileEditorManagerImpl;
import com.intellij.ide.lightEdit.project.LightEditFileIndexFacade;
import com.intellij.ide.lightEdit.project.LightEditProjectFileIndex;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.ProjectLoadHelper;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LightEditProjectImpl
extends ProjectImpl
implements LightEditCompatible {
    private static final Logger LOG = Logger.getInstance(LightEditProjectImpl.class);
    private static final String NAME = "LightEditProject";

    LightEditProjectImpl() {
        this(LightEditProjectImpl.getProjectPath());
    }

    private LightEditProjectImpl(@NotNull Path projectPath) {
        if (projectPath == null) {
            LightEditProjectImpl.$$$reportNull$$$0(0);
        }
        super(projectPath, NAME);
        ProjectLoadHelper.registerComponents(this);
        this.customizeRegisteredComponents();
        this.getStateStore().setPath(projectPath, false, null);
        this.init(null);
    }

    private void customizeRegisteredComponents() {
        IdeaPluginDescriptor pluginDescriptor = PluginManagerCore.getPlugin(PluginManagerCore.CORE_ID);
        if (pluginDescriptor == null) {
            LOG.error("Could not find plugin by id: " + PluginManagerCore.CORE_ID);
            return;
        }
        this.registerService(DirectoryIndex.class, LightEditDirectoryIndex.class, (PluginDescriptor)pluginDescriptor, true);
        this.registerService(ProjectFileIndex.class, LightEditProjectFileIndex.class, (PluginDescriptor)pluginDescriptor, true);
        this.registerService(FileIndexFacade.class, LightEditFileIndexFacade.class, (PluginDescriptor)pluginDescriptor, true);
        this.registerService(DumbService.class, LightEditDumbService.class, (PluginDescriptor)pluginDescriptor, true);
        this.registerComponent(FileEditorManager.class, LightEditFileEditorManagerImpl.class, (PluginDescriptor)pluginDescriptor, true);
    }

    @NotNull
    private static Path getProjectPath() {
        Path path = Paths.get(PathManager.getConfigPath() + File.separator + "light-edit", new String[0]);
        if (path == null) {
            LightEditProjectImpl.$$$reportNull$$$0(1);
        }
        return path;
    }

    @Override
    public void init(@Nullable ProgressIndicator indicator) {
        this.createComponents(null);
    }

    @Override
    public void setProjectName(@NotNull String name) {
        if (name == null) {
            LightEditProjectImpl.$$$reportNull$$$0(2);
        }
        throw new IllegalStateException();
    }

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public String getLocationHash() {
        String string = this.getName();
        if (string == null) {
            LightEditProjectImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/lightEdit/project/LightEditProjectImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/lightEdit/project/LightEditProjectImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationHash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setProjectName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

