/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PendingDynamicPluginInstall;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginReplacement;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginInstallOperation {
    private static final Logger LOG = Logger.getInstance(PluginInstallOperation.class);
    private final List<PluginNode> myPluginsToInstall;
    private final List<? extends IdeaPluginDescriptor> myAllPlugins;
    private final PluginManagerMain.PluginEnabler myPluginEnabler;
    private final ProgressIndicator myIndicator;
    private boolean mySuccess;
    private final Set<PluginNode> myDependant;
    private boolean myAllowInstallWithoutRestart;
    private final List<PendingDynamicPluginInstall> myPendingDynamicPluginInstalls;
    private boolean myRestartRequired;
    private boolean myShownErrors;

    public PluginInstallOperation(@NotNull List<PluginNode> pluginsToInstall, List<? extends IdeaPluginDescriptor> allPlugins, PluginManagerMain.PluginEnabler pluginEnabler, @NotNull ProgressIndicator indicator) {
        if (pluginsToInstall == null) {
            PluginInstallOperation.$$$reportNull$$$0(0);
        }
        if (indicator == null) {
            PluginInstallOperation.$$$reportNull$$$0(1);
        }
        this.mySuccess = true;
        this.myDependant = new HashSet<PluginNode>();
        this.myAllowInstallWithoutRestart = false;
        this.myPendingDynamicPluginInstalls = new ArrayList<PendingDynamicPluginInstall>();
        this.myRestartRequired = false;
        this.myPluginsToInstall = pluginsToInstall;
        this.myAllPlugins = allPlugins;
        this.myPluginEnabler = pluginEnabler;
        this.myIndicator = indicator;
    }

    public void setAllowInstallWithoutRestart(boolean allowInstallWithoutRestart) {
        this.myAllowInstallWithoutRestart = allowInstallWithoutRestart;
    }

    public List<PendingDynamicPluginInstall> getPendingDynamicPluginInstalls() {
        return this.myPendingDynamicPluginInstalls;
    }

    public boolean isRestartRequired() {
        return this.myRestartRequired;
    }

    public void run() {
        this.updateUrls();
        this.mySuccess = this.prepareToInstall(this.myPluginsToInstall);
    }

    public boolean isSuccess() {
        return this.mySuccess;
    }

    public Set<PluginNode> getInstalledDependentPlugins() {
        return this.myDependant;
    }

    public boolean isShownErrors() {
        return this.myShownErrors;
    }

    private void updateUrls() {
        boolean unknownNodes = false;
        for (PluginNode node : this.myPluginsToInstall) {
            if (node.getRepositoryName() != "__unknown_repository__") continue;
            unknownNodes = true;
            break;
        }
        if (!unknownNodes) {
            return;
        }
        SmartList hosts = new SmartList();
        ContainerUtil.addIfNotNull((Collection)hosts, (Object)ApplicationInfoEx.getInstanceEx().getBuiltinPluginsUrl());
        hosts.addAll(UpdateSettings.getInstance().getPluginHosts());
        HashMap<PluginId, IdeaPluginDescriptor> allPlugins = new HashMap<PluginId, IdeaPluginDescriptor>();
        for (String host : hosts) {
            try {
                List<IdeaPluginDescriptor> descriptors = RepositoryHelper.loadPlugins(host, this.myIndicator);
                for (IdeaPluginDescriptor descriptor2 : descriptors) {
                    allPlugins.put(descriptor2.getPluginId(), descriptor2);
                }
            }
            catch (IOException descriptors) {
            }
        }
        for (PluginNode node : this.myPluginsToInstall) {
            if (node.getRepositoryName() != "__unknown_repository__") continue;
            IdeaPluginDescriptor descriptor3 = (IdeaPluginDescriptor)allPlugins.get(node.getPluginId());
            if (descriptor3 != null) {
                node.setRepositoryName(((PluginNode)descriptor3).getRepositoryName());
                node.setDownloadUrl(((PluginNode)descriptor3).getDownloadUrl());
                continue;
            }
            node.setRepositoryName(null);
        }
    }

    private boolean prepareToInstall(List<PluginNode> pluginsToInstall) {
        SmartList pluginIds = new SmartList();
        for (PluginNode pluginNode : pluginsToInstall) {
            pluginIds.add(pluginNode.getPluginId());
        }
        boolean result2 = false;
        for (PluginNode pluginNode : pluginsToInstall) {
            this.myIndicator.setText(pluginNode.getName());
            try {
                result2 |= this.prepareToInstall(pluginNode, (List<PluginId>)pluginIds);
            }
            catch (IOException e) {
                String title = IdeBundle.message((String)"title.plugin.error", (Object[])new Object[0]);
                Notifications.Bus.notify((Notification)new Notification(title, title, pluginNode.getName() + ": " + e.getMessage(), NotificationType.ERROR));
                return false;
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareToInstall(PluginNode pluginNode, List<PluginId> pluginIds) throws IOException {
        this.myDependant.add(pluginNode);
        if (pluginNode.getDepends() != null && !pluginNode.getDepends().isEmpty()) {
            Object[] optionalDependentPluginIds = pluginNode.getOptionalDependentPluginIds();
            ArrayList<PluginNode> depends = new ArrayList<PluginNode>();
            ArrayList<PluginNode> optionalDeps = new ArrayList<PluginNode>();
            for (int i = 0; i < pluginNode.getDepends().size(); ++i) {
                PluginId depPluginId = pluginNode.getDepends().get(i);
                if (PluginManagerCore.isPluginInstalled(depPluginId) || PluginManagerCore.isModuleDependency(depPluginId) || InstalledPluginsState.getInstance().wasInstalled(depPluginId) || InstalledPluginsState.getInstance().wasInstalledWithoutRestart(depPluginId) || pluginIds != null && pluginIds.contains(depPluginId)) continue;
                IdeaPluginDescriptor depPluginDescriptor = this.findPluginInRepo(depPluginId);
                PluginNode depPlugin = depPluginDescriptor instanceof PluginNode ? (PluginNode)depPluginDescriptor : new PluginNode(depPluginId, depPluginId.getIdString(), "-1");
                if (depPluginDescriptor == null) continue;
                if (ArrayUtil.indexOf((Object[])optionalDependentPluginIds, (Object)depPluginId) != -1) {
                    optionalDeps.add(depPlugin);
                    continue;
                }
                depends.add(depPlugin);
            }
            if (!depends.isEmpty()) {
                boolean[] proceed = new boolean[1];
                try {
                    ApplicationManager.getApplication().invokeAndWait(() -> {
                        String title = IdeBundle.message((String)"plugin.manager.dependencies.detected.title", (Object[])new Object[0]);
                        String deps = PluginInstallOperation.getPluginsText(depends);
                        String message = IdeBundle.message((String)"plugin.manager.dependencies.detected.message", (Object[])new Object[]{pluginNode.getName(), deps});
                        proceed[0] = Messages.showYesNoDialog((String)message, (String)title, (String)IdeBundle.message((String)"button.install", (Object[])new Object[0]), (String)Messages.getNoButton(), (Icon)Messages.getWarningIcon()) == 0;
                    }, ModalityState.any());
                }
                catch (Exception e) {
                    return false;
                }
                if (!proceed[0] || !this.prepareToInstall(depends)) {
                    return false;
                }
            }
            if (!optionalDeps.isEmpty()) {
                boolean[] proceed = new boolean[1];
                try {
                    ApplicationManager.getApplication().invokeAndWait(() -> {
                        String title = IdeBundle.message((String)"plugin.manager.optional.dependencies.detected.title", (Object[])new Object[0]);
                        String deps = PluginInstallOperation.getPluginsText(optionalDeps);
                        String message = IdeBundle.message((String)"plugin.manager.optional.dependencies.detected.message", (Object[])new Object[]{pluginNode.getName(), deps});
                        proceed[0] = Messages.showYesNoDialog((String)message, (String)title, (String)IdeBundle.message((String)"button.install", (Object[])new Object[0]), (String)Messages.getNoButton(), (Icon)Messages.getWarningIcon()) == 0;
                    }, ModalityState.any());
                }
                catch (Exception e) {
                    return false;
                }
                if (proceed[0] && !this.prepareToInstall(optionalDeps)) {
                    return false;
                }
            }
        }
        Ref toDisable = Ref.create(null);
        PluginReplacement pluginReplacement = (PluginReplacement)ContainerUtil.find((Object[])PluginReplacement.EP_NAME.getExtensions(), r -> r.getNewPluginId().equals(pluginNode.getPluginId().getIdString()));
        if (pluginReplacement != null) {
            IdeaPluginDescriptor oldPlugin = PluginManagerCore.getPlugin(pluginReplacement.getOldPluginDescriptor().getPluginId());
            if (oldPlugin == null) {
                LOG.warn("Plugin with id '" + pluginReplacement.getOldPluginDescriptor().getPluginId() + "' not found");
            } else if (!this.myPluginEnabler.isDisabled(oldPlugin.getPluginId())) {
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    String title = IdeBundle.message((String)"plugin.manager.obsolete.plugins.detected.title", (Object[])new Object[0]);
                    String message = pluginReplacement.getReplacementMessage(oldPlugin, (IdeaPluginDescriptor)pluginNode);
                    if (Messages.showYesNoDialog((String)message, (String)title, (String)IdeBundle.message((String)"button.disable", (Object[])new Object[0]), (String)Messages.getNoButton(), (Icon)Messages.getWarningIcon()) == 0) {
                        toDisable.set((Object)oldPlugin);
                    }
                }, ModalityState.any());
            }
        }
        this.myShownErrors = false;
        PluginDownloader downloader = PluginDownloader.createDownloader(pluginNode, pluginNode.getRepositoryName(), null);
        IdeaPluginDescriptorImpl descriptor2 = downloader.prepareToInstallAndLoadDescriptor(this.myIndicator);
        if (descriptor2 != null) {
            if (this.myAllowInstallWithoutRestart && DynamicPlugins.allowLoadUnloadWithoutRestart(descriptor2)) {
                this.myPendingDynamicPluginInstalls.add(new PendingDynamicPluginInstall(downloader.getFile(), descriptor2));
                InstalledPluginsState state = InstalledPluginsState.getInstanceIfLoaded();
                if (state != null) {
                    state.onPluginInstall(downloader.getDescriptor(), false, false);
                }
            } else {
                this.myRestartRequired = true;
                Object object = PluginInstaller.ourLock;
                synchronized (object) {
                    downloader.install();
                }
            }
            pluginNode.setStatus(PluginNode.Status.DOWNLOADED);
            if (!toDisable.isNull()) {
                this.myPluginEnabler.disablePlugins(Collections.singleton(toDisable.get()));
            }
        } else {
            this.myShownErrors = downloader.isShownErrors();
            return false;
        }
        return true;
    }

    @NotNull
    private static String getPluginsText(@NotNull List<PluginNode> pluginNodes) {
        int size;
        if (pluginNodes == null) {
            PluginInstallOperation.$$$reportNull$$$0(2);
        }
        if ((size = pluginNodes.size()) == 1) {
            String string = "\"" + pluginNodes.get(0).getName() + "\" plugin";
            if (string == null) {
                PluginInstallOperation.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = StringUtil.join(pluginNodes.subList(0, size - 1), node -> "\"" + node.getName() + "\"", (String)", ") + " and \"" + pluginNodes.get(size - 1) + "\" plugins";
        if (string == null) {
            PluginInstallOperation.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private IdeaPluginDescriptor findPluginInRepo(PluginId depPluginId) {
        return ((Stream)this.myAllPlugins.stream().parallel()).filter(p -> p.getPluginId().equals(depPluginId)).findAny().orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsToInstall";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginNodes";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginInstallOperation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginInstallOperation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPluginsText";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

