/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.search.ConfigurableHit;
import com.intellij.ide.ui.search.IndexedCharsInterner;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.PorterStemmerUtil;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionIndexLoader;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CollectConsumer;
import com.intellij.util.ResourceUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.ByteArrayCharSequence;
import com.intellij.util.text.CharSequenceHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import javax.swing.event.DocumentEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchableOptionsRegistrarImpl
extends SearchableOptionsRegistrar {
    private final Map<CharSequence, long[]> myStorage = new THashMap(20, 0.9f, (TObjectHashingStrategy)CharSequenceHashingStrategy.CASE_SENSITIVE);
    private final Set<String> myStopWords = Collections.synchronizedSet(new THashSet());
    @NotNull
    private volatile Map<Couple<String>, Set<String>> myHighlightOptionToSynonym = Collections.emptyMap();
    private volatile boolean allTheseHugeFilesAreLoaded;
    private final IndexedCharsInterner myIdentifierTable = new IndexedCharsInterner(){

        @Override
        public synchronized int toId(@NotNull String name) {
            if (name == null) {
                1.$$$reportNull$$$0(0);
            }
            return super.toId(name);
        }

        @Override
        @NotNull
        public synchronized CharSequence fromId(int id2) {
            CharSequence charSequence = super.fromId(id2);
            if (charSequence == null) {
                1.$$$reportNull$$$0(1);
            }
            return charSequence;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "toId";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final Logger LOG = Logger.getInstance(SearchableOptionsRegistrarImpl.class);
    @NonNls
    private static final Pattern REG_EXP = Pattern.compile("[\\W&&[^-]]+");

    public SearchableOptionsRegistrarImpl() {
        if (ApplicationManager.getApplication().isCommandLine() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        try {
            InputStream stream = ResourceUtil.getResourceAsStream(SearchableOptionsRegistrarImpl.class, (String)"/search/", (String)"ignore.txt");
            if (stream == null) {
                throw new IOException("Broken installation: IDE does not provide /search/ignore.txt");
            }
            String text2 = ResourceUtil.loadText((InputStream)stream);
            Object[] stopWords = text2.split("[\\W]");
            ContainerUtil.addAll(this.myStopWords, (Object[])stopWords);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void loadHugeFilesIfNecessary() {
        if (this.allTheseHugeFilesAreLoaded) {
            return;
        }
        this.allTheseHugeFilesAreLoaded = true;
        try {
            Set<URL> searchableOptions = SearchableOptionsRegistrarImpl.findSearchableOptions();
            if (searchableOptions.isEmpty()) {
                LOG.info("No /search/searchableOptions.xml found, settings search won't work!");
                return;
            }
            SearchableOptionIndexLoader loader = new SearchableOptionIndexLoader(this, this.myStorage);
            loader.load(searchableOptions);
            this.myHighlightOptionToSynonym = loader.getHighlightOptionToSynonym();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private static Set<URL> findSearchableOptions() throws IOException, URISyntaxException {
        HashSet<URL> urls = new HashSet<URL>();
        HashSet<ClassLoader> visited = new HashSet<ClassLoader>();
        for (IdeaPluginDescriptor plugin : PluginManagerCore.getPlugins()) {
            ClassLoader classLoader;
            if (!plugin.isEnabled() || !visited.add(classLoader = plugin.getPluginClassLoader())) continue;
            Enumeration<URL> resources = classLoader.getResources("search");
            while (resources.hasMoreElements()) {
                File[] files2;
                URL url = resources.nextElement();
                if ("jar".equals(url.getProtocol())) {
                    Pair parts = Objects.requireNonNull(URLUtil.splitJarUrl((String)url.getFile()));
                    File file2 = new File((String)parts.first);
                    JarFile jar = new JarFile(file2);
                    Throwable throwable = null;
                    try {
                        Enumeration<JarEntry> entries = jar.entries();
                        while (entries.hasMoreElements()) {
                            String name2 = entries.nextElement().getName();
                            if (!name2.startsWith("search/") || !name2.endsWith("searchableOptions.xml") || StringUtil.countChars((CharSequence)name2, (char)'/') != 1) continue;
                            urls.add(URLUtil.getJarEntryURL((File)file2, (String)name2));
                        }
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (jar == null) continue;
                        if (throwable != null) {
                            try {
                                jar.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        jar.close();
                        continue;
                    }
                }
                File file3 = new File(url.toURI());
                if (!file3.isDirectory() || (files2 = file3.listFiles((dir, name) -> name.endsWith("searchableOptions.xml"))) == null) continue;
                for (File xml : files2) {
                    if (!xml.isFile()) continue;
                    urls.add(xml.toURI().toURL());
                }
            }
        }
        HashSet<URL> hashSet = urls;
        if (hashSet == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    private long pack(@NotNull String id2, @Nullable String hit, @Nullable String path, @Nullable String groupName) {
        long _groupName;
        if (id2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(1);
        }
        long _id = this.myIdentifierTable.toId(id2.trim());
        long _hit = hit == null ? 32767L : (long)this.myIdentifierTable.toId(hit.trim());
        long _path = path == null ? 32767L : (long)this.myIdentifierTable.toId(path.trim());
        long l = _groupName = groupName == null ? 32767L : (long)this.myIdentifierTable.toId(groupName.trim());
        assert (_id >= 0L && _id < 32767L);
        assert (_hit >= 0L && _hit <= 32767L);
        assert (_path >= 0L && _path <= 32767L);
        assert (_groupName >= 0L && _groupName <= 32767L);
        return _groupName << 48 | _id << 32 | _hit << 16 | _path;
    }

    private OptionDescription unpack(long data2) {
        int _groupName = (int)(data2 >> 48 & 0xFFFFL);
        int _id = (int)(data2 >> 32 & 0xFFFFL);
        int _hit = (int)(data2 >> 16 & 0xFFFFL);
        int _path = (int)(data2 & 0xFFFFL);
        assert (_id < Short.MAX_VALUE);
        assert (_hit <= Short.MAX_VALUE);
        assert (_path <= Short.MAX_VALUE);
        assert (_groupName <= Short.MAX_VALUE);
        String groupName = _groupName == Short.MAX_VALUE ? null : this.myIdentifierTable.fromId(_groupName).toString();
        String configurableId = this.myIdentifierTable.fromId(_id).toString();
        String hit = _hit == Short.MAX_VALUE ? null : this.myIdentifierTable.fromId(_hit).toString();
        String path = _path == Short.MAX_VALUE ? null : this.myIdentifierTable.fromId(_path).toString();
        return new OptionDescription(null, configurableId, hit, path, groupName);
    }

    static void putOptionWithHelpId(@NotNull String option2, @NotNull String id2, @Nullable String groupName, @Nullable String hit, @Nullable String path, @NotNull Map<CharSequence, long[]> storage, @NotNull SearchableOptionsRegistrarImpl registrar) {
        if (option2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(2);
        }
        if (id2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(3);
        }
        if (storage == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(4);
        }
        if (registrar == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(5);
        }
        if (registrar.isStopWord(option2)) {
            return;
        }
        String stopWord = PorterStemmerUtil.stem(option2);
        if (stopWord == null) {
            return;
        }
        if (registrar.isStopWord(stopWord)) {
            return;
        }
        long[] configs = storage.get(option2);
        long packed = registrar.pack(id2, hit, path, groupName);
        if (configs == null) {
            configs = new long[]{packed};
        } else if (ArrayUtil.indexOf((long[])configs, (long)packed) == -1) {
            configs = ArrayUtil.append((long[])configs, (long)packed);
        }
        storage.put(ByteArrayCharSequence.convertToBytesIfPossible((CharSequence)option2), configs);
    }

    @NotNull
    public ConfigurableHit getConfigurables(@NotNull List<? extends ConfigurableGroup> groups, DocumentEvent.EventType type, @Nullable Set<? extends Configurable> configurables, @NotNull String option2, @Nullable Project project) {
        if (groups == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(6);
        }
        if (option2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(7);
        }
        return this.findConfigurables(groups, type, configurables, option2, project);
    }

    @NotNull
    private ConfigurableHit findConfigurables(@NotNull List<? extends ConfigurableGroup> groups, DocumentEvent.EventType type, @Nullable Collection<Configurable> configurables, @NotNull String option2, @Nullable Project project) {
        THashSet currentConfigurables;
        Collection<Configurable> effectiveConfigurables;
        if (groups == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(8);
        }
        if (option2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(9);
        }
        if (ContainerUtil.isEmpty(configurables)) {
            configurables = null;
        }
        if (configurables == null) {
            effectiveConfigurables = new LinkedHashSet<Configurable>();
            CollectConsumer consumer = new CollectConsumer(effectiveConfigurables);
            for (ConfigurableGroup configurableGroup : groups) {
                SearchUtil.processExpandedGroups(configurableGroup, (Consumer<? super Configurable>)consumer);
            }
        } else {
            effectiveConfigurables = configurables;
        }
        String optionToCheck = StringUtil.toLowerCase((String)option2.trim());
        Set<String> options = this.getProcessedWordsWithoutStemming(optionToCheck);
        LinkedHashSet<Configurable> linkedHashSet = new LinkedHashSet<Configurable>();
        LinkedHashSet<Configurable> nameFullHits = new LinkedHashSet<Configurable>();
        for (Configurable each : effectiveConfigurables) {
            if (each.getDisplayName() == null) continue;
            String displayName = StringUtil.toLowerCase((String)each.getDisplayName());
            List allWords = StringUtil.getWordsIn((String)displayName);
            if (displayName.contains(optionToCheck)) {
                nameFullHits.add(each);
                linkedHashSet.add(each);
            }
            Iterator iterator2 = allWords.iterator();
            while (iterator2.hasNext()) {
                String eachWord = (String)iterator2.next();
                if (!eachWord.startsWith(optionToCheck)) continue;
                linkedHashSet.add(each);
                break;
            }
            if (!options.isEmpty()) continue;
            linkedHashSet.add(each);
            nameFullHits.add(each);
        }
        THashSet tHashSet = currentConfigurables = type == DocumentEvent.EventType.CHANGE ? new THashSet(effectiveConfigurables) : null;
        if (options.isEmpty()) {
            String[] components = REG_EXP.split(optionToCheck);
            if (components.length > 0) {
                Collections.addAll(options, components);
            } else {
                options.add(option2);
            }
        }
        LinkedHashSet<Configurable> contentHits = configurables == null ? (LinkedHashSet<Configurable>)effectiveConfigurables : new LinkedHashSet<Configurable>(effectiveConfigurables);
        HashSet<String> helpIds = null;
        for (String opt : options) {
            Set<OptionDescription> optionIds = this.getAcceptableDescriptions(opt);
            if (optionIds == null) {
                contentHits.clear();
                return new ConfigurableHit(linkedHashSet, nameFullHits, contentHits);
            }
            HashSet<String> ids = new HashSet<String>();
            for (OptionDescription id2 : optionIds) {
                ids.add(id2.getConfigurableId());
            }
            if (helpIds == null) {
                helpIds = ids;
            }
            helpIds.retainAll(ids);
        }
        if (helpIds != null) {
            Iterator it = contentHits.iterator();
            while (it.hasNext()) {
                Configurable configurable2 = (Configurable)it.next();
                boolean needToRemove = true;
                if (configurable2 instanceof SearchableConfigurable && helpIds.contains(((SearchableConfigurable)configurable2).getId())) {
                    needToRemove = false;
                }
                if (configurable2 instanceof SearchableConfigurable.Merged) {
                    List mergedConfigurables = ((SearchableConfigurable.Merged)configurable2).getMergedConfigurables();
                    for (Configurable mergedConfigurable : mergedConfigurables) {
                        if (!(mergedConfigurable instanceof SearchableConfigurable) || !helpIds.contains(((SearchableConfigurable)mergedConfigurable).getId())) continue;
                        needToRemove = false;
                        break;
                    }
                }
                if (!needToRemove) continue;
                it.remove();
            }
        }
        if (type == DocumentEvent.EventType.CHANGE && configurables != null && currentConfigurables.equals(contentHits)) {
            ConfigurableHit configurableHit = this.getConfigurables(groups, DocumentEvent.EventType.CHANGE, null, option2, project);
            if (configurableHit == null) {
                SearchableOptionsRegistrarImpl.$$$reportNull$$$0(10);
            }
            return configurableHit;
        }
        return new ConfigurableHit(linkedHashSet, nameFullHits, contentHits);
    }

    @Nullable
    public synchronized Set<OptionDescription> getAcceptableDescriptions(@Nullable String prefix) {
        if (prefix == null) {
            return null;
        }
        String stemmedPrefix = PorterStemmerUtil.stem(prefix);
        if (StringUtil.isEmptyOrSpaces((String)stemmedPrefix)) {
            return null;
        }
        this.loadHugeFilesIfNecessary();
        THashSet result2 = null;
        for (Map.Entry<CharSequence, long[]> entry : this.myStorage.entrySet()) {
            String stemmedOption;
            long[] descriptions = entry.getValue();
            CharSequence option2 = entry.getKey();
            if (!StringUtil.startsWith((CharSequence)option2, (CharSequence)prefix) && !StringUtil.startsWith((CharSequence)option2, (CharSequence)stemmedPrefix) && (stemmedOption = PorterStemmerUtil.stem(option2.toString())) != null && !stemmedOption.startsWith(prefix) && !stemmedOption.startsWith(stemmedPrefix)) continue;
            if (result2 == null) {
                result2 = new THashSet();
            }
            for (long description : descriptions) {
                OptionDescription desc = this.unpack(description);
                result2.add(desc);
            }
        }
        return result2;
    }

    @Nullable
    private Set<OptionDescription> getOptionDescriptionsByWords(SearchableConfigurable configurable2, Set<String> words) {
        HashSet<OptionDescription> path = null;
        for (String word : words) {
            Set<OptionDescription> configs = this.getAcceptableDescriptions(word);
            if (configs == null) {
                return null;
            }
            HashSet<OptionDescription> paths = new HashSet<OptionDescription>();
            for (OptionDescription config2 : configs) {
                if (!Comparing.strEqual((String)config2.getConfigurableId(), (String)configurable2.getId())) continue;
                paths.add(config2);
            }
            if (path == null) {
                path = paths;
            }
            path.retainAll(paths);
        }
        return path;
    }

    public Set<String> getInnerPaths(SearchableConfigurable configurable2, String option2) {
        this.loadHugeFilesIfNecessary();
        Set<String> words = this.getProcessedWordsWithoutStemming(option2);
        Set<OptionDescription> path = this.getOptionDescriptionsByWords(configurable2, words);
        HashSet<String> resultSet = new HashSet<String>();
        if (path != null && !path.isEmpty()) {
            OptionDescription theOnlyResult = null;
            for (OptionDescription description : path) {
                String hit = description.getHit();
                if (hit != null) {
                    boolean theBest = true;
                    for (String word : words) {
                        if (StringUtil.containsIgnoreCase((String)hit, (String)word)) continue;
                        theBest = false;
                        break;
                    }
                    if (theBest) {
                        resultSet.add(description.getPath());
                    }
                }
                theOnlyResult = description;
            }
            if (resultSet.isEmpty()) {
                resultSet.add(theOnlyResult.getPath());
            }
        }
        return resultSet;
    }

    public boolean isStopWord(String word) {
        return this.myStopWords.contains(word);
    }

    public synchronized void addOption(@NotNull String option2, @Nullable String path, @NotNull String hit, @NotNull String configurableId, String configurableDisplayName) {
        if (option2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(11);
        }
        if (hit == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(12);
        }
        if (configurableId == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(13);
        }
        SearchableOptionsRegistrarImpl.putOptionWithHelpId(option2, configurableId, configurableDisplayName, hit, path, this.myStorage, this);
    }

    public synchronized void addOptions(@NotNull Collection<String> words, @Nullable String path, String hit, @NotNull String configurableId, String configurableDisplayName) {
        if (words == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(14);
        }
        if (configurableId == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(15);
        }
        for (String word : words) {
            SearchableOptionsRegistrarImpl.putOptionWithHelpId(word, configurableId, configurableDisplayName, hit, path, this.myStorage, this);
        }
    }

    public Set<String> getProcessedWordsWithoutStemming(@NotNull String text2) {
        if (text2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(16);
        }
        THashSet result2 = new THashSet();
        for (String opt : REG_EXP.split(StringUtil.toLowerCase((String)text2))) {
            String processed2;
            if (this.isStopWord(opt) || this.isStopWord(processed2 = PorterStemmerUtil.stem(opt))) continue;
            result2.add(opt);
        }
        return result2;
    }

    public Set<String> getProcessedWords(@NotNull String text2) {
        String[] options;
        if (text2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(17);
        }
        THashSet result2 = new THashSet();
        String toLowerCase = StringUtil.toLowerCase((String)text2);
        for (String opt : options = REG_EXP.split(toLowerCase)) {
            if (this.isStopWord(opt) || (opt = PorterStemmerUtil.stem(opt)) == null) continue;
            result2.add(opt);
        }
        return result2;
    }

    @NotNull
    public Set<String> replaceSynonyms(@NotNull Set<String> options, @NotNull SearchableConfigurable configurable2) {
        if (options == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(18);
        }
        if (configurable2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(19);
        }
        if (this.myHighlightOptionToSynonym.isEmpty()) {
            Set<String> set = options;
            if (set == null) {
                SearchableOptionsRegistrarImpl.$$$reportNull$$$0(20);
            }
            return set;
        }
        THashSet result2 = new THashSet(options);
        this.loadHugeFilesIfNecessary();
        for (String option2 : options) {
            Set<String> synonyms = this.myHighlightOptionToSynonym.get(Couple.of((Object)option2, (Object)configurable2.getId()));
            if (synonyms != null) {
                result2.addAll(synonyms);
                continue;
            }
            result2.add(option2);
        }
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(21);
        }
        return tHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hit";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurableId";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findSearchableOptions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findConfigurables";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceSynonyms";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "pack";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "putOptionWithHelpId";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurables";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findConfigurables";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addOption";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addOptions";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getProcessedWordsWithoutStemming";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getProcessedWords";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "replaceSynonyms";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

