/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.BundleBase;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ApplyIntentionAction;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.ui.RegistryTextOptionDescriptor;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.GotoActionAliasMatcher;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.WordPrefixMatcher;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.LightColors;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.OnOffButton;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoActionModel
implements ChooseByNameModel,
Comparator<Object>,
DumbAware {
    private static final Logger LOG = Logger.getInstance(GotoActionModel.class);
    private static final Pattern INNER_GROUP_WITH_IDS = Pattern.compile("(.*) \\(\\d+\\)");
    @Nullable
    private final Project myProject;
    private final Component myContextComponent;
    @Nullable
    private final Editor myEditor;
    protected final ActionManager myActionManager = ActionManager.getInstance();
    private static final Icon EMPTY_ICON = EmptyIcon.ICON_18;
    private final Map<AnAction, GroupMapping> myActionGroups = new HashMap<AnAction, GroupMapping>();
    private final NotNullLazyValue<Map<String, String>> myConfigurablesNames = VolatileNotNullLazyValue.createValue(() -> {
        if (SwingUtilities.isEventDispatchThread() && !ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error("Configurable names must not be loaded on EDT");
        }
        THashMap map2 = new THashMap();
        for (Configurable configurable2 : ShowSettingsUtilImpl.getConfigurables(this.getProject(), true)) {
            if (!(configurable2 instanceof SearchableConfigurable)) continue;
            map2.put(((SearchableConfigurable)configurable2).getId(), configurable2.getDisplayName());
        }
        return map2;
    });
    private final ModalityState myModality;

    public GotoActionModel(@Nullable Project project, Component component2, @Nullable Editor editor) {
        this(project, component2, editor, ModalityState.defaultModalityState());
    }

    public GotoActionModel(@Nullable Project project, Component component2, @Nullable Editor editor, @Nullable ModalityState modalityState) {
        this.myProject = project;
        this.myContextComponent = component2;
        this.myEditor = editor;
        this.myModality = modalityState;
        this.buildActions();
    }

    private void buildActions() {
        ActionGroup mainMenu = (ActionGroup)this.myActionManager.getActionOrStub("MainMenu");
        ActionGroup keymapOthers = (ActionGroup)this.myActionManager.getActionOrStub("Other.KeymapGroup");
        assert (mainMenu != null && keymapOthers != null);
        this.collectActions(this.myActionGroups, mainMenu, Collections.emptyList(), false);
        HashMap<AnAction, GroupMapping> keymapActionGroups = new HashMap<AnAction, GroupMapping>();
        this.collectActions(keymapActionGroups, keymapOthers, Collections.emptyList(), true);
        keymapActionGroups.forEach(this.myActionGroups::putIfAbsent);
    }

    @NotNull
    Map<String, ApplyIntentionAction> getAvailableIntentions() {
        TreeMap<String, ApplyIntentionAction> map2 = new TreeMap<String, ApplyIntentionAction>();
        if (!(this.myProject == null || this.myProject.isDisposed() || DumbService.isDumb((Project)this.myProject) || this.myEditor == null || this.myEditor.isDisposed())) {
            ApplyIntentionAction[] children2;
            PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
            ApplyIntentionAction[] applyIntentionActionArray = children2 = file2 == null ? null : ApplyIntentionAction.getAvailableIntentions(this.myEditor, file2);
            if (children2 != null) {
                for (ApplyIntentionAction action2 : children2) {
                    map2.put(action2.getName(), action2);
                }
            }
        }
        TreeMap<String, ApplyIntentionAction> treeMap = map2;
        if (treeMap == null) {
            GotoActionModel.$$$reportNull$$$0(0);
        }
        return treeMap;
    }

    public String getPromptText() {
        return IdeBundle.message((String)"prompt.gotoaction.enter.action", (Object[])new Object[0]);
    }

    @Nullable
    public String getCheckBoxName() {
        return IdeBundle.message((String)"checkbox.disabled.included", (Object[])new Object[0]);
    }

    @NotNull
    public String getNotInMessage() {
        String string = IdeBundle.message((String)"label.no.enabled.actions.found", (Object[])new Object[0]);
        if (string == null) {
            GotoActionModel.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getNotFoundMessage() {
        String string = IdeBundle.message((String)"label.no.actions.found", (Object[])new Object[0]);
        if (string == null) {
            GotoActionModel.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean loadInitialCheckBoxState() {
        return false;
    }

    public void saveInitialCheckBoxState(boolean state) {
    }

    @ApiStatus.Internal
    public void rebuildActions() {
        this.myActionGroups.clear();
        this.buildActions();
    }

    @NotNull
    public ListCellRenderer getListCellRenderer() {
        return new GotoActionListCellRenderer((Function<? super OptionDescription, String>)((Function)this::getGroupName));
    }

    protected String getActionId(@NotNull AnAction anAction) {
        if (anAction == null) {
            GotoActionModel.$$$reportNull$$$0(3);
        }
        return this.myActionManager.getId(anAction);
    }

    @NotNull
    private static JLabel createIconLabel(@Nullable Icon icon2, boolean disabled) {
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(EMPTY_ICON, 0);
        if (icon2 == null) {
            return new JLabel((Icon)layeredIcon);
        }
        int width = icon2.getIconWidth();
        int height = icon2.getIconHeight();
        int emptyIconWidth = EMPTY_ICON.getIconWidth();
        int emptyIconHeight = EMPTY_ICON.getIconHeight();
        if (width <= emptyIconWidth && height <= emptyIconHeight) {
            layeredIcon.setIcon(disabled && IconLoader.isGoodSize((Icon)icon2) ? IconLoader.getDisabledIcon((Icon)icon2) : icon2, 1, (emptyIconWidth - width) / 2, (emptyIconHeight - height) / 2);
        }
        return new JLabel((Icon)layeredIcon);
    }

    @Override
    public int compare(@NotNull Object o1, @NotNull Object o2) {
        if (o1 == null) {
            GotoActionModel.$$$reportNull$$$0(4);
        }
        if (o2 == null) {
            GotoActionModel.$$$reportNull$$$0(5);
        }
        if ("...".equals(o1)) {
            return 1;
        }
        if ("...".equals(o2)) {
            return -1;
        }
        return ((MatchedValue)o1).compareWeights((MatchedValue)o2);
    }

    @NotNull
    public static AnActionEvent updateActionBeforeShow(@NotNull AnAction anAction, @NotNull DataContext dataContext) {
        if (anAction == null) {
            GotoActionModel.$$$reportNull$$$0(6);
        }
        if (dataContext == null) {
            GotoActionModel.$$$reportNull$$$0(7);
        }
        Presentation presentation = new Presentation();
        presentation.copyFrom(anAction.getTemplatePresentation());
        AnActionEvent event = AnActionEvent.createFromDataContext((String)"GoToAction", (Presentation)presentation, (DataContext)dataContext);
        ActionUtil.performDumbAwareUpdate((boolean)false, (AnAction)anAction, (AnActionEvent)event, (boolean)false);
        AnActionEvent anActionEvent = event;
        if (anActionEvent == null) {
            GotoActionModel.$$$reportNull$$$0(8);
        }
        return anActionEvent;
    }

    @Deprecated
    public static Color defaultActionForeground(boolean isSelected, @Nullable Presentation presentation) {
        return GotoActionModel.defaultActionForeground(isSelected, true, presentation);
    }

    public static Color defaultActionForeground(boolean isSelected, boolean hasFocus, @Nullable Presentation presentation) {
        if (isSelected) {
            return UIUtil.getListSelectionForeground((boolean)hasFocus);
        }
        if (presentation != null && !presentation.isEnabledAndVisible()) {
            return UIUtil.getInactiveTextColor();
        }
        return UIUtil.getListForeground();
    }

    public String @NotNull [] getNames(boolean checkBoxState) {
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            GotoActionModel.$$$reportNull$$$0(9);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public Object @NotNull [] getElementsByName(@NotNull String id2, boolean checkBoxState, @NotNull String pattern) {
        if (id2 == null) {
            GotoActionModel.$$$reportNull$$$0(10);
        }
        if (pattern == null) {
            GotoActionModel.$$$reportNull$$$0(11);
        }
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            GotoActionModel.$$$reportNull$$$0(12);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    public String getGroupName(@NotNull OptionDescription description) {
        String settings;
        if (description == null) {
            GotoActionModel.$$$reportNull$$$0(13);
        }
        if (description instanceof RegistryTextOptionDescriptor) {
            return "Registry";
        }
        String groupName = description.getGroupName();
        String string = settings = SystemInfo.isMac ? "Preferences" : "Settings";
        if (groupName == null || groupName.equals(description.getHit())) {
            String string2 = settings;
            if (string2 == null) {
                GotoActionModel.$$$reportNull$$$0(14);
            }
            return string2;
        }
        String string3 = settings + " > " + groupName;
        if (string3 == null) {
            GotoActionModel.$$$reportNull$$$0(15);
        }
        return string3;
    }

    @NotNull
    Map<String, String> getConfigurablesNames() {
        Map map2 = (Map)this.myConfigurablesNames.getValue();
        if (map2 == null) {
            GotoActionModel.$$$reportNull$$$0(16);
        }
        return map2;
    }

    private void collectActions(@NotNull Map<AnAction, GroupMapping> actionGroups, @NotNull ActionGroup group, @NotNull List<ActionGroup> path, boolean showNonPopupGroups) {
        Object[] actions;
        boolean hasMeaningfulChildren;
        if (actionGroups == null) {
            GotoActionModel.$$$reportNull$$$0(17);
        }
        if (group == null) {
            GotoActionModel.$$$reportNull$$$0(18);
        }
        if (path == null) {
            GotoActionModel.$$$reportNull$$$0(19);
        }
        if (!(hasMeaningfulChildren = ContainerUtil.exists((Object[])(actions = group.getChildren(null)), action2 -> this.myActionManager.getId(action2) != null))) {
            GroupMapping mapping2 = actionGroups.computeIfAbsent((AnAction)group, key -> new GroupMapping(showNonPopupGroups));
            mapping2.addPath(path);
        }
        List newPath = ContainerUtil.append(path, (Object[])new ActionGroup[]{group});
        for (Object action3 : actions) {
            if (action3 == null || action3 instanceof Separator) continue;
            if (action3 instanceof ActionGroup) {
                this.collectActions(actionGroups, (ActionGroup)action3, newPath, showNonPopupGroups);
                continue;
            }
            GroupMapping mapping3 = actionGroups.computeIfAbsent((AnAction)action3, key -> new GroupMapping(showNonPopupGroups));
            mapping3.addPath(newPath);
        }
    }

    @Nullable
    GroupMapping getGroupMapping(@NotNull AnAction action2) {
        if (action2 == null) {
            GotoActionModel.$$$reportNull$$$0(20);
        }
        return this.myActionGroups.get(action2);
    }

    @Nullable
    public String getFullName(@NotNull Object element2) {
        if (element2 == null) {
            GotoActionModel.$$$reportNull$$$0(21);
        }
        return this.getElementName(element2);
    }

    @NonNls
    public String getHelpId() {
        return "procedures.navigating.goto.action";
    }

    public String @NotNull [] getSeparators() {
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            GotoActionModel.$$$reportNull$$$0(22);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @Nullable
    public String getElementName(@NotNull Object mv) {
        if (mv == null) {
            GotoActionModel.$$$reportNull$$$0(23);
        }
        return ((MatchedValue)mv).getValueText();
    }

    protected MatchMode actionMatches(@NotNull String pattern, com.intellij.util.text.Matcher matcher, @NotNull AnAction anAction) {
        if (pattern == null) {
            GotoActionModel.$$$reportNull$$$0(24);
        }
        if (anAction == null) {
            GotoActionModel.$$$reportNull$$$0(25);
        }
        Presentation presentation = anAction.getTemplatePresentation();
        String text2 = presentation.getText();
        String description = presentation.getDescription();
        if (text2 != null && matcher.matches(text2)) {
            return MatchMode.NAME;
        }
        if (description != null && !description.equals(text2) && new WordPrefixMatcher(pattern).matches(description)) {
            return MatchMode.DESCRIPTION;
        }
        if (text2 == null) {
            return MatchMode.NONE;
        }
        GroupMapping groupMapping = this.myActionGroups.get(anAction);
        if (groupMapping != null) {
            for (String groupName : groupMapping.getAllGroupNames()) {
                if (matcher.matches(groupName + " " + text2)) {
                    return anAction instanceof ToggleAction ? MatchMode.NAME : MatchMode.GROUP;
                }
                if (!matcher.matches(text2 + " " + groupName)) continue;
                return MatchMode.GROUP;
            }
        }
        for (GotoActionAliasMatcher m : (GotoActionAliasMatcher[])GotoActionAliasMatcher.EP_NAME.getExtensions()) {
            if (!m.match(anAction, pattern)) continue;
            return MatchMode.NAME;
        }
        return MatchMode.NONE;
    }

    @Nullable
    protected Project getProject() {
        return this.myProject;
    }

    protected Component getContextComponent() {
        return this.myContextComponent;
    }

    @NotNull
    public SortedSet<Object> sortItems(@NotNull Set<Object> elements2) {
        if (elements2 == null) {
            GotoActionModel.$$$reportNull$$$0(26);
        }
        TreeSet<Object> objects = new TreeSet<Object>(this);
        objects.addAll(elements2);
        TreeSet<Object> treeSet = objects;
        if (treeSet == null) {
            GotoActionModel.$$$reportNull$$$0(27);
        }
        return treeSet;
    }

    private void updateOnEdt(Runnable update2) {
        Semaphore semaphore = new Semaphore(1);
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        ApplicationManager.getApplication().invokeLater(() -> {
            try {
                update2.run();
            }
            finally {
                semaphore.up();
            }
        }, this.myModality, __ -> indicator != null && indicator.isCanceled());
        ProgressIndicatorUtils.awaitWithCheckCanceled(semaphore, indicator);
    }

    public boolean willOpenEditor() {
        return false;
    }

    public boolean useMiddleMatching() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/gotoByName/GotoActionModel";
                break;
            }
            case 3: 
            case 6: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 11: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroups";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mv";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableIntentions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotInMessage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotFoundMessage";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/gotoByName/GotoActionModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "updateActionBeforeShow";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsByName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurablesNames";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparators";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "sortItems";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getActionId";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateActionBeforeShow";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getElementsByName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getGroupName";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "collectActions";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getGroupMapping";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getFullName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getElementName";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "actionMatches";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "sortItems";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @DirtyUI
    public static class GotoActionListCellRenderer
    extends DefaultListCellRenderer {
        public static final Border TOGGLE_BUTTON_BORDER = JBUI.Borders.empty((int)0, (int)2);
        private final Function<? super OptionDescription, String> myGroupNamer;
        private final boolean myUseListFont;

        public GotoActionListCellRenderer(Function<? super OptionDescription, String> groupNamer) {
            this(groupNamer, false);
        }

        public GotoActionListCellRenderer(Function<? super OptionDescription, String> groupNamer, boolean useListFont) {
            this.myGroupNamer = groupNamer;
            this.myUseListFont = useListFont;
        }

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList list2, Object matchedValue, int index, boolean isSelected, boolean cellHasFocus) {
            if (list2 == null) {
                GotoActionListCellRenderer.$$$reportNull$$$0(0);
            }
            boolean showIcon = UISettings.getInstance().getShowIconsInMenus();
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.setBorder(JBUI.Borders.empty((int)2));
            panel2.setOpaque(true);
            Color bg = UIUtil.getListBackground((boolean)isSelected, (boolean)cellHasFocus);
            panel2.setBackground(bg);
            SimpleColoredComponent nameComponent = new SimpleColoredComponent();
            if (this.myUseListFont) {
                nameComponent.setFont(list2.getFont());
            }
            nameComponent.setBackground(bg);
            panel2.add((Component)nameComponent, "Center");
            if (matchedValue instanceof String) {
                if (showIcon) {
                    panel2.add((Component)new JBLabel(EMPTY_ICON), "West");
                }
                String str = GotoActionListCellRenderer.cutName((String)matchedValue, null, list2, panel2, nameComponent);
                nameComponent.append(str, new SimpleTextAttributes(0, GotoActionModel.defaultActionForeground(isSelected, cellHasFocus, null)));
                JPanel jPanel = panel2;
                if (jPanel == null) {
                    GotoActionListCellRenderer.$$$reportNull$$$0(1);
                }
                return jPanel;
            }
            Color groupFg = isSelected ? UIUtil.getListSelectionForeground((boolean)true) : UIUtil.getInactiveTextColor();
            Object value2 = ((MatchedValue)matchedValue).value;
            String pattern = ((MatchedValue)matchedValue).pattern;
            JBEmptyBorder eastBorder = JBUI.Borders.emptyRight((int)2);
            if (value2 instanceof ActionWrapper) {
                boolean disabled;
                ActionWrapper actionWithParentGroup = (ActionWrapper)value2;
                AnAction anAction = actionWithParentGroup.getAction();
                boolean toggle = anAction instanceof ToggleAction;
                String groupName = actionWithParentGroup.getAction() instanceof ApplyIntentionAction ? null : actionWithParentGroup.getGroupName();
                Presentation presentation = actionWithParentGroup.getPresentation();
                Color fg = GotoActionModel.defaultActionForeground(isSelected, cellHasFocus, presentation);
                boolean bl = disabled = !isSelected && !presentation.isEnabledAndVisible();
                if (disabled) {
                    groupFg = UIUtil.getLabelDisabledForeground();
                }
                if (showIcon) {
                    Icon icon2 = presentation.getIcon();
                    panel2.add((Component)GotoActionModel.createIconLabel(icon2, disabled), "West");
                }
                if (toggle) {
                    AnActionEvent event = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)((ActionWrapper)value2).myDataContext);
                    boolean selected2 = ((ToggleAction)anAction).isSelected(event);
                    GotoActionListCellRenderer.addOnOffButton(panel2, selected2);
                } else if (groupName != null) {
                    JLabel groupLabel = new JLabel(groupName);
                    groupLabel.setBackground(bg);
                    groupLabel.setBorder((Border)eastBorder);
                    groupLabel.setForeground(groupFg);
                    panel2.add((Component)groupLabel, "East");
                }
                panel2.getAccessibleContext().setAccessibleName(presentation.getText());
                panel2.getAccessibleContext().setAccessibleDescription(presentation.getDescription());
                panel2.setToolTipText(presentation.getDescription());
                Shortcut[] shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)ActionManager.getInstance().getId(anAction)).getShortcuts();
                String shortcutText = KeymapUtil.getPreferredShortcutText((Shortcut[])shortcuts);
                String name = GotoActionListCellRenderer.getName(presentation.getText(), groupName, toggle);
                name = GotoActionListCellRenderer.cutName(name, shortcutText, list2, panel2, nameComponent);
                GotoActionListCellRenderer.appendWithColoredMatches(nameComponent, name, pattern, fg, isSelected);
                if (StringUtil.isNotEmpty((String)shortcutText)) {
                    nameComponent.append(" " + shortcutText, new SimpleTextAttributes(129, groupFg));
                }
            } else if (value2 instanceof OptionDescription) {
                if (!isSelected && !(value2 instanceof BooleanOptionDescription)) {
                    Color descriptorBg = StartupUiUtil.isUnderDarcula() ? ColorUtil.brighter((Color)UIUtil.getListBackground(), (int)1) : LightColors.SLIGHTLY_GRAY;
                    panel2.setBackground(descriptorBg);
                    nameComponent.setBackground(descriptorBg);
                }
                String hit = GotoActionListCellRenderer.calcHit((OptionDescription)value2);
                Color fg = UIUtil.getListForeground((boolean)isSelected, (boolean)cellHasFocus);
                if (showIcon) {
                    panel2.add((Component)new JLabel(EMPTY_ICON), "West");
                }
                if (value2 instanceof BooleanOptionDescription) {
                    boolean selected3 = ((BooleanOptionDescription)value2).isOptionEnabled();
                    GotoActionListCellRenderer.addOnOffButton(panel2, selected3);
                } else {
                    JLabel settingsLabel = new JLabel((String)this.myGroupNamer.fun((Object)((OptionDescription)value2)));
                    settingsLabel.setForeground(groupFg);
                    settingsLabel.setBackground(bg);
                    settingsLabel.setBorder((Border)eastBorder);
                    panel2.add((Component)settingsLabel, "East");
                }
                String name = GotoActionListCellRenderer.cutName(hit, null, list2, panel2, nameComponent);
                GotoActionListCellRenderer.appendWithColoredMatches(nameComponent, name, pattern, fg, isSelected);
            }
            JPanel jPanel = panel2;
            if (jPanel == null) {
                GotoActionListCellRenderer.$$$reportNull$$$0(2);
            }
            return jPanel;
        }

        @NotNull
        private static String calcHit(@NotNull OptionDescription value2) {
            if (value2 == null) {
                GotoActionListCellRenderer.$$$reportNull$$$0(3);
            }
            if (value2 instanceof RegistryTextOptionDescriptor) {
                String string = value2.getHit() + " = " + value2.getValue();
                if (string == null) {
                    GotoActionListCellRenderer.$$$reportNull$$$0(4);
                }
                return string;
            }
            String hit = StringUtil.defaultIfEmpty((String)value2.getHit(), (String)value2.getOption());
            String string = StringUtil.unescapeXmlEntities((String)StringUtil.notNullize((String)hit)).replace(BundleBase.MNEMONIC_STRING, "").replace("  ", " ");
            if (string == null) {
                GotoActionListCellRenderer.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static String cutName(String name, String shortcutText, JList list2, JPanel panel2, SimpleColoredComponent nameComponent) {
            if (!list2.isShowing() || list2.getWidth() <= 0) {
                return StringUtil.first((String)name, (int)60, (boolean)true);
            }
            if (name.length() < 40) {
                return name;
            }
            int freeSpace = GotoActionListCellRenderer.calcFreeSpace(list2, panel2, nameComponent, shortcutText);
            if (freeSpace <= 0) {
                return name;
            }
            FontMetrics fm = nameComponent.getFontMetrics(nameComponent.getFont());
            int strWidth = fm.stringWidth(name);
            if (strWidth <= freeSpace) {
                return name;
            }
            int cutSymbolIndex = (int)(((double)freeSpace - (double)fm.stringWidth("...")) / (double)strWidth * (double)name.length());
            cutSymbolIndex = Integer.max(1, cutSymbolIndex);
            name = name.substring(0, cutSymbolIndex);
            while (fm.stringWidth(name + "...") > freeSpace && name.length() > 1) {
                name = name.substring(0, name.length() - 1);
            }
            return name.trim() + "...";
        }

        private static int calcFreeSpace(JList list2, JPanel panel2, SimpleColoredComponent nameComponent, String shortcutText) {
            BorderLayout layout = (BorderLayout)panel2.getLayout();
            Component eastComponent = layout.getLayoutComponent("East");
            Component westComponent = layout.getLayoutComponent("West");
            int freeSpace = list2.getWidth() - (list2.getInsets().right + list2.getInsets().left) - (panel2.getInsets().right + panel2.getInsets().left) - (eastComponent == null ? 0 : eastComponent.getPreferredSize().width) - (westComponent == null ? 0 : westComponent.getPreferredSize().width) - (nameComponent.getInsets().right + nameComponent.getInsets().left) - (nameComponent.getIpad().right + nameComponent.getIpad().left) - nameComponent.getIconTextGap();
            if (StringUtil.isNotEmpty((String)shortcutText)) {
                FontMetrics fm = nameComponent.getFontMetrics(nameComponent.getFont().deriveFont(1));
                freeSpace -= fm.stringWidth(" " + shortcutText);
            }
            return freeSpace;
        }

        private static void addOnOffButton(@NotNull JPanel panel2, boolean selected2) {
            if (panel2 == null) {
                GotoActionListCellRenderer.$$$reportNull$$$0(6);
            }
            OnOffButton button2 = new OnOffButton();
            button2.setSelected(selected2);
            panel2.add((Component)button2, "East");
            panel2.setBorder(TOGGLE_BUTTON_BORDER);
        }

        @NotNull
        private static String getName(@Nullable String text2, @Nullable String groupName, boolean toggle) {
            String string = toggle && StringUtil.isNotEmpty((String)groupName) ? (StringUtil.isNotEmpty((String)text2) ? groupName + ": " + text2 : groupName) : StringUtil.notNullize((String)text2);
            if (string == null) {
                GotoActionListCellRenderer.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static void appendWithColoredMatches(SimpleColoredComponent nameComponent, @NotNull String name, @NotNull String pattern, Color fg, boolean selected2) {
            int matchStart;
            if (name == null) {
                GotoActionListCellRenderer.$$$reportNull$$$0(8);
            }
            if (pattern == null) {
                GotoActionListCellRenderer.$$$reportNull$$$0(9);
            }
            SimpleTextAttributes plain = new SimpleTextAttributes(0, fg);
            SimpleTextAttributes highlighted = new SimpleTextAttributes(null, fg, null, 64);
            ArrayList<TextRange> fragments = new ArrayList<TextRange>();
            if (selected2 && (matchStart = StringUtil.indexOfIgnoreCase((String)name, (String)pattern, (int)0)) >= 0) {
                fragments.add(TextRange.from((int)matchStart, (int)pattern.length()));
            }
            SpeedSearchUtil.appendColoredFragments((SimpleColoredComponent)nameComponent, (String)name, fragments, (SimpleTextAttributes)plain, (SimpleTextAttributes)highlighted);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/gotoByName/GotoActionModel$GotoActionListCellRenderer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/gotoByName/GotoActionModel$GotoActionListCellRenderer";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getListCellRendererComponent";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calcHit";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getListCellRendererComponent";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "calcHit";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addOnOffButton";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "appendWithColoredMatches";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ActionWrapper {
        @NotNull
        private final AnAction myAction;
        @NotNull
        private final MatchMode myMode;
        @Nullable
        private final GroupMapping myGroupMapping;
        private final DataContext myDataContext;
        private final GotoActionModel myModel;
        private volatile Presentation myPresentation;

        public ActionWrapper(@NotNull AnAction action2, @Nullable GroupMapping groupMapping, @NotNull MatchMode mode, DataContext dataContext, GotoActionModel model) {
            if (action2 == null) {
                ActionWrapper.$$$reportNull$$$0(0);
            }
            if (mode == null) {
                ActionWrapper.$$$reportNull$$$0(1);
            }
            this.myAction = action2;
            this.myMode = mode;
            this.myGroupMapping = groupMapping;
            this.myDataContext = dataContext;
            this.myModel = model;
        }

        @NotNull
        public AnAction getAction() {
            AnAction anAction = this.myAction;
            if (anAction == null) {
                ActionWrapper.$$$reportNull$$$0(2);
            }
            return anAction;
        }

        @NotNull
        public MatchMode getMode() {
            MatchMode matchMode = this.myMode;
            if (matchMode == null) {
                ActionWrapper.$$$reportNull$$$0(3);
            }
            return matchMode;
        }

        public int compareWeights(@NotNull ActionWrapper o) {
            int compared;
            if (o == null) {
                ActionWrapper.$$$reportNull$$$0(4);
            }
            if ((compared = this.myMode.compareTo(o.getMode())) != 0) {
                return compared;
            }
            Presentation myPresentation2 = this.myAction.getTemplatePresentation();
            Presentation oPresentation = o.getAction().getTemplatePresentation();
            String myText = StringUtil.notNullize((String)myPresentation2.getText());
            String oText = StringUtil.notNullize((String)oPresentation.getText());
            int byText = StringUtil.compare((String)StringUtil.trimEnd((String)myText, (String)"..."), (String)StringUtil.trimEnd((String)oText, (String)"..."), (boolean)true);
            if (byText != 0) {
                return byText;
            }
            int byTextLength = StringUtil.notNullize((String)myText).length() - StringUtil.notNullize((String)oText).length();
            if (byTextLength != 0) {
                return byTextLength;
            }
            int byGroup = Comparing.compare((Comparable)this.myGroupMapping, (Comparable)o.myGroupMapping);
            if (byGroup != 0) {
                return byGroup;
            }
            int byDesc = StringUtil.compare((String)myPresentation2.getDescription(), (String)oPresentation.getDescription(), (boolean)true);
            if (byDesc != 0) {
                return byDesc;
            }
            int byClassHashCode = Comparing.compare((int)this.myAction.getClass().hashCode(), (int)o.myAction.getClass().hashCode());
            if (byClassHashCode != 0) {
                return byClassHashCode;
            }
            int byInstanceHashCode = Comparing.compare((int)this.myAction.hashCode(), (int)o.myAction.hashCode());
            if (byInstanceHashCode != 0) {
                return byInstanceHashCode;
            }
            return 0;
        }

        public boolean isAvailable() {
            return this.getPresentation().isEnabledAndVisible();
        }

        @NotNull
        public Presentation getPresentation() {
            if (this.myPresentation != null) {
                Presentation presentation = this.myPresentation;
                if (presentation == null) {
                    ActionWrapper.$$$reportNull$$$0(5);
                }
                return presentation;
            }
            Runnable r = () -> {
                this.myPresentation = GotoActionModel.updateActionBeforeShow(this.myAction, this.myDataContext).getPresentation();
                if (this.myGroupMapping != null) {
                    this.myGroupMapping.updateBeforeShow(this.myDataContext);
                }
            };
            if (ApplicationManager.getApplication().isDispatchThread()) {
                r.run();
            } else {
                this.myModel.updateOnEdt(r);
            }
            Presentation presentation = (Presentation)ObjectUtils.notNull((Object)this.myPresentation, (Object)this.myAction.getTemplatePresentation());
            if (presentation == null) {
                ActionWrapper.$$$reportNull$$$0(6);
            }
            return presentation;
        }

        private boolean hasPresentation() {
            return this.myPresentation != null;
        }

        @Nullable
        public String getGroupName() {
            if (this.myGroupMapping == null) {
                return null;
            }
            String groupName = this.myGroupMapping.getBestGroupName();
            if (this.myAction instanceof ActionGroup && Comparing.equal((String)this.myAction.getTemplatePresentation().getText(), (String)groupName)) {
                return null;
            }
            return groupName;
        }

        public boolean isGroupAction() {
            return this.myAction instanceof ActionGroup;
        }

        public boolean equals(Object obj) {
            return obj instanceof ActionWrapper && this.myAction.equals(((ActionWrapper)obj).myAction);
        }

        public int hashCode() {
            String text2 = this.myAction.getTemplatePresentation().getText();
            return text2 != null ? text2.hashCode() : 0;
        }

        public String toString() {
            return this.myAction.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mode";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/gotoByName/GotoActionModel$ActionWrapper";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/gotoByName/GotoActionModel$ActionWrapper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMode";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "compareWeights";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class GroupMapping
    implements Comparable<GroupMapping> {
        private final boolean myShowNonPopupGroups;
        private final List<List<ActionGroup>> myPaths = new ArrayList<List<ActionGroup>>();
        @Nullable
        private String myBestGroupName;
        private boolean myBestNameComputed;

        public GroupMapping() {
            this(false);
        }

        public GroupMapping(boolean showNonPopupGroups) {
            this.myShowNonPopupGroups = showNonPopupGroups;
        }

        @NotNull
        public static GroupMapping createFromText(String text2) {
            GroupMapping mapping2 = new GroupMapping();
            mapping2.addPath(Collections.singletonList(new DefaultActionGroup(text2, false)));
            GroupMapping groupMapping = mapping2;
            if (groupMapping == null) {
                GroupMapping.$$$reportNull$$$0(0);
            }
            return groupMapping;
        }

        private void addPath(@NotNull List<ActionGroup> path) {
            if (path == null) {
                GroupMapping.$$$reportNull$$$0(1);
            }
            this.myPaths.add(path);
        }

        @Override
        public int compareTo(@NotNull GroupMapping o) {
            if (o == null) {
                GroupMapping.$$$reportNull$$$0(2);
            }
            return Comparing.compare((Comparable)((Object)this.getFirstGroupName()), (Comparable)((Object)o.getFirstGroupName()));
        }

        @Nullable
        public String getBestGroupName() {
            if (this.myBestNameComputed) {
                return this.myBestGroupName;
            }
            return this.getFirstGroupName();
        }

        @Nullable
        private String getFirstGroupName() {
            List path = (List)ContainerUtil.getFirstItem(this.myPaths);
            return path != null ? this.getPathName(path) : null;
        }

        private void updateBeforeShow(@NotNull DataContext context) {
            if (context == null) {
                GroupMapping.$$$reportNull$$$0(3);
            }
            if (this.myBestNameComputed) {
                return;
            }
            this.myBestNameComputed = true;
            for (List<ActionGroup> path : this.myPaths) {
                String name = this.getActualPathName(path, context);
                if (name == null) continue;
                this.myBestGroupName = name;
                return;
            }
        }

        @NotNull
        public List<String> getAllGroupNames() {
            List list2 = ContainerUtil.map(this.myPaths, path -> this.getPathName((List<? extends ActionGroup>)path));
            if (list2 == null) {
                GroupMapping.$$$reportNull$$$0(4);
            }
            return list2;
        }

        @Nullable
        private String getPathName(@NotNull List<? extends ActionGroup> path) {
            if (path == null) {
                GroupMapping.$$$reportNull$$$0(5);
            }
            String name = "";
            for (ActionGroup actionGroup : path) {
                name = this.appendGroupName(name, actionGroup, actionGroup.getTemplatePresentation());
            }
            return StringUtil.nullize((String)name);
        }

        @Nullable
        private String getActualPathName(@NotNull List<? extends ActionGroup> path, @NotNull DataContext context) {
            if (path == null) {
                GroupMapping.$$$reportNull$$$0(6);
            }
            if (context == null) {
                GroupMapping.$$$reportNull$$$0(7);
            }
            String name = "";
            for (ActionGroup actionGroup : path) {
                Presentation presentation = GotoActionModel.updateActionBeforeShow((AnAction)actionGroup, context).getPresentation();
                if (!presentation.isVisible()) {
                    return null;
                }
                name = this.appendGroupName(name, actionGroup, presentation);
            }
            return StringUtil.nullize((String)name);
        }

        @NotNull
        private String appendGroupName(@NotNull String prefix, @NotNull ActionGroup group, @NotNull Presentation presentation) {
            String groupName;
            if (prefix == null) {
                GroupMapping.$$$reportNull$$$0(8);
            }
            if (group == null) {
                GroupMapping.$$$reportNull$$$0(9);
            }
            if (presentation == null) {
                GroupMapping.$$$reportNull$$$0(10);
            }
            if ((group.isPopup() || this.myShowNonPopupGroups) && !StringUtil.isEmptyOrSpaces((String)(groupName = GroupMapping.getActionGroupName(presentation)))) {
                String string = prefix.isEmpty() ? groupName : prefix + " | " + groupName;
                if (string == null) {
                    GroupMapping.$$$reportNull$$$0(11);
                }
                return string;
            }
            String string = prefix;
            if (string == null) {
                GroupMapping.$$$reportNull$$$0(12);
            }
            return string;
        }

        @Nullable
        private static String getActionGroupName(@NotNull Presentation presentation) {
            String text2;
            if (presentation == null) {
                GroupMapping.$$$reportNull$$$0(13);
            }
            if ((text2 = presentation.getText()) == null) {
                return null;
            }
            Matcher matcher = INNER_GROUP_WITH_IDS.matcher(text2);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            return text2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/gotoByName/GotoActionModel$GroupMapping";
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFromText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/gotoByName/GotoActionModel$GroupMapping";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllGroupNames";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "appendGroupName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addPath";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "updateBeforeShow";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getPathName";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getActualPathName";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "appendGroupName";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getActionGroupName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum MatchMode {
        NONE,
        INTENTION,
        NAME,
        DESCRIPTION,
        GROUP,
        NON_MENU;

    }

    public static class MatchedValue {
        @NotNull
        public final Object value;
        @NotNull
        final String pattern;

        public MatchedValue(@NotNull Object value2, @NotNull String pattern) {
            if (value2 == null) {
                MatchedValue.$$$reportNull$$$0(0);
            }
            if (pattern == null) {
                MatchedValue.$$$reportNull$$$0(1);
            }
            assert (value2 instanceof OptionDescription || value2 instanceof ActionWrapper);
            this.value = value2;
            this.pattern = pattern;
        }

        @Nullable
        @VisibleForTesting
        public String getValueText() {
            if (this.value instanceof OptionDescription) {
                return ((OptionDescription)this.value).getHit();
            }
            if (this.value instanceof ActionWrapper) {
                return ((ActionWrapper)this.value).getAction().getTemplatePresentation().getText();
            }
            return null;
        }

        @Nullable
        public String toString() {
            return this.getMatchingDegree() + " " + this.getValueText();
        }

        private int getMatchingDegree() {
            String text2 = this.getValueText();
            if (text2 != null) {
                int degree = this.getRank(text2);
                return this.value instanceof ActionWrapper && !((ActionWrapper)this.value).isGroupAction() ? degree + 1 : degree;
            }
            return 0;
        }

        private int getRank(@NotNull String text2) {
            if (text2 == null) {
                MatchedValue.$$$reportNull$$$0(2);
            }
            if (StringUtil.equalsIgnoreCase((CharSequence)StringUtil.trimEnd((String)text2, (String)"..."), (CharSequence)this.pattern)) {
                return 3;
            }
            if (StringUtil.startsWithIgnoreCase((String)text2, (String)this.pattern)) {
                return 2;
            }
            if (StringUtil.containsIgnoreCase((String)text2, (String)this.pattern)) {
                return 1;
            }
            return 0;
        }

        public int compareWeights(@NotNull MatchedValue o) {
            ActionWrapper value2;
            ActionWrapper value1;
            int compared;
            if (o == null) {
                MatchedValue.$$$reportNull$$$0(3);
            }
            if (o == this) {
                return 0;
            }
            int diff = o.getMatchingDegree() - this.getMatchingDegree();
            if (diff != 0) {
                return diff;
            }
            diff = MatchedValue.getTypeWeight(o.value) - MatchedValue.getTypeWeight(this.value);
            if (diff != 0) {
                return diff;
            }
            if (this.value instanceof ActionWrapper && o.value instanceof ActionWrapper && (compared = (value1 = (ActionWrapper)this.value).compareWeights(value2 = (ActionWrapper)o.value)) != 0) {
                return compared;
            }
            diff = StringUtil.notNullize((String)this.getValueText()).length() - StringUtil.notNullize((String)o.getValueText()).length();
            if (diff != 0) {
                return diff;
            }
            if (this.value instanceof OptionDescription && o.value instanceof OptionDescription && (diff = (value1 = (OptionDescription)this.value).compareTo((OptionDescription)(value2 = (OptionDescription)o.value))) != 0) {
                return diff;
            }
            return o.hashCode() - this.hashCode();
        }

        private static int getTypeWeight(@NotNull Object value2) {
            if (value2 == null) {
                MatchedValue.$$$reportNull$$$0(4);
            }
            if (value2 instanceof ActionWrapper) {
                ActionWrapper actionWrapper = (ActionWrapper)value2;
                if ((ApplicationManager.getApplication().isDispatchThread() || actionWrapper.hasPresentation()) && actionWrapper.isAvailable()) {
                    return 0;
                }
                return 2;
            }
            if (value2 instanceof OptionDescription) {
                if (value2 instanceof BooleanOptionDescription) {
                    return 1;
                }
                return 3;
            }
            throw new IllegalArgumentException(value2.getClass() + " - " + value2.toString());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MatchedValue value1 = (MatchedValue)o;
            return Objects.equals(this.value, value1.value) && Objects.equals(this.pattern, value1.pattern);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.pattern);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/util/gotoByName/GotoActionModel$MatchedValue";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRank";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareWeights";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getTypeWeight";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

