/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.scratch.ScratchesSearchScope;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.ChangeListsScopesProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopeChooserUtils {
    private ScopeChooserUtils() {
    }

    @NotNull
    public static GlobalSearchScope findScopeByName(@NotNull Project project, @Nullable String scopeName) {
        if (project == null) {
            ScopeChooserUtils.$$$reportNull$$$0(0);
        }
        if (scopeName == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                ScopeChooserUtils.$$$reportNull$$$0(1);
            }
            return globalSearchScope;
        }
        if (ScopeChooserUtils.getOpenFilesScopeName().equals(scopeName)) {
            return ScopeChooserUtils.intersectWithContentScope(project, GlobalSearchScopes.openFilesScope((Project)project));
        }
        if (ScopeChooserUtils.getCurrentFileScopeName().equals(scopeName)) {
            Object[] array = FileEditorManager.getInstance((Project)project).getSelectedFiles();
            List files2 = ContainerUtil.createMaybeSingletonList((Object)ArrayUtil.getFirstElement((Object[])array));
            GlobalSearchScope scope = GlobalSearchScope.filesScope((Project)project, (Collection)files2, (String)ScopeChooserUtils.getCurrentFileScopeName());
            return ScopeChooserUtils.intersectWithContentScope(project, scope);
        }
        for (SearchScope scope : PredefinedSearchScopeProvider.getInstance().getPredefinedScopes(project, null, false, false, false, false, true)) {
            if (!(scope instanceof GlobalSearchScope) || !scope.getDisplayName().equals(scopeName)) continue;
            if (scope instanceof ScratchesSearchScope) {
                ScratchesSearchScope scratchesSearchScope = (ScratchesSearchScope)scope;
                if (scratchesSearchScope == null) {
                    ScopeChooserUtils.$$$reportNull$$$0(2);
                }
                return scratchesSearchScope;
            }
            return ScopeChooserUtils.intersectWithContentScope(project, (GlobalSearchScope)scope);
        }
        for (SearchScope scope : ChangeListsScopesProvider.getInstance(project).getFilteredScopes()) {
            if (!scope.getName().equals(scopeName)) continue;
            return ScopeChooserUtils.intersectWithContentScope(project, GlobalSearchScopesCore.filterScope((Project)project, (NamedScope)scope));
        }
        for (Iterator<Object> iterator2 : NamedScopesHolder.getAllNamedScopeHolders((Project)project)) {
            NamedScope[] scopes;
            for (NamedScope scope : scopes = iterator2.getEditableScopes()) {
                if (!scope.getName().equals(scopeName)) continue;
                return ScopeChooserUtils.intersectWithContentScope(project, GlobalSearchScopesCore.filterScope((Project)project, (NamedScope)scope));
            }
        }
        if (scopeName.startsWith("Module '") && scopeName.endsWith("'")) {
            GlobalSearchScope globalSearchScope = ProjectScope.getContentScope((Project)project);
            if (globalSearchScope == null) {
                ScopeChooserUtils.$$$reportNull$$$0(3);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
        if (globalSearchScope == null) {
            ScopeChooserUtils.$$$reportNull$$$0(4);
        }
        return globalSearchScope;
    }

    @NotNull
    private static GlobalSearchScope intersectWithContentScope(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            ScopeChooserUtils.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            ScopeChooserUtils.$$$reportNull$$$0(6);
        }
        GlobalSearchScope globalSearchScope = scope.intersectWith(ProjectScope.getContentScope((Project)project));
        if (globalSearchScope == null) {
            ScopeChooserUtils.$$$reportNull$$$0(7);
        }
        return globalSearchScope;
    }

    private static String getCurrentFileScopeName() {
        return IdeBundle.message((String)"scope.current.file", (Object[])new Object[0]);
    }

    private static String getOpenFilesScopeName() {
        return IdeBundle.message((String)"scope.open.files", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/scopeChooser/ScopeChooserUtils";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeChooserUtils";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findScopeByName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectWithContentScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findScopeByName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "intersectWithContentScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

