/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.codeInsight.hint.ImplementationViewComponent;
import com.intellij.codeInsight.hint.PsiImplementationViewElement;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.PropertyName;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageDuplicateResultsDialog
extends DialogWrapper {
    private final Project myProject;
    private final List<VirtualFile> myImages;
    private final Map<String, Set<VirtualFile>> myDuplicates;
    private final Tree myTree;
    private final TreeSpeedSearch mySpeedSearch;
    private final ResourceModules myResourceModules = new ResourceModules();

    public ImageDuplicateResultsDialog(Project project, List<VirtualFile> images, Map<String, Set<VirtualFile>> duplicates) {
        super(project);
        this.myProject = project;
        this.myImages = images;
        PropertiesComponent.getInstance((Project)this.myProject).loadFields((Object)this.myResourceModules);
        this.myDuplicates = duplicates;
        this.setModal(false);
        this.myTree = new Tree((TreeNode)new MyRootNode());
        this.myTree.setRootVisible(true);
        MyCellRenderer renderer = new MyCellRenderer();
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)renderer));
        this.mySpeedSearch = new TreeSpeedSearch(this.myTree, (Convertor<? super TreePath, String>)((Convertor)x -> renderer.getTreeCellRendererComponent((JTree)this.myTree, x.getLastPathComponent(), false, false, false, 0, false).toString()));
        this.init();
        TreeUtil.expandAll((JTree)this.myTree);
        this.setTitle("Image Duplicates");
        TreeUtil.promiseSelectFirst((JTree)this.myTree);
    }

    protected Action @NotNull [] createActions() {
        Action[] actions = new Action[4];
        actions[0] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        actions[0].putValue("Name", "Fix all");
        actions[0].putValue("DefaultAction", Boolean.TRUE);
        actions[0].putValue("FocusedAction", Boolean.TRUE);
        actions[1] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        actions[1].putValue("Name", "Fix selected");
        actions[2] = this.getCancelAction();
        actions[3] = this.getHelpAction();
        return new Action[0];
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        DataManager.registerDataProvider((JComponent)panel2, dataId -> {
            TreePath path = this.myTree.getSelectionPath();
            if (path != null) {
                Object component2 = path.getLastPathComponent();
                VirtualFile file2 = null;
                if (component2 instanceof MyFileNode) {
                    component2 = ((MyFileNode)component2).getParent();
                }
                if (component2 instanceof MyDuplicatesNode) {
                    file2 = (VirtualFile)((MyDuplicatesNode)component2).getUserObject().iterator().next();
                }
                if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                    return file2;
                }
                if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId) && file2 != null) {
                    return new VirtualFile[]{file2};
                }
            }
            return null;
        });
        JBList list2 = new JBList(new ResourceModules().getModuleNames());
        NotNullFunction modulesRenderer = dom -> new JLabel(dom instanceof Module ? ((Module)dom).getName() : dom.toString(), PlatformIcons.SOURCE_FOLDERS_ICON, 2);
        list2.installCellRenderer(modulesRenderer);
        JPanel modulesPanel = ToolbarDecorator.createDecorator((JList)list2).setAddAction(button2 -> {
            Object[] all = ModuleManager.getInstance((Project)this.myProject).getModules();
            Arrays.sort(all, (o1, o2) -> o1.getName().compareTo(o2.getName()));
            JBList modules = new JBList(all);
            modules.installCellRenderer(modulesRenderer);
            JBPopupFactory.getInstance().createListPopupBuilder((JList)modules).setTitle("Add Resource Module").setNamerForFiltering(o -> ((Module)o).getName()).setItemChoosenCallback(() -> {
                Object value2 = modules.getSelectedValue();
                if (value2 instanceof Module && !this.myResourceModules.contains((Module)value2)) {
                    this.myResourceModules.add((Module)value2);
                    ((DefaultListModel)list2.getModel()).addElement(((Module)value2).getName());
                }
                ((DefaultTreeModel)this.myTree.getModel()).reload();
                TreeUtil.expandAll((JTree)this.myTree);
            }).createPopup().show(button2.getPreferredPopupPoint());
        }).setRemoveAction(button2 -> {
            Object[] values2;
            for (Object value2 : values2 = list2.getSelectedValues()) {
                this.myResourceModules.remove((String)value2);
                ((DefaultListModel)list2.getModel()).removeElement(value2);
            }
            ((DefaultTreeModel)this.myTree.getModel()).reload();
            TreeUtil.expandAll((JTree)this.myTree);
        }).disableDownAction().disableUpAction().createPanel();
        modulesPanel.setPreferredSize(new Dimension(-1, 60));
        JPanel top = new JPanel(new BorderLayout());
        top.add((Component)new JLabel("Image modules:"), "North");
        top.add((Component)modulesPanel, "Center");
        panel2.add((Component)top, "North");
        panel2.add((Component)new JBScrollPane((Component)this.myTree), "Center");
        new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                PsiFile psiFile;
                VirtualFile file2;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((file2 = ImageDuplicateResultsDialog.this.getFileFromSelection()) != null && (psiFile = PsiManager.getInstance((Project)ImageDuplicateResultsDialog.this.myProject).findFile(file2)) != null) {
                    ImplementationViewComponent viewComponent = new ImplementationViewComponent(Collections.singletonList(new PsiImplementationViewElement((PsiElement)psiFile)), 0);
                    TreeSelectionListener listener2 = e1 -> {
                        PsiFile newElement;
                        VirtualFile selection = ImageDuplicateResultsDialog.this.getFileFromSelection();
                        if (selection != null && (newElement = PsiManager.getInstance((Project)ImageDuplicateResultsDialog.this.myProject).findFile(selection)) != null) {
                            viewComponent.update(Collections.singletonList(new PsiImplementationViewElement((PsiElement)newElement)), 0);
                        }
                    };
                    ImageDuplicateResultsDialog.this.myTree.addTreeSelectionListener(listener2);
                    JBPopup popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)viewComponent, viewComponent.getPreferredFocusableComponent()).setProject(ImageDuplicateResultsDialog.this.myProject).setDimensionServiceKey(ImageDuplicateResultsDialog.this.myProject, ImageDuplicateResultsDialog.class.getName(), false).setResizable(true).setMovable(true).setRequestFocus(false).setCancelCallback(() -> {
                        ImageDuplicateResultsDialog.this.myTree.removeTreeSelectionListener(listener2);
                        return true;
                    }).setTitle("Image Preview").createPopup();
                    Window window = ImageDuplicateResultsDialog.this.getWindow();
                    popup2.show(new RelativePoint((Component)window, new Point(window.getWidth(), 0)));
                    viewComponent.setHint(popup2, "Image Preview");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/ImageDuplicateResultsDialog$3", "actionPerformed"));
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ENTER"}), (JComponent)panel2);
        int total = this.myDuplicates.values().stream().mapToInt(Set::size).sum() - this.myDuplicates.size();
        JLabel label2 = new JLabel("<html>Press <b>Enter</b> to preview image<br>Total images found: " + this.myImages.size() + ". Total duplicates found: " + total + "</html>");
        panel2.add((Component)label2, "South");
        return panel2;
    }

    protected String getDimensionServiceKey() {
        return "image.duplicates.dialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    @Nullable
    private VirtualFile getFileFromSelection() {
        TreePath path = this.myTree.getSelectionPath();
        if (path != null) {
            Object component2 = path.getLastPathComponent();
            VirtualFile file2 = null;
            if (component2 instanceof MyFileNode) {
                component2 = ((MyFileNode)component2).getParent();
            }
            if (component2 instanceof MyDuplicatesNode) {
                file2 = (VirtualFile)((MyDuplicatesNode)component2).getUserObject().iterator().next();
            }
            return file2;
        }
        return null;
    }

    private static String getRelativePathToProject(Project project, VirtualFile file2) {
        String path = project.getBasePath();
        assert (path != null);
        String result2 = FileUtil.getRelativePath((String)path, (String)file2.getPath().replace('/', File.separatorChar), (char)File.separatorChar);
        assert (result2 != null);
        return result2;
    }

    static class ResourceModules {
        @PropertyName(value="resource.modules", defaultValue="icons")
        public String modules;

        ResourceModules() {
        }

        public List<String> getModuleNames() {
            return Arrays.asList(StringUtil.splitByLines((String)(this.modules == null ? "icons" : this.modules)));
        }

        public boolean contains(Module module) {
            return this.getModuleNames().contains(module.getName());
        }

        public void add(Module module) {
            this.modules = StringUtil.isEmpty((String)this.modules) ? module.getName() : this.modules + "\n" + module.getName();
        }

        public void remove(String value2) {
            ArrayList<String> names2 = new ArrayList<String>(this.getModuleNames());
            names2.remove(value2);
            this.modules = StringUtil.join(names2, (String)"\n");
        }
    }

    private class MyCellRenderer
    extends ColoredTreeCellRenderer {
        private MyCellRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                MyCellRenderer.$$$reportNull$$$0(0);
            }
            if (value2 instanceof MyFileNode) {
                VirtualFile file2 = ((MyFileNode)value2).getUserObject();
                Module module = ModuleUtil.findModuleForFile((VirtualFile)file2, (Project)ImageDuplicateResultsDialog.this.myProject);
                if (module != null) {
                    this.setIcon(PlatformIcons.CONTENT_ROOT_ICON_CLOSED);
                    SearchUtil.appendFragments(ImageDuplicateResultsDialog.this.mySpeedSearch.getEnteredPrefix(), "[" + module.getName() + "] ", 1, UIUtil.getTreeForeground(), UIUtil.getTreeBackground(), (SimpleColoredComponent)this);
                }
                SearchUtil.appendFragments(ImageDuplicateResultsDialog.this.mySpeedSearch.getEnteredPrefix(), ImageDuplicateResultsDialog.getRelativePathToProject(ImageDuplicateResultsDialog.this.myProject, file2), 0, UIUtil.getTreeForeground(), UIUtil.getTreeBackground(), (SimpleColoredComponent)this);
            } else if (value2 instanceof MyDuplicatesNode) {
                Object files2 = ((MyDuplicatesNode)value2).getUserObject();
                Iterator iterator2 = files2.iterator();
                while (iterator2.hasNext()) {
                    VirtualFile file3 = (VirtualFile)iterator2.next();
                    Module module = ModuleUtil.findModuleForFile((VirtualFile)file3, (Project)ImageDuplicateResultsDialog.this.myProject);
                    if (module == null || !ImageDuplicateResultsDialog.this.myResourceModules.contains(module)) continue;
                    this.append("Icons can be replaced to ");
                    this.append(ImageDuplicateResultsDialog.getRelativePathToProject(ImageDuplicateResultsDialog.this.myProject, file3), new SimpleTextAttributes(1, ColorUtil.fromHex((String)"008000")));
                    return;
                }
                this.append("Icon conflict");
            } else if (value2 instanceof MyRootNode) {
                this.append("All conflicts");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/internal/ImageDuplicateResultsDialog$MyCellRenderer", "customizeCellRenderer"));
        }
    }

    private static class MyFileNode
    extends DefaultMutableTreeNode {
        MyFileNode(DefaultMutableTreeNode node, VirtualFile file2) {
            super(file2);
            this.setParent(node);
        }

        public VirtualFile getUserObject() {
            return (VirtualFile)super.getUserObject();
        }
    }

    private static class MyDuplicatesNode
    extends DefaultMutableTreeNode {
        MyDuplicatesNode(DefaultMutableTreeNode node, Set<? extends VirtualFile> files2) {
            super(files2);
            this.setParent(node);
            this.children = files2.stream().map(file2 -> new MyFileNode(this, (VirtualFile)file2)).collect(Collectors.toCollection(Vector::new));
        }

        @Override
        public Set<VirtualFile> getUserObject() {
            return (Set)super.getUserObject();
        }
    }

    private class MyRootNode
    extends DefaultMutableTreeNode {
        private MyRootNode() {
            this.children = ImageDuplicateResultsDialog.this.myDuplicates.values().stream().map(files2 -> new MyDuplicatesNode(this, (Set<? extends VirtualFile>)files2)).collect(Collectors.toCollection(Vector::new));
        }
    }
}

