/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.search.searchTask;

import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.largeFilesEditor.Utils;
import com.intellij.largeFilesEditor.search.Position;
import com.intellij.largeFilesEditor.search.SearchResult;
import com.intellij.largeFilesEditor.search.searchTask.SearchTaskOptions;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

class FrameSearcher {
    static char NOT_EXISTING_BORDERING_SYMBOL = (char)10;
    static char ELLIPSIS = (char)8230;
    private final SmartStringSearcher smartStringSearcher;
    private final SearchTaskOptions options;
    private final FindModel ijFindModel;
    private final Position resultStartPos;
    private final Position resultEndPos;
    private long curPageNumber;
    private String curPageText;
    private String tailText;
    private char beforeFrameStartSymbol;
    private char afterFrameEndSymbol;

    FrameSearcher(SearchTaskOptions options, SmartStringSearcher smartStringSearcher) {
        this.smartStringSearcher = smartStringSearcher;
        this.options = options;
        this.ijFindModel = options.generateFindModel();
        this.resultStartPos = new Position();
        this.resultEndPos = new Position();
    }

    void setFrame(long curPageNumber, char beforeFrameStartSymbol, String curPageText, String tailText, char afterFrameEndSymbol) {
        this.curPageNumber = curPageNumber;
        this.beforeFrameStartSymbol = beforeFrameStartSymbol;
        this.curPageText = curPageText;
        this.tailText = tailText;
        this.afterFrameEndSymbol = afterFrameEndSymbol;
    }

    @NotNull
    ArrayList<SearchResult> findAllMatchesAtFrame() {
        boolean isNeedAfterFrameEndSymbol;
        String frameText = this.beforeFrameStartSymbol + this.curPageText + this.tailText;
        boolean bl = isNeedAfterFrameEndSymbol = !this.options.regularExpression && this.options.wholeWords;
        if (isNeedAfterFrameEndSymbol) {
            frameText = frameText + this.afterFrameEndSymbol;
        }
        int offset = 1;
        ArrayList<SearchResult> resultsList = new ArrayList<SearchResult>();
        while (true) {
            FindResult ijFindResult;
            if (!(ijFindResult = this.smartStringSearcher.findString(frameText, offset, this.ijFindModel)).isStringFound()) {
                ArrayList<SearchResult> arrayList = resultsList;
                if (arrayList == null) {
                    FrameSearcher.$$$reportNull$$$0(0);
                }
                return arrayList;
            }
            this.calculateAndResetStartResultPosition(this.resultStartPos, ijFindResult);
            this.calculateAndResetEndResultPosition(this.resultEndPos, ijFindResult);
            String contextPrefix = FrameSearcher.calculateContextPrefix(frameText, ijFindResult, this.options);
            String foundString = FrameSearcher.calculateFoundString(frameText, ijFindResult);
            String contextPostfix = FrameSearcher.calculateContextPostfix(frameText, ijFindResult, this.options);
            if (this.resultStartPos.pageNumber != this.curPageNumber || isNeedAfterFrameEndSymbol && ijFindResult.getEndOffset() == frameText.length()) {
                ArrayList<SearchResult> arrayList = resultsList;
                if (arrayList == null) {
                    FrameSearcher.$$$reportNull$$$0(1);
                }
                return arrayList;
            }
            resultsList.add(new SearchResult(this.resultStartPos.pageNumber, this.resultStartPos.symbolOffsetInPage, this.resultEndPos.pageNumber, this.resultEndPos.symbolOffsetInPage, contextPrefix, Utils.cutToMaxLength(foundString, 100), contextPostfix));
            offset = ijFindResult.getEndOffset();
        }
    }

    private static String calculateFoundString(String frameText, FindResult ijFindResult) {
        return frameText.substring(ijFindResult.getStartOffset(), ijFindResult.getEndOffset());
    }

    private static String calculateContextPrefix(String frameText, FindResult ijFindResult, SearchTaskOptions options) {
        char _char;
        int contextStartOffset = ijFindResult.getStartOffset();
        int minAllowedContextStartOffset = ijFindResult.getStartOffset() - options.contextOneSideLength;
        if (minAllowedContextStartOffset < 0) {
            minAllowedContextStartOffset = 0;
        }
        while (contextStartOffset > minAllowedContextStartOffset && (_char = frameText.charAt(contextStartOffset - 1)) != '\r' && _char != '\n') {
            --contextStartOffset;
        }
        boolean ellipsis = false;
        if (contextStartOffset > 0 && (_char = frameText.charAt(contextStartOffset - 1)) != '\n' && _char != '\r') {
            ellipsis = true;
        }
        String str = frameText.substring(contextStartOffset, ijFindResult.getStartOffset());
        str = str.replace('\t', ' ');
        if (ellipsis) {
            str = ELLIPSIS + str;
        }
        return str;
    }

    private static String calculateContextPostfix(String frameText, FindResult ijFindResult, SearchTaskOptions options) {
        char _char;
        int contextEndOffset = ijFindResult.getEndOffset();
        int maxAllowedContextEndOffset = ijFindResult.getEndOffset() + options.contextOneSideLength;
        if (maxAllowedContextEndOffset > frameText.length()) {
            maxAllowedContextEndOffset = frameText.length();
        }
        while (contextEndOffset < maxAllowedContextEndOffset && (_char = frameText.charAt(contextEndOffset)) != '\r' && _char != '\n') {
            ++contextEndOffset;
        }
        boolean ellipsis = false;
        if (contextEndOffset < frameText.length() && (_char = frameText.charAt(contextEndOffset)) != '\n' && _char != '\r') {
            ellipsis = true;
        }
        String str = frameText.substring(ijFindResult.getEndOffset(), contextEndOffset);
        str = str.replace('\t', ' ');
        if (ellipsis) {
            str = str + ELLIPSIS;
        }
        return str;
    }

    private void calculateAndResetStartResultPosition(Position resultStartPos, FindResult ijFindResult) {
        if (ijFindResult.getStartOffset() - 1 < this.curPageText.length()) {
            resultStartPos.pageNumber = this.curPageNumber;
            resultStartPos.symbolOffsetInPage = ijFindResult.getStartOffset() - 1;
        } else {
            resultStartPos.pageNumber = this.curPageNumber + 1L;
            resultStartPos.symbolOffsetInPage = ijFindResult.getStartOffset() - this.curPageText.length() - 1;
        }
    }

    private void calculateAndResetEndResultPosition(Position resultEndPos, FindResult ijFindResult) {
        if (ijFindResult.getEndOffset() - 1 <= this.curPageText.length()) {
            resultEndPos.pageNumber = this.curPageNumber;
            resultEndPos.symbolOffsetInPage = ijFindResult.getEndOffset() - 1;
        } else {
            resultEndPos.pageNumber = this.curPageNumber + 1L;
            resultEndPos.symbolOffsetInPage = ijFindResult.getEndOffset() - this.curPageText.length() - 1;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/largeFilesEditor/search/searchTask/FrameSearcher", "findAllMatchesAtFrame"));
    }

    public static interface SmartStringSearcher {
        public FindResult findString(String var1, int var2, FindModel var3);
    }
}

