/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.navigation;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.searcheverywhere.SymbolSearchEverywhereContributor;
import com.intellij.navigation.JBProtocolNavigateCommand;
import com.intellij.navigation.JBProtocolNavigateCommandKt;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.StatusBarProgress;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.PsiNavigateUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u001a$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0010H\u0002\u001a,\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u001a,\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0001H\u0002\u001a.\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u001a0\u00192\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0010H\u0002\u001a$\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u001aH\u0002\u001a$\u0010\u001d\u001a\u00020\f2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"COLUMN_GROUP", "", "FILE_PROTOCOL", "LINE_GROUP", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PATH_GROUP", "PATH_WITH_LOCATION", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "findAndNavigateToReference", "", "project", "Lcom/intellij/openapi/project/Project;", "parameters", "", "navigateByFqn", "reference", "navigateByPath", "pathText", "parsePosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "range", "parseSelections", "", "Lkotlin/Pair;", "setSelection", "selection", "setSelections", "intellij.platform.lang.impl"})
public final class JBProtocolNavigateCommandKt {
    private static final Logger LOG;
    private static final String FILE_PROTOCOL = "file://";
    private static final String PATH_GROUP = "path";
    private static final String LINE_GROUP = "line";
    private static final String COLUMN_GROUP = "column";
    private static final Pattern PATH_WITH_LOCATION;

    private static final void findAndNavigateToReference(Project project, Map<String, String> parameters) {
        Map<String, String> map2 = parameters;
        boolean bl = false;
        for (Map.Entry<String, String> it : map2.entrySet()) {
            if (!StringsKt.startsWith$default((String)it.getKey(), (String)"fqn", (boolean)false, (int)2, null)) continue;
            JBProtocolNavigateCommandKt.navigateByFqn(project, parameters, it.getValue());
        }
        map2 = parameters;
        bl = false;
        for (Map.Entry<String, String> it : map2.entrySet()) {
            if (!StringsKt.startsWith$default((String)it.getKey(), (String)PATH_GROUP, (boolean)false, (int)2, null)) continue;
            JBProtocolNavigateCommandKt.navigateByPath(project, parameters, it.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void navigateByPath(Project project, Map<String, String> parameters, String pathText) {
        int n;
        int n2;
        int n3;
        boolean bl;
        CaretModel caretModel;
        Editor editor;
        void $this$filterIsInstanceTo$iv$iv;
        Matcher matcher = PATH_WITH_LOCATION.matcher(pathText);
        if (!matcher.matches()) {
            return;
        }
        String path = matcher.group(PATH_GROUP);
        String line = matcher.group(LINE_GROUP);
        String column = matcher.group(COLUMN_GROUP);
        if (path == null) {
            return;
        }
        if (!FileUtil.isAbsolute((String)(path = FileUtil.expandUserHome((String)path)))) {
            path = new File(project.getBasePath(), path).getAbsolutePath();
        }
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(FILE_PROTOCOL + path);
        if (virtualFile == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"VirtualFileManager.getIn\u2026ROTOCOL + path) ?: return");
        VirtualFile virtualFile2 = virtualFile;
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)project).openFile(virtualFile2, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorArray, (String)"FileEditorManager.getIns\u2026enFile(virtualFile, true)");
        FileEditor[] $this$filterIsInstance$iv = fileEditorArray;
        boolean $i$f$filterIsInstance = false;
        FileEditor[] fileEditorArray2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TextEditor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object object = CollectionsKt.first((List)((List)destination$iv$iv));
        boolean bl2 = false;
        boolean bl3 = false;
        TextEditor textEditor = (TextEditor)object;
        boolean bl4 = false;
        Editor editor2 = textEditor.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"textEditor.editor");
        Editor editor3 = editor2;
        CaretModel caretModel2 = editor3.getCaretModel();
        Editor editor4 = editor3;
        String string = line;
        if (string != null) {
            String string2 = string;
            editor = editor4;
            caretModel = caretModel2;
            bl = false;
            n3 = Integer.parseInt(string2);
            caretModel2 = caretModel;
            editor4 = editor;
            n2 = n3;
        } else {
            n2 = 0;
        }
        String string3 = column;
        if (string3 != null) {
            String string4 = string3;
            n3 = n2;
            editor = editor4;
            caretModel = caretModel2;
            bl = false;
            int n4 = Integer.parseInt(string4);
            caretModel2 = caretModel;
            editor4 = editor;
            n2 = n3;
            n = n4;
        } else {
            n = 0;
        }
        int n5 = n;
        int n6 = n2;
        caretModel2.moveToOffset(editor4.logicalPositionToOffset(new LogicalPosition(n6, n5)));
        JBProtocolNavigateCommandKt.setSelections(parameters, project);
    }

    private static final void navigateByFqn(Project project, Map<String, String> parameters, String reference2) {
        String string;
        block3: {
            block2: {
                string = parameters.get("__fragment");
                if (string == null) break block2;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                string = reference2 + '#' + it;
                if (string != null) break block3;
            }
            string = reference2;
        }
        String fqn = string;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, fqn, parameters, project, IdeBundle.message((String)"navigate.command.search.reference.progress.title", (Object[])new Object[]{fqn}), true){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $fqn;
            final /* synthetic */ Map $parameters;

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                void $this$filterIsInstanceTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                DataContext dataContext = SimpleDataContext.getProjectContext(this.$project);
                Intrinsics.checkExpressionValueIsNotNull((Object)dataContext, (String)"SimpleDataContext.getProjectContext(project)");
                DataContext dataContext2 = dataContext;
                SymbolSearchEverywhereContributor symbolSearchEverywhereContributor = new SymbolSearchEverywhereContributor(AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext2));
                ProgressManager progressManager = ProgressManager.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
                ProgressIndicator progressIndicator2 = progressManager.getProgressIndicator();
                if (progressIndicator2 == null) {
                    progressIndicator2 = new StatusBarProgress();
                }
                List list2 = symbolSearchEverywhereContributor.search(this.$fqn, progressIndicator2);
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"SymbolSearchEverywhereCo\u2026r ?: StatusBarProgress())");
                Iterable $this$filterIsInstance$iv = list2;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof PsiElement)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    ApplicationManager.getApplication().invokeLater(new Runnable(it, this){
                        final /* synthetic */ PsiElement $it;
                        final /* synthetic */ navigateByFqn.1 this$0;
                        {
                            this.$it = psiElement;
                            this.this$0 = var2_2;
                        }

                        public final void run() {
                            PsiNavigateUtil.navigate((PsiElement)this.$it);
                            JBProtocolNavigateCommandKt.access$setSelections(this.this$0.$parameters, this.this$0.$project);
                        }
                    });
                }
            }

            public boolean shouldStartInBackground() {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                return !application.isUnitTestMode();
            }

            public boolean isConditionalModal() {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                return !application.isUnitTestMode();
            }
            {
                this.$project = $captured_local_variable$0;
                this.$fqn = $captured_local_variable$1;
                this.$parameters = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        });
    }

    private static final void setSelections(Map<String, String> parameters, Project project) {
        Iterable $this$forEach$iv = JBProtocolNavigateCommandKt.parseSelections(parameters);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair selection = (Pair)element$iv;
            boolean bl = false;
            JBProtocolNavigateCommandKt.setSelection(project, (Pair<? extends LogicalPosition, ? extends LogicalPosition>)selection);
        }
    }

    private static final void setSelection(Project project, Pair<? extends LogicalPosition, ? extends LogicalPosition> selection) {
        block0: {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorManager, (String)"FileEditorManager.getInstance(project)");
            Editor editor = fileEditorManager.getSelectedTextEditor();
            Editor editor2 = editor;
            if (editor2 == null || (editor2 = editor2.getSelectionModel()) == null) break block0;
            editor2.setSelection(editor.logicalPositionToOffset((LogicalPosition)selection.getFirst()), editor.logicalPositionToOffset((LogicalPosition)selection.getSecond()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Pair<LogicalPosition, LogicalPosition>> parseSelections(Map<String, String> parameters) {
        void $this$mapNotNullTo$iv$iv;
        Map<String, String> $this$filterKeys$iv = parameters;
        boolean $i$f$filterKeys = false;
        Object result$iv = new LinkedHashMap();
        Map<String, String> map2 = $this$filterKeys$iv;
        boolean bl = false;
        for (Map.Entry<String, String> entry$iv : map2.entrySet()) {
            String it = entry$iv.getKey();
            boolean bl2 = false;
            if (!StringsKt.startsWith$default((String)it, (String)"selection", (boolean)false, (int)2, null)) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Iterable $this$mapNotNull$iv = ((Map)result$iv).values();
        boolean $i$f$mapNotNull = false;
        result$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl3 = false;
            String it = (String)element$iv$iv;
            boolean bl4 = false;
            List split = StringsKt.split$default((CharSequence)it, (char[])new char[]{'-'}, (boolean)false, (int)0, (int)6, null);
            if (split.size() != 2) {
                pair = null;
            } else {
                LogicalPosition position1 = JBProtocolNavigateCommandKt.parsePosition((String)split.get(0));
                LogicalPosition position2 = JBProtocolNavigateCommandKt.parsePosition((String)split.get(1));
                pair = position1 != null && position2 != null ? new Pair((Object)position1, (Object)position1) : null;
            }
            if (pair == null) continue;
            Pair pair2 = pair;
            boolean bl5 = false;
            boolean bl6 = false;
            Pair it$iv$iv = pair2;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final LogicalPosition parsePosition(String range2) {
        List position = StringsKt.split$default((CharSequence)range2, (char[])new char[]{':'}, (boolean)false, (int)0, (int)6, null);
        if (position.size() != 2) {
            return null;
        }
        try {
            return new LogicalPosition(Integer.parseInt((String)position.get(0)), Integer.parseInt((String)position.get(1)));
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JBProtocolNavigateCommand.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        PATH_WITH_LOCATION = Pattern.compile("(?<path>[^:]*)(:(?<line>[\\d]+))?(:(?<column>[\\d]+))?");
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ void access$findAndNavigateToReference(Project project, Map parameters) {
        JBProtocolNavigateCommandKt.findAndNavigateToReference(project, parameters);
    }

    public static final /* synthetic */ void access$setSelections(Map parameters, Project project) {
        JBProtocolNavigateCommandKt.setSelections(parameters, project);
    }
}

