/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.impl.FlushQueue;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.UIUtil;
import java.awt.Dialog;
import java.awt.Window;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaterInvocator {
    private static final Logger LOG = Logger.getInstance(LaterInvocator.class);
    private static final List<Object> ourModalEntities = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final Map<Project, List<Dialog>> projectToModalEntities = ContainerUtil.createWeakMap();
    private static final Map<Project, Stack<ModalityState>> projectToModalEntitiesStack = ContainerUtil.createWeakMap();
    private static final Stack<ModalityStateEx> ourModalityStack = new Stack((Object[])new ModalityStateEx[]{(ModalityStateEx)ModalityState.NON_MODAL});
    private static final EventDispatcher<ModalityStateListener> ourModalityStateMulticaster = EventDispatcher.create(ModalityStateListener.class);
    private static final Executor ourWriteThreadExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Write Thread", (int)1);
    private static final FlushQueue ourEdtQueue = new FlushQueue(SwingUtilities::invokeLater);
    private static final FlushQueue ourWtQueue = new FlushQueue(r -> ourWriteThreadExecutor.execute(() -> ApplicationManager.getApplication().runIntendedWriteActionOnCurrentThread(r)));
    private static final ConcurrentMap<Window, ModalityStateEx> ourWindowModalities = ContainerUtil.createConcurrentWeakMap();
    static final AtomicBoolean FLUSHER_SCHEDULED = new AtomicBoolean(false);
    private static final AtomicInteger THREAD_TO_FLUSH = new AtomicInteger(0);

    private LaterInvocator() {
    }

    public static void addModalityStateListener(@NotNull ModalityStateListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            LaterInvocator.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            LaterInvocator.$$$reportNull$$$0(1);
        }
        if (!ourModalityStateMulticaster.getListeners().contains(listener2)) {
            ourModalityStateMulticaster.addListener((EventListener)listener2, parentDisposable);
        }
    }

    @NotNull
    static ModalityStateEx modalityStateForWindow(@NotNull Window window) {
        if (window == null) {
            LaterInvocator.$$$reportNull$$$0(2);
        }
        ModalityStateEx modalityStateEx = ourWindowModalities.computeIfAbsent(window, __ -> {
            Stack<ModalityStateEx> stack = ourModalityStack;
            synchronized (stack) {
                for (ModalityStateEx state : ourModalityStack) {
                    if (!state.getModalEntities().contains(window)) continue;
                    return state;
                }
            }
            Window owner = window.getOwner();
            ModalityStateEx ownerState = owner == null ? (ModalityStateEx)ModalityState.NON_MODAL : LaterInvocator.modalityStateForWindow(owner);
            return LaterInvocator.isModalDialog(window) ? ownerState.appendEntity(window) : ownerState;
        });
        if (modalityStateEx == null) {
            LaterInvocator.$$$reportNull$$$0(3);
        }
        return modalityStateEx;
    }

    private static boolean isModalDialog(@NotNull Object window) {
        if (window == null) {
            LaterInvocator.$$$reportNull$$$0(4);
        }
        return window instanceof Dialog && ((Dialog)window).isModal();
    }

    @NotNull
    static ActionCallback invokeLater(@NotNull Runnable runnable2, @NotNull Condition<?> expired, boolean onEdt) {
        if (runnable2 == null) {
            LaterInvocator.$$$reportNull$$$0(5);
        }
        if (expired == null) {
            LaterInvocator.$$$reportNull$$$0(6);
        }
        ModalityState modalityState = ModalityState.defaultModalityState();
        return LaterInvocator.invokeLater(runnable2, modalityState, expired, onEdt);
    }

    @NotNull
    static ActionCallback invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState modalityState, boolean onEdt) {
        if (runnable2 == null) {
            LaterInvocator.$$$reportNull$$$0(7);
        }
        if (modalityState == null) {
            LaterInvocator.$$$reportNull$$$0(8);
        }
        return LaterInvocator.invokeLater(runnable2, modalityState, Conditions.alwaysFalse(), onEdt);
    }

    @NotNull
    static ActionCallback invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState modalityState, @NotNull Condition<?> expired, boolean onEdt) {
        if (runnable2 == null) {
            LaterInvocator.$$$reportNull$$$0(9);
        }
        if (modalityState == null) {
            LaterInvocator.$$$reportNull$$$0(10);
        }
        if (expired == null) {
            LaterInvocator.$$$reportNull$$$0(11);
        }
        ActionCallback callback2 = new ActionCallback();
        LaterInvocator.invokeLaterWithCallback(runnable2, modalityState, expired, callback2, onEdt);
        ActionCallback actionCallback = callback2;
        if (actionCallback == null) {
            LaterInvocator.$$$reportNull$$$0(12);
        }
        return actionCallback;
    }

    static void invokeLaterWithCallback(@NotNull Runnable runnable2, @NotNull ModalityState modalityState, @NotNull Condition<?> expired, @Nullable ActionCallback callback2, boolean onEdt) {
        if (runnable2 == null) {
            LaterInvocator.$$$reportNull$$$0(13);
        }
        if (modalityState == null) {
            LaterInvocator.$$$reportNull$$$0(14);
        }
        if (expired == null) {
            LaterInvocator.$$$reportNull$$$0(15);
        }
        if (expired.value(null)) {
            if (callback2 != null) {
                callback2.setRejected();
            }
            return;
        }
        FlushQueue.RunnableInfo runnableInfo = new FlushQueue.RunnableInfo(runnable2, modalityState, expired, callback2);
        LaterInvocator.getRunnableQueue(onEdt).push(runnableInfo);
        LaterInvocator.requestFlush();
    }

    static void invokeAndWait(final @NotNull Runnable runnable2, @NotNull ModalityState modalityState, boolean onEdt) {
        if (runnable2 == null) {
            LaterInvocator.$$$reportNull$$$0(16);
        }
        if (modalityState == null) {
            LaterInvocator.$$$reportNull$$$0(17);
        }
        LOG.assertTrue(!LaterInvocator.isDispatchThread());
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final Ref exception = Ref.create();
        Runnable runnable1 = new Runnable(){

            @Override
            public void run() {
                try {
                    runnable2.run();
                }
                catch (Throwable e) {
                    exception.set((Object)e);
                }
                finally {
                    semaphore.up();
                }
            }

            @NonNls
            public String toString() {
                return "InvokeAndWait[" + runnable2 + "]";
            }
        };
        LaterInvocator.invokeLaterWithCallback(runnable1, modalityState, Conditions.alwaysFalse(), null, onEdt);
        semaphore.waitFor();
        if (!exception.isNull()) {
            Throwable cause = (Throwable)exception.get();
            if (SystemProperties.getBooleanProperty((String)"invoke.later.wrap.error", (boolean)true)) {
                throw new RuntimeException(cause);
            }
            ExceptionUtil.rethrow((Throwable)cause);
        }
    }

    public static void enterModal(@NotNull Object modalEntity) {
        if (modalEntity == null) {
            LaterInvocator.$$$reportNull$$$0(18);
        }
        ModalityStateEx state = LaterInvocator.getCurrentModalityState().appendEntity(modalEntity);
        if (LaterInvocator.isModalDialog(modalEntity)) {
            List<Object> currentEntities = state.getModalEntities();
            state = LaterInvocator.modalityStateForWindow((Window)modalEntity);
            state.forceModalEntities(currentEntities);
        }
        LaterInvocator.enterModal(modalEntity, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enterModal(@NotNull Object modalEntity, @NotNull ModalityStateEx appendedState) {
        TransactionGuardImpl guard;
        if (modalEntity == null) {
            LaterInvocator.$$$reportNull$$$0(19);
        }
        if (appendedState == null) {
            LaterInvocator.$$$reportNull$$$0(20);
        }
        LOG.assertTrue(LaterInvocator.isWriteThread(), (Object)"enterModal() should be invoked in write thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("enterModal:" + modalEntity);
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(true);
        ourModalEntities.add(modalEntity);
        Stack<ModalityStateEx> stack = ourModalityStack;
        synchronized (stack) {
            ourModalityStack.push((Object)appendedState);
        }
        TransactionGuardImpl transactionGuardImpl = guard = LoadingState.COMPONENTS_LOADED.isOccurred() ? (TransactionGuardImpl)TransactionGuard.getInstance() : null;
        if (guard != null) {
            guard.enteredModality(appendedState);
        }
        LaterInvocator.reincludeSkippedItems();
        LaterInvocator.requestFlush();
    }

    public static void enterModal(Project project, Dialog dialog2) {
        LOG.assertTrue(LaterInvocator.isDispatchThread(), (Object)"enterModal() should be invoked in event-dispatch thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("enterModal:" + dialog2.getName() + " ; for project: " + project.getName());
        }
        if (project == null) {
            LaterInvocator.enterModal(dialog2);
            return;
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(true);
        List<Dialog> modalEntitiesList = projectToModalEntities.getOrDefault(project, ContainerUtil.createLockFreeCopyOnWriteList());
        projectToModalEntities.put(project, modalEntitiesList);
        modalEntitiesList.add(dialog2);
        Stack<ModalityState> modalEntitiesStack = projectToModalEntitiesStack.getOrDefault(project, (Stack<ModalityState>)new Stack((Object[])new ModalityState[]{ModalityState.NON_MODAL}));
        projectToModalEntitiesStack.put(project, modalEntitiesStack);
        modalEntitiesStack.push((Object)new ModalityStateEx(ArrayUtil.toObjectArray(ourModalEntities)));
    }

    @ApiStatus.Internal
    public static void markTransparent(@NotNull ModalityState state) {
        if (state == null) {
            LaterInvocator.$$$reportNull$$$0(21);
        }
        ((ModalityStateEx)state).markTransparent();
        LaterInvocator.reincludeSkippedItems();
        LaterInvocator.requestFlush();
    }

    public static void leaveModal(Project project, Dialog dialog2) {
        LOG.assertTrue(LaterInvocator.isWriteThread(), (Object)"leaveModal() should be invoked in write thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("leaveModal:" + dialog2.getName() + " ; for project: " + project.getName());
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(false);
        int index = ourModalEntities.indexOf(dialog2);
        if (index != -1) {
            LaterInvocator.removeModality(dialog2, index);
        } else if (project != null) {
            List<Dialog> dialogs = projectToModalEntities.get(project);
            int perProjectIndex = dialogs.indexOf(dialog2);
            LOG.assertTrue(perProjectIndex >= 0);
            dialogs.remove(perProjectIndex);
            Stack<ModalityState> states = projectToModalEntitiesStack.get(project);
            states.remove(perProjectIndex + 1);
            for (int i = 1; i < states.size(); ++i) {
                ((ModalityStateEx)((Object)states.get(i))).removeModality(dialog2);
            }
        }
        LaterInvocator.reincludeSkippedItems();
        LaterInvocator.requestFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeModality(@NotNull Object modalEntity, int index) {
        if (modalEntity == null) {
            LaterInvocator.$$$reportNull$$$0(22);
        }
        ourModalEntities.remove(index);
        Stack<ModalityStateEx> stack = ourModalityStack;
        synchronized (stack) {
            ourModalityStack.remove(index + 1);
            for (int i = 1; i < ourModalityStack.size(); ++i) {
                ((ModalityStateEx)((Object)ourModalityStack.get(i))).removeModality(modalEntity);
            }
        }
        ModalityStateEx.unmarkTransparent(modalEntity);
    }

    public static void leaveModal(@NotNull Object modalEntity) {
        if (modalEntity == null) {
            LaterInvocator.$$$reportNull$$$0(23);
        }
        LOG.assertTrue(LaterInvocator.isWriteThread(), (Object)"leaveModal() should be invoked in write thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("leaveModal:" + modalEntity);
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(false);
        int index = ourModalEntities.indexOf(modalEntity);
        LOG.assertTrue(index >= 0);
        LaterInvocator.removeModality(modalEntity, index);
        LaterInvocator.reincludeSkippedItems();
        LaterInvocator.requestFlush();
    }

    public static void leaveAllModals() {
        while (!ourModalEntities.isEmpty()) {
            LaterInvocator.leaveModal(ourModalEntities.get(ourModalEntities.size() - 1));
        }
        LOG.assertTrue(LaterInvocator.getCurrentModalityState() == ModalityState.NON_MODAL, (Object)LaterInvocator.getCurrentModalityState());
        LaterInvocator.reincludeSkippedItems();
        LaterInvocator.requestFlush();
    }

    public static Object @NotNull [] getCurrentModalEntities() {
        ApplicationManager.getApplication().assertIsWriteThread();
        Object[] objectArray = ArrayUtil.toObjectArray(ourModalEntities);
        if (objectArray == null) {
            LaterInvocator.$$$reportNull$$$0(24);
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static ModalityStateEx getCurrentModalityState() {
        if (!SwingUtilities.isEventDispatchThread()) {
            ApplicationManager.getApplication().assertIsWriteThread();
        }
        Stack<ModalityStateEx> stack = ourModalityStack;
        // MONITORENTER : stack
        ModalityStateEx modalityStateEx = (ModalityStateEx)((Object)ourModalityStack.peek());
        // MONITOREXIT : stack
        if (modalityStateEx != null) return modalityStateEx;
        LaterInvocator.$$$reportNull$$$0(25);
        return modalityStateEx;
    }

    public static boolean isInModalContextForProject(Project project) {
        LOG.assertTrue(LaterInvocator.isWriteThread());
        if (ourModalEntities.isEmpty()) {
            return false;
        }
        List<Dialog> modalEntitiesForProject = projectToModalEntities.get(project);
        return modalEntitiesForProject == null || modalEntitiesForProject.isEmpty();
    }

    public static boolean isInModalContext() {
        return LaterInvocator.isInModalContextForProject(null);
    }

    private static boolean isDispatchThread() {
        return ApplicationManager.getApplication().isDispatchThread();
    }

    private static boolean isWriteThread() {
        return ApplicationManager.getApplication().isWriteThread();
    }

    private static FlushQueue getRunnableQueue(boolean onEdt) {
        return onEdt ? ourEdtQueue : ourWtQueue;
    }

    static void requestFlush() {
        if (FLUSHER_SCHEDULED.compareAndSet(false, true)) {
            int whichThread = THREAD_TO_FLUSH.getAndUpdate(operand -> operand ^ 1);
            FlushQueue firstQueue = LaterInvocator.getRunnableQueue(whichThread == 0);
            if (firstQueue.mayHaveItems()) {
                firstQueue.scheduleFlush();
                return;
            }
            FlushQueue secondQueue = LaterInvocator.getRunnableQueue(whichThread != 0);
            if (secondQueue.mayHaveItems()) {
                secondQueue.scheduleFlush();
                return;
            }
            FLUSHER_SCHEDULED.set(false);
        }
    }

    public static void pollWriteThreadEventsOnce() {
        LOG.assertTrue(!SwingUtilities.isEventDispatchThread());
        LOG.assertTrue(ApplicationManager.getApplication().isWriteThread());
        ourWtQueue.flushNow();
    }

    public static boolean ensureFlushRequested() {
        if (ourEdtQueue.getNextEvent(false) != null) {
            ourEdtQueue.scheduleFlush();
            return true;
        }
        if (ourWtQueue.getNextEvent(false) != null) {
            ourWtQueue.scheduleFlush();
            return true;
        }
        return false;
    }

    public static Collection<FlushQueue.RunnableInfo> getLaterInvocatorEdtQueue() {
        return ourEdtQueue.getQueue();
    }

    @NotNull
    public static Collection<FlushQueue.RunnableInfo> getLaterInvocatorWtQueue() {
        Collection<FlushQueue.RunnableInfo> collection = ourWtQueue.getQueue();
        if (collection == null) {
            LaterInvocator.$$$reportNull$$$0(26);
        }
        return collection;
    }

    private static void reincludeSkippedItems() {
        ourEdtQueue.reincludeSkippedItems();
        ourWtQueue.reincludeSkippedItems();
    }

    public static void purgeExpiredItems() {
        ourEdtQueue.purgeExpiredItems();
        ourWtQueue.purgeExpiredItems();
    }

    public static void dispatchPendingFlushes() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Must call from EDT");
        }
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        LaterInvocator.invokeLater(() -> ((Semaphore)semaphore).up(), ModalityState.any(), true);
        while (!semaphore.isUp()) {
            UIUtil.dispatchAllInvocationEvents();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 12: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 12: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 3: 
            case 12: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/LaterInvocator";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 6: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expired";
                break;
            }
            case 8: 
            case 10: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 18: 
            case 19: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalEntity";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appendedState";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/LaterInvocator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "modalityStateForWindow";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeLater";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentModalEntities";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentModalityState";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getLaterInvocatorWtQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addModalityStateListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "modalityStateForWindow";
                break;
            }
            case 3: 
            case 12: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isModalDialog";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterWithCallback";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWait";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "enterModal";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "markTransparent";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeModality";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "leaveModal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 12: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

