/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.FileStorageCoreUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import gnu.trove.THashMap;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryStorageUtil {
    private static final Logger LOG = Logger.getInstance(DirectoryStorageUtil.class);

    @NotNull
    public static Map<String, Element> loadFrom(@Nullable VirtualFile dir, @Nullable PathMacroSubstitutor pathMacroSubstitutor) {
        if (dir == null || !dir.exists()) {
            Map<String, Element> map2 = Collections.emptyMap();
            if (map2 == null) {
                DirectoryStorageUtil.$$$reportNull$$$0(0);
            }
            return map2;
        }
        THashMap fileToState = new THashMap();
        for (VirtualFile file2 : dir.getChildren()) {
            if (!StringUtilRt.endsWithIgnoreCase((CharSequence)file2.getNameSequence(), (CharSequence)".xml")) continue;
            try {
                Element state;
                if (file2.getLength() == 0L) {
                    LOG.warn("Ignore empty file " + file2.getPath());
                    continue;
                }
                Element element2 = JDOMUtil.load((InputStream)file2.getInputStream());
                String componentName = FileStorageCoreUtil.getComponentNameIfValid(element2);
                if (componentName == null) continue;
                if (!element2.getName().equals("component")) {
                    LOG.error("Incorrect root tag name (" + element2.getName() + ") in " + file2.getPresentableUrl());
                    continue;
                }
                List elementChildren = element2.getChildren();
                if (elementChildren.isEmpty() || JDOMUtil.isEmpty((Element)(state = ((Element)elementChildren.get(0)).detach()))) continue;
                if (pathMacroSubstitutor != null) {
                    pathMacroSubstitutor.expandPaths(state);
                    if (pathMacroSubstitutor instanceof TrackingPathMacroSubstitutor) {
                        ((TrackingPathMacroSubstitutor)pathMacroSubstitutor).addUnknownMacros(componentName, PathMacrosCollector.getMacroNames(state));
                    }
                }
                Element newState2 = JDOMUtil.internElement((Element)state);
                fileToState.put(file2.getName(), newState2);
            }
            catch (Throwable e) {
                LOG.warn("Unable to load state", e);
            }
        }
        THashMap tHashMap = fileToState;
        if (tHashMap == null) {
            DirectoryStorageUtil.$$$reportNull$$$0(1);
        }
        return tHashMap;
    }

    @Nullable
    public static Element getCompositeState(@NotNull Map<String, Element> fileToState, @NotNull StateSplitterEx splitter) {
        if (fileToState == null) {
            DirectoryStorageUtil.$$$reportNull$$$0(2);
        }
        if (splitter == null) {
            DirectoryStorageUtil.$$$reportNull$$$0(3);
        }
        Element state = new Element("component");
        if (fileToState.isEmpty()) {
            return state;
        }
        for (String fileName : fileToState.keySet()) {
            Element subState = fileToState.get(fileName);
            if (subState == null) {
                return null;
            }
            splitter.mergeStateInto(state, subState);
        }
        return state;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/components/impl/stores/DirectoryStorageUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFrom";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/components/impl/stores/DirectoryStorageUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCompositeState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

