/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.internal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.ExternalSystemFacadeManager;
import com.intellij.openapi.externalSystem.service.internal.AbstractExternalSystemTask;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalSystemProcessingManager
implements ExternalSystemTaskNotificationListener,
Disposable {
    private static final long TOO_LONG_EXECUTION_MS = TimeUnit.SECONDS.toMillis(10L);
    @NotNull
    private final ConcurrentMap<ExternalSystemTaskId, Long> myTasksInProgress = ContainerUtil.newConcurrentMap();
    @NotNull
    private final ConcurrentMap<ExternalSystemTaskId, ExternalSystemTask> myTasksDetails = ContainerUtil.newConcurrentMap();
    @NotNull
    private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    @NotNull
    private final ExternalSystemFacadeManager myFacadeManager;
    @NotNull
    private final ExternalSystemProgressNotificationManager myProgressNotificationManager;

    public ExternalSystemProcessingManager() {
        Application app = ApplicationManager.getApplication();
        this.myFacadeManager = (ExternalSystemFacadeManager)app.getService(ExternalSystemFacadeManager.class);
        this.myProgressNotificationManager = (ExternalSystemProgressNotificationManager)app.getService(ExternalSystemProgressNotificationManager.class);
        if (app.isUnitTestMode()) {
            return;
        }
        this.myProgressNotificationManager.addNotificationListener(this);
    }

    public void dispose() {
        this.myProgressNotificationManager.removeNotificationListener(this);
        this.myAlarm.cancelAllRequests();
    }

    public boolean hasTaskOfTypeInProgress(@NotNull ExternalSystemTaskType type, @NotNull Project project) {
        if (type == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(1);
        }
        String projectId = ExternalSystemTaskId.getProjectId((Project)project);
        for (ExternalSystemTaskId id2 : this.myTasksInProgress.keySet()) {
            if (!type.equals((Object)id2.getType()) || !projectId.equals(id2.getIdeProjectId())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public ExternalSystemTask findTask(@NotNull ExternalSystemTaskType type, @NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        if (type == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(2);
        }
        if (projectSystemId == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(3);
        }
        if (externalProjectPath == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(4);
        }
        for (ExternalSystemTask task2 : this.myTasksDetails.values()) {
            AbstractExternalSystemTask externalSystemTask;
            if (!(task2 instanceof AbstractExternalSystemTask) || (externalSystemTask = (AbstractExternalSystemTask)task2).getId().getType() != type || !externalSystemTask.getExternalSystemId().getId().equals(projectSystemId.getId()) || !externalSystemTask.getExternalProjectPath().equals(externalProjectPath)) continue;
            return task2;
        }
        return null;
    }

    @NotNull
    public List<ExternalSystemTask> findTasksOfState(@NotNull ProjectSystemId projectSystemId, ExternalSystemTaskState ... taskStates) {
        if (projectSystemId == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(5);
        }
        if (taskStates == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(6);
        }
        SmartList result2 = new SmartList();
        for (ExternalSystemTask task2 : this.myTasksDetails.values()) {
            AbstractExternalSystemTask externalSystemTask;
            if (!(task2 instanceof AbstractExternalSystemTask) || !(externalSystemTask = (AbstractExternalSystemTask)task2).getExternalSystemId().getId().equals(projectSystemId.getId()) || !ArrayUtil.contains((Object)externalSystemTask.getState(), (Object[])taskStates)) continue;
            result2.add(task2);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    public void add(@NotNull ExternalSystemTask task2) {
        if (task2 == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(8);
        }
        this.myTasksDetails.put(task2.getId(), task2);
    }

    public void release(@NotNull ExternalSystemTaskId id2) {
        if (id2 == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(9);
        }
        this.myTasksDetails.remove(id2);
    }

    public void onStart(@NotNull ExternalSystemTaskId id2, String workingDir) {
        if (id2 == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(10);
        }
        this.myTasksInProgress.put(id2, System.currentTimeMillis() + TOO_LONG_EXECUTION_MS);
        if (this.myAlarm.isEmpty()) {
            this.myAlarm.addRequest(() -> this.update(), TOO_LONG_EXECUTION_MS);
        }
    }

    public void onStart(@NotNull ExternalSystemTaskId id2) {
        if (id2 == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(11);
        }
        this.myTasksInProgress.put(id2, System.currentTimeMillis() + TOO_LONG_EXECUTION_MS);
    }

    public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
        if (event == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(12);
        }
        this.myTasksInProgress.put(event.getId(), System.currentTimeMillis() + TOO_LONG_EXECUTION_MS);
    }

    public void onTaskOutput(@NotNull ExternalSystemTaskId id2, @NotNull String text2, boolean stdOut) {
        if (id2 == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(13);
        }
        if (text2 == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(14);
        }
        this.myTasksInProgress.put(id2, System.currentTimeMillis() + TOO_LONG_EXECUTION_MS);
    }

    public void onEnd(@NotNull ExternalSystemTaskId id2) {
        if (id2 == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(15);
        }
        this.myTasksInProgress.remove(id2);
        if (this.myTasksInProgress.isEmpty()) {
            this.myAlarm.cancelAllRequests();
        }
    }

    public void onSuccess(@NotNull ExternalSystemTaskId id2) {
        if (id2 == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(16);
        }
    }

    public void onFailure(@NotNull ExternalSystemTaskId id2, @NotNull Exception e) {
        if (id2 == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(17);
        }
        if (e == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(18);
        }
    }

    public void beforeCancel(@NotNull ExternalSystemTaskId id2) {
        if (id2 == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(19);
        }
    }

    public void onCancel(@NotNull ExternalSystemTaskId id2) {
        if (id2 == null) {
            ExternalSystemProcessingManager.$$$reportNull$$$0(20);
        }
    }

    public void update() {
        long delay = TOO_LONG_EXECUTION_MS;
        HashMap newState2 = new HashMap();
        HashMap<ExternalSystemTaskId, Long> currentState = new HashMap<ExternalSystemTaskId, Long>(this.myTasksInProgress);
        if (currentState.isEmpty()) {
            return;
        }
        for (Map.Entry entry : currentState.entrySet()) {
            long diff = System.currentTimeMillis() - (Long)entry.getValue();
            if (diff > 0L) {
                delay = Math.min(delay, diff);
                newState2.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!this.myFacadeManager.isTaskActive((ExternalSystemTaskId)entry.getKey())) continue;
            newState2.put(entry.getKey(), System.currentTimeMillis() + TOO_LONG_EXECUTION_MS);
        }
        this.myTasksInProgress.clear();
        this.myTasksInProgress.putAll(newState2);
        if (!newState2.isEmpty()) {
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(() -> this.update(), delay);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskStates";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/internal/ExternalSystemProcessingManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/internal/ExternalSystemProcessingManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findTasksOfState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasTaskOfTypeInProgress";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findTask";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findTasksOfState";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "release";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onStart";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "onStatusChange";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "onTaskOutput";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "onEnd";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "onSuccess";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "onFailure";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "beforeCancel";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "onCancel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

