/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.application.options.schemes.SimpleSchemesPanel;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.impl.ui.KeymapScheme;
import com.intellij.openapi.keymap.impl.ui.KeymapSchemeManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.ui.MessageType;
import com.intellij.ui.components.labels.SwingActionLink;
import com.intellij.util.ui.JBDimension;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class KeymapSelector
extends SimpleSchemesPanel<KeymapScheme> {
    private KeymapSchemeManager manager;
    private final Consumer<? super Keymap> consumer;
    private String messageReplacement;
    private boolean messageShown;
    private boolean internal;

    KeymapSelector(Consumer<? super Keymap> consumer) {
        super(0);
        this.consumer = consumer;
    }

    void attachKeymapListener(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            KeymapSelector.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().getMessageBus().connect(parentDisposable).subscribe(KeymapManagerListener.TOPIC, (Object)new KeymapManagerListener(){

            public void keymapAdded(@NotNull Keymap keymap2) {
                if (keymap2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                KeymapSelector.this.manager.handleKeymapAdded(keymap2);
                KeymapSelector.this.resetSchemes(KeymapSelector.this.manager.getSchemes());
            }

            public void keymapRemoved(@NotNull Keymap keymap2) {
                if (keymap2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                KeymapSelector.this.manager.handleKeymapRemoved(keymap2);
                KeymapSelector.this.resetSchemes(KeymapSelector.this.manager.getSchemes());
            }

            public void activeKeymapChanged(@Nullable Keymap keymap2) {
                KeymapSelector.this.manager.handleActiveKeymapChanged(keymap2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "keymap";
                objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/KeymapSelector$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "keymapAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "keymapRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public KeymapSchemeManager getManager() {
        if (this.manager == null) {
            this.manager = new KeymapSchemeManager(this);
        }
        KeymapSchemeManager keymapSchemeManager = this.manager;
        if (keymapSchemeManager == null) {
            KeymapSelector.$$$reportNull$$$0(1);
        }
        return keymapSchemeManager;
    }

    @Override
    @NotNull
    public SchemesModel<KeymapScheme> getModel() {
        KeymapSchemeManager keymapSchemeManager = this.getManager();
        if (keymapSchemeManager == null) {
            KeymapSelector.$$$reportNull$$$0(2);
        }
        return keymapSchemeManager;
    }

    @Override
    @Nullable
    protected String getComboBoxLabel() {
        return null;
    }

    @Override
    @NotNull
    protected AbstractSchemeActions<KeymapScheme> createSchemeActions() {
        KeymapSchemeManager keymapSchemeManager = this.getManager();
        if (keymapSchemeManager == null) {
            KeymapSelector.$$$reportNull$$$0(3);
        }
        return keymapSchemeManager;
    }

    @Override
    protected int getIndent(@NotNull KeymapScheme scheme) {
        if (scheme == null) {
            KeymapSelector.$$$reportNull$$$0(4);
        }
        return scheme.isMutable() ? 1 : 0;
    }

    @Override
    protected boolean supportsProjectSchemes() {
        return false;
    }

    @Override
    protected boolean highlightNonDefaultSchemes() {
        return false;
    }

    @Override
    public boolean useBoldForNonRemovableSchemes() {
        return true;
    }

    @Override
    public void showMessage(@Nullable String message, @NotNull MessageType messageType) {
        if (messageType == null) {
            KeymapSelector.$$$reportNull$$$0(5);
        }
        this.messageShown = true;
        super.showMessage(message, messageType);
    }

    @Override
    public void clearMessage() {
        this.messageShown = false;
        super.showMessage(this.messageReplacement, MessageType.INFO);
    }

    @Override
    protected JComponent createTopComponent() {
        SwingActionLink link = new SwingActionLink((Action)new AbstractAction(KeyMapBundle.message((String)"link.get.more.keymaps.in.0.plugins", (Object[])new Object[]{ShowSettingsUtil.getSettingsMenuName()})){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings settings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)((SwingActionLink)e.getSource())));
                if (settings != null) {
                    settings.select(settings.find("preferences.pluginManager"), "/tag:Keymap");
                }
            }
        });
        Box row = new Box(0);
        row.add(Box.createRigidArea((Dimension)new JBDimension(2, 0)));
        row.add((Component)link);
        row.add(Box.createHorizontalGlue());
        Box box = new Box(1);
        box.add(Box.createRigidArea((Dimension)new JBDimension(0, 5)));
        box.add(row);
        box.add(Box.createRigidArea((Dimension)new JBDimension(0, 12)));
        return box;
    }

    void notifyConsumer(KeymapScheme scheme) {
        if (this.internal) {
            return;
        }
        Keymap keymap2 = scheme == null ? null : scheme.getParent();
        String string = this.messageReplacement = keymap2 == null ? null : KeyMapBundle.message((String)"based.on.keymap.label", (Object[])new Object[]{keymap2.getPresentableName()});
        if (!this.messageShown) {
            this.clearMessage();
        }
        this.consumer.accept(scheme == null ? null : scheme.getCurrent());
    }

    void selectKeymap(KeymapScheme scheme, boolean reset2) {
        try {
            this.internal = true;
            if (reset2) {
                this.resetSchemes(this.getManager().getSchemes());
            }
            if (scheme != null) {
                this.selectScheme(scheme);
            }
        }
        finally {
            this.internal = false;
            this.notifyConsumer((KeymapScheme)this.getSelectedScheme());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/impl/ui/KeymapSelector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/KeymapSelector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createSchemeActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "attachKeymapListener";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIndent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

