/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.openapi.paths.DynamicContextProvider;
import com.intellij.openapi.paths.PathReferenceProviderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;

public class GenericDynamicContextProvider
implements DynamicContextProvider {
    @Override
    public int getOffset(PsiElement element2, int offset, String elementText) {
        PsiElement[] children2;
        for (PsiElement child2 : children2 = element2.getChildren()) {
            if (!this.isDynamic(child2)) continue;
            int i = child2.getStartOffsetInParent();
            if (i == offset) {
                PsiElement next = child2.getNextSibling();
                if (next == null || !next.getText().startsWith("/")) {
                    return -1;
                }
                offset = next.getStartOffsetInParent();
                continue;
            }
            int pos = PathReferenceProviderBase.getLastPosOfURL(offset, elementText);
            if (pos == -1 || pos > i) {
                return -1;
            }
            return offset;
        }
        return offset;
    }

    protected boolean isDynamic(PsiElement child2) {
        return child2 instanceof OuterLanguageElement;
    }
}

