/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.google.common.collect.ConcurrentHashMultiset;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.WrappedProgressIndicator;
import com.intellij.openapi.progress.impl.NonCancelableIndicator;
import com.intellij.openapi.progress.impl.ProgressRunner;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreProgressManager
extends ProgressManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(CoreProgressManager.class);
    static final int CHECK_CANCELED_DELAY_MILLIS = 10;
    private final AtomicInteger myUnsafeProgressCount = new AtomicInteger(0);
    public static final boolean ENABLED = !"disabled".equals(System.getProperty("idea.ProcessCanceledException"));
    private static CheckCanceledHook ourCheckCanceledHook;
    private ScheduledFuture<?> myCheckCancelledFuture;
    private static final Map<ProgressIndicator, Set<Thread>> threadsUnderIndicator;
    private static final ConcurrentLongObjectMap<ProgressIndicator> currentIndicators;
    private static final ConcurrentLongObjectMap<ProgressIndicator> threadTopLevelIndicators;
    static final Set<Thread> threadsUnderCanceledIndicator;
    @NotNull
    private static volatile CheckCanceledBehavior ourCheckCanceledBehavior;
    private static final Collection<ProgressIndicator> nonStandardIndicators;
    private static final ThreadLocal<Boolean> isInNonCancelableSection;
    private static final long MAX_PRIORITIZATION_NANOS;
    private static final Thread[] NO_THREADS;
    private final Set<Thread> myPrioritizedThreads = ContainerUtil.newConcurrentSet();
    private volatile Thread[] myEffectivePrioritizedThreads = NO_THREADS;
    private int myDeprioritizations = 0;
    private final Object myPrioritizationLock = ObjectUtils.sentinel((String)"myPrioritizationLock");
    private volatile long myPrioritizingStarted = 0L;

    private void startBackgroundNonStandardIndicatorsPing() {
        if (this.myCheckCancelledFuture == null) {
            this.myCheckCancelledFuture = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> {
                for (ProgressIndicator indicator : nonStandardIndicators) {
                    try {
                        indicator.checkCanceled();
                    }
                    catch (ProcessCanceledException e) {
                        this.indicatorCanceled(indicator);
                    }
                }
            }, 0L, 10L, TimeUnit.MILLISECONDS);
        }
    }

    private void stopBackgroundNonStandardIndicatorsPing() {
        if (this.myCheckCancelledFuture != null) {
            this.myCheckCancelledFuture.cancel(true);
            this.myCheckCancelledFuture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            this.stopBackgroundNonStandardIndicatorsPing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ProgressIndicator> getCurrentIndicators() {
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            return new ArrayList<ProgressIndicator>(threadsUnderIndicator.keySet());
        }
    }

    @ApiStatus.Internal
    public static boolean runCheckCanceledHooks(@Nullable ProgressIndicator indicator) {
        CheckCanceledHook hook2 = ourCheckCanceledHook;
        return hook2 != null && hook2.runHook(indicator);
    }

    protected void doCheckCanceled() throws ProcessCanceledException {
        CheckCanceledBehavior behavior = ourCheckCanceledBehavior;
        if (behavior == CheckCanceledBehavior.NONE) {
            return;
        }
        ProgressIndicator progress2 = this.getProgressIndicator();
        if (progress2 != null && behavior == CheckCanceledBehavior.INDICATOR_PLUS_HOOKS) {
            progress2.checkCanceled();
        } else {
            CoreProgressManager.runCheckCanceledHooks(progress2);
        }
    }

    public boolean hasProgressIndicator() {
        return this.getProgressIndicator() != null;
    }

    public boolean hasUnsafeProgressIndicator() {
        return this.myUnsafeProgressCount.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasModalProgressIndicator() {
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            return ContainerUtil.or(threadsUnderIndicator.keySet(), i -> i.isModal());
        }
    }

    public void runProcess(@NotNull Runnable process2, @Nullable ProgressIndicator progress2) {
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(0);
        }
        this.executeProcessUnderProgress(() -> {
            try {
                try {
                    if (progress2 != null && !progress2.isRunning()) {
                        progress2.start();
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                process2.run();
            }
            finally {
                if (progress2 != null && progress2.isRunning()) {
                    progress2.stop();
                    if (progress2 instanceof ProgressIndicatorEx) {
                        ((ProgressIndicatorEx)progress2).processFinish();
                    }
                }
            }
        }, progress2);
    }

    public void executeNonCancelableSection(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            CoreProgressManager.$$$reportNull$$$0(1);
        }
        if (this.isInNonCancelableSection()) {
            runnable2.run();
        } else {
            try {
                isInNonCancelableSection.set(Boolean.TRUE);
                this.executeProcessUnderProgress(runnable2, (ProgressIndicator)NonCancelableIndicator.INSTANCE);
            }
            finally {
                isInNonCancelableSection.remove();
            }
        }
    }

    public <T, E extends Exception> T computeInNonCancelableSection(@NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            CoreProgressManager.$$$reportNull$$$0(2);
        }
        Ref result2 = Ref.create();
        Ref exception = Ref.create();
        this.executeNonCancelableSection(() -> {
            try {
                result2.set(computable.compute());
            }
            catch (Exception t) {
                exception.set((Object)t);
            }
        });
        Throwable t = (Throwable)exception.get();
        if (t != null) {
            ExceptionUtil.rethrowUnchecked((Throwable)t);
            Exception e = (Exception)t;
            throw e;
        }
        return (T)result2.get();
    }

    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process2, @NotNull @Nls String progressTitle, boolean canBeCanceled, @Nullable Project project) {
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(3);
        }
        if (progressTitle == null) {
            CoreProgressManager.$$$reportNull$$$0(4);
        }
        return this.runProcessWithProgressSynchronously(process2, progressTitle, canBeCanceled, project, null);
    }

    public <T, E extends Exception> T runProcessWithProgressSynchronously(final @NotNull ThrowableComputable<T, E> process2, @NotNull @Nls String progressTitle, boolean canBeCanceled, @Nullable Project project) throws E {
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(5);
        }
        if (progressTitle == null) {
            CoreProgressManager.$$$reportNull$$$0(6);
        }
        final AtomicReference result2 = new AtomicReference();
        final AtomicReference exception = new AtomicReference();
        this.runProcessWithProgressSynchronously((Task)new Task.Modal(project, progressTitle, canBeCanceled){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    Object compute = process2.compute();
                    result2.set(compute);
                }
                catch (Throwable t) {
                    exception.set(t);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$1", "run"));
            }
        }, null);
        Throwable t = (Throwable)exception.get();
        if (t != null) {
            ExceptionUtil.rethrowUnchecked((Throwable)t);
            Exception e = (Exception)t;
            throw e;
        }
        return (T)result2.get();
    }

    public boolean runProcessWithProgressSynchronously(final @NotNull Runnable process2, @NotNull @Nls String progressTitle, boolean canBeCanceled, @Nullable Project project, @Nullable JComponent parentComponent) {
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(7);
        }
        if (progressTitle == null) {
            CoreProgressManager.$$$reportNull$$$0(8);
        }
        Task.Modal task2 = new Task.Modal(project, progressTitle, canBeCanceled){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                process2.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$2", "run"));
            }
        };
        return this.runProcessWithProgressSynchronously((Task)task2, parentComponent);
    }

    public void runProcessWithProgressAsynchronously(@NotNull Project project, @NotNull @Nls String progressTitle, @NotNull Runnable process2, @Nullable Runnable successRunnable, @Nullable Runnable canceledRunnable) {
        if (project == null) {
            CoreProgressManager.$$$reportNull$$$0(9);
        }
        if (progressTitle == null) {
            CoreProgressManager.$$$reportNull$$$0(10);
        }
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(11);
        }
        this.runProcessWithProgressAsynchronously(project, progressTitle, process2, successRunnable, canceledRunnable, PerformInBackgroundOption.DEAF);
    }

    public void runProcessWithProgressAsynchronously(@NotNull Project project, @NotNull @Nls String progressTitle, final @NotNull Runnable process2, final @Nullable Runnable successRunnable, final @Nullable Runnable canceledRunnable, @NotNull PerformInBackgroundOption option2) {
        if (project == null) {
            CoreProgressManager.$$$reportNull$$$0(12);
        }
        if (progressTitle == null) {
            CoreProgressManager.$$$reportNull$$$0(13);
        }
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(14);
        }
        if (option2 == null) {
            CoreProgressManager.$$$reportNull$$$0(15);
        }
        this.runProcessWithProgressAsynchronously(new Task.Backgroundable(project, progressTitle, true, option2){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                process2.run();
            }

            public void onCancel() {
                if (canceledRunnable != null) {
                    canceledRunnable.run();
                }
            }

            public void onSuccess() {
                if (successRunnable != null) {
                    successRunnable.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$3", "run"));
            }
        });
    }

    public void run(@NotNull Task task2) {
        if (task2 == null) {
            CoreProgressManager.$$$reportNull$$$0(16);
        }
        if (task2.isHeadless()) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.runProcessWithProgressSynchronously(task2, null);
            } else {
                this.runProcessWithProgressInCurrentThread(task2, (ProgressIndicator)new EmptyProgressIndicator(), ModalityState.defaultModalityState());
            }
        } else if (task2.isModal()) {
            this.runSynchronously((Task)task2.asModal());
        } else {
            Task.Backgroundable backgroundable = task2.asBackgroundable();
            if (backgroundable.isConditionalModal() && !backgroundable.shouldStartInBackground()) {
                this.runSynchronously(task2);
            } else {
                this.runAsynchronously(backgroundable);
            }
        }
    }

    private void runSynchronously(@NotNull Task task2) {
        if (task2 == null) {
            CoreProgressManager.$$$reportNull$$$0(17);
        }
        this.runProcessWithProgressSynchronously(task2, null);
    }

    private void runAsynchronously(@NotNull Task.Backgroundable task2) {
        if (task2 == null) {
            CoreProgressManager.$$$reportNull$$$0(18);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.runProcessWithProgressAsynchronously(task2);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> {
                Project project = task2.getProject();
                if (project != null && project.isDisposed()) {
                    LOG.info("Task canceled because of project disposal: " + task2);
                    this.finishTask((Task)task2, true, null);
                    return;
                }
                this.runProcessWithProgressAsynchronously(task2);
            }, ModalityState.defaultModalityState());
        }
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task2) {
        if (task2 == null) {
            CoreProgressManager.$$$reportNull$$$0(19);
        }
        Future<?> future2 = this.runProcessWithProgressAsynchronously(task2, (ProgressIndicator)new EmptyProgressIndicator(), null);
        if (future2 == null) {
            CoreProgressManager.$$$reportNull$$$0(20);
        }
        return future2;
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task2, @NotNull ProgressIndicator progressIndicator2, @Nullable Runnable continuation) {
        if (task2 == null) {
            CoreProgressManager.$$$reportNull$$$0(21);
        }
        if (progressIndicator2 == null) {
            CoreProgressManager.$$$reportNull$$$0(22);
        }
        Future<?> future2 = this.runProcessWithProgressAsynchronously(task2, progressIndicator2, continuation, progressIndicator2.getModalityState());
        if (future2 == null) {
            CoreProgressManager.$$$reportNull$$$0(23);
        }
        return future2;
    }

    @Deprecated
    @NotNull
    protected TaskRunnable createTaskRunnable(@NotNull Task task2, @NotNull ProgressIndicator indicator, @Nullable Runnable continuation) {
        if (task2 == null) {
            CoreProgressManager.$$$reportNull$$$0(24);
        }
        if (indicator == null) {
            CoreProgressManager.$$$reportNull$$$0(25);
        }
        return new TaskRunnable(task2, indicator, continuation);
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task2, @NotNull ProgressIndicator progressIndicator2, @Nullable Runnable continuation, @NotNull ModalityState modalityState) {
        IndicatorDisposable indicatorDisposable;
        if (task2 == null) {
            CoreProgressManager.$$$reportNull$$$0(26);
        }
        if (progressIndicator2 == null) {
            CoreProgressManager.$$$reportNull$$$0(27);
        }
        if (modalityState == null) {
            CoreProgressManager.$$$reportNull$$$0(28);
        }
        if (progressIndicator2 instanceof Disposable) {
            indicatorDisposable = new IndicatorDisposable(progressIndicator2);
            Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)indicatorDisposable);
        } else {
            indicatorDisposable = null;
        }
        Future<?> future2 = this.runProcessWithProgressAsync(task2, CompletableFuture.completedFuture(progressIndicator2), continuation, indicatorDisposable, modalityState);
        if (future2 == null) {
            CoreProgressManager.$$$reportNull$$$0(29);
        }
        return future2;
    }

    @NotNull
    protected Future<?> runProcessWithProgressAsync(@NotNull Task.Backgroundable task2, @NotNull CompletableFuture<? extends ProgressIndicator> progressIndicator2, @Nullable Runnable continuation, @Nullable IndicatorDisposable indicatorDisposable, @Nullable ModalityState modalityState) {
        if (task2 == null) {
            CoreProgressManager.$$$reportNull$$$0(30);
        }
        if (progressIndicator2 == null) {
            CoreProgressManager.$$$reportNull$$$0(31);
        }
        AtomicLong elapsed = new AtomicLong();
        CompletionStage completionStage = new ProgressRunner(progress2 -> {
            long start2 = System.currentTimeMillis();
            try {
                new TaskRunnable((Task)task2, (ProgressIndicator)progress2, continuation).run();
            }
            finally {
                elapsed.set(System.currentTimeMillis() - start2);
            }
            return null;
        }).onThread(ProgressRunner.ThreadToUse.POOLED).withProgress(progressIndicator2).submit().whenComplete((result2, err) -> {
            ModalityState modality;
            if (!result2.isCanceled()) {
                this.notifyTaskFinished(task2, elapsed.get());
            }
            if (modalityState != null) {
                modality = modalityState;
            } else {
                try {
                    modality = ((ProgressIndicator)progressIndicator2.get()).getModalityState();
                }
                catch (Throwable e) {
                    modality = ModalityState.NON_MODAL;
                }
            }
            ApplicationUtil.invokeLaterSomewhere(() -> {
                this.finishTask((Task)task2, result2.isCanceled(), result2.getThrowable() instanceof ProcessCanceledException ? null : result2.getThrowable());
                if (indicatorDisposable != null) {
                    Disposer.dispose((Disposable)indicatorDisposable);
                }
            }, task2.whereToRunCallbacks(), modality);
        });
        if (completionStage == null) {
            CoreProgressManager.$$$reportNull$$$0(32);
        }
        return completionStage;
    }

    void notifyTaskFinished(@NotNull Task.Backgroundable task2, long elapsed) {
        if (task2 == null) {
            CoreProgressManager.$$$reportNull$$$0(33);
        }
    }

    public boolean runProcessWithProgressSynchronously(final @NotNull Task task2, @Nullable JComponent parentComponent) {
        if (task2 == null) {
            CoreProgressManager.$$$reportNull$$$0(34);
        }
        final Ref exceptionRef = new Ref();
        TaskContainer taskContainer = new TaskContainer(task2){

            @Override
            public void run() {
                try {
                    CoreProgressManager.this.createTaskRunnable(task2, CoreProgressManager.this.getProgressIndicator(), null).run();
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    exceptionRef.set((Object)e);
                }
            }
        };
        ApplicationEx application = (ApplicationEx)ApplicationManager.getApplication();
        boolean result2 = application.runProcessWithProgressSynchronously(taskContainer, task2.getTitle(), task2.isCancellable(), task2.getProject(), parentComponent, task2.getCancelText());
        ApplicationUtil.invokeAndWaitSomewhere(() -> this.finishTask(task2, !result2, (Throwable)exceptionRef.get()), task2.whereToRunCallbacks());
        return result2;
    }

    public void runProcessWithProgressInCurrentThread(@NotNull Task task2, @NotNull ProgressIndicator progressIndicator2, @NotNull ModalityState modalityState) {
        if (task2 == null) {
            CoreProgressManager.$$$reportNull$$$0(35);
        }
        if (progressIndicator2 == null) {
            CoreProgressManager.$$$reportNull$$$0(36);
        }
        if (modalityState == null) {
            CoreProgressManager.$$$reportNull$$$0(37);
        }
        if (progressIndicator2 instanceof Disposable) {
            Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)((Disposable)progressIndicator2));
        }
        TaskRunnable process2 = this.createTaskRunnable(task2, progressIndicator2, null);
        boolean processCanceled = false;
        Throwable exception = null;
        try {
            this.runProcess(process2, progressIndicator2);
        }
        catch (ProcessCanceledException e) {
            processCanceled = true;
        }
        catch (Throwable e) {
            exception = e;
        }
        boolean finalCanceled = processCanceled || progressIndicator2.isCanceled();
        Throwable finalException = exception;
        ApplicationUtil.invokeAndWaitSomewhere(() -> this.finishTask(task2, finalCanceled, finalException), task2.whereToRunCallbacks(), modalityState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishTask(@NotNull Task task2, boolean canceled, @Nullable Throwable error) {
        if (task2 == null) {
            CoreProgressManager.$$$reportNull$$$0(38);
        }
        try {
            if (error != null) {
                task2.onThrowable(error);
            } else if (canceled) {
                task2.onCancel();
            } else {
                task2.onSuccess();
            }
        }
        finally {
            task2.onFinished();
        }
    }

    public void runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task2, @NotNull ProgressIndicator progressIndicator2) {
        if (task2 == null) {
            CoreProgressManager.$$$reportNull$$$0(39);
        }
        if (progressIndicator2 == null) {
            CoreProgressManager.$$$reportNull$$$0(40);
        }
        this.runProcessWithProgressAsynchronously(task2, progressIndicator2, null);
    }

    public ProgressIndicator getProgressIndicator() {
        return CoreProgressManager.getCurrentIndicator(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeProcessUnderProgress(@NotNull Runnable process2, ProgressIndicator progress2) throws ProcessCanceledException {
        block10: {
            if (process2 == null) {
                CoreProgressManager.$$$reportNull$$$0(41);
            }
            if (progress2 == null) {
                this.myUnsafeProgressCount.incrementAndGet();
            }
            try {
                boolean set;
                ProgressIndicator oldIndicator = null;
                boolean bl = set = progress2 != null && progress2 != (oldIndicator = this.getProgressIndicator());
                if (set) {
                    Thread currentThread = Thread.currentThread();
                    long threadId = currentThread.getId();
                    CoreProgressManager.setCurrentIndicator(threadId, progress2);
                    try {
                        this.registerIndicatorAndRun(progress2, currentThread, oldIndicator, process2);
                        break block10;
                    }
                    finally {
                        CoreProgressManager.setCurrentIndicator(threadId, oldIndicator);
                    }
                }
                process2.run();
            }
            finally {
                if (progress2 == null) {
                    this.myUnsafeProgressCount.decrementAndGet();
                }
            }
        }
    }

    public boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action2, @Nullable ProgressIndicator indicator) {
        if (action2 == null) {
            CoreProgressManager.$$$reportNull$$$0(42);
        }
        ApplicationManager.getApplication().runReadAction(action2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerIndicatorAndRun(@NotNull ProgressIndicator indicator, @NotNull Thread currentThread, ProgressIndicator oldIndicator, @NotNull Runnable process2) {
        boolean isStandard;
        Set underIndicator;
        if (indicator == null) {
            CoreProgressManager.$$$reportNull$$$0(43);
        }
        if (currentThread == null) {
            CoreProgressManager.$$$reportNull$$$0(44);
        }
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(45);
        }
        ArrayList<Set> threadsUnderThisIndicator = new ArrayList<Set>();
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            boolean oneOfTheIndicatorsIsCanceled = false;
            ProgressIndicator thisIndicator = indicator;
            while (thisIndicator != null) {
                underIndicator = threadsUnderIndicator.computeIfAbsent(thisIndicator, __ -> new SmartHashSet());
                boolean alreadyUnder = !underIndicator.add(currentThread);
                threadsUnderThisIndicator.add(alreadyUnder ? null : underIndicator);
                isStandard = thisIndicator instanceof StandardProgressIndicator;
                if (!isStandard) {
                    nonStandardIndicators.add(thisIndicator);
                    this.startBackgroundNonStandardIndicatorsPing();
                }
                oneOfTheIndicatorsIsCanceled |= thisIndicator.isCanceled();
                thisIndicator = thisIndicator instanceof WrappedProgressIndicator ? ((WrappedProgressIndicator)thisIndicator).getOriginalProgressIndicator() : null;
            }
            if (oneOfTheIndicatorsIsCanceled) {
                threadsUnderCanceledIndicator.add(currentThread);
            } else {
                threadsUnderCanceledIndicator.remove(currentThread);
            }
            this.updateShouldCheckCanceled();
        }
        try {
            process2.run();
            map2 = threadsUnderIndicator;
        }
        catch (Throwable throwable) {
            Map<ProgressIndicator, Set<Thread>> map3 = threadsUnderIndicator;
            synchronized (map3) {
                ProgressIndicator thisIndicator = null;
                for (int i = 0; i < threadsUnderThisIndicator.size(); ++i) {
                    boolean isStandard2;
                    boolean removed;
                    thisIndicator = i == 0 ? indicator : ((WrappedProgressIndicator)thisIndicator).getOriginalProgressIndicator();
                    Set underIndicator2 = (Set)threadsUnderThisIndicator.get(i);
                    boolean bl = removed = underIndicator2 != null && underIndicator2.remove(currentThread);
                    if (removed && underIndicator2.isEmpty()) {
                        threadsUnderIndicator.remove(thisIndicator);
                    }
                    if (!(isStandard2 = thisIndicator instanceof StandardProgressIndicator)) {
                        nonStandardIndicators.remove(thisIndicator);
                        if (nonStandardIndicators.isEmpty()) {
                            this.stopBackgroundNonStandardIndicatorsPing();
                        }
                    }
                    if (oldIndicator != null && oldIndicator.isCanceled()) {
                        threadsUnderCanceledIndicator.add(currentThread);
                        continue;
                    }
                    threadsUnderCanceledIndicator.remove(currentThread);
                }
                this.updateShouldCheckCanceled();
            }
            throw throwable;
        }
        synchronized (map2) {
            ProgressIndicator thisIndicator = null;
            for (int i = 0; i < threadsUnderThisIndicator.size(); ++i) {
                boolean removed;
                thisIndicator = i == 0 ? indicator : ((WrappedProgressIndicator)thisIndicator).getOriginalProgressIndicator();
                underIndicator = (Set)threadsUnderThisIndicator.get(i);
                boolean bl = removed = underIndicator != null && underIndicator.remove(currentThread);
                if (removed && underIndicator.isEmpty()) {
                    threadsUnderIndicator.remove(thisIndicator);
                }
                if (!(isStandard = thisIndicator instanceof StandardProgressIndicator)) {
                    nonStandardIndicators.remove(thisIndicator);
                    if (nonStandardIndicators.isEmpty()) {
                        this.stopBackgroundNonStandardIndicatorsPing();
                    }
                }
                if (oldIndicator != null && oldIndicator.isCanceled()) {
                    threadsUnderCanceledIndicator.add(currentThread);
                    continue;
                }
                threadsUnderCanceledIndicator.remove(currentThread);
            }
            this.updateShouldCheckCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void updateShouldCheckCanceled() {
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            CheckCanceledHook hook2 = this.createCheckCanceledHook();
            boolean hasCanceledIndicator = !threadsUnderCanceledIndicator.isEmpty();
            ourCheckCanceledHook = hook2;
            ourCheckCanceledBehavior = hook2 == null && !hasCanceledIndicator ? CheckCanceledBehavior.NONE : (hasCanceledIndicator && ENABLED ? CheckCanceledBehavior.INDICATOR_PLUS_HOOKS : CheckCanceledBehavior.ONLY_HOOKS);
        }
    }

    @Nullable
    protected CheckCanceledHook createCheckCanceledHook() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void indicatorCanceled(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CoreProgressManager.$$$reportNull$$$0(46);
        }
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            Set<Thread> threads = threadsUnderIndicator.get(indicator);
            if (threads != null) {
                for (Thread thread : threads) {
                    boolean underCancelledIndicator = false;
                    ProgressIndicator currentIndicator = CoreProgressManager.getCurrentIndicator(thread);
                    while (currentIndicator != null) {
                        if (currentIndicator == indicator) {
                            underCancelledIndicator = true;
                            break;
                        }
                        currentIndicator = currentIndicator instanceof WrappedProgressIndicator ? ((WrappedProgressIndicator)currentIndicator).getOriginalProgressIndicator() : null;
                    }
                    if (!underCancelledIndicator) continue;
                    threadsUnderCanceledIndicator.add(thread);
                    this.updateShouldCheckCanceled();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCanceledThread(@NotNull Thread thread) {
        if (thread == null) {
            CoreProgressManager.$$$reportNull$$$0(47);
        }
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            return threadsUnderCanceledIndicator.contains(thread);
        }
    }

    public boolean isInNonCancelableSection() {
        return isInNonCancelableSection.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T computePrioritized(@NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            CoreProgressManager.$$$reportNull$$$0(48);
        }
        Thread thread = Thread.currentThread();
        if (!Registry.is((String)"ide.prioritize.threads") || this.isPrioritizedThread(thread)) {
            return (T)computable.compute();
        }
        Object object = this.myPrioritizationLock;
        synchronized (object) {
            if (this.myPrioritizedThreads.isEmpty()) {
                this.myPrioritizingStarted = System.nanoTime();
            }
            this.myPrioritizedThreads.add(thread);
            this.updateEffectivePrioritized();
        }
        try {
            object = computable.compute();
            return (T)object;
        }
        finally {
            Object object2 = this.myPrioritizationLock;
            synchronized (object2) {
                this.myPrioritizedThreads.remove(thread);
                this.updateEffectivePrioritized();
            }
        }
    }

    private void updateEffectivePrioritized() {
        Thread[] prev = this.myEffectivePrioritizedThreads;
        Thread[] current2 = this.myDeprioritizations > 0 || this.myPrioritizedThreads.isEmpty() ? NO_THREADS : this.myPrioritizedThreads.toArray(NO_THREADS);
        this.myEffectivePrioritizedThreads = current2;
        if (prev.length == 0 && current2.length > 0) {
            this.prioritizingStarted();
        } else if (prev.length > 0 && current2.length == 0) {
            this.prioritizingFinished();
        }
    }

    protected void prioritizingStarted() {
    }

    protected void prioritizingFinished() {
    }

    @ApiStatus.Internal
    public boolean isPrioritizedThread(@NotNull Thread from) {
        if (from == null) {
            CoreProgressManager.$$$reportNull$$$0(49);
        }
        return this.myPrioritizedThreads.contains(from);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void suppressPrioritizing() {
        Object object = this.myPrioritizationLock;
        synchronized (object) {
            if (++this.myDeprioritizations == 100 + ForkJoinPool.getCommonPoolParallelism() * 2) {
                Attachment attachment = new Attachment("threadDump.txt", ThreadDumper.dumpThreadsToString());
                attachment.setIncluded(true);
                LOG.error("A suspiciously high nesting of suppressPrioritizing, forgot to call restorePrioritizing?", new Attachment[]{attachment});
            }
            this.updateEffectivePrioritized();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void restorePrioritizing() {
        Object object = this.myPrioritizationLock;
        synchronized (object) {
            if (--this.myDeprioritizations < 0) {
                this.myDeprioritizations = 0;
                LOG.error("Unmatched suppressPrioritizing/restorePrioritizing");
            }
            this.updateEffectivePrioritized();
        }
    }

    protected boolean sleepIfNeededToGivePriorityToAnotherThread() {
        if (!this.isCurrentThreadEffectivelyPrioritized() && this.checkLowPriorityReallyApplicable()) {
            LockSupport.parkNanos(1000000L);
            this.avoidBlockingPrioritizingThread();
            return true;
        }
        return false;
    }

    private boolean isCurrentThreadEffectivelyPrioritized() {
        Thread current2 = Thread.currentThread();
        for (Thread prioritized : this.myEffectivePrioritizedThreads) {
            if (prioritized != current2) continue;
            return true;
        }
        return false;
    }

    private boolean checkLowPriorityReallyApplicable() {
        long time = System.nanoTime() - this.myPrioritizingStarted;
        if (time < 5000000L) {
            return false;
        }
        if (this.avoidBlockingPrioritizingThread()) {
            return false;
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return false;
        }
        if (time > MAX_PRIORITIZATION_NANOS) {
            this.stopAllPrioritization();
            return false;
        }
        return true;
    }

    private boolean avoidBlockingPrioritizingThread() {
        if (this.isAnyPrioritizedThreadBlocked()) {
            this.suppressPrioritizing();
            this.checkLaterThreadsAreUnblocked();
            return true;
        }
        return false;
    }

    private void checkLaterThreadsAreUnblocked() {
        try {
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> {
                if (this.isAnyPrioritizedThreadBlocked()) {
                    this.checkLaterThreadsAreUnblocked();
                } else {
                    this.restorePrioritizing();
                }
            }, 5L, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAllPrioritization() {
        Object object = this.myPrioritizationLock;
        synchronized (object) {
            this.myPrioritizedThreads.clear();
            this.updateEffectivePrioritized();
        }
    }

    private boolean isAnyPrioritizedThreadBlocked() {
        for (Thread thread : this.myEffectivePrioritizedThreads) {
            Thread.State state = thread.getState();
            if (state != Thread.State.WAITING && state != Thread.State.TIMED_WAITING && state != Thread.State.BLOCKED) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static ModalityState getCurrentThreadProgressModality() {
        ProgressIndicator indicator = (ProgressIndicator)threadTopLevelIndicators.get(Thread.currentThread().getId());
        ModalityState modality = indicator == null ? null : indicator.getModalityState();
        ModalityState modalityState = modality != null ? modality : ModalityState.NON_MODAL;
        if (modalityState == null) {
            CoreProgressManager.$$$reportNull$$$0(50);
        }
        return modalityState;
    }

    private static void setCurrentIndicator(long threadId, ProgressIndicator indicator) {
        if (indicator == null) {
            currentIndicators.remove(threadId);
            threadTopLevelIndicators.remove(threadId);
        } else {
            currentIndicators.put(threadId, (Object)indicator);
            if (!threadTopLevelIndicators.containsKey(threadId)) {
                threadTopLevelIndicators.put(threadId, (Object)indicator);
            }
        }
    }

    private static ProgressIndicator getCurrentIndicator(@NotNull Thread thread) {
        if (thread == null) {
            CoreProgressManager.$$$reportNull$$$0(51);
        }
        return (ProgressIndicator)currentIndicators.get(thread.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertUnderProgress(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CoreProgressManager.$$$reportNull$$$0(52);
        }
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            Set<Thread> threads = threadsUnderIndicator.get(indicator);
            if (threads == null || !threads.contains(Thread.currentThread())) {
                LOG.error("Must be executed under progress indicator: " + indicator + ". Please see e.g. ProgressManager.runProcess()");
            }
        }
    }

    static {
        threadsUnderIndicator = new HashMap<ProgressIndicator, Set<Thread>>();
        currentIndicators = ContainerUtil.createConcurrentLongObjectMap();
        threadTopLevelIndicators = ContainerUtil.createConcurrentLongObjectMap();
        threadsUnderCanceledIndicator = new HashSet<Thread>();
        ourCheckCanceledBehavior = CheckCanceledBehavior.NONE;
        nonStandardIndicators = ConcurrentHashMultiset.create();
        isInNonCancelableSection = new ThreadLocal();
        MAX_PRIORITIZATION_NANOS = TimeUnit.SECONDS.toNanos(12L);
        NO_THREADS = new Thread[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 23: 
            case 29: 
            case 32: 
            case 50: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 23: 
            case 29: 
            case 32: 
            case 50: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: 
            case 26: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 20: 
            case 23: 
            case 29: 
            case 32: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/impl/CoreProgressManager";
                break;
            }
            case 22: 
            case 27: 
            case 31: 
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 25: 
            case 43: 
            case 46: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 28: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentThread";
                break;
            }
            case 47: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/impl/CoreProgressManager";
                break;
            }
            case 20: 
            case 23: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcessWithProgressAsynchronously";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcessWithProgressAsync";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentThreadProgressModality";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runProcess";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "executeNonCancelableSection";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeInNonCancelableSection";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressSynchronously";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressAsynchronously";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "runSynchronously";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "runAsynchronously";
                break;
            }
            case 20: 
            case 23: 
            case 29: 
            case 32: 
            case 50: {
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createTaskRunnable";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressAsync";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "notifyTaskFinished";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressInCurrentThread";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "finishTask";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "executeProcessUnderProgress";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "runInReadActionWithWriteActionPriority";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "registerIndicatorAndRun";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "indicatorCanceled";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isCanceledThread";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "computePrioritized";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isPrioritizedThread";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentIndicator";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "assertUnderProgress";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 23: 
            case 29: 
            case 32: 
            case 50: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    static interface CheckCanceledHook {
        public boolean runHook(@Nullable ProgressIndicator var1);
    }

    @Deprecated
    protected static class TaskRunnable
    extends TaskContainer {
        private final ProgressIndicator myIndicator;
        private final Runnable myContinuation;

        TaskRunnable(@NotNull Task task2, @NotNull ProgressIndicator indicator, @Nullable Runnable continuation) {
            if (task2 == null) {
                TaskRunnable.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                TaskRunnable.$$$reportNull$$$0(1);
            }
            super(task2);
            this.myIndicator = indicator;
            this.myContinuation = continuation;
        }

        @Override
        public void run() {
            try {
                this.getTask().run(this.myIndicator);
            }
            finally {
                try {
                    if (this.myIndicator instanceof ProgressIndicatorEx) {
                        ((ProgressIndicatorEx)this.myIndicator).finish((TaskInfo)this.getTask());
                    }
                }
                finally {
                    if (this.myContinuation != null) {
                        this.myContinuation.run();
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "task";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "indicator";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/progress/impl/CoreProgressManager$TaskRunnable";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static abstract class TaskContainer
    implements Runnable {
        private final Task myTask;

        protected TaskContainer(@NotNull Task task2) {
            if (task2 == null) {
                TaskContainer.$$$reportNull$$$0(0);
            }
            this.myTask = task2;
        }

        @NotNull
        public Task getTask() {
            Task task2 = this.myTask;
            if (task2 == null) {
                TaskContainer.$$$reportNull$$$0(1);
            }
            return task2;
        }

        public String toString() {
            return this.myTask.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/progress/impl/CoreProgressManager$TaskContainer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/progress/impl/CoreProgressManager$TaskContainer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class IndicatorDisposable
    implements Disposable {
        @NotNull
        private final ProgressIndicator myIndicator;

        IndicatorDisposable(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                IndicatorDisposable.$$$reportNull$$$0(0);
            }
            this.myIndicator = indicator;
        }

        public void dispose() {
            Disposer.dispose((Disposable)((Disposable)this.myIndicator), (boolean)false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$IndicatorDisposable", "<init>"));
        }
    }

    private static enum CheckCanceledBehavior {
        NONE,
        ONLY_HOOKS,
        INDICATOR_PLUS_HOOKS;

    }
}

