/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.InvalidDataException;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class LibraryTableImplUtil {
    @NonNls
    public static final String MODULE_LEVEL = "module";

    private LibraryTableImplUtil() {
    }

    @NotNull
    public static Library loadLibrary(@NotNull Element rootElement, @NotNull RootModelImpl rootModel) throws InvalidDataException {
        List children2;
        if (rootElement == null) {
            LibraryTableImplUtil.$$$reportNull$$$0(0);
        }
        if (rootModel == null) {
            LibraryTableImplUtil.$$$reportNull$$$0(1);
        }
        if ((children2 = rootElement.getChildren("library")).size() != 1) {
            throw new InvalidDataException();
        }
        Element element2 = (Element)children2.get(0);
        return new LibraryImpl(null, element2, (ModifiableRootModel)rootModel);
    }

    @NotNull
    public static Library createModuleLevelLibrary(@Nullable String name, PersistentLibraryKind kind, @NotNull RootModelImpl rootModel, @Nullable ProjectModelExternalSource externalSource) {
        if (rootModel == null) {
            LibraryTableImplUtil.$$$reportNull$$$0(2);
        }
        return new LibraryImpl(name, kind, null, rootModel, externalSource);
    }

    public static boolean isValidLibrary(@NotNull Library library) {
        LibraryTable table;
        if (library == null) {
            LibraryTableImplUtil.$$$reportNull$$$0(3);
        }
        if ((table = library.getTable()) != null) {
            String name = library.getName();
            return name != null && table.getLibraryByName(name) == library;
        }
        if (!(library instanceof LibraryEx)) {
            return false;
        }
        Module module = ((LibraryEx)library).getModule();
        if (module == null) {
            return false;
        }
        for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            if (!(entry instanceof LibraryOrderEntry) || ((LibraryOrderEntry)entry).getLibrary() != library) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/LibraryTableImplUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadLibrary";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createModuleLevelLibrary";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidLibrary";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

