/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.migrate;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.DiffViewer;
import com.intellij.openapi.diff.impl.mergeTool.MergeRequestImpl;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.vcs.changes.actions.migrate.MigrateToNewDiffUtil;
import java.awt.Window;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MigrateDiffTool
implements DiffTool {
    public static final MigrateDiffTool INSTANCE = new MigrateDiffTool();

    private MigrateDiffTool() {
    }

    public void show(com.intellij.openapi.diff.DiffRequest request2) {
        if (MigrateDiffTool.isMergeRequest(request2)) {
            try {
                MergeRequest newRequest = MigrateToNewDiffUtil.convertMergeRequest((MergeRequestImpl)request2);
                DiffManager.getInstance().showMerge(request2.getProject(), newRequest);
            }
            catch (InvalidDiffRequestException e) {
                MessagesEx.error(request2.getProject(), e.getMessage()).showNow();
            }
        } else {
            DiffRequest newRequest = MigrateToNewDiffUtil.convertRequest(request2);
            Runnable onOkRunnable = request2.getOnOkRunnable();
            if (onOkRunnable == null) {
                DiffManager.getInstance().showDiff(request2.getProject(), newRequest, new DiffDialogHints(MigrateDiffTool.getWindowMode(request2.getHints())));
            } else {
                DialogBuilder builder2 = new DialogBuilder(request2.getProject());
                DiffRequestPanel diffPanel = DiffManager.getInstance().createRequestPanel(request2.getProject(), (Disposable)builder2, builder2.getWindow());
                diffPanel.setRequest(newRequest);
                builder2.setCenterPanel(diffPanel.getComponent());
                builder2.setPreferredFocusComponent(diffPanel.getPreferredFocusedComponent());
                builder2.setTitle(request2.getWindowTitle());
                builder2.setDimensionServiceKey(request2.getGroupKey());
                builder2.setOkOperation(() -> {
                    builder2.getDialogWrapper().close(0);
                    onOkRunnable.run();
                });
                boolean useNonModal = request2.getHints().contains(DiffTool.HINT_SHOW_NOT_MODAL_DIALOG);
                builder2.showModal(!useNonModal);
            }
        }
    }

    public boolean canShow(com.intellij.openapi.diff.DiffRequest request2) {
        return request2.getContents().length == 2 || request2.getContents().length == 3;
    }

    private static boolean isMergeRequest(com.intellij.openapi.diff.DiffRequest request2) {
        return request2 instanceof MergeRequestImpl && ((MergeRequestImpl)request2).getMergeContent() != null;
    }

    public DiffViewer createComponent(String title, com.intellij.openapi.diff.DiffRequest request2, Window window, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MigrateDiffTool.$$$reportNull$$$0(0);
        }
        return null;
    }

    @Nullable
    private static WindowWrapper.Mode getWindowMode(Collection hints) {
        if (hints.contains(DiffTool.HINT_SHOW_MODAL_DIALOG)) {
            return WindowWrapper.Mode.MODAL;
        }
        if (hints.contains(DiffTool.HINT_SHOW_NOT_MODAL_DIALOG)) {
            return WindowWrapper.Mode.NON_MODAL;
        }
        if (hints.contains(DiffTool.HINT_SHOW_FRAME)) {
            return WindowWrapper.Mode.FRAME;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateDiffTool", "createComponent"));
    }
}

