/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.ZipEntryMap;
import com.intellij.util.io.ResourceHandle;
import com.intellij.util.text.ByteArrayCharSequence;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ZipHandlerBase
extends ArchiveHandler {
    public ZipHandlerBase(@NotNull String path) {
        if (path == null) {
            ZipHandlerBase.$$$reportNull$$$0(0);
        }
        super(path);
    }

    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> createEntriesMap() throws IOException {
        Map<String, ArchiveHandler.EntryInfo> map2;
        try (ResourceHandle<ZipFile> existingZipRef = this.acquireZipHandle();){
            Map<String, ArchiveHandler.EntryInfo> map3 = this.buildEntryMapForZipFile((ZipFile)existingZipRef.get());
            map2 = map3;
        }
        if (map2 == null) {
            ZipHandlerBase.$$$reportNull$$$0(1);
        }
        return map2;
    }

    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> buildEntryMapForZipFile(@NotNull ZipFile zip) {
        if (zip == null) {
            ZipHandlerBase.$$$reportNull$$$0(2);
        }
        ZipEntryMap map2 = new ZipEntryMap(zip.size());
        map2.put("", this.createRootEntry());
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            this.getOrCreate(entries.nextElement(), (Map<String, ArchiveHandler.EntryInfo>)map2, zip);
        }
        ZipEntryMap zipEntryMap = map2;
        if (zipEntryMap == null) {
            ZipHandlerBase.$$$reportNull$$$0(3);
        }
        return zipEntryMap;
    }

    public void dispose() {
        super.dispose();
        this.clearCaches();
    }

    @NotNull
    private ArchiveHandler.EntryInfo getOrCreate(@NotNull ZipEntry entry, @NotNull Map<String, ArchiveHandler.EntryInfo> map2, @NotNull ZipFile zip) {
        ArchiveHandler.EntryInfo info;
        if (entry == null) {
            ZipHandlerBase.$$$reportNull$$$0(4);
        }
        if (map2 == null) {
            ZipHandlerBase.$$$reportNull$$$0(5);
        }
        if (zip == null) {
            ZipHandlerBase.$$$reportNull$$$0(6);
        }
        boolean isDirectory = entry.isDirectory();
        String entryName = entry.getName();
        if (StringUtil.endsWithChar((CharSequence)entryName, (char)'/')) {
            entryName = entryName.substring(0, entryName.length() - 1);
            isDirectory = true;
        }
        if (StringUtil.startsWithChar((CharSequence)entryName, (char)'/')) {
            entryName = StringUtil.trimStart((String)entryName, (String)"/");
        }
        if ((info = map2.get(entryName)) != null) {
            ArchiveHandler.EntryInfo entryInfo = info;
            if (entryInfo == null) {
                ZipHandlerBase.$$$reportNull$$$0(7);
            }
            return entryInfo;
        }
        Trinity path = this.splitPathAndFix(entryName);
        ArchiveHandler.EntryInfo parentInfo = this.getOrCreate((String)path.first, map2, zip);
        if (".".equals(path.second)) {
            ArchiveHandler.EntryInfo entryInfo = parentInfo;
            if (entryInfo == null) {
                ZipHandlerBase.$$$reportNull$$$0(8);
            }
            return entryInfo;
        }
        ArchiveHandler.EntryInfo entryInfo = info = ZipHandlerBase.store(map2, parentInfo, (CharSequence)path.second, isDirectory, entry.getSize(), this.getEntryFileStamp(), (String)path.third);
        if (entryInfo == null) {
            ZipHandlerBase.$$$reportNull$$$0(9);
        }
        return entryInfo;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static ArchiveHandler.EntryInfo store(@NotNull Map<String, ArchiveHandler.EntryInfo> map2, @Nullable ArchiveHandler.EntryInfo parentInfo, @NotNull CharSequence shortName, boolean isDirectory, long size, long time, @NotNull String string) {
        void entryName;
        if (map2 == null) {
            ZipHandlerBase.$$$reportNull$$$0(10);
        }
        if (shortName == null) {
            ZipHandlerBase.$$$reportNull$$$0(11);
        }
        if (string == null) {
            ZipHandlerBase.$$$reportNull$$$0(12);
        }
        CharSequence sequence = ByteArrayCharSequence.convertToBytesIfPossible((CharSequence)shortName);
        ArchiveHandler.EntryInfo info = new ArchiveHandler.EntryInfo(sequence, isDirectory, size, time, parentInfo);
        map2.put((String)entryName, info);
        ArchiveHandler.EntryInfo entryInfo = info;
        if (entryInfo == null) {
            ZipHandlerBase.$$$reportNull$$$0(13);
        }
        return entryInfo;
    }

    @NotNull
    private ArchiveHandler.EntryInfo getOrCreate(@NotNull String entryName, @NotNull Map<String, ArchiveHandler.EntryInfo> map2, @NotNull ZipFile zip) {
        ArchiveHandler.EntryInfo info;
        if (entryName == null) {
            ZipHandlerBase.$$$reportNull$$$0(14);
        }
        if (map2 == null) {
            ZipHandlerBase.$$$reportNull$$$0(15);
        }
        if (zip == null) {
            ZipHandlerBase.$$$reportNull$$$0(16);
        }
        if ((info = map2.get(entryName)) == null) {
            ZipEntry entry = zip.getEntry(entryName + "/");
            if (entry != null) {
                return this.getOrCreate(entry, map2, zip);
            }
            Trinity path = this.splitPathAndFix(entryName);
            ArchiveHandler.EntryInfo parentInfo = this.getOrCreate((String)path.first, map2, zip);
            entryName = (String)path.third;
            info = ZipHandlerBase.store(map2, parentInfo, (CharSequence)path.second, true, 0L, -1L, entryName);
        }
        if (!info.isDirectory) {
            Logger.getInstance(((Object)((Object)this)).getClass()).info(zip.getName() + ": " + entryName + " should be a directory");
            info = ZipHandlerBase.store(map2, info.parent, info.shortName, true, info.length, info.timestamp, entryName);
        }
        ArchiveHandler.EntryInfo entryInfo = info;
        if (entryInfo == null) {
            ZipHandlerBase.$$$reportNull$$$0(17);
        }
        return entryInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte @NotNull [] contentsToByteArray(@NotNull String relativePath) throws IOException {
        block31: {
            byte[] byArray;
            Throwable throwable;
            ResourceHandle<ZipFile> zipRef;
            block32: {
                if (relativePath == null) {
                    ZipHandlerBase.$$$reportNull$$$0(18);
                }
                zipRef = this.acquireZipHandle();
                throwable = null;
                try {
                    ZipFile zip = (ZipFile)zipRef.get();
                    ZipEntry entry = zip.getEntry(relativePath);
                    if (entry == null) break block31;
                    long length = entry.getSize();
                    if (FileUtilRt.isTooLarge((long)length)) {
                        throw new FileTooBigException(this.getFile() + "!/" + relativePath);
                    }
                    try (InputStream stream = zip.getInputStream(entry);){
                        if (stream == null) break block31;
                        byArray = FileUtil.loadBytes((InputStream)stream, (int)((int)length));
                        if (byArray != null) break block32;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                ZipHandlerBase.$$$reportNull$$$0(19);
            }
            return byArray;
            finally {
                if (zipRef != null) {
                    if (throwable != null) {
                        try {
                            zipRef.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        zipRef.close();
                    }
                }
            }
        }
        throw new FileNotFoundException(this.getFile() + "!/" + relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public InputStream getInputStream(@NotNull String relativePath) throws IOException {
        block12: {
            InputStream stream;
            if (relativePath == null) {
                ZipHandlerBase.$$$reportNull$$$0(20);
            }
            boolean release2 = true;
            ResourceHandle<ZipFile> zipRef = this.acquireZipHandle();
            ZipFile zip = (ZipFile)zipRef.get();
            ZipEntry entry = zip.getEntry(relativePath);
            if (entry == null || (stream = zip.getInputStream(entry)) == null) break block12;
            long length = entry.getSize();
            if (!FileUtilRt.isTooLarge((long)length)) {
                BufferExposingByteArrayInputStream bufferExposingByteArrayInputStream = new BufferExposingByteArrayInputStream(FileUtil.loadBytes((InputStream)stream, (int)((int)length)));
                BufferExposingByteArrayInputStream bufferExposingByteArrayInputStream2 = bufferExposingByteArrayInputStream;
                if (bufferExposingByteArrayInputStream2 == null) {
                    ZipHandlerBase.$$$reportNull$$$0(21);
                }
                return bufferExposingByteArrayInputStream2;
                finally {
                    stream.close();
                }
            }
            release2 = false;
            InputStreamWrapper inputStreamWrapper = new InputStreamWrapper(stream, zipRef);
            InputStreamWrapper inputStreamWrapper2 = inputStreamWrapper;
            if (inputStreamWrapper2 == null) {
                ZipHandlerBase.$$$reportNull$$$0(22);
            }
            return inputStreamWrapper2;
            finally {
                if (release2) {
                    zipRef.close();
                }
            }
        }
        throw new FileNotFoundException(this.getFile() + "!/" + relativePath);
    }

    protected abstract long getEntryFileStamp();

    @NotNull
    protected abstract ResourceHandle<ZipFile> acquireZipHandle() throws IOException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 17: 
            case 19: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 17: 
            case 19: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 17: 
            case 19: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/ZipHandlerBase";
                break;
            }
            case 2: 
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zip";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 5: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/ZipHandlerBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createEntriesMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildEntryMapForZipFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "store";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 17: 
            case 19: 
            case 21: 
            case 22: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildEntryMapForZipFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "store";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 17: 
            case 19: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InputStreamWrapper
    extends InputStream {
        private final InputStream myStream;
        private final ResourceHandle<ZipFile> myZipRef;
        private final AtomicBoolean closed = new AtomicBoolean(false);

        InputStreamWrapper(InputStream stream, ResourceHandle<ZipFile> zipRef) {
            this.myStream = stream;
            this.myZipRef = zipRef;
        }

        @Override
        public int read() throws IOException {
            return this.myStream.read();
        }

        @Override
        public int read(byte @NotNull [] b, int off, int len) throws IOException {
            if (b == null) {
                InputStreamWrapper.$$$reportNull$$$0(0);
            }
            return this.myStream.read(b, off, len);
        }

        @Override
        public int available() throws IOException {
            return this.myStream.available();
        }

        @Override
        public void close() throws IOException {
            if (!this.closed.getAndSet(true)) {
                try {
                    this.myStream.close();
                }
                finally {
                    this.myZipRef.close();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/openapi/vfs/impl/ZipHandlerBase$InputStreamWrapper", "read"));
        }
    }
}

