/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.http;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import org.jetbrains.annotations.Nullable;

public class RemoteFileUtil {
    private RemoteFileUtil() {
    }

    @Nullable
    public static FileType getFileType(@Nullable String contentType) {
        String mimeType;
        if (contentType == null) {
            return null;
        }
        int end = contentType.indexOf(59);
        String string = mimeType = end == -1 ? contentType : contentType.substring(0, end);
        if (mimeType.isEmpty()) {
            return null;
        }
        for (Language language : Language.getRegisteredLanguages()) {
            String[] types;
            for (String type : types = language.getMimeTypes()) {
                LanguageFileType fileType;
                if (!type.equalsIgnoreCase(mimeType) || (fileType = language.getAssociatedFileType()) == null) continue;
                return fileType;
            }
        }
        return null;
    }
}

