/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.impl.ZipHandlerBase;
import com.intellij.openapi.vfs.impl.jar.JarFileSystemImpl;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.io.ResourceHandle;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicJarHandler
extends ZipHandlerBase {
    private static final Logger LOG = Logger.getInstance(BasicJarHandler.class);
    private static final boolean doTracing = LOG.isTraceEnabled();
    private final ZipResourceHandle myHandle;
    private final JarFileSystemImpl myFileSystem;
    private static final Map<BasicJarHandler, ScheduledFuture<?>> ourOpenFileLimitGuard;
    private static final AtomicLong ourOpenTime;
    private static final AtomicInteger ourOpenCount;
    private static final AtomicInteger ourCloseCount;
    private static final AtomicLong ourCloseTime;
    private static final ScheduledExecutorService ourScheduledExecutorService;

    public BasicJarHandler(@NotNull String path) {
        if (path == null) {
            BasicJarHandler.$$$reportNull$$$0(0);
        }
        super(path);
        this.myFileSystem = (JarFileSystemImpl)JarFileSystem.getInstance();
        this.myHandle = new ZipResourceHandle();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myHandle.invalidateZipReference();
    }

    @Override
    @NotNull
    protected ResourceHandle<ZipFile> acquireZipHandle() throws IOException {
        this.myHandle.attach();
        ZipResourceHandle zipResourceHandle = this.myHandle;
        if (zipResourceHandle == null) {
            BasicJarHandler.$$$reportNull$$$0(1);
        }
        return zipResourceHandle;
    }

    private static void trace(String msg) {
        LOG.trace(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeOpenedZipReferences() {
        Map<BasicJarHandler, ScheduledFuture<?>> map2 = ourOpenFileLimitGuard;
        synchronized (map2) {
            ourOpenFileLimitGuard.keySet().forEach(BasicJarHandler::dispose);
        }
    }

    @Override
    protected long getEntryFileStamp() {
        return this.myHandle.getFileStamp();
    }

    static {
        int maxSize2 = 30;
        ourOpenFileLimitGuard = new LinkedHashMap<BasicJarHandler, ScheduledFuture<?>>(30, true){

            protected boolean removeEldestEntry(Map.Entry<BasicJarHandler, ScheduledFuture<?>> eldest, BasicJarHandler key, ScheduledFuture<?> value2) {
                if (this.size() > 30) {
                    key.myHandle.invalidateZipReference(value2);
                    return true;
                }
                return false;
            }
        };
        ourOpenTime = new AtomicLong();
        ourOpenCount = new AtomicInteger();
        ourCloseCount = new AtomicInteger();
        ourCloseTime = new AtomicLong();
        ourScheduledExecutorService = AppExecutorUtil.createBoundedScheduledExecutorService((String)"Zip Handle Janitor", (int)1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/jar/BasicJarHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/jar/BasicJarHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "acquireZipHandle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class ZipResourceHandle
    extends ResourceHandle<ZipFile> {
        private ZipFile myFile;
        private long myFileStamp;
        private final ReentrantLock myLock = new ReentrantLock();
        private ScheduledFuture<?> myInvalidationRequest;

        private ZipResourceHandle() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void attach() throws IOException {
            Map map2 = ourOpenFileLimitGuard;
            synchronized (map2) {
                ourOpenFileLimitGuard.remove((Object)BasicJarHandler.this);
            }
            this.myLock.lock();
            try {
                ScheduledFuture<?> invalidationRequest = this.myInvalidationRequest;
                if (invalidationRequest != null) {
                    invalidationRequest.cancel(false);
                    this.myInvalidationRequest = null;
                }
                if (this.myFile == null) {
                    File fileToUse = BasicJarHandler.this.getFile();
                    if (doTracing) {
                        BasicJarHandler.trace("To be opened:" + fileToUse);
                    }
                    long started = doTracing ? System.nanoTime() : 0L;
                    FileAttributes attributes = FileSystemUtil.getAttributes((String)fileToUse.getPath());
                    this.myFileStamp = attributes != null ? attributes.lastModified : -1L;
                    ZipFile file2 = new ZipFile(fileToUse);
                    if (doTracing) {
                        long openedFor = System.nanoTime() - started;
                        int opened = ourOpenCount.incrementAndGet();
                        long openTime = ourOpenTime.addAndGet(openedFor);
                        BasicJarHandler.trace("Opened for " + TimeUnit.NANOSECONDS.toMillis(openedFor) + "ms, times opened:" + opened + ", open time:" + TimeUnit.NANOSECONDS.toMillis(openTime) + "ms, reference will be cached for " + this.cacheInvalidationTime() + "ms");
                    }
                    this.myFile = file2;
                }
            }
            catch (Throwable e) {
                this.myLock.unlock();
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            ScheduledFuture<?> invalidationRequest;
            assert (this.myLock.isLocked());
            try {
                invalidationRequest = ourScheduledExecutorService.schedule(() -> this.invalidateZipReference(), (long)this.cacheInvalidationTime(), TimeUnit.MILLISECONDS);
                this.myInvalidationRequest = invalidationRequest;
            }
            finally {
                this.myLock.unlock();
            }
            Map map2 = ourOpenFileLimitGuard;
            synchronized (map2) {
                ourOpenFileLimitGuard.put(BasicJarHandler.this, invalidationRequest);
            }
        }

        private int cacheInvalidationTime() {
            File file2 = BasicJarHandler.this.getFile();
            return BasicJarHandler.this.myFileSystem.isMakeCopyOfJar(file2) ? 2000 : 300000;
        }

        @NotNull
        public ZipFile get() {
            assert (this.myLock.isLocked());
            ZipFile zipFile = this.myFile;
            if (zipFile == null) {
                ZipResourceHandle.$$$reportNull$$$0(0);
            }
            return zipFile;
        }

        private void invalidateZipReference() {
            this.invalidateZipReference(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void invalidateZipReference(@Nullable ScheduledFuture<?> expectedInvalidationRequest) {
            this.myLock.lock();
            try {
                if (this.myFile == null) {
                    return;
                }
                if (expectedInvalidationRequest != null) {
                    if (doTracing) {
                        BasicJarHandler.trace("Invalidation cache size exceeded");
                    }
                    if (this.myInvalidationRequest != expectedInvalidationRequest) {
                        return;
                    }
                }
                this.myInvalidationRequest = null;
                long started = doTracing ? System.nanoTime() : 0L;
                try {
                    this.myFile.close();
                }
                catch (IOException ex) {
                    LOG.info((Throwable)ex);
                }
                if (doTracing) {
                    long closeTime = System.nanoTime() - started;
                    int closed = ourCloseCount.incrementAndGet();
                    long totalCloseTime = ourCloseTime.addAndGet(closeTime);
                    BasicJarHandler.trace("Disposed:" + BasicJarHandler.this.getFile() + " " + TimeUnit.NANOSECONDS.toMillis(closeTime) + "ms, times closed:" + closed + ", closed time:" + TimeUnit.NANOSECONDS.toMillis(totalCloseTime) + "ms");
                }
                this.myFile = null;
            }
            finally {
                this.myLock.unlock();
            }
        }

        long getFileStamp() {
            assert (this.myLock.isLocked());
            return this.myFileStamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/BasicJarHandler$ZipResourceHandle", "get"));
        }
    }
}

