/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.customFrameDecorations.header;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.jdkEx.JdkEx;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.WindowsRegistryUtil;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.openapi.wm.impl.customFrameDecorations.CustomFrameTitleButtons;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomHeader;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.DefaultFrameHeader;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.DialogHeader;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.FrameHeader;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.MainFrameHeader;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import com.intellij.ui.scale.UserScaleContext;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000 L2\u00020\u00012\u00020\u0002:\u0003LMNB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000202H\u0016J\b\u00106\u001a\u000202H\u0004J\b\u00107\u001a\u00020\tH&J\b\u00108\u001a\u00020'H\u0002J\b\u00109\u001a\u000202H\u0016J\b\u0010:\u001a\u00020\u0011H\u0002J\u0010\u0010:\u001a\u00020\u00112\u0006\u0010;\u001a\u00020<H\u0014J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>H&J\b\u0010@\u001a\u000202H\u0014J\b\u0010A\u001a\u000202H\u0016J\u0010\u0010B\u001a\u0002022\u0006\u0010C\u001a\u00020\u0007H\u0002J(\u0010D\u001a\u0002022\u000e\b\u0002\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00070F2\u000e\b\u0002\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00070FH\u0004J\b\u0010H\u001a\u000202H\u0014J\b\u0010I\u001a\u000202H\u0014J\b\u0010J\u001a\u000202H\u0004J\b\u0010K\u001a\u000202H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\b\u0018\u00010\u000fR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010#\u001a\u0010\u0012\f\u0012\n %*\u0004\u0018\u00010\u00110\u00110$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010&\u001a\u00020'8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010\r\u001a\u0004\b(\u0010)R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010-\u001a\u0004\u0018\u00010.X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100\u00a8\u0006O"}, d2={"Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/CustomHeader;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "window", "Ljava/awt/Window;", "(Ljava/awt/Window;)V", "added", "", "buttonPanes", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/CustomFrameTitleButtons;", "getButtonPanes", "()Lcom/intellij/openapi/wm/impl/customFrameDecorations/CustomFrameTitleButtons;", "buttonPanes$delegate", "Lkotlin/Lazy;", "customFrameTopBorder", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/CustomHeader$CustomFrameTopBorder;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "iconSize", "", "getIconSize", "()I", "myActive", "getMyActive", "()Z", "setMyActive", "(Z)V", "myCloseAction", "Ljavax/swing/Action;", "getMyCloseAction", "()Ljavax/swing/Action;", "myComponentListener", "Ljava/awt/event/ComponentListener;", "myIconProvider", "Lcom/intellij/ui/scale/ScaleContext$Cache;", "kotlin.jvm.PlatformType", "productIcon", "Ljavax/swing/JComponent;", "getProductIcon", "()Ljavax/swing/JComponent;", "productIcon$delegate", "windowListener", "Ljava/awt/event/WindowAdapter;", "windowRootPane", "Ljavax/swing/JRootPane;", "getWindowRootPane", "()Ljavax/swing/JRootPane;", "addMenuItems", "", "menu", "Ljavax/swing/JPopupMenu;", "addNotify", "close", "createButtonsPane", "createProductIcon", "dispose", "getFrameIcon", "ctx", "Lcom/intellij/ui/scale/ScaleContext;", "getHitTestSpots", "", "Lcom/intellij/ui/awt/RelativeRectangle;", "installListeners", "removeNotify", "setActive", "value", "setCustomFrameTopBorder", "isTopNeeded", "Lkotlin/Function0;", "isBottomNeeded", "uninstallListeners", "updateActive", "updateCustomDecorationHitTestSpots", "windowStateChanged", "Companion", "CustomFrameAction", "CustomFrameTopBorder", "intellij.platform.ide.impl"})
public abstract class CustomHeader
extends JPanel
implements Disposable {
    private WindowAdapter windowListener;
    private final ComponentListener myComponentListener;
    private final ScaleContext.Cache<Icon> myIconProvider;
    private boolean myActive;
    @Nullable
    private final JRootPane windowRootPane;
    private CustomFrameTopBorder customFrameTopBorder;
    private final int iconSize;
    @NotNull
    private final Lazy productIcon$delegate;
    @NotNull
    private final Lazy buttonPanes$delegate;
    private boolean added;
    @NotNull
    private final Action myCloseAction;
    private final Window window;
    private static final Logger LOGGER;
    @Nullable
    private static final String WINDOWS_VERSION;
    private static final int windowBorderThicknessInPhysicalPx;
    public static final Companion Companion;

    protected final boolean getMyActive() {
        return this.myActive;
    }

    protected final void setMyActive(boolean bl) {
        this.myActive = bl;
    }

    @Nullable
    protected final JRootPane getWindowRootPane() {
        return this.windowRootPane;
    }

    private final Icon getIcon() {
        return this.getFrameIcon();
    }

    protected final int getIconSize() {
        return this.iconSize;
    }

    private final Icon getFrameIcon() {
        ScaleContext scaleContext = ScaleContext.create((Component)this.window);
        Intrinsics.checkExpressionValueIsNotNull((Object)scaleContext, (String)"ScaleContext.create(window)");
        ScaleContext ctx = scaleContext;
        ctx.overrideScale(ScaleType.USR_SCALE.of((double)UISettings.Companion.getDefFontScale()));
        Object object = this.myIconProvider.getOrProvide((UserScaleContext)ctx);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (Icon)object;
    }

    @NotNull
    protected Icon getFrameIcon(@NotNull ScaleContext ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Icon icon2 = AppUIUtil.loadSmallApplicationIcon(ctx, this.iconSize);
        Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"AppUIUtil.loadSmallApplicationIcon(ctx, iconSize)");
        return icon2;
    }

    @NotNull
    protected final JComponent getProductIcon() {
        Lazy lazy = this.productIcon$delegate;
        CustomHeader customHeader = this;
        Object var3_3 = null;
        boolean bl = false;
        return (JComponent)lazy.getValue();
    }

    @NotNull
    protected final CustomFrameTitleButtons getButtonPanes() {
        Lazy lazy = this.buttonPanes$delegate;
        CustomHeader customHeader = this;
        Object var3_3 = null;
        boolean bl = false;
        return (CustomFrameTitleButtons)lazy.getValue();
    }

    protected final void setCustomFrameTopBorder(@NotNull Function0<Boolean> isTopNeeded, @NotNull Function0<Boolean> isBottomNeeded) {
        Intrinsics.checkParameterIsNotNull(isTopNeeded, (String)"isTopNeeded");
        Intrinsics.checkParameterIsNotNull(isBottomNeeded, (String)"isBottomNeeded");
        this.customFrameTopBorder = new CustomFrameTopBorder(this, isTopNeeded, isBottomNeeded);
        this.setBorder(this.customFrameTopBorder);
    }

    public static /* synthetic */ void setCustomFrameTopBorder$default(CustomHeader customHeader, Function0 function0, Function0 function02, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setCustomFrameTopBorder");
        }
        if ((n & 1) != 0) {
            function0 = setCustomFrameTopBorder.1.INSTANCE;
        }
        if ((n & 2) != 0) {
            function02 = setCustomFrameTopBorder.2.INSTANCE;
        }
        customHeader.setCustomFrameTopBorder((Function0<Boolean>)function0, (Function0<Boolean>)function02);
    }

    @NotNull
    public abstract CustomFrameTitleButtons createButtonsPane();

    public void windowStateChanged() {
        this.updateCustomDecorationHitTestSpots();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.added = true;
        this.installListeners();
        this.updateCustomDecorationHitTestSpots();
        CustomFrameTopBorder customFrameTopBorder = this.customFrameTopBorder;
        if (customFrameTopBorder == null) {
            Intrinsics.throwNpe();
        }
        customFrameTopBorder.addNotify();
    }

    @Override
    public void removeNotify() {
        this.added = false;
        super.removeNotify();
        this.uninstallListeners();
        CustomFrameTopBorder customFrameTopBorder = this.customFrameTopBorder;
        if (customFrameTopBorder == null) {
            Intrinsics.throwNpe();
        }
        customFrameTopBorder.removeNotify();
    }

    protected void installListeners() {
        this.updateActive();
        this.window.addWindowListener(this.windowListener);
        this.window.addWindowStateListener(this.windowListener);
        this.window.addComponentListener(this.myComponentListener);
    }

    protected void uninstallListeners() {
        this.window.removeWindowListener(this.windowListener);
        this.window.removeWindowStateListener(this.windowListener);
        this.window.removeComponentListener(this.myComponentListener);
    }

    /*
     * WARNING - void declaration
     */
    protected final void updateCustomDecorationHitTestSpots() {
        if (!this.added) {
            return;
        }
        if (this.window instanceof JDialog && ((JDialog)this.window).isUndecorated() || this.window instanceof JFrame && ((JFrame)this.window).isUndecorated()) {
            JdkEx.setCustomDecorationHitTestSpots(this.window, Collections.emptyList());
            JdkEx.setCustomDecorationTitleBarHeight(this.window, 0);
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.getHitTestSpots();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RelativeRectangle relativeRectangle = (RelativeRectangle)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Rectangle rectangle = it.getRectangleOn((Component)this.window);
                collection.add(rectangle);
            }
            List toList = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            JdkEx.setCustomDecorationHitTestSpots(this.window, toList);
            JdkEx.setCustomDecorationTitleBarHeight(this.window, this.getHeight());
        }
    }

    @NotNull
    public abstract List<RelativeRectangle> getHitTestSpots();

    private final void setActive(boolean value2) {
        this.myActive = value2;
        this.updateActive();
        this.updateCustomDecorationHitTestSpots();
    }

    protected void updateActive() {
        this.getButtonPanes().setSelected(this.myActive);
        this.getButtonPanes().updateVisibility();
        CustomFrameTopBorder customFrameTopBorder = this.customFrameTopBorder;
        if (customFrameTopBorder != null) {
            customFrameTopBorder.repaintBorder();
        }
        this.setBackground(JBUI.CurrentTheme.CustomFrameDecorations.titlePaneBackground((boolean)this.myActive));
    }

    @NotNull
    protected final Action getMyCloseAction() {
        return this.myCloseAction;
    }

    protected final void close() {
        this.window.dispatchEvent(new WindowEvent(this.window, 201));
    }

    public void dispose() {
    }

    private final JComponent createProductIcon() {
        JPopupMenu menu = new JPopupMenu();
        JLabel ic2 = new JLabel(this){
            final /* synthetic */ CustomHeader this$0;

            @NotNull
            public Icon getIcon() {
                return CustomHeader.access$getIcon$p(this.this$0);
            }
            {
                this.this$0 = $outer;
            }
        };
        ic2.addMouseListener(new MouseAdapter(menu, ic2){
            final /* synthetic */ JPopupMenu $menu;
            final /* synthetic */ createProductIcon.ic.1 $ic;

            public void mousePressed(@Nullable MouseEvent e) {
                this.$menu.show(this.$ic, 0, this.$ic.getHeight());
            }
            {
                this.$menu = $captured_local_variable$0;
                this.$ic = $captured_local_variable$1;
            }
        });
        menu.setFocusable(false);
        menu.setBorderPainted(true);
        this.addMenuItems(menu);
        return ic2;
    }

    public void addMenuItems(@NotNull JPopupMenu menu) {
        JMenuItem closeMenuItem;
        Intrinsics.checkParameterIsNotNull((Object)menu, (String)"menu");
        JMenuItem jMenuItem = closeMenuItem = menu.add(this.myCloseAction);
        Intrinsics.checkExpressionValueIsNotNull((Object)jMenuItem, (String)"closeMenuItem");
        jMenuItem.setFont(JBFont.label().deriveFont(1));
    }

    public CustomHeader(@NotNull Window window) {
        Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
        this.window = window;
        this.myIconProvider = new ScaleContext.Cache(new Function<ScaleContext, D>(this){
            final /* synthetic */ CustomHeader this$0;

            @NotNull
            public final Icon apply(ScaleContext ctx) {
                ScaleContext scaleContext = ctx;
                Intrinsics.checkExpressionValueIsNotNull((Object)scaleContext, (String)"ctx");
                return this.this$0.getFrameIcon(scaleContext);
            }
            {
                this.this$0 = customHeader;
            }
        });
        Window window2 = this.window;
        this.windowRootPane = window2 instanceof JWindow ? ((JWindow)this.window).getRootPane() : (window2 instanceof JDialog ? ((JDialog)this.window).getRootPane() : (window2 instanceof JFrame ? ((JFrame)this.window).getRootPane() : null));
        this.iconSize = (int)((float)16 * UISettings.Companion.getDefFontScale());
        this.productIcon$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JComponent>(this){
            final /* synthetic */ CustomHeader this$0;

            @NotNull
            public final JComponent invoke() {
                return CustomHeader.access$createProductIcon(this.this$0);
            }
            {
                this.this$0 = customHeader;
                super(0);
            }
        }));
        this.buttonPanes$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CustomFrameTitleButtons>(this){
            final /* synthetic */ CustomHeader this$0;

            @NotNull
            public final CustomFrameTitleButtons invoke() {
                return this.this$0.createButtonsPane();
            }
            {
                this.this$0 = customHeader;
                super(0);
            }
        }));
        this.setOpaque(true);
        this.setBackground(JBUI.CurrentTheme.CustomFrameDecorations.titlePaneBackground());
        Function0<Unit> $fun$onClose$1 = new Function0<Unit>(){

            public final void invoke() {
                Disposer.dispose((Disposable)this);
            }
        };
        this.windowListener = new WindowAdapter($fun$onClose$1){
            final /* synthetic */ 1 $onClose$1;

            @Override
            public void windowActivated(@Nullable WindowEvent ev) {
                this.setActive(true);
            }

            @Override
            public void windowDeactivated(@Nullable WindowEvent ev) {
                this.setActive(false);
            }

            @Override
            public void windowClosed(@Nullable WindowEvent e) {
                this.$onClose$1.invoke();
            }

            @Override
            public void windowStateChanged(@Nullable WindowEvent e) {
                this.windowStateChanged();
            }
            {
                this.$onClose$1 = $captured_local_variable$1;
            }
        };
        this.myComponentListener = new ComponentAdapter(){

            @Override
            public void componentResized(@Nullable ComponentEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    final /* synthetic */ 3 this$0;

                    public final void run() {
                        this.this$0.this.updateCustomDecorationHitTestSpots();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
        };
        CustomHeader.setCustomFrameTopBorder$default(this, null, null, 3, null);
        Icon icon2 = AllIcons.Windows.CloseSmall;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"AllIcons.Windows.CloseSmall");
        this.myCloseAction = new CustomFrameAction("Close", icon2, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ CustomHeader this$0;

            public final void invoke() {
                this.this$0.close();
            }
            {
                this.this$0 = customHeader;
                super(0);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CustomHeader.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOGGER = logger;
        WINDOWS_VERSION = CustomHeader.Companion.getWindowsReleaseId();
        Companion companion = Companion;
        boolean bl = false;
        boolean bl2 = false;
        Companion $this$run = companion;
        boolean bl3 = false;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Intrinsics.checkExpressionValueIsNotNull((Object)graphicsEnvironment, (String)"GraphicsEnvironment.getLocalGraphicsEnvironment()");
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        Intrinsics.checkExpressionValueIsNotNull((Object)graphicsDevice, (String)"GraphicsEnvironment.getL\u2026ent().defaultScreenDevice");
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)graphicsConfiguration, (String)"GraphicsEnvironment.getL\u2026vice.defaultConfiguration");
        AffineTransform affineTransform = graphicsConfiguration.getDefaultTransform();
        Intrinsics.checkExpressionValueIsNotNull((Object)affineTransform, (String)"GraphicsEnvironment.getL\u2026guration.defaultTransform");
        double scale = affineTransform.getScaleY();
        boolean bl4 = false;
        windowBorderThicknessInPhysicalPx = (int)Math.floor(scale);
    }

    public static final /* synthetic */ Icon access$getIcon$p(CustomHeader $this) {
        return $this.getIcon();
    }

    public static final /* synthetic */ JComponent access$createProductIcon(CustomHeader $this) {
        return $this.createProductIcon();
    }

    @JvmStatic
    @NotNull
    public static final MainFrameHeader createMainFrameHeader(@NotNull JFrame frame, @Nullable IdeMenuBar delegatingMenuBar) {
        return Companion.createMainFrameHeader(frame, delegatingMenuBar);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/CustomHeader$CustomFrameAction;", "Ljavax/swing/AbstractAction;", "name", "", "icon", "Ljavax/swing/Icon;", "action", "Lkotlin/Function0;", "", "(Ljava/lang/String;Ljavax/swing/Icon;Lkotlin/jvm/functions/Function0;)V", "getAction", "()Lkotlin/jvm/functions/Function0;", "actionPerformed", "e", "Ljava/awt/event/ActionEvent;", "intellij.platform.ide.impl"})
    protected static final class CustomFrameAction
    extends AbstractAction {
        @NotNull
        private final Function0<Unit> action;

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            this.action.invoke();
        }

        @NotNull
        public final Function0<Unit> getAction() {
            return this.action;
        }

        public CustomFrameAction(@NotNull String name, @NotNull Icon icon2, @NotNull Function0<Unit> action2) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)icon2, (String)"icon");
            Intrinsics.checkParameterIsNotNull(action2, (String)"action");
            super(name, icon2);
            this.action = action2;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B%\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\bH\u0002J\b\u0010\u001b\u001a\u00020\u0004H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0004H\u0016J2\u0010#\u001a\u00020\u00192\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120%\"\u00020\u00122\u000e\b\u0004\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00190\u0003H\u0082\b\u00a2\u0006\u0002\u0010'J8\u0010(\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020\nH\u0016J\u0006\u0010/\u001a\u00020\u0019J\u0006\u00100\u001a\u00020\u0019R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u000eR \u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00061"}, d2={"Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/CustomHeader$CustomFrameTopBorder;", "Ljavax/swing/border/Border;", "isTopNeeded", "Lkotlin/Function0;", "", "isBottomNeeded", "(Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/CustomHeader;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "activeColor", "Ljava/awt/Color;", "bottomBorderWidthLogicalPx", "", "colorizationAffectsBorders", "defaultActiveBorder", "inactiveColor", "()Lkotlin/jvm/functions/Function0;", "listeners", "", "Lkotlin/Pair;", "", "Ljava/beans/PropertyChangeListener;", "menuBarBorderColor", "shouldDrawTopBorder", "getShouldDrawTopBorder", "()Z", "addNotify", "", "calculateActiveBorderColor", "calculateAffectsBorders", "calculateWindowBorderThicknessInLogicalPx", "", "getBorderInsets", "Ljava/awt/Insets;", "c", "Ljava/awt/Component;", "isBorderOpaque", "listenForPropertyChanges", "propertyNames", "", "action", "([Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "paintBorder", "g", "Ljava/awt/Graphics;", "x", "y", "width", "height", "removeNotify", "repaintBorder", "intellij.platform.ide.impl"})
    public final class CustomFrameTopBorder
    implements Border {
        private final int bottomBorderWidthLogicalPx;
        private final Color defaultActiveBorder;
        private final Color inactiveColor;
        private final Color menuBarBorderColor;
        private boolean colorizationAffectsBorders;
        private Color activeColor;
        private final List<Pair<String, PropertyChangeListener>> listeners;
        @NotNull
        private final Function0<Boolean> isTopNeeded;
        @NotNull
        private final Function0<Boolean> isBottomNeeded;
        final /* synthetic */ CustomHeader this$0;

        private final boolean calculateAffectsBorders() {
            int windowsVersion;
            Object object = Companion.getWINDOWS_VERSION();
            int n = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : (windowsVersion = 0);
            if (windowsVersion < 1809) {
                return true;
            }
            Boolean bl = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.dwm.colorizationColor.affects.borders");
            return bl != null ? bl : true;
        }

        private final Color calculateActiveBorderColor() {
            Color color;
            Integer colorizationColorBalance;
            if (!this.colorizationAffectsBorders) {
                return this.defaultActiveBorder;
            }
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            boolean bl = false;
            boolean bl2 = false;
            Toolkit $this$apply = toolkit;
            boolean bl3 = false;
            Color colorizationColor = (Color)$this$apply.getDesktopProperty("win.dwm.colorizationColor");
            if (colorizationColor != null && (colorizationColorBalance = (Integer)$this$apply.getDesktopProperty("win.dwm.colorizationColorBalance")) != null) {
                Color color2;
                Integer n;
                if (colorizationColorBalance < 0) {
                    colorizationColorBalance = 100;
                }
                if ((n = colorizationColorBalance) == 0) {
                    color2 = new Color(0xD9D9D9);
                } else if (n == 100) {
                    color2 = colorizationColor;
                } else {
                    float alpha = (float)colorizationColorBalance.intValue() / 100.0f;
                    float remainder = 1.0f - alpha;
                    int r = MathKt.roundToInt((float)((float)colorizationColor.getRed() * alpha + (float)217 * remainder));
                    int g = MathKt.roundToInt((float)((float)colorizationColor.getGreen() * alpha + (float)217 * remainder));
                    int b = MathKt.roundToInt((float)((float)colorizationColor.getBlue() * alpha + (float)217 * remainder));
                    color2 = new Color(r, g, b);
                }
                return color2;
            }
            Color color3 = colorizationColor;
            if (color3 == null) {
                color3 = color = (Color)$this$apply.getDesktopProperty("win.frame.activeBorderColor");
            }
            if (color3 == null) {
                color = this.menuBarBorderColor;
            }
            return color;
        }

        private final double calculateWindowBorderThicknessInLogicalPx() {
            return (double)windowBorderThicknessInPhysicalPx / (double)JBUIScale.sysScale((Component)this.this$0.window);
        }

        private final void listenForPropertyChanges(String[] propertyNames, Function0<Unit> action2) {
            int $i$f$listenForPropertyChanges = 0;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            PropertyChangeListener listener2 = new PropertyChangeListener(action2){
                final /* synthetic */ Function0 $action;

                public final void propertyChange(PropertyChangeEvent it) {
                    this.$action.invoke();
                }
                {
                    this.$action = function0;
                }
            };
            for (String property : propertyNames) {
                toolkit.addPropertyChangeListener(property, listener2);
                this.listeners.add(TuplesKt.to((Object)property, (Object)listener2));
            }
        }

        public final void addNotify() {
            CustomFrameTopBorder this_$iv;
            this.colorizationAffectsBorders = this.calculateAffectsBorders();
            CustomFrameTopBorder customFrameTopBorder = this;
            String[] propertyNames$iv = new String[]{"win.dwm.colorizationColor.affects.borders"};
            boolean $i$f$listenForPropertyChanges = false;
            Toolkit toolkit$iv = Toolkit.getDefaultToolkit();
            PropertyChangeListener listener$iv = new PropertyChangeListener(this){
                final /* synthetic */ CustomFrameTopBorder this$0;
                {
                    this.this$0 = customFrameTopBorder;
                }

                public final void propertyChange(PropertyChangeEvent it) {
                    boolean bl = false;
                    CustomFrameTopBorder.access$setColorizationAffectsBorders$p(this.this$0, CustomFrameTopBorder.access$calculateAffectsBorders(this.this$0));
                    CustomFrameTopBorder.access$setActiveColor$p(this.this$0, CustomFrameTopBorder.access$calculateActiveBorderColor(this.this$0));
                }
            };
            for (String property$iv : propertyNames$iv) {
                toolkit$iv.addPropertyChangeListener(property$iv, listener$iv);
                this_$iv.listeners.add(TuplesKt.to((Object)property$iv, (Object)listener$iv));
            }
            this.activeColor = this.calculateActiveBorderColor();
            this_$iv = this;
            propertyNames$iv = new String[]{"win.dwm.colorizationColor", "win.dwm.colorizationColorBalance", "win.frame.activeBorderColor"};
            $i$f$listenForPropertyChanges = false;
            toolkit$iv = Toolkit.getDefaultToolkit();
            listener$iv = new PropertyChangeListener(this){
                final /* synthetic */ CustomFrameTopBorder this$0;
                {
                    this.this$0 = customFrameTopBorder;
                }

                public final void propertyChange(PropertyChangeEvent it) {
                    boolean bl = false;
                    CustomFrameTopBorder.access$setActiveColor$p(this.this$0, CustomFrameTopBorder.access$calculateActiveBorderColor(this.this$0));
                }
            };
            for (String property$iv : propertyNames$iv) {
                toolkit$iv.addPropertyChangeListener(property$iv, listener$iv);
                this_$iv.listeners.add(TuplesKt.to((Object)property$iv, (Object)listener$iv));
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void removeNotify() {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            for (Pair<String, PropertyChangeListener> pair : this.listeners) {
                void propertyName;
                String string = (String)pair.component1();
                PropertyChangeListener listener2 = (PropertyChangeListener)pair.component2();
                toolkit.removePropertyChangeListener((String)propertyName, listener2);
            }
            this.listeners.clear();
        }

        public final void repaintBorder() {
            Insets borderInsets = this.getBorderInsets(this.this$0);
            double thickness = this.calculateWindowBorderThicknessInLogicalPx();
            int n = this.this$0.getWidth();
            int n2 = 0;
            int n3 = 0;
            CustomHeader customHeader = this.this$0;
            boolean bl = false;
            double d = Math.ceil(thickness);
            customHeader.repaint(n3, n2, n, (int)d);
            this.this$0.repaint(0, this.this$0.getHeight() - borderInsets.bottom, this.this$0.getWidth(), borderInsets.bottom);
        }

        private final boolean getShouldDrawTopBorder() {
            boolean drawTopBorderActive = this.this$0.getMyActive() && (this.colorizationAffectsBorders || UIUtil.isUnderIntelliJLaF());
            boolean drawTopBorderInactive = !this.this$0.getMyActive() && UIUtil.isUnderIntelliJLaF();
            return drawTopBorderActive || drawTopBorderInactive;
        }

        @Override
        public void paintBorder(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height) {
            Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
            Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
            double thickness = this.calculateWindowBorderThicknessInLogicalPx();
            if (((Boolean)this.isTopNeeded.invoke()).booleanValue() && this.getShouldDrawTopBorder()) {
                g.setColor(this.this$0.getMyActive() ? this.activeColor : this.inactiveColor);
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)y, (double)width, (double)y, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.INSIDE, (double)thickness);
            }
            if (((Boolean)this.isBottomNeeded.invoke()).booleanValue()) {
                g.setColor(this.menuBarBorderColor);
                int y1 = y + height - this.bottomBorderWidthLogicalPx;
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)y1, (double)width, (double)y1);
            }
        }

        @Override
        @NotNull
        public Insets getBorderInsets(@NotNull Component c) {
            int n;
            Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
            double thickness = this.calculateWindowBorderThicknessInLogicalPx();
            if (((Boolean)this.isTopNeeded.invoke()).booleanValue() && (this.colorizationAffectsBorders || UIUtil.isUnderIntelliJLaF())) {
                boolean bl = false;
                n = (int)Math.ceil(thickness);
            } else {
                n = 0;
            }
            int top = n;
            int bottom = (Boolean)this.isBottomNeeded.invoke() != false ? this.bottomBorderWidthLogicalPx : 0;
            return new Insets(top, 0, bottom, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @NotNull
        public final Function0<Boolean> isTopNeeded() {
            return this.isTopNeeded;
        }

        @NotNull
        public final Function0<Boolean> isBottomNeeded() {
            return this.isBottomNeeded;
        }

        public CustomFrameTopBorder(@NotNull CustomHeader $outer, @NotNull Function0<Boolean> isTopNeeded, Function0<Boolean> isBottomNeeded) {
            List list2;
            Intrinsics.checkParameterIsNotNull(isTopNeeded, (String)"isTopNeeded");
            Intrinsics.checkParameterIsNotNull(isBottomNeeded, (String)"isBottomNeeded");
            this.this$0 = $outer;
            this.isTopNeeded = isTopNeeded;
            this.isBottomNeeded = isBottomNeeded;
            this.bottomBorderWidthLogicalPx = JBUI.scale((int)1);
            this.defaultActiveBorder = new Color(0x707070);
            this.inactiveColor = new Color(0xAAAAAA);
            JBColor jBColor = JBColor.namedColor((String)"MenuBar.borderColor", (Color)((Color)new JBColor((Color)Gray.xCD, (Color)Gray.x51)));
            Intrinsics.checkExpressionValueIsNotNull((Object)jBColor, (String)"JBColor.namedColor(\"Menu\u2026olor(Gray.xCD, Gray.x51))");
            this.menuBarBorderColor = (Color)jBColor;
            this.activeColor = this.defaultActiveBorder;
            CustomFrameTopBorder customFrameTopBorder = this;
            boolean bl = false;
            customFrameTopBorder.listeners = list2 = (List)new ArrayList();
        }

        public /* synthetic */ CustomFrameTopBorder(CustomHeader customHeader, Function0 function0, Function0 function02, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                function0 = 1.INSTANCE;
            }
            if ((n & 2) != 0) {
                function02 = 2.INSTANCE;
            }
            this(customHeader, (Function0<Boolean>)function0, (Function0<Boolean>)function02);
        }

        public static final /* synthetic */ boolean access$getColorizationAffectsBorders$p(CustomFrameTopBorder $this) {
            return $this.colorizationAffectsBorders;
        }

        public static final /* synthetic */ void access$setColorizationAffectsBorders$p(CustomFrameTopBorder $this, boolean bl) {
            $this.colorizationAffectsBorders = bl;
        }

        public static final /* synthetic */ boolean access$calculateAffectsBorders(CustomFrameTopBorder $this) {
            return $this.calculateAffectsBorders();
        }

        public static final /* synthetic */ Color access$getActiveColor$p(CustomFrameTopBorder $this) {
            return $this.activeColor;
        }

        public static final /* synthetic */ void access$setActiveColor$p(CustomFrameTopBorder $this, Color color) {
            $this.activeColor = color;
        }

        public static final /* synthetic */ Color access$calculateActiveBorderColor(CustomFrameTopBorder $this) {
            return $this.calculateActiveBorderColor();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001a\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0007J\n\u0010!\u001a\u0004\u0018\u00010\u0011H\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0006R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/CustomHeader$Companion;", "", "()V", "H", "", "getH", "()I", "LABEL_BORDER", "Lcom/intellij/util/ui/JBEmptyBorder;", "Lorg/jetbrains/annotations/NotNull;", "getLABEL_BORDER", "()Lcom/intellij/util/ui/JBEmptyBorder;", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "V", "getV", "WINDOWS_VERSION", "", "getWINDOWS_VERSION", "()Ljava/lang/String;", "windowBorderThicknessInPhysicalPx", "create", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/CustomHeader;", "window", "Ljava/awt/Window;", "createFrameHeader", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/DefaultFrameHeader;", "frame", "Ljavax/swing/JFrame;", "createMainFrameHeader", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/MainFrameHeader;", "delegatingMenuBar", "Lcom/intellij/openapi/wm/impl/IdeMenuBar;", "getWindowsReleaseId", "intellij.platform.ide.impl"})
    public static final class Companion {
        public final int getH() {
            return 7;
        }

        public final int getV() {
            return 5;
        }

        @NotNull
        public final JBEmptyBorder getLABEL_BORDER() {
            JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty((int)Companion.getV(), (int)0);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBEmptyBorder, (String)"JBUI.Borders.empty(V, 0)");
            return jBEmptyBorder;
        }

        @Nullable
        public final String getWINDOWS_VERSION() {
            return WINDOWS_VERSION;
        }

        private final String getWindowsReleaseId() {
            try {
                if (JnaLoader.isLoaded()) {
                    return Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", (String)"ReleaseId");
                }
            }
            catch (Throwable e) {
                LOGGER.warn(e);
            }
            return WindowsRegistryUtil.readRegistryValue((String)"HKLM\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", (String)"ReleaseId");
        }

        @NotNull
        public final CustomHeader create(@NotNull Window window) {
            Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
            return window instanceof JFrame ? (CustomHeader)(((JFrame)window).getRootPane() instanceof IdeRootPane ? (FrameHeader)this.createMainFrameHeader((JFrame)window, null) : (FrameHeader)this.createFrameHeader((JFrame)window)) : (CustomHeader)new DialogHeader(window);
        }

        private final DefaultFrameHeader createFrameHeader(JFrame frame) {
            return new DefaultFrameHeader(frame);
        }

        @JvmStatic
        @NotNull
        public final MainFrameHeader createMainFrameHeader(@NotNull JFrame frame, @Nullable IdeMenuBar delegatingMenuBar) {
            Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
            return new MainFrameHeader(frame, delegatingMenuBar);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

