/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.util.MinimizeButton;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.impl.status.InfoAndProgressPanel;
import com.intellij.openapi.wm.impl.status.InlineProgressIndicator;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.VerticalBox;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import org.jetbrains.annotations.NotNull;

public class ProcessPopup {
    private final VerticalBox myProcessBox = new VerticalBox();
    private final InfoAndProgressPanel myProgressPanel;
    private JBPopup myPopup;
    private JPanel myActiveFocusedContent;
    private JComponent myActiveContentComponent;
    private final JLabel myInactiveContentComponent;
    private final Wrapper myRootContent = new Wrapper();
    private final Set<InlineProgressIndicator> myIndicators = new HashSet<InlineProgressIndicator>();

    public ProcessPopup(InfoAndProgressPanel progressPanel) {
        this.myProgressPanel = progressPanel;
        this.buildActiveContent();
        this.myInactiveContentComponent = new JLabel(IdeBundle.message((String)"progress.window.empty.text", (Object[])new Object[0]), null, 0){

            @Override
            public Dimension getPreferredSize() {
                return ProcessPopup.getEmptyPreferredSize();
            }
        };
        this.myInactiveContentComponent.setFocusable(true);
        this.switchToPassive();
    }

    public void addIndicator(InlineProgressIndicator indicator) {
        this.myIndicators.add(indicator);
        this.myProcessBox.add((Component)indicator.getComponent());
        this.myProcessBox.add(Box.createVerticalStrut(4));
        this.swithToActive();
        this.revalidateAll();
    }

    public void removeIndicator(InlineProgressIndicator indicator) {
        if (indicator.getComponent().getParent() != this.myProcessBox) {
            return;
        }
        this.removeExtraSeparator(indicator);
        this.myProcessBox.remove((Component)indicator.getComponent());
        this.myIndicators.remove(indicator);
        this.switchToPassive();
        this.revalidateAll();
    }

    private void swithToActive() {
        if (this.myActiveContentComponent.getParent() == null && this.myIndicators.size() > 0) {
            this.myRootContent.removeAll();
            this.myRootContent.setContent(this.myActiveContentComponent);
        }
    }

    private void switchToPassive() {
        if (this.myInactiveContentComponent.getParent() == null && this.myIndicators.size() == 0) {
            this.myRootContent.removeAll();
            this.myRootContent.setContent((JComponent)this.myInactiveContentComponent);
        }
    }

    private void removeExtraSeparator(InlineProgressIndicator indicator) {
        Object[] all = this.myProcessBox.getComponents();
        int index = ArrayUtil.indexOf((Object[])all, (Object)indicator.getComponent());
        if (index == -1) {
            return;
        }
        if (index == 0 && all.length > 1) {
            this.myProcessBox.remove(1);
        } else if (all.length > 2 && index < all.length - 1) {
            this.myProcessBox.remove(index + 1);
        }
        this.myProcessBox.remove((Component)indicator.getComponent());
    }

    public void show(boolean requestFocus) {
        JComponent toFocus = this.myRootContent.getTargetComponent() == this.myActiveContentComponent ? this.myActiveFocusedContent : this.myInactiveContentComponent;
        ComponentPopupBuilder builder2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.myRootContent, toFocus);
        builder2.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                ProcessPopup.this.myProgressPanel.hideProcessPopup();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/status/ProcessPopup$2", "onClosed"));
            }
        });
        builder2.setMovable(true);
        builder2.setResizable(true);
        builder2.setTitle(IdeBundle.message((String)"progress.window.title", (Object[])new Object[0]));
        builder2.setDimensionServiceKey(null, "ProcessPopupWindow", true);
        builder2.setCancelOnClickOutside(false);
        builder2.setRequestFocus(requestFocus);
        builder2.setBelongsToGlobalPopupStack(false);
        builder2.setLocateByContent(true);
        builder2.setCancelButton((IconButton)new MinimizeButton("Hide"));
        JFrame frame = (JFrame)UIUtil.findUltimateParent((Component)this.myProgressPanel);
        this.updateContentUI();
        this.myActiveContentComponent.setBorder(null);
        if (frame != null) {
            Dimension contentSize = this.myRootContent.getPreferredSize();
            Rectangle bounds2 = frame.getBounds();
            int width = Math.max(bounds2.width / 4, contentSize.width);
            int height = Math.min(bounds2.height / 4, contentSize.height);
            int x = (int)(bounds2.getMaxX() - (double)width);
            int y = (int)(bounds2.getMaxY() - (double)height);
            this.myPopup = builder2.addUserData((Object)"SIMPLE_WINDOW").createPopup();
            this.myPopup.getContent().putClientProperty("FirstTimeSize", new JBDimension(400, 0));
            StatusBarEx sb = (StatusBarEx)((IdeFrame)frame).getStatusBar();
            if (sb.isVisible()) {
                y -= sb.getSize().height;
            }
            this.myPopup.showInScreenCoordinates((Component)this.myProgressPanel.getRootPane(), new Point(x - 5, y - 5));
        } else {
            this.myPopup = builder2.createPopup();
            this.myPopup.showInCenterOf((Component)this.myProgressPanel.getRootPane());
        }
    }

    private void buildActiveContent() {
        this.myActiveFocusedContent = new ActiveContent();
        JPanel wrapper2 = new JPanel(new BorderLayout());
        wrapper2.add((Component)this.myProcessBox, "North");
        this.myActiveFocusedContent.add((Component)wrapper2, "Center");
        this.myActiveContentComponent = new JBScrollPane(this.myActiveFocusedContent){

            public Dimension getPreferredSize() {
                if (ProcessPopup.this.myProcessBox.getComponentCount() > 0) {
                    return super.getPreferredSize();
                }
                return ProcessPopup.getEmptyPreferredSize();
            }
        };
        this.updateContentUI();
    }

    private void updateContentUI() {
        if (this.myActiveContentComponent == null || this.myActiveFocusedContent == null) {
            return;
        }
        IJSwingUtilities.updateComponentTreeUI(this.myActiveContentComponent);
        if (this.myActiveContentComponent instanceof JScrollPane) {
            ((JScrollPane)this.myActiveContentComponent).getViewport().setBackground(this.myActiveFocusedContent.getBackground());
        }
        this.myActiveContentComponent.setBorder(null);
    }

    private static Dimension getEmptyPreferredSize() {
        Dimension size = ScreenUtil.getMainScreenBounds().getSize();
        size.width = (int)((double)size.width * 0.3);
        size.height = (int)((double)size.height * 0.3);
        return size;
    }

    public void hide() {
        if (this.myPopup != null) {
            JBPopup popup2 = this.myPopup;
            this.myPopup = null;
            popup2.cancel();
        }
    }

    public boolean isShowing() {
        return this.myPopup != null;
    }

    private void revalidateAll() {
        this.myRootContent.revalidate();
        this.myRootContent.repaint();
    }

    private static class ActiveContent
    extends JPanel
    implements Scrollable {
        private final JLabel myLabel = new JLabel("XXX");

        ActiveContent() {
            super(new BorderLayout());
            this.setBorder(DialogWrapper.createDefaultBorder());
            this.setFocusable(true);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.myLabel.getPreferredSize().height;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.myLabel.getPreferredSize().height;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

