/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status.widget;

import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.StatusBarWidgetProvider;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetProviderToFactoryAdapter;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetSettings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class StatusBarWidgetsManager
extends SimpleModificationTracker
implements Disposable {
    @NotNull
    private static final Logger LOG = Logger.getInstance(StatusBar.class);
    private final Map<StatusBarWidgetFactory, StatusBarWidget> myWidgetFactories;
    private final Map<String, StatusBarWidgetFactory> myWidgetIdsMap;
    private final Project myProject;

    public StatusBarWidgetsManager(@NotNull Project project) {
        if (project == null) {
            StatusBarWidgetsManager.$$$reportNull$$$0(0);
        }
        this.myWidgetFactories = new LinkedHashMap<StatusBarWidgetFactory, StatusBarWidget>();
        this.myWidgetIdsMap = new HashMap<String, StatusBarWidgetFactory>();
        this.myProject = project;
        Disposer.register((Disposable)this.myProject, (Disposable)this);
        StatusBarWidgetFactory.EP_NAME.getPoint(null).addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<StatusBarWidgetFactory>(){

            public void extensionAdded(@NotNull StatusBarWidgetFactory factory, @NotNull PluginDescriptor pluginDescriptor) {
                if (factory == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                StatusBarWidgetsManager.this.addWidgetFactory(factory);
            }

            public void extensionRemoved(@NotNull StatusBarWidgetFactory factory, @NotNull PluginDescriptor pluginDescriptor) {
                if (factory == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                StatusBarWidgetsManager.this.removeWidgetFactory(factory);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "factory";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/widget/StatusBarWidgetsManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, true, (Disposable)this);
        StatusBarWidgetProvider.EP_NAME.getPoint(null).addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<StatusBarWidgetProvider>(){

            public void extensionAdded(@NotNull StatusBarWidgetProvider provider, @NotNull PluginDescriptor pluginDescriptor) {
                if (provider == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                StatusBarWidgetsManager.this.addWidgetFactory(new StatusBarWidgetProviderToFactoryAdapter(StatusBarWidgetsManager.this.myProject, provider));
            }

            public void extensionRemoved(@NotNull StatusBarWidgetProvider provider, @NotNull PluginDescriptor pluginDescriptor) {
                if (provider == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                StatusBarWidgetsManager.this.removeWidgetFactory(new StatusBarWidgetProviderToFactoryAdapter(StatusBarWidgetsManager.this.myProject, provider));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "provider";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/widget/StatusBarWidgetsManager$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, true, (Disposable)this);
    }

    public void updateAllWidgets() {
        for (StatusBarWidgetFactory factory : this.myWidgetFactories.keySet()) {
            this.updateWidget(factory);
        }
    }

    public void updateWidget(@NotNull Class<? extends StatusBarWidgetFactory> factoryExtension) {
        StatusBarWidgetFactory factory;
        if (factoryExtension == null) {
            StatusBarWidgetsManager.$$$reportNull$$$0(1);
        }
        if ((factory = (StatusBarWidgetFactory)StatusBarWidgetFactory.EP_NAME.findExtension(factoryExtension)) == null) {
            LOG.error("Factory is not registered as `com.intellij.statusBarWidgetFactory` extension: " + factoryExtension.getName());
            return;
        }
        this.updateWidget(factory);
    }

    public void updateWidget(@NotNull StatusBarWidgetFactory factory) {
        if (factory == null) {
            StatusBarWidgetsManager.$$$reportNull$$$0(2);
        }
        if (factory.isAvailable(this.myProject) && (!factory.isConfigurable() || ((StatusBarWidgetSettings)((Object)ServiceManager.getService(StatusBarWidgetSettings.class))).isEnabled(factory))) {
            this.enableWidget(factory);
        } else {
            this.disableWidget(factory);
        }
    }

    public boolean wasWidgetCreated(@Nullable StatusBarWidgetFactory factory) {
        return this.myWidgetFactories.get(factory) != null;
    }

    public void dispose() {
        this.myWidgetFactories.forEach((factory, createdWidget) -> {
            if (createdWidget != null) {
                factory.disposeWidget(createdWidget);
            }
        });
        this.myWidgetFactories.clear();
    }

    @Nullable
    public StatusBarWidgetFactory findWidgetFactory(@NotNull String widgetId) {
        if (widgetId == null) {
            StatusBarWidgetsManager.$$$reportNull$$$0(3);
        }
        return this.myWidgetIdsMap.get(widgetId);
    }

    @NotNull
    public Set<StatusBarWidgetFactory> getWidgetFactories() {
        Set<StatusBarWidgetFactory> set = this.myWidgetFactories.keySet();
        if (set == null) {
            StatusBarWidgetsManager.$$$reportNull$$$0(4);
        }
        return set;
    }

    private void enableWidget(@NotNull StatusBarWidgetFactory factory) {
        if (factory == null) {
            StatusBarWidgetsManager.$$$reportNull$$$0(5);
        }
        if (!this.myWidgetFactories.containsKey(factory)) {
            LOG.error("Factory is not registered as `com.intellij.statusBarWidgetFactory` extension: " + factory.getId());
            return;
        }
        StatusBarWidget createdWidget = this.myWidgetFactories.get(factory);
        if (createdWidget != null) {
            return;
        }
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.myProject);
        if (statusBar == null) {
            LOG.error("Cannot add a widget for project without root status bar: " + factory.getId());
            return;
        }
        StatusBarWidget widget = factory.createWidget(this.myProject);
        this.myWidgetFactories.put(factory, widget);
        this.myWidgetIdsMap.put(widget.ID(), factory);
        statusBar.addWidget(widget, this.getAnchor(factory), (Disposable)this);
        Disposer.register((Disposable)this, () -> this.disableWidget(factory));
    }

    @NotNull
    private String getAnchor(@NotNull StatusBarWidgetFactory factory) {
        StatusBarWidget widget;
        int i;
        if (factory == null) {
            StatusBarWidgetsManager.$$$reportNull$$$0(6);
        }
        if (factory instanceof StatusBarWidgetProviderToFactoryAdapter) {
            String string = ((StatusBarWidgetProviderToFactoryAdapter)factory).getAnchor();
            if (string == null) {
                StatusBarWidgetsManager.$$$reportNull$$$0(7);
            }
            return string;
        }
        List factories = StatusBarWidgetFactory.EP_NAME.getExtensionList();
        int indexOf2 = factories.indexOf(factory);
        for (i = indexOf2 + 1; i < factories.size(); ++i) {
            StatusBarWidgetFactory nextFactory = (StatusBarWidgetFactory)factories.get(i);
            widget = this.myWidgetFactories.get(nextFactory);
            if (widget == null) continue;
            String string = StatusBar.Anchors.before((String)widget.ID());
            if (string == null) {
                StatusBarWidgetsManager.$$$reportNull$$$0(8);
            }
            return string;
        }
        for (i = indexOf2 - 1; i >= 0; --i) {
            StatusBarWidgetFactory prevFactory = (StatusBarWidgetFactory)factories.get(i);
            widget = this.myWidgetFactories.get(prevFactory);
            if (widget == null) continue;
            String string = StatusBar.Anchors.after((String)widget.ID());
            if (string == null) {
                StatusBarWidgetsManager.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = StatusBar.Anchors.DEFAULT_ANCHOR;
        if (string == null) {
            StatusBarWidgetsManager.$$$reportNull$$$0(10);
        }
        return string;
    }

    private void disableWidget(@NotNull StatusBarWidgetFactory factory) {
        StatusBarWidget createdWidget;
        if (factory == null) {
            StatusBarWidgetsManager.$$$reportNull$$$0(11);
        }
        if ((createdWidget = (StatusBarWidget)this.myWidgetFactories.put(factory, null)) != null) {
            this.myWidgetIdsMap.remove(createdWidget.ID());
            factory.disposeWidget(createdWidget);
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.myProject);
            if (statusBar != null) {
                statusBar.removeWidget(createdWidget.ID());
            }
        }
    }

    public boolean canBeEnabledOnStatusBar(@NotNull StatusBarWidgetFactory factory, @NotNull StatusBar statusBar) {
        if (factory == null) {
            StatusBarWidgetsManager.$$$reportNull$$$0(12);
        }
        if (statusBar == null) {
            StatusBarWidgetsManager.$$$reportNull$$$0(13);
        }
        return factory.isAvailable(this.myProject) && factory.isConfigurable() && factory.canBeEnabledOn(statusBar);
    }

    private void addWidgetFactory(@NotNull StatusBarWidgetFactory factory) {
        if (factory == null) {
            StatusBarWidgetsManager.$$$reportNull$$$0(14);
        }
        if (LightEdit.owns((Project)this.myProject) && !(factory instanceof LightEditCompatible)) {
            return;
        }
        if (this.myWidgetFactories.containsKey(factory)) {
            LOG.error("Factory has been added already: " + factory.getId());
            return;
        }
        this.myWidgetFactories.put(factory, null);
        this.incModificationCount();
    }

    private void removeWidgetFactory(@NotNull StatusBarWidgetFactory factory) {
        if (factory == null) {
            StatusBarWidgetsManager.$$$reportNull$$$0(15);
        }
        this.disableWidget(factory);
        this.myWidgetFactories.remove(factory);
        this.incModificationCount();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryExtension";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widgetId";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/status/widget/StatusBarWidgetsManager";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/widget/StatusBarWidgetsManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getWidgetFactories";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateWidget";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findWidgetFactory";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "enableWidget";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAnchor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "disableWidget";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canBeEnabledOnStatusBar";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addWidgetFactory";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeWidgetFactory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

