/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconLayerProvider;
import com.intellij.ide.IconProvider;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.SourceRootPresentation;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SourceRootIconProvider {
    @NotNull
    public static Icon getDirectoryIcon(VirtualFile vFile, Project project) {
        SourceFolder sourceFolder = ProjectRootsUtil.getModuleSourceRoot(vFile, project);
        if (sourceFolder != null) {
            Icon icon2 = SourceRootPresentation.getSourceRootIcon(sourceFolder);
            if (icon2 == null) {
                SourceRootIconProvider.$$$reportNull$$$0(0);
            }
            return icon2;
        }
        Icon excludedIcon = SourceRootIconProvider.getIconIfExcluded(project, vFile);
        Icon icon3 = excludedIcon != null ? excludedIcon : PlatformIcons.FOLDER_ICON;
        if (icon3 == null) {
            SourceRootIconProvider.$$$reportNull$$$0(1);
        }
        return icon3;
    }

    @Nullable
    public static Icon getIconIfExcluded(@NotNull Project project, @NotNull VirtualFile vFile) {
        boolean ignored;
        if (project == null) {
            SourceRootIconProvider.$$$reportNull$$$0(2);
        }
        if (vFile == null) {
            SourceRootIconProvider.$$$reportNull$$$0(3);
        }
        if (!Registry.is((String)"ide.hide.excluded.files") && (ignored = ProjectRootManager.getInstance((Project)project).getFileIndex().isExcluded(vFile))) {
            return AllIcons.Modules.ExcludeRoot;
        }
        return null;
    }

    @Nullable
    private static Icon calcFileLayerIcon(VirtualFile vFile, Project project) {
        ProjectFileIndex index = ProjectFileIndex.getInstance((Project)project);
        if (vFile != null) {
            VirtualFile parent = vFile.getParent();
            if (index.isExcluded(vFile)) {
                if (parent == null || !index.isExcluded(parent)) {
                    return AllIcons.Nodes.ExcludedFromCompile;
                }
            } else {
                SourceFolder sourceFolder = index.getSourceFolder(vFile);
                if (sourceFolder != null && vFile.equals(sourceFolder.getFile())) {
                    SourceFolder parentSourceFolder;
                    SourceFolder sourceFolder2 = parentSourceFolder = parent == null ? null : index.getSourceFolder(parent);
                    if (parentSourceFolder == null || !sourceFolder.equals(parentSourceFolder)) {
                        return SourceRootPresentation.getSourceRootFileLayerIcon(sourceFolder);
                    }
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/file/SourceRootIconProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryIcon";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/file/SourceRootIconProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIconIfExcluded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FileLayerProvider
    implements IconLayerProvider,
    DumbAware {
        @Nullable
        public Icon getLayerIcon(@NotNull Iconable element2, boolean isLocked) {
            if (element2 == null) {
                FileLayerProvider.$$$reportNull$$$0(0);
            }
            if (element2 instanceof PsiFile) {
                Project project = ((PsiFile)element2).getProject();
                VirtualFile virtualFile = ((PsiFile)element2).getVirtualFile();
                return (Icon)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)element2), () -> CachedValueProvider.Result.create((Object)SourceRootIconProvider.calcFileLayerIcon(virtualFile, project), (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)}));
            }
            return null;
        }

        @NotNull
        public String getLayerDescription() {
            return "Source root files";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/file/SourceRootIconProvider$FileLayerProvider", "getLayerIcon"));
        }
    }

    public static class DirectoryProvider
    extends IconProvider
    implements DumbAware {
        public Icon getIcon(@NotNull PsiElement element2, int flags) {
            if (element2 == null) {
                DirectoryProvider.$$$reportNull$$$0(0);
            }
            if (element2 instanceof PsiDirectory) {
                PsiDirectory psiDirectory = (PsiDirectory)element2;
                return SourceRootIconProvider.getDirectoryIcon(psiDirectory.getVirtualFile(), psiDirectory.getProject());
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/file/SourceRootIconProvider$DirectoryProvider", "getIcon"));
        }
    }
}

