/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.options.SchemeImportUtil;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class CodeStyleSettingsLoader {
    public CodeStyleSettings loadSettings(@NotNull VirtualFile file2) throws SchemeImportException {
        if (file2 == null) {
            CodeStyleSettingsLoader.$$$reportNull$$$0(0);
        }
        Element rootElement = SchemeImportUtil.loadSchemeDom(file2);
        CodeStyleSettings settings = new CodeStyleSettings();
        CodeStyleSettingsLoader.loadSettings(rootElement, settings);
        return settings;
    }

    protected static void loadSettings(@NotNull Element rootElement, @NotNull CodeStyleSettings settings) throws SchemeImportException {
        if (rootElement == null) {
            CodeStyleSettingsLoader.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            CodeStyleSettingsLoader.$$$reportNull$$$0(2);
        }
        try {
            settings.readExternal(CodeStyleSettingsLoader.findSchemeRoot(rootElement));
        }
        catch (InvalidDataException e) {
            throw new SchemeImportException(ApplicationBundle.message((String)"settings.code.style.import.xml.error.can.not.load", (Object[])new Object[]{e.getMessage()}));
        }
    }

    protected static Element findSchemeRoot(@NotNull Element rootElement) throws SchemeImportException {
        String rootName;
        if (rootElement == null) {
            CodeStyleSettingsLoader.$$$reportNull$$$0(3);
        }
        if ("project".equals(rootName = rootElement.getName())) {
            Element child2 = rootElement.getChild("component");
            if (child2 != null && "ProjectCodeStyleSettingsManager".equals(child2.getAttributeValue("name")) && (child2 = child2.getChild("option")) != null && "PER_PROJECT_SETTINGS".equals(child2.getAttributeValue("name")) && (child2 = child2.getChild("value")) != null) {
                return child2;
            }
            throw new SchemeImportException("Invalid scheme root: " + rootName);
        }
        if ("component".equals(rootName)) {
            Element child3;
            if ("ProjectCodeStyleConfiguration".equals(rootElement.getAttributeValue("name")) && (child3 = rootElement.getChild("code_scheme")) != null) {
                return child3;
            }
            throw new SchemeImportException("Invalid scheme root: " + rootName);
        }
        return rootElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/CodeStyleSettingsLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findSchemeRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

