/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ColoredItem;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ChangeListsScopesProvider;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchScopeProvider;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.FileColorManager;
import com.intellij.util.TreeItem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultSearchScopeProviders {
    private DefaultSearchScopeProviders() {
    }

    @NotNull
    private static GlobalSearchScope wrapNamedScope(@NotNull Project project, @NotNull NamedScope namedScope, boolean colored) {
        if (project == null) {
            DefaultSearchScopeProviders.$$$reportNull$$$0(0);
        }
        if (namedScope == null) {
            DefaultSearchScopeProviders.$$$reportNull$$$0(1);
        }
        GlobalSearchScope scope = GlobalSearchScopesCore.filterScope((Project)project, (NamedScope)namedScope);
        if (!colored && !(namedScope instanceof WeighedItem)) {
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                DefaultSearchScopeProviders.$$$reportNull$$$0(2);
            }
            return globalSearchScope;
        }
        int weight2 = namedScope instanceof WeighedItem ? ((WeighedItem)namedScope).getWeight() : -1;
        Color color = !colored ? null : FileColorManager.getInstance((Project)project).getScopeColor(namedScope.getName());
        return new MyWeightedScope(scope, weight2, color);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/DefaultSearchScopeProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/DefaultSearchScopeProviders";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapNamedScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrapNamedScope";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyWeightedScope
    extends DelegatingGlobalSearchScope
    implements WeighedItem,
    ColoredItem {
        final int weight;
        final Color color;

        MyWeightedScope(@NotNull GlobalSearchScope scope, int weight2, Color color) {
            if (scope == null) {
                MyWeightedScope.$$$reportNull$$$0(0);
            }
            super(scope);
            this.weight = weight2;
            this.color = color;
        }

        public int getWeight() {
            return this.weight;
        }

        @Nullable
        public Color getColor() {
            return this.color;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/DefaultSearchScopeProviders$MyWeightedScope", "<init>"));
        }
    }

    public static class CustomNamed
    implements SearchScopeProvider {
        @Override
        public String getDisplayName() {
            return "Other";
        }

        @Override
        @NotNull
        public List<SearchScope> getSearchScopes(@NotNull Project project, @NotNull DataContext dataContext) {
            NamedScopesHolder[] holders;
            if (project == null) {
                CustomNamed.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                CustomNamed.$$$reportNull$$$0(1);
            }
            ArrayList<SearchScope> result2 = new ArrayList<SearchScope>();
            for (NamedScopesHolder holder : holders = NamedScopesHolder.getAllNamedScopeHolders((Project)project)) {
                NamedScope[] scopes;
                for (NamedScope scope : scopes = holder.getEditableScopes()) {
                    result2.add((SearchScope)DefaultSearchScopeProviders.wrapNamedScope(project, scope, true));
                }
            }
            ArrayList<SearchScope> arrayList = result2;
            if (arrayList == null) {
                CustomNamed.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/DefaultSearchScopeProviders$CustomNamed";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/DefaultSearchScopeProviders$CustomNamed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSearchScopes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSearchScopes";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ChangeLists
    implements SearchScopeProvider {
        @Override
        public String getDisplayName() {
            return "Local Changes";
        }

        @Override
        @NotNull
        public List<SearchScope> getSearchScopes(@NotNull Project project, @NotNull DataContext dataContext) {
            if (project == null) {
                ChangeLists.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                ChangeLists.$$$reportNull$$$0(1);
            }
            ArrayList<SearchScope> result2 = new ArrayList<SearchScope>();
            List changeLists = ChangeListsScopesProvider.getInstance(project).getFilteredScopes();
            if (!changeLists.isEmpty()) {
                for (NamedScope changeListScope : changeLists) {
                    result2.add((SearchScope)DefaultSearchScopeProviders.wrapNamedScope(project, changeListScope, false));
                }
            }
            ArrayList<SearchScope> arrayList = result2;
            if (arrayList == null) {
                ChangeLists.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/DefaultSearchScopeProviders$ChangeLists";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/DefaultSearchScopeProviders$ChangeLists";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSearchScopes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSearchScopes";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Favorites
    implements SearchScopeProvider {
        @Override
        public String getDisplayName() {
            return "Favorites";
        }

        @Override
        @NotNull
        public List<SearchScope> getSearchScopes(@NotNull Project project, @NotNull DataContext dataContext) {
            FavoritesManager favoritesManager;
            if (project == null) {
                Favorites.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                Favorites.$$$reportNull$$$0(1);
            }
            if ((favoritesManager = FavoritesManager.getInstance(project)) == null) {
                List<SearchScope> list2 = Collections.emptyList();
                if (list2 == null) {
                    Favorites.$$$reportNull$$$0(2);
                }
                return list2;
            }
            ArrayList<SearchScope> result2 = new ArrayList<SearchScope>();
            for (final String favorite : favoritesManager.getAvailableFavoritesListNames()) {
                List<TreeItem<Pair<AbstractUrl, String>>> rootUrls = favoritesManager.getFavoritesListRootUrls(favorite);
                if (rootUrls.isEmpty()) continue;
                result2.add((SearchScope)new GlobalSearchScope(project){

                    @NotNull
                    public String getDisplayName() {
                        String string = "Favorite '" + favorite + "'";
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    public boolean contains(@NotNull VirtualFile file2) {
                        if (file2 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return (Boolean)ReadAction.compute(() -> favoritesManager.contains(favorite, file2));
                    }

                    public boolean isSearchInModuleContent(@NotNull Module aModule) {
                        if (aModule == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return true;
                    }

                    public boolean isSearchInLibraries() {
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                            case 1: 
                            case 2: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 2;
                                break;
                            }
                            case 1: 
                            case 2: {
                                n2 = 3;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/psi/search/DefaultSearchScopeProviders$Favorites$1";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "file";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "aModule";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getDisplayName";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/psi/search/DefaultSearchScopeProviders$Favorites$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 1: {
                                objectArray = objectArray;
                                objectArray[2] = "contains";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray;
                                objectArray[2] = "isSearchInModuleContent";
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                            case 1: 
                            case 2: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                });
            }
            ArrayList<SearchScope> arrayList = result2;
            if (arrayList == null) {
                Favorites.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/DefaultSearchScopeProviders$Favorites";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/DefaultSearchScopeProviders$Favorites";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSearchScopes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSearchScopes";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

