/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.tree.IStubFileElementType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StubBuilderType {
    private static final Logger LOG = Logger.getInstance(StubBuilderType.class);
    private final IStubFileElementType myElementType;
    private final BinaryFileStubBuilder myBinaryFileStubBuilder;
    private final Object myBinarySubBuilder;

    StubBuilderType(@NotNull IStubFileElementType elementType) {
        if (elementType == null) {
            StubBuilderType.$$$reportNull$$$0(0);
        }
        this.myElementType = elementType;
        this.myBinaryFileStubBuilder = null;
        this.myBinarySubBuilder = null;
    }

    StubBuilderType(@NotNull BinaryFileStubBuilder binaryFileStubBuilder) {
        if (binaryFileStubBuilder == null) {
            StubBuilderType.$$$reportNull$$$0(1);
        }
        this.myElementType = null;
        this.myBinaryFileStubBuilder = binaryFileStubBuilder;
        this.myBinarySubBuilder = null;
    }

    StubBuilderType(@NotNull BinaryFileStubBuilder.CompositeBinaryFileStubBuilder binaryFileStubBuilder, @Nullable Object binarySubBuilder) {
        if (binaryFileStubBuilder == null) {
            StubBuilderType.$$$reportNull$$$0(2);
        }
        this.myElementType = null;
        this.myBinaryFileStubBuilder = binaryFileStubBuilder;
        this.myBinarySubBuilder = binarySubBuilder;
    }

    BinaryFileStubBuilder getBinaryFileStubBuilder() {
        return this.myBinaryFileStubBuilder;
    }

    String getVersion() {
        if (this.myElementType != null) {
            if (this.myElementType.getLanguage() instanceof TemplateLanguage && this.myElementType.getStubVersion() < IStubFileElementType.getTemplateStubVersion()) {
                PluginException.logPluginError((Logger)LOG, (String)(this.myElementType.getLanguage() + " stub version should call super.getStubVersion()"), null, ((Object)((Object)this.myElementType)).getClass());
            }
            return ((Object)((Object)this.myElementType)).getClass().getName() + ":" + this.myElementType.getStubVersion();
        }
        assert (this.myBinaryFileStubBuilder != null);
        String baseVersion = this.myBinaryFileStubBuilder.getClass().getName() + ":" + this.myBinaryFileStubBuilder.getStubVersion();
        if (this.myBinaryFileStubBuilder instanceof BinaryFileStubBuilder.CompositeBinaryFileStubBuilder) {
            return baseVersion + ":" + ((BinaryFileStubBuilder.CompositeBinaryFileStubBuilder)this.myBinaryFileStubBuilder).getSubBuilderVersion(this.myBinarySubBuilder);
        }
        return baseVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StubBuilderType type = (StubBuilderType)o;
        return Objects.equals((Object)this.myElementType, (Object)type.myElementType) && Objects.equals(this.myBinaryFileStubBuilder, type.myBinaryFileStubBuilder) && Objects.equals(this.myBinarySubBuilder, type.myBinarySubBuilder);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.myElementType, this.myBinaryFileStubBuilder, this.myBinarySubBuilder});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "elementType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "binaryFileStubBuilder";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/stubs/StubBuilderType";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

