/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.RenameUtilBase;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RenamePsiElementProcessor {
    private static final Logger LOG = Logger.getInstance(RenamePsiElementProcessor.class);
    public static final ExtensionPointName<RenamePsiElementProcessor> EP_NAME = ExtensionPointName.create((String)"com.intellij.renamePsiElementProcessor");
    public static final RenamePsiElementProcessor DEFAULT = new RenamePsiElementProcessor(){

        @Override
        public boolean canProcessElement(@NotNull PsiElement element2) {
            if (element2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/rename/RenamePsiElementProcessor$1", "canProcessElement"));
        }
    };
    final boolean myOldFindMethodsImplemented;

    public RenamePsiElementProcessor() {
        boolean implemented;
        try {
            Method find1 = this.getClass().getMethod("findReferences", PsiElement.class);
            Method find2 = this.getClass().getMethod("findReferences", PsiElement.class, Boolean.TYPE);
            boolean bl = implemented = !RenamePsiElementProcessor.class.equals(find1.getDeclaringClass()) || !RenamePsiElementProcessor.class.equals(find2.getDeclaringClass());
            if (implemented) {
                LOG.warn(this.getClass().getName() + " overrides deprecated findReferences(..).\nOverride findReferences(PsiElement, SearchScope, boolean) instead.");
            }
        }
        catch (NoSuchMethodException e) {
            implemented = false;
            LOG.warn((Throwable)e);
        }
        this.myOldFindMethodsImplemented = implemented;
    }

    public abstract boolean canProcessElement(@NotNull PsiElement var1);

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element2, @Nullable PsiElement nameSuggestionContext, @Nullable Editor editor) {
        if (project == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(1);
        }
        return new RenameDialog(project, element2, nameSuggestionContext, editor);
    }

    public void renameElement(@NotNull PsiElement element2, @NotNull String newName, UsageInfo @NotNull [] usages, @Nullable RefactoringElementListener listener2) throws IncorrectOperationException {
        if (element2 == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(2);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(3);
        }
        if (usages == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(4);
        }
        RenameUtil.doRenameGenericNamedElement(element2, newName, usages, listener2);
    }

    @Deprecated
    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element2, boolean searchInCommentsAndStrings) {
        if (element2 == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(5);
        }
        Collection<PsiReference> collection = this.myOldFindMethodsImplemented ? this.findReferences(element2) : this.findReferences(element2, (SearchScope)GlobalSearchScope.projectScope((Project)element2.getProject()), searchInCommentsAndStrings);
        if (collection == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @Deprecated
    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element2) {
        if (element2 == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(7);
        }
        Collection<PsiReference> collection = this.myOldFindMethodsImplemented ? ReferencesSearch.search((PsiElement)element2, (SearchScope)GlobalSearchScope.projectScope((Project)element2.getProject())).findAll() : this.findReferences(element2, (SearchScope)GlobalSearchScope.projectScope((Project)element2.getProject()), false);
        if (collection == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element2, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        if (element2 == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(9);
        }
        if (searchScope == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(10);
        }
        if (this.myOldFindMethodsImplemented) {
            Collection<PsiReference> refs = this.findReferences(element2, searchInCommentsAndStrings);
            if (!searchScope.equals(GlobalSearchScope.projectScope((Project)element2.getProject()))) {
                ArrayList<PsiReference> result2 = new ArrayList<PsiReference>();
                for (PsiReference ref : refs) {
                    VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)ref.getElement());
                    if (file2 != null && !searchScope.contains(file2)) continue;
                    result2.add(ref);
                }
                ArrayList<PsiReference> arrayList = result2;
                if (arrayList == null) {
                    RenamePsiElementProcessor.$$$reportNull$$$0(11);
                }
                return arrayList;
            }
            Collection<PsiReference> collection = refs;
            if (collection == null) {
                RenamePsiElementProcessor.$$$reportNull$$$0(12);
            }
            return collection;
        }
        Collection collection = ReferencesSearch.search((PsiElement)element2, (SearchScope)searchScope).findAll();
        if (collection == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @Nullable
    public Pair<String, String> getTextOccurrenceSearchStrings(@NotNull PsiElement element2, @NotNull String newName) {
        if (element2 == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(14);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(15);
        }
        return null;
    }

    @Nullable
    public String getQualifiedNameAfterRename(@NotNull PsiElement element2, @NotNull String newName, boolean nonJava) {
        if (element2 == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(16);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(17);
        }
        return null;
    }

    public void prepareRenaming(@NotNull PsiElement element2, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        if (element2 == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(18);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(19);
        }
        if (allRenames == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(20);
        }
        this.prepareRenaming(element2, newName, allRenames, element2.getUseScope());
    }

    public void prepareRenaming(@NotNull PsiElement element2, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope) {
        if (element2 == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(21);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(22);
        }
        if (allRenames == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(23);
        }
        if (scope == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(24);
        }
    }

    public void findExistingNameConflicts(@NotNull PsiElement element2, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (element2 == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(25);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(26);
        }
        if (conflicts == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(27);
        }
    }

    public void findExistingNameConflicts(@NotNull PsiElement element2, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts, @NotNull Map<PsiElement, String> allRenames) {
        if (element2 == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(28);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(29);
        }
        if (conflicts == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(30);
        }
        if (allRenames == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(31);
        }
        this.findExistingNameConflicts(element2, newName, conflicts);
    }

    public boolean isInplaceRenameSupported() {
        return true;
    }

    @NotNull
    public static List<RenamePsiElementProcessor> allForElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(32);
        }
        ArrayList<RenamePsiElementProcessor> result2 = new ArrayList<RenamePsiElementProcessor>();
        for (RenamePsiElementProcessor processor2 : (RenamePsiElementProcessor[])EP_NAME.getExtensions()) {
            if (!processor2.canProcessElement(element2)) continue;
            result2.add(processor2);
        }
        ArrayList<RenamePsiElementProcessor> arrayList = result2;
        if (arrayList == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(33);
        }
        return arrayList;
    }

    @NotNull
    public static RenamePsiElementProcessor forElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(34);
        }
        for (RenamePsiElementProcessor processor2 : EP_NAME.getExtensionList()) {
            if (!processor2.canProcessElement(element2)) continue;
            RenamePsiElementProcessor renamePsiElementProcessor = processor2;
            if (renamePsiElementProcessor == null) {
                RenamePsiElementProcessor.$$$reportNull$$$0(35);
            }
            return renamePsiElementProcessor;
        }
        RenamePsiElementProcessor renamePsiElementProcessor = DEFAULT;
        if (renamePsiElementProcessor == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(36);
        }
        return renamePsiElementProcessor;
    }

    @Nullable
    public Runnable getPostRenameCallback(@NotNull PsiElement element2, @NotNull String newName, @NotNull RefactoringElementListener elementListener) {
        if (element2 == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(37);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(38);
        }
        if (elementListener == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(39);
        }
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpID(PsiElement element2) {
        if (element2 instanceof PsiFile) {
            return "refactoring.renameFile";
        }
        return "refactoring.renameDialogs";
    }

    public boolean isToSearchInComments(@NotNull PsiElement element2) {
        if (element2 == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(40);
        }
        return element2 instanceof PsiFileSystemItem && RefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FILE;
    }

    public void setToSearchInComments(@NotNull PsiElement element2, boolean enabled) {
        if (element2 == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(41);
        }
        if (element2 instanceof PsiFileSystemItem) {
            RefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FILE = enabled;
        }
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element2) {
        if (element2 == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(42);
        }
        return element2 instanceof PsiFileSystemItem && RefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FILE;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element2, boolean enabled) {
        if (element2 == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(43);
        }
        if (element2 instanceof PsiFileSystemItem) {
            RefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FILE = enabled;
        }
    }

    public boolean showRenamePreviewButton(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(44);
        }
        return true;
    }

    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element2, @Nullable Editor editor) {
        if (element2 == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(45);
        }
        return element2;
    }

    public void substituteElementToRename(@NotNull PsiElement element2, @NotNull Editor editor, @NotNull Pass<PsiElement> renameCallback) {
        PsiElement psiElement;
        if (element2 == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(46);
        }
        if (editor == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(47);
        }
        if (renameCallback == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(48);
        }
        if ((psiElement = this.substituteElementToRename(element2, editor)) == null) {
            return;
        }
        if (!PsiElementRenameHandler.canRename(psiElement.getProject(), editor, psiElement)) {
            return;
        }
        renameCallback.pass((Object)psiElement);
    }

    public void findCollisions(@NotNull PsiElement element2, @NotNull String newName, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result2) {
        if (element2 == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(49);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(50);
        }
        if (allRenames == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(51);
        }
        if (result2 == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(52);
        }
    }

    public boolean forcesShowPreview() {
        return false;
    }

    @Nullable
    public PsiElement getElementToSearchInStringsAndComments(@NotNull PsiElement element2) {
        if (element2 == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(53);
        }
        return element2;
    }

    @NotNull
    public UsageInfo createUsageInfo(@NotNull PsiElement element2, @NotNull PsiReference ref, @NotNull PsiElement referenceElement) {
        if (element2 == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(54);
        }
        if (ref == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(55);
        }
        if (referenceElement == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(56);
        }
        UsageInfo usageInfo = RenameUtilBase.createMoveRenameUsageInfo(element2, ref, referenceElement);
        if (usageInfo == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(57);
        }
        return usageInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 33: 
            case 35: 
            case 36: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 33: 
            case 35: 
            case 36: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 25: 
            case 28: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 49: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 26: 
            case 29: 
            case 38: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 33: 
            case 35: 
            case 36: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/rename/RenamePsiElementProcessor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 20: 
            case 23: 
            case 31: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementListener";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renameCallback";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/rename/RenamePsiElementProcessor";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "allForElement";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "forElement";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createRenameDialog";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "renameElement";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 33: 
            case 35: 
            case 36: 
            case 57: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTextOccurrenceSearchStrings";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameAfterRename";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findExistingNameConflicts";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "allForElement";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "forElement";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getPostRenameCallback";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchInComments";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchInComments";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchForTextOccurrences";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchForTextOccurrences";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "showRenamePreviewButton";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "substituteElementToRename";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "findCollisions";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getElementToSearchInStringsAndComments";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createUsageInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 33: 
            case 35: 
            case 36: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

