/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.Condition;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.ext.CredentialsLanguageContribution;
import com.intellij.remote.ext.CredentialsManager;
import com.intellij.remote.ui.CredentialsEditorProvider;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CredentialsTypeUtil {
    private CredentialsTypeUtil() {
    }

    public static boolean isCredentialsTypeSupportedForLanguage(@NotNull CredentialsType<?> credentialsType, @NotNull Class<?> languageContributionMarkerClass) {
        if (credentialsType == null) {
            CredentialsTypeUtil.$$$reportNull$$$0(0);
        }
        if (languageContributionMarkerClass == null) {
            CredentialsTypeUtil.$$$reportNull$$$0(1);
        }
        for (CredentialsType<?> type : CredentialsManager.getInstance().getAllTypes()) {
            List<CredentialsLanguageContribution> contributions;
            CredentialsEditorProvider editorProvider;
            if (!credentialsType.equals(type) || (editorProvider = (CredentialsEditorProvider)ObjectUtils.tryCast(type, CredentialsEditorProvider.class)) == null || (contributions = CredentialsTypeUtil.getContributions(languageContributionMarkerClass)).isEmpty()) continue;
            for (CredentialsLanguageContribution contribution : contributions) {
                if (contribution.getType() != type || !editorProvider.isAvailable(contribution)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static <T> List<CredentialsLanguageContribution> getContributions(@NotNull Class<T> languageContributionMarkerInterface) {
        if (languageContributionMarkerInterface == null) {
            CredentialsTypeUtil.$$$reportNull$$$0(2);
        }
        List list2 = ContainerUtil.filter((Object[])CredentialsLanguageContribution.EP_NAME.getExtensions(), (Condition)FilteringIterator.instanceOf(languageContributionMarkerInterface));
        if (list2 == null) {
            CredentialsTypeUtil.$$$reportNull$$$0(3);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentialsType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageContributionMarkerClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageContributionMarkerInterface";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remote/CredentialsTypeUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remote/CredentialsTypeUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContributions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isCredentialsTypeSupportedForLanguage";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getContributions";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

