/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.terminal.TerminalExecutionConsole;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CompositeFilterWrapper {
    private final Project myProject;
    private final TerminalExecutionConsole myConsole;
    private final List<Filter> myFilters;
    private volatile CompositeFilter myCompositeFilter;
    private final AtomicBoolean myConsoleFilterProvidersAdded;

    CompositeFilterWrapper(@NotNull Project project, @Nullable TerminalExecutionConsole console) {
        if (project == null) {
            CompositeFilterWrapper.$$$reportNull$$$0(0);
        }
        this.myFilters = new CopyOnWriteArrayList<Filter>();
        this.myConsoleFilterProvidersAdded = new AtomicBoolean(false);
        this.myProject = project;
        this.myConsole = console;
    }

    void addFilter(@NotNull Filter filter2) {
        if (filter2 == null) {
            CompositeFilterWrapper.$$$reportNull$$$0(1);
        }
        this.myFilters.add(filter2);
        this.myCompositeFilter = null;
    }

    @NotNull
    private List<Filter> createCompositeFilters() {
        if (this.myProject.isDefault()) {
            List<Filter> list2 = Collections.emptyList();
            if (list2 == null) {
                CompositeFilterWrapper.$$$reportNull$$$0(2);
            }
            return list2;
        }
        List list3 = (List)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                return Collections.emptyList();
            }
            return ConsoleViewUtil.computeConsoleFilters(this.myProject, this.myConsole, GlobalSearchScope.allScope((Project)this.myProject));
        });
        if (list3 == null) {
            CompositeFilterWrapper.$$$reportNull$$$0(3);
        }
        return list3;
    }

    @NotNull
    CompositeFilter getCompositeFilter() {
        CompositeFilter filter2 = this.myCompositeFilter;
        if (filter2 != null) {
            CompositeFilter compositeFilter = filter2;
            if (compositeFilter == null) {
                CompositeFilterWrapper.$$$reportNull$$$0(4);
            }
            return compositeFilter;
        }
        if (this.myConsoleFilterProvidersAdded.compareAndSet(false, true)) {
            this.myFilters.addAll(this.createCompositeFilters());
        }
        filter2 = new CompositeFilter(this.myProject, this.myFilters);
        filter2.setForceUseAllFilters(true);
        this.myCompositeFilter = filter2;
        CompositeFilter compositeFilter = filter2;
        if (compositeFilter == null) {
            CompositeFilterWrapper.$$$reportNull$$$0(5);
        }
        return compositeFilter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/terminal/CompositeFilterWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/terminal/CompositeFilterWrapper";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompositeFilters";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompositeFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addFilter";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

