/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.keymap.KeymapExtension;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import java.util.Arrays;
import java.util.HashMap;

public abstract class BaseToolKeymapExtension
implements KeymapExtension {
    public KeymapGroup createGroup(Condition<AnAction> filtered2, Project project) {
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        Object[] ids = actionManager.getActionIds(this.getActionIdPrefix());
        Arrays.sort(ids);
        Group group = new Group(this.getGroupName(), AllIcons.Nodes.KeymapTools);
        HashMap<String, Group> toolGroupNameToGroup = new HashMap<String, Group>();
        for (Object id2 : ids) {
            Group subGroup;
            if (filtered2 != null && !filtered2.value((Object)actionManager.getActionOrStub((String)id2))) continue;
            String groupName = this.getGroupByActionId((String)id2);
            if (groupName != null && groupName.trim().length() == 0) {
                groupName = null;
            }
            if ((subGroup = (Group)toolGroupNameToGroup.get(groupName)) == null) {
                subGroup = new Group(groupName, null, null);
                toolGroupNameToGroup.put(groupName, subGroup);
                if (groupName != null) {
                    group.addGroup(subGroup);
                }
            }
            subGroup.addActionId((String)id2);
        }
        Group subGroup = (Group)toolGroupNameToGroup.get(null);
        if (subGroup != null) {
            group.addAll(subGroup);
        }
        return group;
    }

    protected abstract String getActionIdPrefix();

    protected abstract String getGroupByActionId(String var1);

    protected abstract String getGroupName();
}

