/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.hash;

import com.intellij.util.io.DifferentSerializableBytesImplyNonEqualityPolicy;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.PersistentBTreeEnumerator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ContentHashEnumerator
extends PersistentBTreeEnumerator<byte[]> {
    private static final int SIGNATURE_LENGTH = 20;

    public ContentHashEnumerator(@NotNull Path contentsHashesFile) throws IOException {
        if (contentsHashesFile == null) {
            ContentHashEnumerator.$$$reportNull$$$0(0);
        }
        this(contentsHashesFile, null);
    }

    public ContentHashEnumerator(@NotNull Path contentsHashesFile, @Nullable PagedFileStorage.StorageLockContext storageLockContext) throws IOException {
        if (contentsHashesFile == null) {
            ContentHashEnumerator.$$$reportNull$$$0(1);
        }
        this(contentsHashesFile, new ContentHashesDescriptor(), 65536, storageLockContext);
    }

    private ContentHashEnumerator(@NotNull Path file2, @NotNull KeyDescriptor<byte[]> dataDescriptor, int initialSize, @Nullable PagedFileStorage.StorageLockContext lockContext) throws IOException {
        if (file2 == null) {
            ContentHashEnumerator.$$$reportNull$$$0(2);
        }
        if (dataDescriptor == null) {
            ContentHashEnumerator.$$$reportNull$$$0(3);
        }
        super(file2, dataDescriptor, initialSize, lockContext);
        LOG.assertTrue(dataDescriptor instanceof DifferentSerializableBytesImplyNonEqualityPolicy);
    }

    public boolean hasHashFor(@NotNull byte[] value2) throws IOException {
        if (value2 == null) {
            ContentHashEnumerator.$$$reportNull$$$0(4);
        }
        return this.tryEnumerate(value2) != 0;
    }

    public int enumerate(@NotNull byte[] value2) throws IOException {
        if (value2 == null) {
            ContentHashEnumerator.$$$reportNull$$$0(5);
        }
        LOG.assertTrue(20 == value2.length);
        return super.enumerate((Object)value2);
    }

    protected int doWriteData(byte[] value2) throws IOException {
        return super.doWriteData((Object)value2) / 20;
    }

    public int getLargestId() {
        return super.getLargestId() / 20;
    }

    protected boolean isKeyAtIndex(byte[] value2, int idx) throws IOException {
        return super.isKeyAtIndex((Object)value2, this.addrToIndex(this.indexToAddr(idx) * 20));
    }

    public byte[] valueOf(int idx) throws IOException {
        return (byte[])super.valueOf(this.addrToIndex(this.indexToAddr(idx) * 20));
    }

    public static int getVersion() {
        return PersistentBTreeEnumerator.VERSION;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentsHashesFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataDescriptor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/hash/ContentHashEnumerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasHashFor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "enumerate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ContentHashesDescriptor
    implements KeyDescriptor<byte[]>,
    DifferentSerializableBytesImplyNonEqualityPolicy {
        private ContentHashesDescriptor() {
        }

        public void save(@NotNull DataOutput out, byte[] value2) throws IOException {
            if (out == null) {
                ContentHashesDescriptor.$$$reportNull$$$0(0);
            }
            out.write(value2);
        }

        public byte[] read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                ContentHashesDescriptor.$$$reportNull$$$0(1);
            }
            byte[] b = new byte[20];
            in.readFully(b);
            return b;
        }

        public int getHashCode(byte[] value2) {
            int hash2 = 0;
            for (int i = 0; i < 4; ++i) {
                hash2 = (hash2 << 8) + (value2[i] & 0xFF);
            }
            return hash2;
        }

        public boolean isEqual(byte[] val1, byte[] val2) {
            return Arrays.equals(val1, val2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/hash/ContentHashEnumerator$ContentHashesDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

