/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.CompositeDataIndexer;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.InputMapExternalizer;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.MemoryIndexStorage;
import com.intellij.util.indexing.SharedIndicesData;
import com.intellij.util.indexing.SharedIntMapForwardIndex;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.DebugAssertions;
import com.intellij.util.indexing.impl.DirectInputDataDiffBuilder;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.MapInputDataDiffBuilder;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.indexing.impl.forward.AbstractMapForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.EmptyForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.IntForwardIndex;
import com.intellij.util.indexing.impl.forward.MapForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.PersistentMapBasedForwardIndex;
import com.intellij.util.indexing.impl.forward.SingleEntryIndexForwardIndexAccessor;
import com.intellij.util.indexing.impl.perFileVersion.PersistentSubIndexerRetriever;
import com.intellij.util.indexing.snapshot.IndexImporterMappingIndex;
import com.intellij.util.indexing.snapshot.SnapshotInputMappingIndex;
import com.intellij.util.indexing.snapshot.SnapshotInputMappings;
import com.intellij.util.indexing.snapshot.SnapshotSingleValueIndexStorage;
import com.intellij.util.indexing.snapshot.UpdatableSnapshotInputMappingIndex;
import com.intellij.util.io.IOUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsAwareMapReduceIndex<Key, Value>
extends MapReduceIndex<Key, Value, FileContent>
implements UpdatableIndex<Key, Value, FileContent> {
    private static final Logger LOG = Logger.getInstance(VfsAwareMapReduceIndex.class);
    @ApiStatus.Internal
    public static final int VERSION = 0;
    private final AtomicBoolean myInMemoryMode;
    private final TIntObjectHashMap<Map<Key, Value>> myInMemoryKeysAndValues;
    private final PersistentSubIndexerRetriever mySubIndexerRetriever;
    private final SnapshotInputMappingIndex<Key, Value, FileContent> mySnapshotInputMappings;
    private final boolean myUpdateMappings;
    private final boolean mySingleEntryIndex;

    public VfsAwareMapReduceIndex(@NotNull IndexExtension<Key, Value, FileContent> extension, @NotNull IndexStorage<Key, Value> storage) throws IOException {
        if (extension == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(0);
        }
        if (storage == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(1);
        }
        this(extension, storage, VfsAwareMapReduceIndex.hasSnapshotMapping(extension) ? new SnapshotInputMappings<Key, Value>(extension) : null);
        if (!(this.myIndexId instanceof ID)) {
            throw new IllegalArgumentException("myIndexId should be instance of com.intellij.util.indexing.ID");
        }
    }

    public VfsAwareMapReduceIndex(@NotNull IndexExtension<Key, Value, FileContent> extension, @NotNull IndexStorage<Key, Value> storage, @Nullable SnapshotInputMappings<Key, Value> snapshotInputMappings) throws IOException {
        if (extension == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(2);
        }
        if (storage == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(3);
        }
        this(extension, storage, (ForwardIndex)(snapshotInputMappings != null ? new SharedIntMapForwardIndex(extension, snapshotInputMappings.getInputIndexStorageFile(), true) : VfsAwareMapReduceIndex.getForwardIndexMap(extension)), (ForwardIndexAccessor<Key, Value>)(snapshotInputMappings != null ? snapshotInputMappings.getForwardIndexAccessor() : VfsAwareMapReduceIndex.getForwardIndexAccessor(extension)), snapshotInputMappings, null);
    }

    /*
     * Unable to fully structure code
     */
    public VfsAwareMapReduceIndex(@NotNull IndexExtension<Key, Value, FileContent> extension, @NotNull IndexStorage<Key, Value> storage, @Nullable ForwardIndex forwardIndexMap, @Nullable ForwardIndexAccessor<Key, Value> forwardIndexAccessor, @Nullable SnapshotInputMappings<Key, Value> snapshotInputMappings, @Nullable ReadWriteLock lock) {
        if (extension == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(4);
        }
        if (storage == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(5);
        }
        super(extension, storage, forwardIndexMap, forwardIndexAccessor, lock);
        this.myInMemoryMode = new AtomicBoolean();
        this.myInMemoryKeysAndValues = new TIntObjectHashMap();
        if (this.myIndexId instanceof ID) {
            SharedIndicesData.registerIndex((ID)this.myIndexId, extension);
        }
        if (storage instanceof MemoryIndexStorage && snapshotInputMappings != null && (backendStorage = ((MemoryIndexStorage)storage).getBackendStorage()) instanceof SnapshotSingleValueIndexStorage) {
            VfsAwareMapReduceIndex.LOG.assertTrue(forwardIndexMap instanceof IntForwardIndex);
            ((SnapshotSingleValueIndexStorage)backendStorage).init(snapshotInputMappings, (IntForwardIndex)forwardIndexMap);
        }
        if (VfsAwareMapReduceIndex.isCompositeIndexer(this.myIndexer)) {
            try {
                this.mySubIndexerRetriever = new PersistentSubIndexerRetriever<SubIndexerType, SubIndexerVersion>((ID)this.myIndexId, extension.getVersion(), (CompositeDataIndexer)this.myIndexer);
                if (snapshotInputMappings == null) ** GOTO lbl23
                snapshotInputMappings.setSubIndexerRetriever(this.mySubIndexerRetriever);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.mySubIndexerRetriever = null;
        }
lbl23:
        // 3 sources

        this.mySnapshotInputMappings = IndexImporterMappingIndex.wrap(snapshotInputMappings, extension);
        this.myUpdateMappings = this.mySnapshotInputMappings instanceof UpdatableSnapshotInputMappingIndex;
        this.mySingleEntryIndex = extension instanceof SingleEntryFileBasedIndexExtension;
        this.installMemoryModeListener();
    }

    public static boolean isCompositeIndexer(@NotNull DataIndexer<?, ?, ?> indexer) {
        if (indexer == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(6);
        }
        return indexer instanceof CompositeDataIndexer && InvertedIndex.ARE_COMPOSITE_INDEXERS_ENABLED;
    }

    static <Key, Value> boolean hasSnapshotMapping(@NotNull IndexExtension<Key, Value, ?> indexExtension) {
        if (indexExtension == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(7);
        }
        return indexExtension instanceof FileBasedIndexExtension && ((FileBasedIndexExtension)indexExtension).hasSnapshotMapping() && FileBasedIndex.ourSnapshotMappingsEnabled;
    }

    @NotNull
    protected InputData<Key, Value> mapInput(int inputId, @Nullable FileContent content2) {
        InputData<Key, Value> data2;
        boolean containsSnapshotData = true;
        if (this.mySnapshotInputMappings != null && content2 != null) {
            block10: {
                InputData<Key, Value> inputData;
                try {
                    data2 = this.mySnapshotInputMappings.readData(content2);
                    if (data2 == null) break block10;
                    inputData = data2;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (inputData == null) {
                    VfsAwareMapReduceIndex.$$$reportNull$$$0(8);
                }
                return inputData;
            }
            containsSnapshotData = !this.myUpdateMappings;
        }
        data2 = super.mapInput(inputId, (Object)content2);
        if (!containsSnapshotData && !UpdatableSnapshotInputMappingIndex.ignoreMappingIndexUpdate(content2)) {
            InputData<Key, Value> inputData;
            try {
                inputData = ((UpdatableSnapshotInputMappingIndex)this.mySnapshotInputMappings).putData(content2, data2);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (inputData == null) {
                VfsAwareMapReduceIndex.$$$reportNull$$$0(9);
            }
            return inputData;
        }
        InputData<Key, Value> inputData = data2;
        if (inputData == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(10);
        }
        return inputData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    protected InputDataDiffBuilder<Key, Value> getKeysDiffBuilder(int inputId) throws IOException {
        if (this.mySnapshotInputMappings != null && !this.myInMemoryMode.get()) {
            InputDataDiffBuilder inputDataDiffBuilder = super.getKeysDiffBuilder(inputId);
            if (inputDataDiffBuilder == null) {
                VfsAwareMapReduceIndex.$$$reportNull$$$0(11);
            }
            return inputDataDiffBuilder;
        }
        if (this.myInMemoryMode.get()) {
            TIntObjectHashMap<Map<Key, Value>> tIntObjectHashMap = this.myInMemoryKeysAndValues;
            synchronized (tIntObjectHashMap) {
                Map keysAndValues = (Map)this.myInMemoryKeysAndValues.get(inputId);
                if (keysAndValues != null) {
                    InputDataDiffBuilder<Key, Value> inputDataDiffBuilder = this.getKeysDiffBuilderInMemoryMode(inputId, keysAndValues);
                    // MONITOREXIT @DISABLED, blocks:[2, 5, 6] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                    if (inputDataDiffBuilder == null) {
                        VfsAwareMapReduceIndex.$$$reportNull$$$0(12);
                    }
                    return inputDataDiffBuilder;
                }
            }
        }
        InputDataDiffBuilder inputDataDiffBuilder = super.getKeysDiffBuilder(inputId);
        if (inputDataDiffBuilder == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(13);
        }
        return inputDataDiffBuilder;
    }

    @NotNull
    protected InputDataDiffBuilder<Key, Value> getKeysDiffBuilderInMemoryMode(int inputId, @NotNull Map<Key, Value> keysAndValues) {
        if (keysAndValues == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(14);
        }
        return this.mySingleEntryIndex ? new SingleEntryIndexForwardIndexAccessor.SingleValueDiffBuilder<Value>(inputId, keysAndValues) : new MapInputDataDiffBuilder(inputId, keysAndValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateForwardIndex(int inputId, @NotNull InputData<Key, Value> data2) throws IOException {
        if (data2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(15);
        }
        if (this.myInMemoryMode.get()) {
            TIntObjectHashMap<Map<Key, Value>> tIntObjectHashMap = this.myInMemoryKeysAndValues;
            synchronized (tIntObjectHashMap) {
                this.myInMemoryKeysAndValues.put(inputId, (Object)data2.getKeyValues());
            }
        } else {
            super.updateForwardIndex(inputId, data2);
        }
    }

    @Override
    public void setIndexedStateForFile(int fileId, @NotNull IndexedFile file2) {
        if (file2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(16);
        }
        IndexingStamp.setFileIndexedStateCurrent(fileId, (ID)this.myIndexId);
        if (this.mySubIndexerRetriever != null) {
            try {
                this.mySubIndexerRetriever.setIndexedState(fileId, file2);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public void resetIndexedStateForFile(int fileId) {
        IndexingStamp.setFileIndexedStateOutdated(fileId, (ID)this.myIndexId);
    }

    @Override
    public boolean isIndexedStateForFile(int fileId, @NotNull IndexedFile file2) {
        if (file2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(17);
        }
        if (!IndexingStamp.isFileIndexedStateCurrent(fileId, (ID)this.myIndexId)) {
            return false;
        }
        if (this.mySubIndexerRetriever == null) {
            return true;
        }
        if (!(file2 instanceof FileContent) && ((CompositeDataIndexer)this.myIndexer).requiresContentForSubIndexerEvaluation(file2)) {
            return this.isIndexConfigurationUpToDate(fileId, file2);
        }
        try {
            return this.mySubIndexerRetriever.isIndexed(fileId, file2);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    protected boolean isIndexConfigurationUpToDate(int fileId, @NotNull IndexedFile file2) {
        if (file2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(18);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTransientDataForFile(int inputId) {
        Lock lock = this.getWriteLock();
        lock.lock();
        try {
            Map keyValueMap;
            TIntObjectHashMap<Map<Key, Value>> tIntObjectHashMap = this.myInMemoryKeysAndValues;
            synchronized (tIntObjectHashMap) {
                keyValueMap = (Map)this.myInMemoryKeysAndValues.remove(inputId);
            }
            if (keyValueMap == null) {
                return;
            }
            try {
                this.removeTransientDataForInMemoryKeys(inputId, keyValueMap);
                InputDataDiffBuilder<Key, Value> builder2 = this.getKeysDiffBuilder(inputId);
                this.removeTransientDataForKeys(inputId, this.getKeys(builder2));
            }
            catch (StorageException | IOException throwable) {
                throw new RuntimeException(throwable);
            }
        }
        finally {
            lock.unlock();
        }
    }

    protected void removeTransientDataForInMemoryKeys(int inputId, @NotNull Map<? extends Key, ? extends Value> map2) {
        if (map2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(19);
        }
        this.removeTransientDataForKeys(inputId, map2.keySet());
    }

    @Override
    public void removeTransientDataForKeys(int inputId, @NotNull Collection<? extends Key> keys2) {
        if (keys2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(20);
        }
        MemoryIndexStorage memoryIndexStorage = (MemoryIndexStorage)this.getStorage();
        boolean modified = false;
        for (Key key : keys2) {
            if (!memoryIndexStorage.clearMemoryMapForId(key, inputId) || modified) continue;
            modified = true;
        }
        if (modified) {
            this.myModificationStamp.incrementAndGet();
        }
    }

    @Override
    public void setBufferingEnabled(boolean enabled) {
        ((MemoryIndexStorage)this.getStorage()).setBufferingEnabled(enabled);
    }

    @Override
    public void cleanupMemoryStorage() {
        MemoryIndexStorage memStorage = (MemoryIndexStorage)this.getStorage();
        ConcurrencyUtil.withLock((Lock)this.getWriteLock(), () -> {
            if (memStorage.clearMemoryMap()) {
                this.myModificationStamp.incrementAndGet();
            }
        });
        memStorage.fireMemoryStorageCleared();
    }

    @Override
    public void cleanupForNextTest() {
        MemoryIndexStorage memStorage = (MemoryIndexStorage)this.getStorage();
        ConcurrencyUtil.withLock((Lock)this.getReadLock(), () -> memStorage.clearCaches());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processAllKeys(@NotNull Processor<? super Key> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) throws StorageException {
        if (processor2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(21);
        }
        if (scope == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(22);
        }
        Lock lock = this.getReadLock();
        lock.lock();
        try {
            boolean bl = ((VfsAwareIndexStorage)this.myStorage).processKeys(processor2, scope, idFilter);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    @NotNull
    public Map<Key, Value> getIndexedFileData(int fileId) throws StorageException {
        Map map2 = (Map)ConcurrencyUtil.withLock((Lock)this.getReadLock(), () -> {
            try {
                return Collections.unmodifiableMap(ContainerUtil.notNullize(this.getNullableIndexedData(fileId)));
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
        });
        if (map2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(23);
        }
        return map2;
    }

    @Nullable
    private Map<Key, Value> getNullableIndexedData(int fileId) throws IOException, StorageException {
        Map map2;
        if (this.myInMemoryMode.get() && (map2 = (Map)this.myInMemoryKeysAndValues.get(fileId)) != null) {
            return map2;
        }
        if (this.getForwardIndexAccessor() instanceof AbstractMapForwardIndexAccessor) {
            ByteArraySequence serializedInputData = this.getForwardIndex().get(Integer.valueOf(fileId));
            AbstractMapForwardIndexAccessor forwardIndexAccessor = (AbstractMapForwardIndexAccessor)this.getForwardIndexAccessor();
            return forwardIndexAccessor.convertToInputDataMap(serializedInputData);
        }
        if (this.myExtension instanceof SingleEntryFileBasedIndexExtension) {
            Integer key = fileId;
            Map[] result2 = new Map[]{Collections.emptyMap()};
            ValueContainer container2 = this.getData(key);
            container2.forEach((id2, value2) -> {
                result2[0] = Collections.singletonMap(key, value2);
                return false;
            });
            return result2[0];
        }
        LOG.error("Can't fetch indexed data for index " + this.myIndexId.getName());
        return null;
    }

    public void checkCanceled() {
        ProgressManager.checkCanceled();
    }

    protected void requestRebuild(@NotNull Throwable ex) {
        if (ex == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(24);
        }
        Runnable action2 = () -> FileBasedIndex.getInstance().requestRebuild((ID)this.myIndexId, ex);
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            ApplicationManager.getApplication().invokeLater(action2);
        } else {
            action2.run();
        }
    }

    protected void doClear() throws StorageException, IOException {
        super.doClear();
        if (this.mySnapshotInputMappings != null && this.myUpdateMappings) {
            try {
                ((UpdatableSnapshotInputMappingIndex)this.mySnapshotInputMappings).clear();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        if (this.mySubIndexerRetriever != null) {
            try {
                this.mySubIndexerRetriever.clear();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    protected void doFlush() throws IOException, StorageException {
        super.doFlush();
        if (this.mySnapshotInputMappings != null && this.myUpdateMappings) {
            ((UpdatableSnapshotInputMappingIndex)this.mySnapshotInputMappings).flush();
        }
        if (this.mySubIndexerRetriever != null) {
            this.mySubIndexerRetriever.flush();
        }
    }

    protected void doDispose() throws StorageException {
        try {
            super.doDispose();
        }
        catch (Throwable throwable) {
            IOUtil.closeSafe((Logger)LOG, (Closeable[])new Closeable[]{this.mySnapshotInputMappings, this.mySubIndexerRetriever});
            throw throwable;
        }
        IOUtil.closeSafe((Logger)LOG, (Closeable[])new Closeable[]{this.mySnapshotInputMappings, this.mySubIndexerRetriever});
    }

    @Nullable
    private static <Key, Value> ForwardIndexAccessor<Key, Value> getForwardIndexAccessor(@NotNull IndexExtension<Key, Value, ?> indexExtension) {
        if (indexExtension == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(25);
        }
        if (!VfsAwareMapReduceIndex.shouldCreateForwardIndex(indexExtension)) {
            return null;
        }
        if (indexExtension instanceof SingleEntryFileBasedIndexExtension) {
            return new SingleEntryIndexForwardIndexAccessor(indexExtension);
        }
        return new MapForwardIndexAccessor(new InputMapExternalizer<Key, Value>(indexExtension));
    }

    @Nullable
    private static ForwardIndex getForwardIndexMap(@NotNull IndexExtension<?, ?, ?> indexExtension) throws IOException {
        if (indexExtension == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(26);
        }
        if (!VfsAwareMapReduceIndex.shouldCreateForwardIndex(indexExtension)) {
            return null;
        }
        if (indexExtension instanceof SingleEntryFileBasedIndexExtension) {
            return new EmptyForwardIndex();
        }
        File indexStorageFile = IndexInfrastructure.getInputIndexStorageFile((ID)indexExtension.getName());
        return new PersistentMapBasedForwardIndex(indexStorageFile.toPath(), false, false);
    }

    private static boolean shouldCreateForwardIndex(@NotNull IndexExtension<?, ?, ?> indexExtension) {
        if (indexExtension == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(27);
        }
        return !VfsAwareMapReduceIndex.hasSnapshotMapping(indexExtension);
    }

    private void installMemoryModeListener() {
        IndexStorage storage = this.getStorage();
        if (storage instanceof MemoryIndexStorage) {
            ((MemoryIndexStorage)storage).addBufferingStateListener(new MemoryIndexStorage.BufferingStateListener(){

                @Override
                public void bufferingStateChanged(boolean newState2) {
                    VfsAwareMapReduceIndex.this.myInMemoryMode.set(newState2);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void memoryStorageCleared() {
                    TIntObjectHashMap tIntObjectHashMap = VfsAwareMapReduceIndex.this.myInMemoryKeysAndValues;
                    synchronized (tIntObjectHashMap) {
                        VfsAwareMapReduceIndex.this.myInMemoryKeysAndValues.clear();
                    }
                }
            });
        }
    }

    @NotNull
    private Collection<Key> getKeys(InputDataDiffBuilder<Key, ?> builder2) throws StorageException {
        if (builder2 instanceof DirectInputDataDiffBuilder) {
            Collection collection = ((DirectInputDataDiffBuilder)builder2).getKeys();
            if (collection == null) {
                VfsAwareMapReduceIndex.$$$reportNull$$$0(28);
            }
            return collection;
        }
        LOG.error("Input data diff builder must be an instance of DirectInputDataDiffBuilder for index " + this.myIndexId.getName());
        THashSet keys2 = new THashSet();
        builder2.differentiate(Collections.emptyMap(), (key, value2, inputId) -> {}, (key, value2, inputId) -> {}, (arg_0, arg_1) -> VfsAwareMapReduceIndex.lambda$getKeys$7((Set)keys2, arg_0, arg_1));
        THashSet tHashSet = keys2;
        if (tHashSet == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(29);
        }
        return tHashSet;
    }

    private static /* synthetic */ void lambda$getKeys$7(Set keys2, Object key, int inputId) throws StorageException {
        keys2.add(key);
    }

    static {
        if (!DebugAssertions.DEBUG) {
            Application app = ApplicationManager.getApplication();
            DebugAssertions.DEBUG = (app.isEAP() || app.isInternal()) && !ApplicationInfoImpl.isInStressTest();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexer";
                break;
            }
            case 7: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexExtension";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/VfsAwareMapReduceIndex";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keysAndValues";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/VfsAwareMapReduceIndex";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "mapInput";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeysDiffBuilder";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexedFileData";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isCompositeIndexer";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasSnapshotMapping";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 28: 
            case 29: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getKeysDiffBuilderInMemoryMode";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateForwardIndex";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setIndexedStateForFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isIndexedStateForFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isIndexConfigurationUpToDate";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeTransientDataForInMemoryKeys";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeTransientDataForKeys";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "requestRebuild";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getForwardIndexAccessor";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getForwardIndexMap";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "shouldCreateForwardIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

